/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.validate;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUnpivot;

import static java.util.Objects.requireNonNull;

/**
 * Namespace for an {@code UNPIVOT} clause.
 */
public class UnpivotNamespace extends AbstractNamespace {
  private final SqlUnpivot unpivot;

  /** Creates an UnpivotNamespace. */
  protected UnpivotNamespace(SqlValidatorImpl validator, SqlUnpivot unpivot,
      SqlNode enclosingNode) {
    super(validator, enclosingNode);
    this.unpivot = unpivot;
  }

  @Override public RelDataType validateImpl(RelDataType targetRowType) {
    validator.validateUnpivot(unpivot);
    return requireNonNull(rowType, "rowType");
  }

  @Override public SqlUnpivot getNode() {
    return unpivot;
  }
}
