/* Generated By:JavaCC: Do not edit this line. HazelcastSqlParser.java */
package com.hazelcast.jet.sql.impl.calcite.parser;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlAnalyzeStatement;
import com.hazelcast.jet.sql.impl.parse.SqlCreateDataConnection;
import com.hazelcast.jet.sql.impl.parse.SqlCreateIndex;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.jet.sql.impl.parse.SqlCreateSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlCreateType;
import com.hazelcast.jet.sql.impl.parse.SqlCreateView;
import com.hazelcast.jet.sql.impl.parse.SqlDataType;
import com.hazelcast.jet.sql.impl.parse.SqlDropDataConnection;
import com.hazelcast.jet.sql.impl.parse.SqlDropIndex;
import com.hazelcast.jet.sql.impl.parse.SqlDropJob;
import com.hazelcast.jet.sql.impl.parse.SqlDropMapping;
import com.hazelcast.jet.sql.impl.parse.SqlDropSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlDropType;
import com.hazelcast.jet.sql.impl.parse.SqlDropView;
import com.hazelcast.jet.sql.impl.parse.SqlExplainStatement;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.jet.sql.impl.parse.SqlMappingColumn;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement.ShowStatementTarget;
import com.hazelcast.jet.sql.impl.parse.SqlTypeColumn;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDrop;

import com.hazelcast.shaded.org.apache.calcite.avatica.util.Casing;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.shaded.org.apache.calcite.sql.JoinConditionType;
import com.hazelcast.shaded.org.apache.calcite.sql.JoinType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAlter;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBasicTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBinaryOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCharStringLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDelete;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDescribeSchema;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDescribeTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplain;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainFormat;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlHint;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlInsertKeyword;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJdbcDataTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJdbcFunctionCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJoin;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonEncoding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonEmptyOrError;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonValueReturning;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlMatchRecognize;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlMerge;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNumericLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOrderBy;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlPivot;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlPostfixOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlPrefixOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlRowTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSampleSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelectKeyword;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSetOption;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSnapshot;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlTableRef;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUnnestOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUnpivot;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWindow;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWith;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWithItem;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlCase;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlInternalOperators;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlLibraryOperators;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.Span;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParseException;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParser;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserImplFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlConformanceEnum;
import com.hazelcast.shaded.org.apache.calcite.util.Glossary;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.SourceStringReader;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.apache.calcite.util.trace.CalciteTrace;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import static com.hazelcast.shaded.org.apache.calcite.util.Static.RESOURCE;

/**
 * SQL parser, generated from Parser.jj by JavaCC.
 *
 * <p>The public wrapper for this parser is {@link SqlParser}.
 */
public class HazelcastSqlParser extends SqlAbstractParserImpl implements HazelcastSqlParserConstants {
    private static final Logger LOGGER = CalciteTrace.getParserTracer();

    // Can't use quoted literal because of a bug in how JavaCC translates
    // backslash-backslash.
    private static final char BACKSLASH = 0x5c;
    private static final char DOUBLE_QUOTE = 0x22;
    private static final String DQ = DOUBLE_QUOTE + "";
    private static final String DQDQ = DQ + DQ;
    private static final SqlLiteral LITERAL_ZERO =
        SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_ONE =
        SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_MINUS_ONE =
        SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);

    private static Metadata metadata;

    private Casing unquotedCasing;
    private Casing quotedCasing;
    private int identifierMaxLength;
    private SqlConformance conformance;

    /**
     * {@link SqlParserImplFactory} implementation for creating parser.
     */
    public static final SqlParserImplFactory FACTORY = new SqlParserImplFactory() {
        public SqlAbstractParserImpl getParser(Reader reader) {
            final HazelcastSqlParser parser = new HazelcastSqlParser(reader);
            if (reader instanceof SourceStringReader) {
                final String sql =
                    ((SourceStringReader) reader).getSourceString();
                parser.setOriginalSql(sql);
            }
          return parser;
        }
    };

    public SqlParseException normalizeException(Throwable ex) {
        try {
            if (ex instanceof ParseException) {
                ex = cleanupParseException((ParseException) ex);
            }
            return convertException(ex);
        } catch (ParseException e) {
            throw new AssertionError(e);
        }
    }

    public Metadata getMetadata() {
        synchronized (HazelcastSqlParser.class) {
            if (metadata == null) {
                metadata = new MetadataImpl(
                    new HazelcastSqlParser(new java.io.StringReader("")));
            }
            return metadata;
        }
    }

    public void setTabSize(int tabSize) {
        jj_input_stream.setTabSize(tabSize);
    }

    public void switchTo(SqlAbstractParserImpl.LexicalState state) {
        final int stateOrdinal =
            Arrays.asList(HazelcastSqlParserTokenManager.lexStateNames)
                .indexOf(state.name());
        token_source.SwitchTo(stateOrdinal);
    }

    public void setQuotedCasing(Casing quotedCasing) {
        this.quotedCasing = quotedCasing;
    }

    public void setUnquotedCasing(Casing unquotedCasing) {
        this.unquotedCasing = unquotedCasing;
    }

    public void setIdentifierMaxLength(int identifierMaxLength) {
        this.identifierMaxLength = identifierMaxLength;
    }

    public void setConformance(SqlConformance conformance) {
        this.conformance = conformance;
    }

    public SqlNode parseSqlExpressionEof() throws Exception {
        return SqlExpressionEof();
    }

    public SqlNode parseSqlStmtEof() throws Exception {
        return SqlStmtEof();
    }

    public SqlNodeList parseSqlStmtList() throws Exception {
        return SqlStmtList();
    }

    public SqlNode parseArray() throws SqlParseException {
        switchTo(LexicalState.BQID);
        try {
          return ArrayLiteral();
        } catch (ParseException ex) {
          throw normalizeException(ex);
        } catch (TokenMgrError ex) {
          throw normalizeException(ex);
        }
    }

    private SqlNode extend(SqlNode table, SqlNodeList extendList) {
        return SqlStdOperatorTable.EXTEND.createCall(
            Span.of(table, extendList).pos(), table, extendList);
    }

    /** Adds a warning that a token such as "HOURS" was used,
    * whereas the SQL standard only allows "HOUR".
    *
    * <p>Currently, we silently add an exception to a list of warnings. In
    * future, we may have better compliance checking, for example a strict
    * compliance mode that throws if any non-standard features are used. */
    private TimeUnit warn(TimeUnit timeUnit) throws ParseException {
        final String token = getToken(0).image.toUpperCase(Locale.ROOT);
        warnings.add(
            SqlUtil.newContextException(getPos(),
                RESOURCE.nonStandardFeatureUsed(token)));
        return timeUnit;
    }

  void debug_message1() throws ParseException {
    LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

  String unquotedIdentifier() throws ParseException {
    return SqlParserUtil.toCase(getToken(0).image, unquotedCasing);
  }

/**
 * Allows parser to be extended with new types of table references.  The
 * default implementation of this production is empty.
 */
  final public SqlNode ExtendedTableRef() throws ParseException {
    UnusedExtension();
        {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * Allows an OVER clause following a table expression as an extension to
 * standard SQL syntax. The default implementation of this production is empty.
 */
  final public SqlNode TableOverOpt() throws ParseException {
        {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/*
 * Parses dialect-specific keywords immediately following the SELECT keyword.
 */
  final public void SqlSelectKeywords(List<SqlLiteral> keywords) throws ParseException {
    E();
  }

/*
 * Parses dialect-specific keywords immediately following the INSERT keyword.
 */
  final public void SqlInsertKeywords(List<SqlLiteral> keywords) throws ParseException {
    E();
  }

/*
* Parse Floor/Ceil function parameters
*/
  final public SqlNode FloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
    SqlNode node;
    node = StandardFloorCeilOptions(s, floorFlag);
        {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  void E() throws ParseException {
  }

  List startList(Object o) throws ParseException {
    List list = new ArrayList();
    list.add(o);
    return list;
  }

  protected SqlParserPos getPos() throws ParseException {
    return new SqlParserPos(
        token.beginLine,
        token.beginColumn,
        token.endLine,
        token.endColumn);
  }

  Span span() throws ParseException {
    return Span.of(getPos());
  }

  void checkQueryExpression(ExprContext exprContext) throws ParseException {
    switch (exprContext) {
    case ACCEPT_NON_QUERY:
    case ACCEPT_SUB_QUERY:
    case ACCEPT_CURSOR:
        throw SqlUtil.newContextException(getPos(),
            RESOURCE.illegalQueryExpression());
    }
  }

  void checkNonQueryExpression(ExprContext exprContext) throws ParseException {
    switch (exprContext) {
    case ACCEPT_QUERY:
        throw SqlUtil.newContextException(getPos(),
            RESOURCE.illegalNonQueryExpression());
    }
  }

  SqlNode checkNotJoin(SqlNode e) throws ParseException {
    if (e instanceof SqlJoin) {
        throw SqlUtil.newContextException(e.getParserPosition(),
            RESOURCE.illegalJoinExpression());
    }
    return e;
  }

  SqlParseException convertException(Throwable ex) throws ParseException {
    if (ex instanceof SqlParseException) {
        return (SqlParseException) ex;
    }
    SqlParserPos pos = null;
    int[][] expectedTokenSequences = null;
    String[] tokenImage = null;
    if (ex instanceof ParseException) {
        ParseException pex = (ParseException) ex;
        expectedTokenSequences = pex.expectedTokenSequences;
        tokenImage = pex.tokenImage;
        if (pex.currentToken != null) {
            final Token token = pex.currentToken.next;
            // Checks token.image.equals("1") to avoid recursive call.
            // The SqlAbstractParserImpl#MetadataImpl constructor uses constant "1" to
            // throw intentionally to collect the expected tokens.
            if (!token.image.equals("1")
                && getMetadata().isKeyword(token.image)
                && SqlParserUtil.allowsIdentifier(tokenImage, expectedTokenSequences)) {
                // If the next token is a keyword, reformat the error message as:

                // Incorrect syntax near the keyword '{keyword}' at line {line_number},
                // column {column_number}.
                final String expecting = ex.getMessage()
                    .substring(ex.getMessage().indexOf("Was expecting"));
                final String errorMsg = String.format("Incorrect syntax near the keyword '%s' "
                        + "at line %d, column %d.\n%s",
                    token.image,
                    token.beginLine,
                    token.beginColumn,
                    expecting);
                // Replace the ParseException with explicit error message.
                ex = new ParseException(errorMsg);
            }
            pos = new SqlParserPos(
                token.beginLine,
                token.beginColumn,
                token.endLine,
                token.endColumn);
        }
    } else if (ex instanceof TokenMgrError) {
        expectedTokenSequences = null;
        tokenImage = null;
        // Example:
        //    Lexical error at line 3, column 24.  Encountered "#" after "a".
        final java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(
            "(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
        java.util.regex.Matcher matcher = pattern.matcher(ex.getMessage());
        if (matcher.matches()) {
            int line = Integer.parseInt(matcher.group(1));
            int column = Integer.parseInt(matcher.group(2));
            pos = new SqlParserPos(line, column, line, column);
        }
    } else if (ex instanceof CalciteContextException) {
        // CalciteContextException is the standard wrapper for exceptions
        // produced by the validator, but in the parser, the standard is
        // SqlParseException; so, strip it away. In case you were wondering,
        // the CalciteContextException appears because the parser
        // occasionally calls into validator-style code such as
        // SqlSpecialOperator.reduceExpr.
        CalciteContextException ece =
            (CalciteContextException) ex;
        pos = new SqlParserPos(
            ece.getPosLine(),
            ece.getPosColumn(),
            ece.getEndPosLine(),
            ece.getEndPosColumn());
        ex = ece.getCause();
    }

    return new SqlParseException(
        ex.getMessage(), pos, expectedTokenSequences, tokenImage, ex);
  }

  ParseException cleanupParseException(ParseException ex) throws ParseException {
    if (ex.expectedTokenSequences == null) {
        return ex;
    }
    int iIdentifier = Arrays.asList(ex.tokenImage).indexOf("<IDENTIFIER>");

    // Find all sequences in the error which contain identifier. For
    // example,
    //       {<IDENTIFIER>}
    //       {A}
    //       {B, C}
    //       {D, <IDENTIFIER>}
    //       {D, A}
    //       {D, B}
    //
    // would yield
    //       {}
    //       {D}
    final List<int[]> prefixList = new ArrayList<int[]>();
    for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
        int[] seq = ex.expectedTokenSequences[i];
        int j = seq.length - 1;
        int i1 = seq[j];
        if (i1 == iIdentifier) {
            int[] prefix = new int[j];
            System.arraycopy(seq, 0, prefix, 0, j);
            prefixList.add(prefix);
        }
    }

    if (prefixList.isEmpty()) {
        return ex;
    }

    int[][] prefixes = (int[][])
        prefixList.toArray(new int[prefixList.size()][]);

    // Since <IDENTIFIER> was one of the possible productions,
    // we know that the parser will also have included all
    // of the non-reserved keywords (which are treated as
    // identifiers in non-keyword contexts).  So, now we need
    // to clean those out, since they're totally irrelevant.

    final List<int[]> list = new ArrayList<int[]>();
    Metadata metadata = getMetadata();
    for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
        int [] seq = ex.expectedTokenSequences[i];
        String tokenImage = ex.tokenImage[seq[seq.length - 1]];
        String token = SqlParserUtil.getTokenVal(tokenImage);
        if (token == null  || !metadata.isNonReservedKeyword(token)) {
            list.add(seq);
            continue;
        }
        boolean match = matchesPrefix(seq, prefixes);
        if (!match) {
            list.add(seq);
        }
    }

    ex.expectedTokenSequences =
        (int [][]) list.toArray(new int [list.size()][]);
    return ex;
  }

  boolean matchesPrefix(int[] seq, int[][] prefixes) throws ParseException {
    nextPrefix:
    for (int[] prefix : prefixes) {
        if (seq.length == prefix.length + 1) {
            for (int k = 0; k < prefix.length; k++) {
                if (prefix[k] != seq[k]) {
                    continue nextPrefix;
                }
            }
            return true;
        }
    }
    return false;
  }

/*****************************************
 * Syntactical Descriptions              *
 *****************************************/
  final public SqlNode ExprOrJoinOrOrderedQuery(ExprContext exprContext) throws ParseException {
    SqlNode e;
    final List<Object> list = new ArrayList<Object>();
    if (jj_2_1(2)) {
      e = Query(exprContext);
      e = OrderByLimitOpt(e);
          {if (true) return e;}
    } else if (jj_2_2(1)) {
      e = TableRef1(ExprContext.ACCEPT_QUERY_OR_JOIN);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CROSS:
        case FULL:
        case INNER:
        case JOIN:
        case LEFT:
        case NATURAL:
        case OUTER:
        case RIGHT:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        e = JoinTable(e);
      }
          list.add(e);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXCEPT:
        case INTERSECT:
        case SET_MINUS:
        case UNION:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
        AddSetOpQuery(list, exprContext);
      }
          {if (true) return SqlParserUtil.toTree(list);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses either a row expression or a query expression with an optional
 * ORDER BY.
 *
 * <p>Postgres syntax for limit:
 *
 * <blockquote><pre>
 *    [ LIMIT { count | ALL } ]
 *    [ OFFSET start ]</pre>
 * </blockquote>
 *
 * <p>Trino syntax for limit:
 *
 * <blockquote><pre>
 *    [ OFFSET start ]
 *    [ LIMIT { count | ALL } ]</pre>
 * </blockquote>
 *
 * <p>MySQL syntax for limit:
 *
 * <blockquote><pre>
 *    [ LIMIT { count | start, count } ]</pre>
 * </blockquote>
 *
 * <p>SQL:2008 syntax for limit:
 *
 * <blockquote><pre>
 *    [ OFFSET start { ROW | ROWS } ]
 *    [ FETCH { FIRST | NEXT } [ count ] { ROW | ROWS } ONLY ]</pre>
 * </blockquote>
 */
  final public SqlNode OrderedQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    e = QueryOrExpr(exprContext);
    e = OrderByLimitOpt(e);
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Reads optional "ORDER BY", "LIMIT", "OFFSET", "FETCH" following a query,
 * {@code e}. If any of them are present, adds them to the query;
 * otherwise returns the query unchanged.
 * Throws if they are present and {@code e} is not a query. */
  final public SqlNode OrderByLimitOpt(SqlNode e) throws ParseException {
    final SqlNodeList orderBy;
    final Span s = Span.of();
    SqlNode[] offsetFetch = {null, null};
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      // use the syntactic type of the expression we just parsed
              // to decide whether ORDER BY makes sense
              orderBy = OrderBy(e.isA(SqlKind.QUERY));
      break;
    default:
      jj_la1[2] = jj_gen;
          orderBy = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FETCH:
    case LIMIT:
    case OFFSET:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMIT:
        LimitClause(s, offsetFetch);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OFFSET:
          OffsetClause(s, offsetFetch);
          break;
        default:
          jj_la1[3] = jj_gen;
          ;
        }
        break;
      case OFFSET:
        OffsetClause(s, offsetFetch);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FETCH:
        case LIMIT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LIMIT:
            LimitClause(s, offsetFetch);
                if (!this.conformance.isOffsetLimitAllowed()) {
                    {if (true) throw SqlUtil.newContextException(s.end(this),
                        RESOURCE.offsetLimitNotAllowed());}
                }
            break;
          case FETCH:
            FetchClause(offsetFetch);
            break;
          default:
            jj_la1[4] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[5] = jj_gen;
          ;
        }
        break;
      case FETCH:
        FetchClause(offsetFetch);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
        if (orderBy != null || offsetFetch[0] != null || offsetFetch[1] != null) {
            {if (true) return new SqlOrderBy(getPos(), e,
                Util.first(orderBy, SqlNodeList.EMPTY),
                offsetFetch[0], offsetFetch[1]);}
        }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an OFFSET clause in an ORDER BY expression.
 */
  final public void OffsetClause(Span s, SqlNode[] offsetFetch) throws ParseException {
    jj_consume_token(OFFSET);
               s.add(this);
    offsetFetch[0] = UnsignedNumericLiteralOrParam();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
    case ROWS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
        break;
      case ROWS:
        jj_consume_token(ROWS);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
  }

/**
 * Parses a FETCH clause in an ORDER BY expression.
 */
  final public void FetchClause(SqlNode[] offsetFetch) throws ParseException {
    jj_consume_token(FETCH);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case NEXT:
      jj_consume_token(NEXT);
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    offsetFetch[1] = UnsignedNumericLiteralOrParam();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
      jj_consume_token(ROW);
      break;
    case ROWS:
      jj_consume_token(ROWS);
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ONLY);
  }

/**
 * Parses a LIMIT clause in an ORDER BY expression.
 */
  final public void LimitClause(Span s, SqlNode[] offsetFetch) throws ParseException {
    jj_consume_token(LIMIT);
              s.add(this);
    if (jj_2_3(2)) {
      offsetFetch[0] = UnsignedNumericLiteralOrParam();
      jj_consume_token(COMMA);
      offsetFetch[1] = UnsignedNumericLiteralOrParam();
            if (!this.conformance.isLimitStartCountAllowed()) {
                {if (true) throw SqlUtil.newContextException(s.end(this),
                    RESOURCE.limitStartCountNotAllowed());}
            }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case HOOK:
        offsetFetch[1] = UnsignedNumericLiteralOrParam();
        break;
      case ALL:
        jj_consume_token(ALL);
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * Parses a leaf in a query expression (SELECT, VALUES or TABLE).
 */
  final public SqlNode LeafQuery(ExprContext exprContext) throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
        // ensure a query is legal in this context
        checkQueryExpression(exprContext);
      e = SqlSelect();
                      {if (true) return e;}
      break;
    case VALUE:
    case VALUES:
      e = TableConstructor();
                             {if (true) return e;}
      break;
    case TABLE:
      e = ExplicitTable(getPos());
                                  {if (true) return e;}
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a parenthesized query or single row expression.
 * Depending on {@code exprContext}, may also accept a join.
 */
  final public SqlNode ParenthesizedExpression(ExprContext exprContext) throws ParseException {
    SqlNode e;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so queries inside should
        // be allowed as sub-queries
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            exprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            exprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    e = ExprOrJoinOrOrderedQuery(exprContext);
    jj_consume_token(RPAREN);
        exprContext.throwIfNotCompatible(e);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a parenthesized query or comma-list of row expressions.
 *
 * <p>REVIEW jvs 8-Feb-2004: There's a small hole in this production.  It can be
 * used to construct something like
 *
 * <blockquote><pre>
 * WHERE x IN (select count(*) from t where c=d,5)</pre>
 * </blockquote>
 *
 * <p>which should be illegal.  The above is interpreted as equivalent to
 *
 * <blockquote><pre>
 * WHERE x IN ((select count(*) from t where c=d),5)</pre>
 * </blockquote>
 *
 * <p>which is a legal use of a sub-query.  The only way to fix the hole is to
 * be able to remember whether a subexpression was parenthesized or not, which
 * means preserving parentheses in the SqlNode tree.  This is probably
 * desirable anyway for use in purely syntactic parsing applications (e.g. SQL
 * pretty-printer).  However, if this is done, it's important to also make
 * isA() on the paren node call down to its operand so that we can
 * always correctly discriminate a query from a row expression.
 */
  final public SqlNodeList ParenthesizedQueryOrCommaList(ExprContext exprContext) throws ParseException {
    SqlNode e;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    ExprContext firstExprContext = exprContext;
    final Span s;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so a query by itself should
        // be interpreted as a sub-query
        s = span();
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    e = OrderedQueryOrExpr(firstExprContext);
                                               list.add(e);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      AddExpression(list, exprContext);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** As ParenthesizedQueryOrCommaList, but allows DEFAULT
 * in place of any of the expressions. For example,
 * {@code (x, DEFAULT, null, DEFAULT)}. */
  final public SqlNodeList ParenthesizedQueryOrCommaListWithDefault(ExprContext exprContext) throws ParseException {
    SqlNode e;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    ExprContext firstExprContext = exprContext;
    final Span s;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so a query by itself should
        // be interpreted as a sub-query
        s = span();
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUE:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = OrderedQueryOrExpr(firstExprContext);
                                                   list.add(e);
      break;
    case DEFAULT_:
      e = Default();
                        list.add(e);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = Expression(exprContext);
                                          list.add(e);
        break;
      case DEFAULT_:
        e = Default();
                            list.add(e);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses function parameter lists.
 * If the list starts with DISTINCT or ALL, it is discarded.
 */
  final public List<SqlNode> UnquantifiedFunctionParameterList(ExprContext exprContext) throws ParseException {
    final List<SqlNode> args;
    args = FunctionParameterList(exprContext);
        args.remove(0); // remove DISTINCT or ALL, if present
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses function parameter lists including DISTINCT keyword recognition,
 * DEFAULT, and named argument assignment.
 */
  final public List<SqlNode> FunctionParameterList(ExprContext exprContext) throws ParseException {
    final SqlLiteral qualifier;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      qualifier = AllOrDistinct();
                                      list.add(qualifier);
      break;
    default:
      jj_la1[18] = jj_gen;
          list.add(null);
    }
    AddArg0(list, exprContext);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      AddArg(list, exprContext);
    }
    jj_consume_token(RPAREN);
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral AllOrDistinct() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                 {if (true) return SqlSelectKeyword.DISTINCT.symbol(getPos());}
      break;
    case ALL:
      jj_consume_token(ALL);
            {if (true) return SqlSelectKeyword.ALL.symbol(getPos());}
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void AddArg0(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    final SqlIdentifier name;
    SqlNode e;
    final ExprContext firstExprContext;
    {
        // we've now seen left paren, so queries inside should
        // be allowed as sub-queries
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        default:
            firstExprContext = exprContext;
            break;
        }
    }
    if (jj_2_4(2)) {
      name = SimpleIdentifier();
      jj_consume_token(NAMED_ARGUMENT_ASSIGNMENT);
    } else {
          name = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_:
      e = Default();
      break;
    default:
      jj_la1[21] = jj_gen;
      if (jj_2_5(3)) {
        e = TableParam();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ARRAY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CASE:
        case CAST:
        case CATALOG:
        case CATALOG_NAME:
        case CEIL:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASSIFIER:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CONVERT:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT:
        case CURRENT_CATALOG:
        case CURRENT_DATE:
        case CURRENT_DEFAULT_TRANSFORM_GROUP:
        case CURRENT_PATH:
        case CURRENT_ROLE:
        case CURRENT_SCHEMA:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURRENT_USER:
        case CURSOR:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATE:
        case DATE_DIFF:
        case DATE_TRUNC:
        case DATETIME:
        case DATETIME_DIFF:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DATETIME_TRUNC:
        case DAYOFWEEK:
        case DAYOFYEAR:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOT_FORMAT:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXISTS:
        case EXP:
        case EXTERNAL:
        case EXTRACT:
        case FALSE:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case ILIKE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDE:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INTERVAL:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case JSON_ARRAY:
        case JSON_ARRAYAGG:
        case JSON_EXISTS:
        case JSON_OBJECT:
        case JSON_OBJECTAGG:
        case JSON_QUERY:
        case JSON_VALUE:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MATCH_NUMBER:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MULTISET:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NEW:
        case NEXT:
        case NORMALIZED:
        case NOT:
        case NTH_VALUE:
        case NTILE:
        case NULL:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERLAY:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENTILE_CONT:
        case PERCENTILE_DISC:
        case PERCENT_RANK:
        case PERIOD:
        case PIVOT:
        case PLACING:
        case PLAN:
        case PLI:
        case POSITION:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PREV:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case QUARTERS:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case RLIKE:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW:
        case ROW_COUNT:
        case ROW_NUMBER:
        case RUNNING:
        case SAFE_CAST:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELECT:
        case SELF:
        case SEPARATOR:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SESSION_USER:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STATEMENT:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case SYSTEM_USER:
        case TABLE:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIME:
        case TIME_DIFF:
        case TIME_TRUNC:
        case TIMESTAMP:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TIMESTAMP_DIFF:
        case TIMESTAMP_TRUNC:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRANSLATE:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRIM:
        case TRUE:
        case TRUNCATE:
        case TRY_CAST:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNIQUE:
        case UNKNOWN:
        case UNPIVOT:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VALUE:
        case VALUES:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WEEKS:
        case WITH:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case ANALYZE:
        case CONNECTOR:
        case JOB:
        case JOBS:
        case MAPPING:
        case MAPPINGS:
        case RESOURCES:
        case RESUME:
        case SHARED:
        case SINK:
        case SNAPSHOT:
        case SUSPEND:
        case TYPES:
        case VIEWS:
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
        case BINARY_STRING_LITERAL:
        case QUOTED_STRING:
        case PREFIXED_STRING_LITERAL:
        case UNICODE_STRING_LITERAL:
        case C_STYLE_ESCAPED_STRING_LITERAL:
        case BIG_QUERY_DOUBLE_QUOTED_STRING:
        case BIG_QUERY_QUOTED_STRING:
        case LPAREN:
        case LBRACE_D:
        case LBRACE_T:
        case LBRACE_TS:
        case LBRACE_FN:
        case HOOK:
        case PLUS:
        case MINUS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          e = PartitionedQueryOrQueryOrExpr(firstExprContext);
          break;
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(
                Span.of(name, e).pos(), e, name);
        }
        list.add(e);
  }

  final public void AddArg(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    final SqlIdentifier name;
    SqlNode e;
    if (jj_2_6(2)) {
      name = SimpleIdentifier();
      jj_consume_token(NAMED_ARGUMENT_ASSIGNMENT);
    } else {
          name = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_:
      e = Default();
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(exprContext);
      break;
    case TABLE:
      e = TableParam();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(
                Span.of(name, e).pos(), e, name);
        }
        list.add(e);
  }

  final public SqlNode Default() throws ParseException {
    jj_consume_token(DEFAULT_);
        {if (true) return SqlStdOperatorTable.DEFAULT.createCall(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a query (SELECT, UNION, INTERSECT, EXCEPT, VALUES, TABLE) followed by
 * the end-of-file symbol.
 */
  final public SqlNode SqlQueryEof() throws ParseException {
    SqlNode query;
    query = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
    jj_consume_token(0);
      {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of SQL statements separated by semicolon.
 * The semicolon is required between statements, but is
 * optional at the end.
 */
  final public SqlNodeList SqlStmtList() throws ParseException {
    final List<SqlNode> stmtList = new ArrayList<SqlNode>();
    SqlNode stmt;
    stmt = SqlStmt();
        stmtList.add(stmt);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_6;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CALL:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CREATE:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DELETE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIBE:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DROP:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXPLAIN:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSERT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MERGE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESET:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SET:
      case SETS:
      case SHOW:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPDATE:
      case UPPER:
      case UPSERT:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUE:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        stmt = SqlStmt();
                stmtList.add(stmt);
        break;
      default:
        jj_la1[25] = jj_gen;
        ;
      }
    }
    jj_consume_token(0);
        {if (true) return new SqlNodeList(stmtList, Span.of(stmtList).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an SQL statement.
 */
  final public SqlNode SqlStmt() throws ParseException {
    SqlNode stmt;
    if (jj_2_7(2)) {
      stmt = SqlAlterJob();
    } else if (jj_2_8(2)) {
      stmt = SqlAnalyzeStatement();
    } else if (jj_2_9(2)) {
      stmt = SqlExplainStatement();
    } else if (jj_2_10(2)) {
      stmt = SqlExtendedInsert();
    } else if (jj_2_11(2)) {
      stmt = SqlShowStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESET:
      case SET:
        stmt = SqlSetOption(Span.of(), null);
        break;
      case ALTER:
        stmt = SqlAlter();
        break;
      case CREATE:
        stmt = SqlCreate();
        break;
      case DROP:
        stmt = SqlDrop();
        break;
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUE:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        break;
      case EXPLAIN:
        stmt = SqlExplain();
        break;
      case DESCRIBE:
        stmt = SqlDescribe();
        break;
      case INSERT:
      case UPSERT:
        stmt = SqlInsert();
        break;
      case DELETE:
        stmt = SqlDelete();
        break;
      case UPDATE:
        stmt = SqlUpdate();
        break;
      case MERGE:
        stmt = SqlMerge();
        break;
      case CALL:
        stmt = SqlProcedureCall();
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an SQL statement followed by the end-of-file symbol.
 */
  final public SqlNode SqlStmtEof() throws ParseException {
    SqlNode stmt;
    stmt = SqlStmt();
    jj_consume_token(0);
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses CREATE EXTERNAL MAPPING statement.
 */
  final public SqlCreate SqlCreateMapping(Span span, boolean replace) throws ParseException {
    SqlParserPos startPos = span.pos();

    SqlIdentifier name;
    SqlIdentifier externalName = null;
    SqlNodeList columns = SqlNodeList.EMPTY;
    SqlIdentifier dataConnection = null;
    SqlIdentifier connectorType = null;
    SqlIdentifier objectType = null;
    SqlNodeList sqlOptions = SqlNodeList.EMPTY;
    boolean ifNotExists = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTERNAL:
      jj_consume_token(EXTERNAL);
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    jj_consume_token(MAPPING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                              ifNotExists = true;
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTERNAL:
      jj_consume_token(EXTERNAL);
      jj_consume_token(NAME);
                            externalName = CompoundIdentifier();
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    columns = MappingColumns();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATA:
      jj_consume_token(DATA);
      jj_consume_token(CONNECTION);
      dataConnection = CompoundIdentifier();
      break;
    case TYPE:
    case CONNECTOR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONNECTOR:
        jj_consume_token(CONNECTOR);
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      jj_consume_token(TYPE);
      connectorType = SimpleIdentifier();
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OBJECT:
      jj_consume_token(OBJECT);
      jj_consume_token(TYPE);
      objectType = SimpleIdentifier();
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      jj_consume_token(OPTIONS);
      sqlOptions = SqlOptions();
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
        {if (true) return new SqlCreateMapping(
            name,
            externalName,
            columns,
            dataConnection,
            connectorType,
            objectType,
            sqlOptions,
            replace,
            ifNotExists,
            startPos.plus(getPos())
        );}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses CREATE DATA CONNECTION statement.
 */
  final public SqlCreate SqlCreateDataConnection(Span span, boolean replace) throws ParseException {
    SqlParserPos startPos = span.pos();
    boolean ifNotExists = false;
    boolean shared = true;
    SqlIdentifier name;
    SqlIdentifier type;
    SqlNodeList sqlOptions = SqlNodeList.EMPTY;
    jj_consume_token(DATA);
    jj_consume_token(CONNECTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                              ifNotExists = true;
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
    jj_consume_token(TYPE);
    type = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
    case SHARED:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
        jj_consume_token(SHARED);
                              shared = false;
        break;
      case SHARED:
        jj_consume_token(SHARED);
                        shared = true;
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      jj_consume_token(OPTIONS);
      sqlOptions = SqlOptions();
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
        {if (true) return new SqlCreateDataConnection(
            startPos.plus(getPos()),
            replace,
            ifNotExists,
            name,
            type,
            shared,
            sqlOptions
        );}
    throw new Error("Missing return statement in function");
  }

  final public SqlCreate SqlCreateType(Span span, boolean replace) throws ParseException {
    SqlParserPos startPos = span.pos();
    SqlIdentifier name;
    SqlNodeList columns = SqlNodeList.EMPTY;
    SqlNodeList sqlOptions = SqlNodeList.EMPTY;
    boolean ifNotExists = false;
    jj_consume_token(TYPE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                              ifNotExists = true;
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
    columns = TypeColumns();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      jj_consume_token(OPTIONS);
      sqlOptions = SqlOptions();
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
        {if (true) return new SqlCreateType(
            name,
            columns,
            sqlOptions,
            replace,
            ifNotExists,
            startPos.plus(getPos())
        );}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList TypeColumns() throws ParseException {
    SqlParserPos pos = getPos();
    SqlTypeColumn column;
    List<SqlNode> columns = new ArrayList<SqlNode>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
                    pos = getPos();
      column = TypeColumn();
            columns.add(column);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[40] = jj_gen;
          break label_7;
        }
        jj_consume_token(COMMA);
        column = TypeColumn();
                columns.add(column);
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
        {if (true) return new SqlNodeList(columns, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

  final public SqlTypeColumn TypeColumn() throws ParseException {
    Span span;
    SqlIdentifier name;
    SqlDataType type;
    name = SimpleIdentifier();
                                span = span();
    type = SqlDataType();
        {if (true) return new SqlTypeColumn(name, type, span.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList MappingColumns() throws ParseException {
    SqlParserPos pos = getPos();

    SqlMappingColumn column;
    List<SqlNode> columns = new ArrayList<SqlNode>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
                    pos = getPos();
      column = MappingColumn();
            columns.add(column);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[42] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        column = MappingColumn();
                columns.add(column);
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
        {if (true) return new SqlNodeList(columns, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

  final public SqlMappingColumn MappingColumn() throws ParseException {
    Span span;

    SqlIdentifier name;
    SqlDataType type;
    SqlIdentifier externalName = null;
    name = SimpleIdentifier();
                                span = span();
    type = SqlDataType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTERNAL:
      jj_consume_token(EXTERNAL);
      jj_consume_token(NAME);
                            externalName = SimpleIdentifier();
      break;
    default:
      jj_la1[44] = jj_gen;
      ;
    }
        {if (true) return new SqlMappingColumn(name, type, externalName, span.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public SqlDataType SqlDataType() throws ParseException {
    Span span;

    QueryDataType type;
    type = QueryDataType();
                             span = span();
        {if (true) return new SqlDataType(type, span.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public QueryDataType QueryDataType() throws ParseException {
    QueryDataType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIGINT:
    case BOOLEAN:
    case DEC:
    case DECIMAL:
    case DOUBLE:
    case INT:
    case INTEGER:
    case NUMERIC:
    case REAL:
    case SMALLINT:
    case TINYINT:
      type = NumericTypes();
      break;
    case CHAR:
    case CHARACTER:
    case VARCHAR:
      type = CharacterTypes();
      break;
    case DATE:
    case TIME:
    case TIMESTAMP:
      type = DateTimeTypes();
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      type = ObjectTypes();
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public QueryDataType NumericTypes() throws ParseException {
    QueryDataType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
                    type = QueryDataType.BOOLEAN;
      break;
    case TINYINT:
      jj_consume_token(TINYINT);
                    type = QueryDataType.TINYINT;
      break;
    case SMALLINT:
      jj_consume_token(SMALLINT);
                     type = QueryDataType.SMALLINT;
      break;
    case INT:
    case INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INT:
        jj_consume_token(INT);
        break;
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                type = QueryDataType.INT;
      break;
    case BIGINT:
      jj_consume_token(BIGINT);
                   type = QueryDataType.BIGINT;
      break;
    case REAL:
      jj_consume_token(REAL);
                 type = QueryDataType.REAL;
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECISION:
        jj_consume_token(PRECISION);
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
                                   type = QueryDataType.DOUBLE;
      break;
    case DEC:
    case DECIMAL:
    case NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      case DEC:
        jj_consume_token(DEC);
        break;
      case NUMERIC:
        jj_consume_token(NUMERIC);
        break;
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                           type = QueryDataType.DECIMAL;
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public QueryDataType CharacterTypes() throws ParseException {
    QueryDataType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARCHAR:
      jj_consume_token(VARCHAR);
      break;
    case CHAR:
    case CHARACTER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR:
        jj_consume_token(CHAR);
        break;
      case CHARACTER:
        jj_consume_token(CHARACTER);
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(VARYING);
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                             type = QueryDataType.VARCHAR;
        {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public QueryDataType DateTimeTypes() throws ParseException {
    QueryDataType type;
    boolean withTimeZone = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIME:
      jj_consume_token(TIME);
                 type = QueryDataType.TIME;
      break;
    case DATE:
      jj_consume_token(DATE);
                 type = QueryDataType.DATE;
      break;
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
      withTimeZone = HazelcastTimeZoneOpt();
            if (withTimeZone) {
                type = QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            } else {
                type = QueryDataType.TIMESTAMP;
            }
      break;
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public QueryDataType ObjectTypes() throws ParseException {
    QueryDataType type;
    SqlIdentifier typeId;
    if (jj_2_12(2)) {
      jj_consume_token(OBJECT);
                   type = QueryDataType.OBJECT;
    } else if (jj_2_13(2)) {
      jj_consume_token(JSON);
                 type = QueryDataType.JSON;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        type = CustomObjectType();
        break;
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public QueryDataType CustomObjectType() throws ParseException {
    SqlIdentifier typeName;
    typeName = SimpleIdentifier();
        {if (true) return new QueryDataType(typeName.getSimple());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses DROP EXTERNAL MAPPING statement.
 */
  final public SqlDrop SqlDropMapping(Span span, boolean replace) throws ParseException {
    SqlParserPos pos = span.pos();

    SqlIdentifier name;
    boolean ifExists = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTERNAL:
      jj_consume_token(EXTERNAL);
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    jj_consume_token(MAPPING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        ifExists = true;
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
        {if (true) return new SqlDropMapping(name, ifExists, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses DROP DATA CONNECTION statement.
 */
  final public SqlDrop SqlDropDataConnection(Span span, boolean replace) throws ParseException {
    SqlParserPos pos = span.pos();

    SqlIdentifier name;
    boolean ifExists = false;
    jj_consume_token(DATA);
    jj_consume_token(CONNECTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        ifExists = true;
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
        {if (true) return new SqlDropDataConnection(name, ifExists, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses DROP TYPE statement.
 */
  final public SqlDrop SqlDropType(Span span, boolean replace) throws ParseException {
    SqlParserPos pos = span.pos();

    SqlIdentifier name;
    boolean ifExists = false;
    jj_consume_token(TYPE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        ifExists = true;
      break;
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
        {if (true) return new SqlDropType(name, ifExists, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
* Parses CREATE INDEX statement.
*/
  final public SqlCreate SqlCreateIndex(Span span, boolean replace) throws ParseException {
    SqlParserPos startPos = span.pos();

    SqlIdentifier name;
    SqlIdentifier objectName;
    SqlNodeList attributes;
    SqlIdentifier type = null;
    SqlNodeList sqlOptions = SqlNodeList.EMPTY;
    boolean ifNotExists = false;
    jj_consume_token(INDEX);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                                  ifNotExists = true;
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    name = SimpleIdentifier();
    jj_consume_token(ON);
    objectName = SimpleIdentifier();
    attributes = IndexAttributes();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TYPE:
      jj_consume_token(TYPE);
      type = SimpleIdentifier();
      break;
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      jj_consume_token(OPTIONS);
      sqlOptions = SqlOptions();
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
            {if (true) return new SqlCreateIndex(
                name,
                objectName,
                attributes,
                type,
                sqlOptions,
                replace,
                ifNotExists,
                startPos.plus(getPos())
        );}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList IndexAttributes() throws ParseException {
    SqlParserPos pos = getPos();

    SqlIdentifier attributeName;
    List<SqlNode> attributes = new ArrayList<SqlNode>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
                    pos = getPos();
      attributeName = SimpleIdentifier();
            attributes.add(attributeName);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        attributeName = SimpleIdentifier();
                attributes.add(attributeName);
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[62] = jj_gen;
      ;
    }
        {if (true) return new SqlNodeList(attributes, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses DROP INDEX statement.
 */
  final public SqlDrop SqlDropIndex(Span span, boolean replace) throws ParseException {
    SqlParserPos pos = span.pos();

    SqlIdentifier name;
    SqlIdentifier objectName;
    boolean ifExists = false;
    jj_consume_token(INDEX);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        ifExists = true;
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    name = SimpleIdentifier();
    jj_consume_token(ON);
    objectName = SimpleIdentifier();
        {if (true) return new SqlDropIndex(name, objectName, ifExists, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses CREATE JOB statement.
 */
  final public SqlCreate SqlCreateJob(Span span, boolean replace) throws ParseException {
    SqlParserPos startPos = span.pos();

    SqlIdentifier name;
    boolean ifNotExists = false;
    SqlNodeList sqlOptions = SqlNodeList.EMPTY;
    SqlExtendedInsert sqlInsert;
    jj_consume_token(JOB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                              ifNotExists = true;
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    name = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      jj_consume_token(OPTIONS);
      sqlOptions = SqlOptions();
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    sqlInsert = SqlExtendedInsert();
        {if (true) return new SqlCreateJob(
            name,
            sqlOptions,
            sqlInsert,
            replace,
            ifNotExists,
            startPos.plus(getPos())
        );}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses ALTER JOB statement.
 */
  final public SqlAlterJob SqlAlterJob() throws ParseException {
    SqlParserPos pos = getPos();

    SqlIdentifier name;
    SqlNodeList sqlOptions = null;
    SqlAlterJob.AlterJobOperation operation = null;
    jj_consume_token(ALTER);
    jj_consume_token(JOB);
    name = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      jj_consume_token(OPTIONS);
      sqlOptions = SqlOptions();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESUME:
        jj_consume_token(RESUME);
                operation = SqlAlterJob.AlterJobOperation.RESUME;
        break;
      default:
        jj_la1[66] = jj_gen;
        ;
      }
      break;
    case SUSPEND:
      jj_consume_token(SUSPEND);
            operation = SqlAlterJob.AlterJobOperation.SUSPEND;
      break;
    case RESUME:
      jj_consume_token(RESUME);
            operation = SqlAlterJob.AlterJobOperation.RESUME;
      break;
    case RESTART:
      jj_consume_token(RESTART);
            operation = SqlAlterJob.AlterJobOperation.RESTART;
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlAlterJob(name, sqlOptions, operation, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses DROP JOB statement.
 */
  final public SqlDrop SqlDropJob(Span span, boolean replace) throws ParseException {
    SqlParserPos pos = span.pos();

    SqlIdentifier name;
    boolean ifExists = false;
    SqlIdentifier withSnapshotName = null;
    jj_consume_token(JOB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        ifExists = true;
      break;
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    name = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      jj_consume_token(SNAPSHOT);
      withSnapshotName = SimpleIdentifier();
      break;
    default:
      jj_la1[69] = jj_gen;
      ;
    }
        {if (true) return new SqlDropJob(name, ifExists, withSnapshotName, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses CREATE SNAPSHOT statement
 */
  final public SqlCreate SqlCreateSnapshot(Span span, boolean replace) throws ParseException {
    SqlParserPos startPos = span.pos();
    SqlIdentifier snapshotName;
    SqlIdentifier jobName;
    jj_consume_token(SNAPSHOT);
    snapshotName = SimpleIdentifier();
    jj_consume_token(FOR);
    jj_consume_token(JOB);
    jobName = SimpleIdentifier();
        {if (true) return new SqlCreateSnapshot(
            snapshotName,
            jobName,
            replace,
            startPos.plus(getPos())
        );}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses DROP SNAPSHOT statement
 */
  final public SqlDrop SqlDropSnapshot(Span span, boolean replace) throws ParseException {
    SqlParserPos pos = span.pos();

    SqlIdentifier name;
    boolean ifExists = false;
    jj_consume_token(SNAPSHOT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        ifExists = true;
      break;
    default:
      jj_la1[70] = jj_gen;
      ;
    }
    name = SimpleIdentifier();
        {if (true) return new SqlDropSnapshot(name, ifExists, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses CREATE VIEW statement.
 */
  final public SqlCreate SqlCreateView(Span span, boolean replace) throws ParseException {
    SqlParserPos startPos = span.pos();
    boolean ifNotExists = false;
    SqlIdentifier name;
    SqlNode query;
    jj_consume_token(VIEW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                              ifNotExists = true;
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
    jj_consume_token(AS);
    query = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new com.hazelcast.jet.sql.impl.parse.SqlCreateView(
            startPos,
            replace,
            ifNotExists,
            name,
            query
        );}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses DROP VIEW statement.
 */
  final public SqlDrop SqlDropView(Span span, boolean replace) throws ParseException {
    SqlParserPos pos = span.pos();

    SqlIdentifier name;
    boolean ifExists = false;
    jj_consume_token(VIEW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        ifExists = true;
      break;
    default:
      jj_la1[72] = jj_gen;
      ;
    }
    name = CompoundIdentifier();
        {if (true) return new SqlDropView(name, ifExists, pos.plus(getPos()));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses OPTIONS.
 */
  final public SqlNodeList SqlOptions() throws ParseException {
    Span span;

    SqlOption sqlOption;
    List<SqlNode> sqlOptions = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               span = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      sqlOption = SqlOption();
            sqlOptions.add(sqlOption);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[73] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        sqlOption = SqlOption();
                sqlOptions.add(sqlOption);
      }
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(sqlOptions, span.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public SqlOption SqlOption() throws ParseException {
    Span span;
    SqlNode key, value;
    key = StringLiteral();
                            span = span();
    jj_consume_token(EQ);
    value = StringLiteral();
        {if (true) return new SqlOption(key, value, span.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
* Parses SHOW statements.
*/
  final public SqlShowStatement SqlShowStatement() throws ParseException {
    ShowStatementTarget target;
    SqlIdentifier dataConnectionName = null;
    jj_consume_token(SHOW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTERNAL:
    case MAPPINGS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTERNAL:
        jj_consume_token(EXTERNAL);
        break;
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      jj_consume_token(MAPPINGS);
                                    target = ShowStatementTarget.MAPPINGS;
      break;
    case VIEWS:
      jj_consume_token(VIEWS);
                  target = ShowStatementTarget.VIEWS;
      break;
    case JOBS:
      jj_consume_token(JOBS);
                 target = ShowStatementTarget.JOBS;
      break;
    case TYPES:
      jj_consume_token(TYPES);
                  target = ShowStatementTarget.TYPES;
      break;
    case DATA:
      jj_consume_token(DATA);
      jj_consume_token(CONNECTIONS);
                               target = ShowStatementTarget.DATACONNECTIONS;
      break;
    case RESOURCES:
      jj_consume_token(RESOURCES);
      jj_consume_token(FOR);
                            dataConnectionName = CompoundIdentifier(); target = ShowStatementTarget.RESOURCES;
      break;
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlShowStatement(getPos(), target, dataConnectionName);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an EXPLAIN statement.
 */
  final public SqlNode SqlExplainStatement() throws ParseException {
    SqlNode stmt;
    jj_consume_token(EXPLAIN);
    if (jj_2_14(2)) {
      jj_consume_token(PLAN);
      jj_consume_token(FOR);
    } else {
      ;
    }
    stmt = ExtendedSqlQueryOrDml();
        {if (true) return new SqlExplainStatement(getPos(), stmt);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode SqlAnalyzeStatement() throws ParseException {
    SqlNode stmt;
    SqlNodeList sqlOptions = SqlNodeList.EMPTY;
    jj_consume_token(ANALYZE);
    if (jj_2_15(2)) {
      jj_consume_token(WITH);
      jj_consume_token(OPTIONS);
      sqlOptions = SqlOptions();
    } else {
      ;
    }
    stmt = ExtendedSqlQueryOrDml();
        {if (true) return new SqlAnalyzeStatement(getPos(), stmt, sqlOptions);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses INSERT/SINK INTO statement.
 */
  final public SqlExtendedInsert SqlExtendedInsert() throws ParseException {
    Span span;

    SqlNode table;
    SqlNode source;
    List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    SqlNodeList keywordList;
    List<SqlLiteral> extendedKeywords = new ArrayList<SqlLiteral>();
    SqlNodeList extendedKeywordList;
    SqlNodeList columns = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
      break;
    case SINK:
      jj_consume_token(SINK);
            extendedKeywords.add(SqlExtendedInsert.Keyword.SINK.symbol(getPos()));
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(INTO);
             span = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, span.addAll(keywords).pos());
        extendedKeywordList = new SqlNodeList(extendedKeywords, span.addAll(extendedKeywords).pos());
    table = CompoundIdentifier();
    if (jj_2_16(2)) {
      columns = ParenthesizedSimpleIdentifierList();
    } else {
      ;
    }
    source = QueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlExtendedInsert(
            table,
            source,
            keywordList,
            extendedKeywordList,
            columns,
            span.end(source)
        );}
    throw new Error("Missing return statement in function");
  }

/** Parses a query (SELECT or VALUES)
 * or DML statement (extended INSERT, UPDATE, DELETE). */
  final public SqlNode ExtendedSqlQueryOrDml() throws ParseException {
    SqlNode stmt;
    if (jj_2_17(2)) {
      stmt = SqlExtendedInsert();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUE:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        break;
      case DELETE:
        stmt = SqlDelete();
        break;
      case UPDATE:
        stmt = SqlUpdate();
        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Hazelcast specific date-time types parsing.
 */
  final public SqlTypeNameSpec HazelcastDateTimeTypeName() throws ParseException {
    SqlTypeName typeName;
    boolean withTimeZone = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
      jj_consume_token(DATE);
        typeName = SqlTypeName.DATE;
        {if (true) return new SqlBasicTypeNameSpec(typeName, getPos());}
      break;
    default:
      jj_la1[79] = jj_gen;
      if (jj_2_18(2)) {
        jj_consume_token(TIME);
        typeName = SqlTypeName.TIME;
        {if (true) return new SqlBasicTypeNameSpec(typeName, -1, getPos());}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIMESTAMP:
          jj_consume_token(TIMESTAMP);
          withTimeZone = HazelcastTimeZoneOpt();
        if (withTimeZone) {
            typeName = SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
        } else {
            typeName = SqlTypeName.TIMESTAMP;
        }
        {if (true) return new SqlBasicTypeNameSpec(typeName, -1, getPos());}
          break;
        default:
          jj_la1[80] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public boolean HazelcastTimeZoneOpt() throws ParseException {
    if (jj_2_19(3)) {
      jj_consume_token(WITHOUT);
      jj_consume_token(TIME);
      jj_consume_token(ZONE);
                              {if (true) return false;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(TIME);
        jj_consume_token(ZONE);
                           {if (true) return true;}
        break;
      default:
        jj_la1[81] = jj_gen;
      {if (true) return false;}
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList ParenthesizedKeyValueOptionCommaList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
      s = span();
    jj_consume_token(LPAREN);
    AddKeyValueOption(list);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[82] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      AddKeyValueOption(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an option with format key=val whose key is a simple identifier or string literal
* and value is a string literal.
*/
  final public void AddKeyValueOption(List<SqlNode> list) throws ParseException {
    final SqlNode key;
    final SqlNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      key = SimpleIdentifier();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      key = StringLiteral();
      break;
    default:
      jj_la1[83] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(EQ);
    value = StringLiteral();
        list.add(key);
        list.add(value);
  }

/** Parses an option value (either a string or a numeric) and adds to a list. */
  final public void AddOptionValue(List<SqlNode> list) throws ParseException {
    final SqlNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case PLUS:
    case MINUS:
      value = NumericLiteral();
                                   list.add(value);
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      value = StringLiteral();
                                  list.add(value);
      break;
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Parses a literal list separated by comma. The literal is either a string or a numeric.
 */
  final public SqlNodeList ParenthesizedLiteralOptionCommaList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
      s = span();
    jj_consume_token(LPAREN);
    AddOptionValue(list);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[85] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      AddOptionValue(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void AddHint(List<SqlNode> hints) throws ParseException {
    final SqlIdentifier hintName;
    final SqlNodeList hintOptions;
    final SqlHint.HintOptionFormat optionFormat;
    hintName = SimpleIdentifier();
    if (jj_2_20(5)) {
      hintOptions = ParenthesizedKeyValueOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.KV_LIST;
    } else if (jj_2_21(3)) {
      hintOptions = ParenthesizedSimpleIdentifierList();
            optionFormat = SqlHint.HintOptionFormat.ID_LIST;
    } else if (jj_2_22(3)) {
      hintOptions = ParenthesizedLiteralOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.LITERAL_LIST;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[86] = jj_gen;
        ;
      }
            hintOptions = SqlNodeList.EMPTY;
            optionFormat = SqlHint.HintOptionFormat.EMPTY;
    }
        hints.add(
           new SqlHint(Span.of(hintOptions).end(this), hintName, hintOptions,
               optionFormat));
  }

/** Parses hints following a table reference,
 * and returns the wrapped table reference. */
  final public SqlNode TableHints(SqlIdentifier tableName) throws ParseException {
    final List<SqlNode> hints = new ArrayList<SqlNode>();
    jj_consume_token(HINT_BEG);
    AddHint(hints);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      AddHint(hints);
    }
    jj_consume_token(COMMENT_END);
        final SqlParserPos pos = Span.of(tableName).addAll(hints).end(this);
        final SqlNodeList hintList = new SqlNodeList(hints, pos);
        {if (true) return new SqlTableRef(pos, tableName, hintList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a leaf SELECT expression without ORDER BY.
 */
  final public SqlSelect SqlSelect() throws ParseException {
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlLiteral keyword;
    final SqlNodeList keywordList;
    final List<SqlNode> selectList = new ArrayList<SqlNode>();
    final SqlNode fromClause;
    final SqlNode where;
    final SqlNodeList groupBy;
    final SqlNode having;
    final SqlNodeList windowDecls;
    final SqlNode qualify;
    final List<SqlNode> hints = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(SELECT);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      jj_consume_token(HINT_BEG);
      AddHint(hints);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[88] = jj_gen;
          break label_14;
        }
        jj_consume_token(COMMA);
        AddHint(hints);
      }
      jj_consume_token(COMMENT_END);
      break;
    default:
      jj_la1[89] = jj_gen;
      ;
    }
    SqlSelectKeywords(keywords);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STREAM:
      jj_consume_token(STREAM);
            keywords.add(SqlSelectKeyword.STREAM.symbol(getPos()));
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      keyword = AllOrDistinct();
                                    keywords.add(keyword);
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
        keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
    AddSelectItem(selectList);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[92] = jj_gen;
        break label_15;
      }
      jj_consume_token(COMMA);
      AddSelectItem(selectList);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      fromClause = FromClause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        where = Where();
        break;
      default:
        jj_la1[93] = jj_gen;
                              where = null;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GROUP:
        groupBy = GroupBy();
        break;
      default:
        jj_la1[94] = jj_gen;
                                  groupBy = null;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HAVING:
        having = Having();
        break;
      default:
        jj_la1[95] = jj_gen;
                                having = null;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WINDOW:
        windowDecls = Window();
        break;
      default:
        jj_la1[96] = jj_gen;
                                     windowDecls = null;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUALIFY:
        qualify = Qualify();
        break;
      default:
        jj_la1[97] = jj_gen;
                                  qualify = null;
      }
      break;
    default:
      jj_la1[98] = jj_gen;
      E();
            fromClause = null;
            where = null;
            groupBy = null;
            having = null;
            windowDecls = null;
            qualify = null;
    }
        {if (true) return new SqlSelect(s.end(this), keywordList,
            new SqlNodeList(selectList, Span.of(selectList).pos()),
            fromClause, where, groupBy, having, windowDecls, qualify,
            null, null, null, new SqlNodeList(hints, getPos()));}
    throw new Error("Missing return statement in function");
  }

/*
 * Abstract production:
 *
 *    void SqlSelectKeywords(List keywords)
 *
 * Parses dialect-specific keywords immediately following the SELECT keyword.
 */

/**
 * Parses an EXPLAIN PLAN statement.
 */
  final public SqlNode SqlExplain() throws ParseException {
    SqlNode stmt;
    SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    SqlExplain.Depth depth;
    final SqlExplainFormat format;
    jj_consume_token(EXPLAIN);
    jj_consume_token(PLAN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLUDING:
    case INCLUDING:
      detailLevel = ExplainDetailLevel();
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    depth = ExplainDepth();
    if (jj_2_23(2)) {
      jj_consume_token(AS);
      jj_consume_token(XML);
                     format = SqlExplainFormat.XML;
    } else if (jj_2_24(2)) {
      jj_consume_token(AS);
      jj_consume_token(JSON);
                      format = SqlExplainFormat.JSON;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        jj_consume_token(DOT_FORMAT);
                            format = SqlExplainFormat.DOT;
        break;
      default:
        jj_la1[100] = jj_gen;
          format = SqlExplainFormat.TEXT;
      }
    }
    jj_consume_token(FOR);
    stmt = SqlQueryOrDml();
        {if (true) return new SqlExplain(getPos(),
            stmt,
            detailLevel.symbol(SqlParserPos.ZERO),
            depth.symbol(SqlParserPos.ZERO),
            format.symbol(SqlParserPos.ZERO),
            nDynamicParams);}
    throw new Error("Missing return statement in function");
  }

/** Parses a query (SELECT or VALUES)
 * or DML statement (INSERT, UPDATE, DELETE, MERGE). */
  final public SqlNode SqlQueryOrDml() throws ParseException {
    SqlNode stmt;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUE:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
      break;
    case INSERT:
    case UPSERT:
      stmt = SqlInsert();
      break;
    case DELETE:
      stmt = SqlDelete();
      break;
    case UPDATE:
      stmt = SqlUpdate();
      break;
    case MERGE:
      stmt = SqlMerge();
      break;
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses WITH TYPE | WITH IMPLEMENTATION | WITHOUT IMPLEMENTATION modifier for
 * EXPLAIN PLAN.
 */
  final public SqlExplain.Depth ExplainDepth() throws ParseException {
    if (jj_2_25(2)) {
      jj_consume_token(WITH);
      jj_consume_token(TYPE);
            {if (true) return SqlExplain.Depth.TYPE;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(IMPLEMENTATION);
            {if (true) return SqlExplain.Depth.PHYSICAL;}
        break;
      case WITHOUT:
        jj_consume_token(WITHOUT);
        jj_consume_token(IMPLEMENTATION);
            {if (true) return SqlExplain.Depth.LOGICAL;}
        break;
      default:
        jj_la1[102] = jj_gen;
            {if (true) return SqlExplain.Depth.PHYSICAL;}
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses INCLUDING ALL ATTRIBUTES modifier for EXPLAIN PLAN.
 */
  final public SqlExplainLevel ExplainDetailLevel() throws ParseException {
    SqlExplainLevel level = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      jj_consume_token(ATTRIBUTES);
            level = SqlExplainLevel.NO_ATTRIBUTES;
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                  level = SqlExplainLevel.ALL_ATTRIBUTES;
        break;
      default:
        jj_la1[103] = jj_gen;
        ;
      }
      jj_consume_token(ATTRIBUTES);

      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return level;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a DESCRIBE statement.
 */
  final public SqlNode SqlDescribe() throws ParseException {
   final Span s;
   final SqlIdentifier table;
   final SqlIdentifier column;
   final SqlIdentifier id;
   final SqlNode stmt;
    jj_consume_token(DESCRIBE);
                 s = span();
    if (jj_2_26(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATABASE:
        jj_consume_token(DATABASE);
        break;
      case CATALOG:
        jj_consume_token(CATALOG);
        break;
      case SCHEMA:
        jj_consume_token(SCHEMA);
        break;
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      id = CompoundIdentifier();
            // DESCRIBE DATABASE and DESCRIBE CATALOG currently do the same as
            // DESCRIBE SCHEMA but should be different. See
            //   [CALCITE-1221] Implement DESCRIBE DATABASE, CATALOG, STATEMENT
            {if (true) return new SqlDescribeSchema(s.end(id), id);}
    } else if (jj_2_27(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
        jj_consume_token(TABLE);
        break;
      default:
        jj_la1[106] = jj_gen;
        ;
      }
      table = CompoundIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        column = SimpleIdentifier();
        break;
      default:
        jj_la1[107] = jj_gen;
                                          column = null;
      }
            {if (true) return new SqlDescribeTable(s.add(table).addIf(column).pos(),
                table, column);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DELETE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSERT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MERGE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPDATE:
      case UPPER:
      case UPSERT:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUE:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STATEMENT:
          jj_consume_token(STATEMENT);
          break;
        default:
          jj_la1[108] = jj_gen;
          ;
        }
        stmt = SqlQueryOrDml();
            // DESCRIBE STATEMENT currently does the same as EXPLAIN. See
            //   [CALCITE-1221] Implement DESCRIBE DATABASE, CATALOG, STATEMENT
            final SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
            final SqlExplain.Depth depth = SqlExplain.Depth.PHYSICAL;
            final SqlExplainFormat format = SqlExplainFormat.TEXT;
            {if (true) return new SqlExplain(s.end(stmt),
                stmt,
                detailLevel.symbol(SqlParserPos.ZERO),
                depth.symbol(SqlParserPos.ZERO),
                format.symbol(SqlParserPos.ZERO),
                nDynamicParams);}
        break;
      default:
        jj_la1[109] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CALL statement.
 */
  final public SqlNode SqlProcedureCall() throws ParseException {
    final Span s;
    SqlNode routineCall;
    jj_consume_token(CALL);
        s = span();
    routineCall = NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_PROCEDURE,
            ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.PROCEDURE_CALL.createCall(
            s.end(routineCall), routineCall);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode NamedRoutineCall(SqlFunctionCategory routineType,
    ExprContext exprContext) throws ParseException {
    final SqlIdentifier name;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    name = CompoundIdentifier();
        s = span();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULT_:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUE:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      AddArg0(list, exprContext);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[110] = jj_gen;
          break label_16;
        }
        jj_consume_token(COMMA);
                // a comma-list can't appear where only a query is expected
                checkNonQueryExpression(exprContext);
        AddArg(list, exprContext);
      }
      break;
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return createCall(name, s.end(this), routineType, null, list);}
    throw new Error("Missing return statement in function");
  }

/**
 * Table parameter of a table function.
 * The input table with set semantics may be partitioned/ordered on one or more columns.
 */
  final public SqlNode TableParam() throws ParseException {
    final Span s;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
    SqlNode tableRef;
      s = span();
    tableRef = ExplicitTable(getPos());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      jj_consume_token(BY);
      partitionList = SimpleIdentifierOrList();
      break;
    default:
      jj_la1[112] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderByOfSetSemanticsTable();
      break;
    default:
      jj_la1[113] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
      {if (true) return CreateSetSemanticsTableIfNeeded(s, tableRef, partitionList, orderList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PartitionedQueryOrQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    e = OrderedQueryOrExpr(exprContext);
    e = PartitionedByAndOrderBy(e);
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PartitionedByAndOrderBy(SqlNode e) throws ParseException {
    final Span s;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
      s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      jj_consume_token(BY);
      partitionList = SimpleIdentifierOrList();
      break;
    default:
      jj_la1[114] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderByOfSetSemanticsTable();
      break;
    default:
      jj_la1[115] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
      {if (true) return CreateSetSemanticsTableIfNeeded(s, e, partitionList, orderList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList OrderByOfSetSemanticsTable() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(ORDER);
    s = span();
    jj_consume_token(BY);
    if (jj_2_29(2)) {
      jj_consume_token(LPAREN);
      AddOrderItem(list);
      label_17:
      while (true) {
        if (jj_2_28(2)) {
          ;
        } else {
          break label_17;
        }
        jj_consume_token(COMMA);
        AddOrderItem(list);
      }
      jj_consume_token(RPAREN);
          {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        AddOrderItem(list);
          {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
        break;
      default:
        jj_la1[116] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlNode CreateSetSemanticsTableIfNeeded(final Span s,
    final SqlNode e,
    final SqlNodeList partitionList,
    final SqlNodeList orderList) throws ParseException {
        if (partitionList.isEmpty() && orderList.isEmpty()) {
            {if (true) return e;}
        } else {
            {if (true) return SqlStdOperatorTable.SET_SEMANTICS_TABLE.createCall(
                s.pos(), e, partitionList, orderList);}
        }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an INSERT statement.
 */
  final public SqlNode SqlInsert() throws ParseException {
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlNodeList keywordList;
    final SqlIdentifier tableName;
    SqlNode tableRef;
    SqlNode source;
    final SqlNodeList columnList;
    final Span s;
    final Pair<SqlNodeList, SqlNodeList> p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
      break;
    case UPSERT:
      jj_consume_token(UPSERT);
                   keywords.add(SqlInsertKeyword.UPSERT.symbol(getPos()));
      break;
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
    jj_consume_token(INTO);
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[118] = jj_gen;
                                           tableRef = tableName;
    }
    if (jj_2_30(5)) {
      tableRef = ExtendTable(tableRef);
    } else {
      ;
    }
    if (jj_2_31(2)) {
      p = ParenthesizedCompoundIdentifierList();
            if (p.right.size() > 0) {
                tableRef = extend(tableRef, p.right);
            }
            if (p.left.size() > 0) {
                columnList = p.left;
            } else {
                columnList = null;
            }
    } else {
          columnList = null;
    }
    source = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlInsert(s.end(source), keywordList, tableRef, source,
            columnList);}
    throw new Error("Missing return statement in function");
  }

/*
 * Abstract production:
 *
 *    void SqlInsertKeywords(List keywords)
 *
 * Parses dialect-specific keywords immediately following the INSERT keyword.
 */

/**
 * Parses a DELETE statement.
 */
  final public SqlNode SqlDelete() throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final SqlNode where;
    final Span s;
    jj_consume_token(DELETE);
        s = span();
    jj_consume_token(FROM);
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[119] = jj_gen;
                                           tableRef = tableName;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      tableRef = ExtendTable(tableRef);
      break;
    default:
      jj_la1[120] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[121] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[122] = jj_gen;
                                              alias = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where = Where();
      break;
    default:
      jj_la1[123] = jj_gen;
                          where = null;
    }
        {if (true) return new SqlDelete(s.add(tableRef).addIf(alias).addIf(where).pos(),
            tableRef, where, null, alias);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an UPDATE statement.
 */
  final public SqlNode SqlUpdate() throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final SqlNode where;
    final SqlNodeList sourceExpressionList;
    final SqlNodeList targetColumnList;
    SqlIdentifier id;
    final Span s;
    jj_consume_token(UPDATE);
        s = span();
        targetColumnList = new SqlNodeList(s.pos());
        sourceExpressionList = new SqlNodeList(s.pos());
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[124] = jj_gen;
                                           tableRef = tableName;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      tableRef = ExtendTable(tableRef);
      break;
    default:
      jj_la1[125] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[126] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[127] = jj_gen;
                                              alias = null;
    }
    jj_consume_token(SET);
    id = SimpleIdentifier();
        targetColumnList.add(id);
    jj_consume_token(EQ);
    AddExpression(sourceExpressionList, ExprContext.ACCEPT_SUB_QUERY);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[128] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      id = SimpleIdentifier();
                                  targetColumnList.add(id);
      jj_consume_token(EQ);
      AddExpression(sourceExpressionList, ExprContext.ACCEPT_SUB_QUERY);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where = Where();
      break;
    default:
      jj_la1[129] = jj_gen;
                          where = null;
    }
        final SqlParserPos pos = s.addAll(targetColumnList)
            .addAll(sourceExpressionList).addIf(where).pos();
        {if (true) return new SqlUpdate(pos, tableRef, targetColumnList,
            sourceExpressionList, where, null, alias);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a MERGE statement.
 */
  final public SqlNode SqlMerge() throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final SqlNode sourceTableRef;
    final SqlNode condition;
    final SqlUpdate updateCall;
    final SqlInsert insertCall;
    final Span s;
    jj_consume_token(MERGE);
              s = span();
    jj_consume_token(INTO);
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[130] = jj_gen;
                                           tableRef = tableName;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      tableRef = ExtendTable(tableRef);
      break;
    default:
      jj_la1[131] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[132] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[133] = jj_gen;
                                              alias = null;
    }
    jj_consume_token(USING);
    sourceTableRef = TableRef();
    jj_consume_token(ON);
    condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
    if (jj_2_32(2)) {
      updateCall = WhenMatchedClause(tableRef, alias);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        insertCall = WhenNotMatchedClause(tableRef);
        break;
      default:
        jj_la1[134] = jj_gen;
                                                          insertCall = null;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
          updateCall = null;
        insertCall = WhenNotMatchedClause(tableRef);
        break;
      default:
        jj_la1[135] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        final SqlParserPos pos = s.addIf(updateCall).addIf(insertCall).pos();
        {if (true) return new SqlMerge(pos, tableRef, condition, sourceTableRef,
            updateCall, insertCall, null, alias);}
    throw new Error("Missing return statement in function");
  }

  final public SqlUpdate WhenMatchedClause(SqlNode table, SqlIdentifier alias) throws ParseException {
    SqlIdentifier id;
    final Span s;
    final SqlNodeList updateColumnList = new SqlNodeList(SqlParserPos.ZERO);
    final SqlNodeList updateExprList = new SqlNodeList(SqlParserPos.ZERO);
    jj_consume_token(WHEN);
             s = span();
    jj_consume_token(MATCHED);
    jj_consume_token(THEN);
    jj_consume_token(UPDATE);
    jj_consume_token(SET);
    id = CompoundIdentifier();
        updateColumnList.add(id);
    jj_consume_token(EQ);
    AddExpression(updateExprList, ExprContext.ACCEPT_SUB_QUERY);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[136] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      id = CompoundIdentifier();
            updateColumnList.add(id);
      jj_consume_token(EQ);
      AddExpression(updateExprList, ExprContext.ACCEPT_SUB_QUERY);
    }
        {if (true) return new SqlUpdate(s.addAll(updateExprList).pos(), table,
            updateColumnList, updateExprList, null, null, alias);}
    throw new Error("Missing return statement in function");
  }

  final public SqlInsert WhenNotMatchedClause(SqlNode table) throws ParseException {
    final Span insertSpan, valuesSpan;
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlNodeList keywordList;
    final SqlNodeList insertColumnList;
    SqlNode rowConstructor;
    SqlNode insertValues;
    jj_consume_token(WHEN);
    jj_consume_token(NOT);
    jj_consume_token(MATCHED);
    jj_consume_token(THEN);
    jj_consume_token(INSERT);
        insertSpan = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, insertSpan.end(this));
    if (jj_2_33(2)) {
      insertColumnList = ParenthesizedSimpleIdentifierList();
    } else {
          insertColumnList = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      jj_consume_token(VALUES);
                   valuesSpan = span();
      rowConstructor = RowConstructor();
      jj_consume_token(RPAREN);
      break;
    case VALUES:
      jj_consume_token(VALUES);
                   valuesSpan = span();
      rowConstructor = RowConstructor();
      break;
    default:
      jj_la1[137] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // TODO zfong 5/26/06: note that extra parentheses are accepted above
        // around the VALUES clause as a hack for unparse, but this is
        // actually invalid SQL; should fix unparse
        insertValues = SqlStdOperatorTable.VALUES.createCall(
            valuesSpan.end(this), rowConstructor);
        {if (true) return new SqlInsert(insertSpan.end(this), keywordList,
            table, insertValues, insertColumnList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one item in a select list.
 */
  final public void AddSelectItem(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlIdentifier id;
    e = SelectExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case QUOTED_STRING:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        id = SimpleIdentifier();
        break;
      case QUOTED_STRING:
        id = SimpleIdentifierFromStringLiteral();
        break;
      default:
        jj_la1[139] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          list.add(SqlStdOperatorTable.AS.createCall(span().end(e), e, id));
      break;
    default:
      jj_la1[140] = jj_gen;
          list.add(e);
    }
  }

/**
 * Parses one unaliased expression in a select list.
 */
  final public SqlNode SelectExpression() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
        {if (true) return SqlIdentifier.star(getPos());}
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return e;}
      break;
    default:
      jj_la1[141] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral Natural() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NATURAL:
      jj_consume_token(NATURAL);
                {if (true) return SqlLiteral.createBoolean(true, getPos());}
      break;
    default:
      jj_la1[142] = jj_gen;
      {if (true) return SqlLiteral.createBoolean(false, getPos());}
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral JoinType() throws ParseException {
    JoinType joinType;
    if (jj_2_34(3)) {
      jj_consume_token(JOIN);
                 joinType = JoinType.INNER;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INNER:
        jj_consume_token(INNER);
        jj_consume_token(JOIN);
                         joinType = JoinType.INNER;
        break;
      case LEFT:
        jj_consume_token(LEFT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[143] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                    joinType = JoinType.LEFT;
        break;
      case RIGHT:
        jj_consume_token(RIGHT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[144] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                     joinType = JoinType.RIGHT;
        break;
      case FULL:
        jj_consume_token(FULL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[145] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                    joinType = JoinType.FULL;
        break;
      case CROSS:
        jj_consume_token(CROSS);
        jj_consume_token(JOIN);
                         joinType = JoinType.CROSS;
        break;
      default:
        jj_la1[146] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return joinType.symbol(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the FROM clause for a SELECT.
 *
 * <p>FROM is mandatory in standard SQL, optional in dialects such as MySQL,
 * PostgreSQL. The parser allows SELECT without FROM, but the validator fails
 * if conformance is, say, STRICT_2003.
 */
  final public SqlNode FromClause() throws ParseException {
    SqlNode e, e2;
    SqlLiteral joinType;
    e = Join();
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[147] = jj_gen;
        break label_20;
      }
      jj_consume_token(COMMA);
                  joinType = JoinType.COMMA.symbol(getPos());
      e2 = Join();
            e = new SqlJoin(joinType.getParserPosition(),
                e,
                SqlLiteral.createBoolean(false, joinType.getParserPosition()),
                joinType,
                e2,
                JoinConditionType.NONE.symbol(SqlParserPos.ZERO),
                null);
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode Join() throws ParseException {
    SqlNode e;
    e = TableRef1(ExprContext.ACCEPT_QUERY_OR_JOIN);
    label_21:
    while (true) {
      if (jj_2_35(2)) {
        ;
      } else {
        break label_21;
      }
      e = JoinTable(e);
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Matches "LEFT JOIN t ON ...", "RIGHT JOIN t USING ...", "JOIN t". */
  final public SqlNode JoinTable(SqlNode e) throws ParseException {
    SqlNode e2, condition;
    final SqlLiteral natural, joinType, on, using;
    SqlNodeList list;
    if (jj_2_36(3)) {
      natural = Natural();
      joinType = JoinType();
      e2 = TableRef1(ExprContext.ACCEPT_QUERY_OR_JOIN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        jj_consume_token(ON);
               on = JoinConditionType.ON.symbol(getPos());
        condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                on,
                condition);}
        break;
      case USING:
        jj_consume_token(USING);
                  using = JoinConditionType.USING.symbol(getPos());
        list = ParenthesizedSimpleIdentifierList();
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                using,
                new SqlNodeList(list, Span.of(using).end(this)));}
        break;
      default:
        jj_la1[148] = jj_gen;
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                JoinConditionType.NONE.symbol(joinType.getParserPosition()),
                null);}
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CROSS:
        jj_consume_token(CROSS);
              joinType = JoinType.CROSS.symbol(getPos());
        jj_consume_token(APPLY);
        e2 = TableRef2(true);
        if (!this.conformance.isApplyAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.applyNotAllowed());}
        }
        {if (true) return new SqlJoin(joinType.getParserPosition(),
            e,
            SqlLiteral.createBoolean(false, joinType.getParserPosition()),
            joinType,
            e2,
            JoinConditionType.NONE.symbol(SqlParserPos.ZERO),
            null);}
        break;
      case OUTER:
        jj_consume_token(OUTER);
              joinType = JoinType.LEFT.symbol(getPos());
        jj_consume_token(APPLY);
        e2 = TableRef2(true);
        if (!this.conformance.isApplyAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.applyNotAllowed());}
        }
        {if (true) return new SqlJoin(joinType.getParserPosition(),
            e,
            SqlLiteral.createBoolean(false, joinType.getParserPosition()),
            joinType,
            e2,
            JoinConditionType.ON.symbol(SqlParserPos.ZERO),
            SqlLiteral.createBoolean(true, joinType.getParserPosition()));}
        break;
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a table reference in a FROM clause, not lateral unless LATERAL
 * is explicitly specified.
 */
  final public SqlNode TableRef() throws ParseException {
    final SqlNode e;
    e = TableRef3(ExprContext.ACCEPT_QUERY, false);
                                                     {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode TableRef1(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    e = TableRef3(exprContext, false);
                                        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a table reference in a FROM clause.
 */
  final public SqlNode TableRef2(boolean lateral) throws ParseException {
    final SqlNode e;
    e = TableRef3(ExprContext.ACCEPT_QUERY, lateral);
                                                       {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode TableRef3(ExprContext exprContext, boolean lateral) throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final Span s;
    SqlNodeList args;
    final SqlNodeList columnAliasList;
    SqlUnnestOperator unnestOp = SqlStdOperatorTable.UNNEST;
    if (jj_2_37(2)) {
      tableName = CompoundTableIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HINT_BEG:
        tableRef = TableHints(tableName);
        break;
      default:
        jj_la1[150] = jj_gen;
                                               tableRef = tableName;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTEND:
      case LPAREN:
        tableRef = ExtendTable(tableRef);
        break;
      default:
        jj_la1[151] = jj_gen;
        ;
      }
      tableRef = Over(tableRef);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        tableRef = Snapshot(tableRef);
        break;
      default:
        jj_la1[152] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH_RECOGNIZE:
        tableRef = MatchRecognize(tableRef);
        break;
      default:
        jj_la1[153] = jj_gen;
        ;
      }
    } else if (jj_2_38(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LATERAL:
        jj_consume_token(LATERAL);
                      lateral = true;
        break;
      default:
        jj_la1[154] = jj_gen;
        ;
      }
      tableRef = ParenthesizedExpression(exprContext);
      tableRef = Over(tableRef);
      tableRef = addLateral(tableRef, lateral);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH_RECOGNIZE:
        tableRef = MatchRecognize(tableRef);
        break;
      default:
        jj_la1[155] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNNEST:
        jj_consume_token(UNNEST);
                   s = span();
        args = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_SUB_QUERY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          jj_consume_token(ORDINALITY);
                unnestOp = SqlStdOperatorTable.UNNEST_WITH_ORDINALITY;
          break;
        default:
          jj_la1[156] = jj_gen;
          ;
        }
            tableRef = unnestOp.createCall(s.end(this), (List<SqlNode>) args);
        break;
      case LATERAL:
      case TABLE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LATERAL:
          jj_consume_token(LATERAL);
                      lateral = true;
          break;
        default:
          jj_la1[157] = jj_gen;
          ;
        }
        tableRef = TableFunctionCall();
        tableRef = addLateral(tableRef, lateral);
        break;
      default:
        jj_la1[158] = jj_gen;
        if (jj_2_39(1)) {
          tableRef = ExtendedTableRef();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    if (jj_2_40(2)) {
      tableRef = Pivot(tableRef);
    } else {
      ;
    }
    if (jj_2_41(2)) {
      tableRef = Unpivot(tableRef);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[159] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        columnAliasList = ParenthesizedSimpleIdentifierList();
        break;
      default:
        jj_la1[160] = jj_gen;
              columnAliasList = null;
      }
            // Standard SQL (and Postgres) allow applying "AS alias" to a JOIN,
            // e.g. "FROM (a CROSS JOIN b) AS c". The new alias obscures the
            // internal aliases, and columns cannot be referenced if they are
            // not unique. TODO: Support this behavior; see
            // [CALCITE-5168] Allow AS after parenthesized JOIN
            checkNotJoin(tableRef);
            if (columnAliasList == null) {
                tableRef = SqlStdOperatorTable.AS.createCall(
                    Span.of(tableRef).end(this), tableRef, alias);
            } else {
                List<SqlNode> idList = new ArrayList<SqlNode>();
                idList.add(tableRef);
                idList.add(alias);
                idList.addAll(columnAliasList.getList());
                tableRef = SqlStdOperatorTable.AS.createCall(
                    Span.of(tableRef).end(this), idList);
            }
      break;
    default:
      jj_la1[161] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLESAMPLE:
      tableRef = Tablesample(tableRef);
      break;
    default:
      jj_la1[162] = jj_gen;
      ;
    }
      {if (true) return tableRef;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode Tablesample(SqlNode tableRef) throws ParseException {
    final Span s;
    final SqlNode sample;
    final boolean isBernoulli;
    final SqlNumericLiteral samplePercentage;
    boolean isRepeatable = false;
    int repeatableSeed = 0;
    jj_consume_token(TABLESAMPLE);
                    s = span(); checkNotJoin(tableRef);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBSTITUTE:
      jj_consume_token(SUBSTITUTE);
      jj_consume_token(LPAREN);
      sample = StringLiteral();
      jj_consume_token(RPAREN);
            String sampleName =
                SqlLiteral.unchain(sample).getValueAs(String.class);
            SqlSampleSpec sampleSpec = SqlSampleSpec.createNamed(sampleName);
            final SqlLiteral sampleLiteral =
                SqlLiteral.createSample(sampleSpec, s.end(this));
            tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(
                s.add(tableRef).end(this), tableRef, sampleLiteral);
      break;
    case BERNOULLI:
    case SYSTEM:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BERNOULLI:
        jj_consume_token(BERNOULLI);
                          isBernoulli = true;
        break;
      case SYSTEM:
        jj_consume_token(SYSTEM);
                       isBernoulli = false;
        break;
      default:
        jj_la1[163] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LPAREN);
      samplePercentage = UnsignedNumericLiteral();
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REPEATABLE:
        jj_consume_token(REPEATABLE);
        jj_consume_token(LPAREN);
        repeatableSeed = IntLiteral();
        jj_consume_token(RPAREN);
                isRepeatable = true;
        break;
      default:
        jj_la1[164] = jj_gen;
        ;
      }
            final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
            BigDecimal rate = samplePercentage.bigDecimalValue();
            if (rate.compareTo(BigDecimal.ZERO) < 0
                || rate.compareTo(ONE_HUNDRED) > 0)
            {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.invalidSampleSize());}
            }

            // Treat TABLESAMPLE(0) and TABLESAMPLE(100) as no table
            // sampling at all.  Not strictly correct: TABLESAMPLE(0)
            // should produce no output, but it simplifies implementation
            // to know that some amount of sampling will occur.
            // In practice values less than ~1E-43% are treated as 0.0 and
            // values greater than ~99.999997% are treated as 1.0
            float fRate = rate.divide(ONE_HUNDRED).floatValue();
            if (fRate > 0.0f && fRate < 1.0f) {
                SqlSampleSpec tableSampleSpec =
                    isRepeatable
                        ? SqlSampleSpec.createTableSample(
                            isBernoulli, fRate, repeatableSeed)
                        : SqlSampleSpec.createTableSample(isBernoulli, fRate);

                SqlLiteral tableSampleLiteral =
                    SqlLiteral.createSample(tableSampleSpec, s.end(this));
                tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(
                    s.end(this), tableRef, tableSampleLiteral);
            }
      break;
    default:
      jj_la1[165] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return tableRef;}
    throw new Error("Missing return statement in function");
  }

/** Wraps a table reference in a call to EXTEND if an optional "EXTEND" clause
 * is present. */
  final public SqlNode ExtendTable(SqlNode tableRef) throws ParseException {
    final SqlNodeList extendList;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
      jj_consume_token(EXTEND);
      break;
    default:
      jj_la1[166] = jj_gen;
      ;
    }
    extendList = ExtendList();
        {if (true) return extend(tableRef, extendList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList ExtendList() throws ParseException {
    final Span s;
    List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    AddColumnType(list);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[167] = jj_gen;
        break label_22;
      }
      jj_consume_token(COMMA);
      AddColumnType(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void AddColumnType(List<SqlNode> list) throws ParseException {
    final SqlIdentifier name;
    final SqlDataTypeSpec type;
    final boolean nullable;
    name = CompoundIdentifier();
    type = DataType();
    nullable = NotNullOpt();
        list.add(name);
        list.add(type.withNullable(nullable, getPos()));
  }

/**
 * Parses a compound identifier with optional type.
 */
  final public void AddCompoundIdentifierType(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
    final SqlIdentifier name;
    final SqlDataTypeSpec type;
    final boolean nullable;
    name = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case ANY:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BIGINT:
    case BINARY:
    case BOOLEAN:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHARACTER:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DEC:
    case DECADE:
    case DECIMAL:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOUBLE:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FLOAT:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INT:
    case INTEGER:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case NUMERIC:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case REAL:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SMALLINT:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TINYINT:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VARBINARY:
    case VARCHAR:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      type = DataType();
      nullable = NotNullOpt();
      break;
    default:
      jj_la1[168] = jj_gen;
          type = null; nullable = true;
    }
        if (type != null) {
            if (!this.conformance.allowExtend()) {
                {if (true) throw SqlUtil.newContextException(type.getParserPosition(),
                    RESOURCE.extendNotAllowed());}
            }
            extendList.add(name);
            extendList.add(type.withNullable(nullable, getPos()));
        }
        list.add(name);
  }

  final public SqlNode TableFunctionCall() throws ParseException {
    final Span s;
    final SqlNode call;
    SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION;
    jj_consume_token(TABLE);
              s = span();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPECIFIC:
      jj_consume_token(SPECIFIC);
            funcType = SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION;
      break;
    default:
      jj_la1[169] = jj_gen;
      ;
    }
    call = NamedRoutineCall(funcType, ExprContext.ACCEPT_CURSOR);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.COLLECTION_TABLE.createCall(s.end(this), call);}
    throw new Error("Missing return statement in function");
  }

/**
 * Abstract production:
 *    SqlNode ExtendedTableRef()
 *
 * <p>Allows parser to be extended with new types of table references.  The
 * default implementation of this production is empty.
 */

/*
 * Abstract production:
 *
 *    SqlNode TableOverOpt()
 *
 * Allows an OVER clause following a table expression as an extension to
 * standard SQL syntax. The default implementation of this production is empty.
 */

/**
 * Parses an explicit TABLE t reference.
 */
  final public SqlNode ExplicitTable(SqlParserPos pos) throws ParseException {
    SqlNode tableRef;
    jj_consume_token(TABLE);
    tableRef = CompoundIdentifier();
        {if (true) return SqlStdOperatorTable.EXPLICIT_TABLE.createCall(pos, tableRef);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a VALUES leaf query expression.
 */
  final public SqlNode TableConstructor() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUES:
      jj_consume_token(VALUES);
                   s = span();
      break;
    case VALUE:
      jj_consume_token(VALUE);
            s = span();
            if (!this.conformance.isValueAllowed()) {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.valueNotAllowed());}
            }
      break;
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    AddRowConstructor(list);
    label_23:
    while (true) {
      if (jj_2_42(2)) {
        ;
      } else {
        break label_23;
      }
      jj_consume_token(COMMA);
      AddRowConstructor(list);
    }
        {if (true) return SqlStdOperatorTable.VALUES.createCall(s.end(this), list);}
    throw new Error("Missing return statement in function");
  }

/** Parses a row constructor and adds it to a list. */
  final public void AddRowConstructor(List<SqlNode> list) throws ParseException {
    SqlNode e;
    e = RowConstructor();
                           list.add(e);
  }

/**
 * Parses a row constructor in the context of a VALUES expression.
 */
  final public SqlNode RowConstructor() throws ParseException {
    final SqlNodeList valueList;
    final SqlNode value;
    final Span s;
    if (jj_2_43(3)) {
      jj_consume_token(LPAREN);
                   s = span();
      jj_consume_token(ROW);
      valueList = ParenthesizedQueryOrCommaListWithDefault(ExprContext.ACCEPT_NONCURSOR);
      jj_consume_token(RPAREN);
                   s.add(this);
    } else if (jj_2_44(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
                    s = span();
        break;
      default:
        jj_la1[171] = jj_gen;
              s = Span.of();
      }
      valueList = ParenthesizedQueryOrCommaListWithDefault(ExprContext.ACCEPT_NONCURSOR);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        value = Expression(ExprContext.ACCEPT_NONCURSOR);
            // NOTE: A bare value here is standard SQL syntax, believe it or
            // not.  Taken together with multi-row table constructors, it leads
            // to very easy mistakes if you forget the parentheses on a
            // single-row constructor.  This is also the reason for the
            // LOOKAHEAD in TableConstructor().  It would be so much more
            // reasonable to require parentheses.  Sigh.
            s = Span.of(value);
            valueList = new SqlNodeList(ImmutableList.of(value),
                value.getParserPosition());
        break;
      default:
        jj_la1[172] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        // REVIEW jvs 8-Feb-2004: Should we discriminate between scalar
        // sub-queries inside of ROW and row sub-queries?  The standard does,
        // but the distinction seems to be purely syntactic.
        {if (true) return SqlStdOperatorTable.ROW.createCall(s.end(valueList),
            (List<SqlNode>) valueList);}
    throw new Error("Missing return statement in function");
  }

/** Parses a WHERE clause for SELECT, DELETE, and UPDATE. */
  final public SqlNode Where() throws ParseException {
    SqlNode condition;
    jj_consume_token(WHERE);
    condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return condition;}
    throw new Error("Missing return statement in function");
  }

/** Parses a GROUP BY clause for SELECT. */
  final public SqlNodeList GroupBy() throws ParseException {
    final List<SqlNode> list;
    final boolean distinct;
    final Span s;
    jj_consume_token(GROUP);
              s = span();
    jj_consume_token(BY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                     distinct = true;
      break;
    case ALL:
      jj_consume_token(ALL);
                distinct = false;
      break;
    default:
      jj_la1[173] = jj_gen;
          distinct = false;
    }
    list = GroupingElementList();
        final SqlParserPos pos = s.end(this);
        final List<SqlNode> list2 = distinct
            ? ImmutableList.of(
                SqlInternalOperators.GROUP_BY_DISTINCT.createCall(pos, list))
            : list;
        {if (true) return new SqlNodeList(list2, pos);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> GroupingElementList() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddGroupingElement(list);
    label_24:
    while (true) {
      if (jj_2_45(2)) {
        ;
      } else {
        break label_24;
      }
      jj_consume_token(COMMA);
      AddGroupingElement(list);
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public void AddGroupingElement(List<SqlNode> list) throws ParseException {
    final List<SqlNode> subList;
    final SqlNodeList nodes;
    final Span s;
    if (jj_2_46(2)) {
      jj_consume_token(GROUPING);
                 s = span();
      jj_consume_token(SETS);
      jj_consume_token(LPAREN);
      subList = GroupingElementList();
      jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.GROUPING_SETS.createCall(s.end(this), subList));
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROLLUP:
        jj_consume_token(ROLLUP);
               s = span();
        jj_consume_token(LPAREN);
        nodes = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.ROLLUP.createCall(s.end(this), nodes.getList()));
        break;
      case CUBE:
        jj_consume_token(CUBE);
             s = span();
        jj_consume_token(LPAREN);
        nodes = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.CUBE.createCall(s.end(this), nodes.getList()));
        break;
      default:
        jj_la1[174] = jj_gen;
        if (jj_2_47(3)) {
          jj_consume_token(LPAREN);
               s = span();
          jj_consume_token(RPAREN);
        list.add(new SqlNodeList(s.end(this)));
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case A:
          case ABS:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ARRAY:
          case ARRAY_AGG:
          case ARRAY_CONCAT_AGG:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case AVG:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CARDINALITY:
          case CASCADE:
          case CASE:
          case CAST:
          case CATALOG:
          case CATALOG_NAME:
          case CEIL:
          case CEILING:
          case CENTURY:
          case CHAIN:
          case CHAR:
          case CHAR_LENGTH:
          case CHARACTER_LENGTH:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASSIFIER:
          case CLASS_ORIGIN:
          case COALESCE:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLLECT:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CONVERT:
          case COUNT:
          case COVAR_POP:
          case COVAR_SAMP:
          case CUME_DIST:
          case CURRENT:
          case CURRENT_CATALOG:
          case CURRENT_DATE:
          case CURRENT_DEFAULT_TRANSFORM_GROUP:
          case CURRENT_PATH:
          case CURRENT_ROLE:
          case CURRENT_SCHEMA:
          case CURRENT_TIME:
          case CURRENT_TIMESTAMP:
          case CURRENT_USER:
          case CURSOR:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATE:
          case DATE_DIFF:
          case DATE_TRUNC:
          case DATETIME:
          case DATETIME_DIFF:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DATETIME_TRUNC:
          case DAYOFWEEK:
          case DAYOFYEAR:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DENSE_RANK:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOT_FORMAT:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ELEMENT:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EVERY:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case EXISTS:
          case EXP:
          case EXTERNAL:
          case EXTRACT:
          case FALSE:
          case FINAL:
          case FIRST:
          case FIRST_VALUE:
          case FLOOR:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case FUSION:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case GROUP_CONCAT:
          case GROUPING:
          case HIERARCHY:
          case HOP:
          case HOUR:
          case HOURS:
          case IGNORE:
          case ILIKE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDE:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INTERSECTION:
          case INTERVAL:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case JSON_ARRAY:
          case JSON_ARRAYAGG:
          case JSON_EXISTS:
          case JSON_OBJECT:
          case JSON_OBJECTAGG:
          case JSON_QUERY:
          case JSON_VALUE:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAG:
          case LAST:
          case LAST_VALUE:
          case LEAD:
          case LEFT:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LN:
          case LOCALTIME:
          case LOCALTIMESTAMP:
          case LOCATOR:
          case LOWER:
          case M:
          case MAP:
          case MATCHED:
          case MATCH_NUMBER:
          case MAX:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MIN:
          case MINUTE:
          case MINUTES:
          case MINVALUE:
          case MOD:
          case MONTH:
          case MONTHS:
          case MORE_:
          case MULTISET:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NEW:
          case NEXT:
          case NORMALIZED:
          case NOT:
          case NTH_VALUE:
          case NTILE:
          case NULL:
          case NULLABLE:
          case NULLIF:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTET_LENGTH:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERLAY:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PERCENTILE_CONT:
          case PERCENTILE_DISC:
          case PERCENT_RANK:
          case PERIOD:
          case PIVOT:
          case PLACING:
          case PLAN:
          case PLI:
          case POSITION:
          case POWER:
          case PRECEDING:
          case PRESERVE:
          case PREV:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case QUARTERS:
          case RANK:
          case READ:
          case REGR_COUNT:
          case REGR_SXX:
          case REGR_SYY:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case RIGHT:
          case RLIKE:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW:
          case ROW_COUNT:
          case ROW_NUMBER:
          case RUNNING:
          case SAFE_CAST:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECOND:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEPARATOR:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SESSION_USER:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOME:
          case SOURCE:
          case SPACE:
          case SPECIFIC:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case SQRT:
          case STATE:
          case STATEMENT:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case STRING_AGG:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case SUBSTRING:
          case SUM:
          case SYSTEM_USER:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIME:
          case TIME_DIFF:
          case TIME_TRUNC:
          case TIMESTAMP:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TIMESTAMP_DIFF:
          case TIMESTAMP_TRUNC:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRANSLATE:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TRIM:
          case TRUE:
          case TRUNCATE:
          case TRY_CAST:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNIQUE:
          case UNKNOWN:
          case UNPIVOT:
          case UNNAMED:
          case UPPER:
          case USAGE:
          case USER:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VAR_POP:
          case VAR_SAMP:
          case VERSION:
          case VIEW:
          case WEEK:
          case WEEKS:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEAR:
          case YEARS:
          case ZONE:
          case ANALYZE:
          case CONNECTOR:
          case JOB:
          case JOBS:
          case MAPPING:
          case MAPPINGS:
          case RESOURCES:
          case RESUME:
          case SHARED:
          case SINK:
          case SNAPSHOT:
          case SUSPEND:
          case TYPES:
          case VIEWS:
          case UNSIGNED_INTEGER_LITERAL:
          case APPROX_NUMERIC_LITERAL:
          case DECIMAL_NUMERIC_LITERAL:
          case BINARY_STRING_LITERAL:
          case QUOTED_STRING:
          case PREFIXED_STRING_LITERAL:
          case UNICODE_STRING_LITERAL:
          case C_STYLE_ESCAPED_STRING_LITERAL:
          case BIG_QUERY_DOUBLE_QUOTED_STRING:
          case BIG_QUERY_QUOTED_STRING:
          case LPAREN:
          case LBRACE_D:
          case LBRACE_T:
          case LBRACE_TS:
          case LBRACE_FN:
          case HOOK:
          case PLUS:
          case MINUS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            AddExpression(list, ExprContext.ACCEPT_SUB_QUERY);
            break;
          default:
            jj_la1[175] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

/**
 * Parses a list of expressions separated by commas.
 */
  final public SqlNodeList ExpressionCommaList(final Span s,
    ExprContext exprContext) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddExpressions(list, exprContext);
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of expressions separated by commas,
 * appending expressions to a given list.
 */
  final public void AddExpressions(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    AddExpression(list, exprContext);
    label_25:
    while (true) {
      if (jj_2_48(2)) {
        ;
      } else {
        break label_25;
      }
      jj_consume_token(COMMA);
      AddExpression(list, ExprContext.ACCEPT_SUB_QUERY);
    }
  }

/** Parses a HAVING clause for SELECT. */
  final public SqlNode Having() throws ParseException {
    SqlNode e;
    jj_consume_token(HAVING);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                            {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a WINDOW clause for SELECT. */
  final public SqlNodeList Window() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(WINDOW);
               s = span();
    AddWindowSpec(list);
    label_26:
    while (true) {
      if (jj_2_49(2)) {
        ;
      } else {
        break label_26;
      }
      jj_consume_token(COMMA);
      AddWindowSpec(list);
    }
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

  final public void AddWindowSpec(List<SqlNode> list) throws ParseException {
    final SqlIdentifier id;
    final SqlWindow e;
    id = SimpleIdentifier();
    jj_consume_token(AS);
    e = WindowSpecification();
        e.setDeclName(id);
        list.add(e);
  }

/**
 * Parses a window specification.
 */
  final public SqlWindow WindowSpecification() throws ParseException {
    final SqlIdentifier id;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
    final SqlLiteral isRows;
    final SqlNode lowerBound, upperBound;
    final Span s, s1, s2;
    final SqlLiteral allowPartial;
    jj_consume_token(LPAREN);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      id = SimpleIdentifier();
      break;
    default:
      jj_la1[176] = jj_gen;
          id = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
                      s1 = span();
      jj_consume_token(BY);
      partitionList = ExpressionCommaList(s1, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[177] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderBy(true);
      break;
    default:
      jj_la1[178] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RANGE:
    case ROWS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROWS:
        jj_consume_token(ROWS);
                     isRows = SqlLiteral.createBoolean(true, getPos());
        break;
      case RANGE:
        jj_consume_token(RANGE);
                      isRows = SqlLiteral.createBoolean(false, getPos());
        break;
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
        jj_consume_token(BETWEEN);
        lowerBound = WindowRange();
        jj_consume_token(AND);
        upperBound = WindowRange();
        break;
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        lowerBound = WindowRange();
              upperBound = null;
        break;
      default:
        jj_la1[180] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[181] = jj_gen;
            isRows = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
            lowerBound = upperBound = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALLOW:
      jj_consume_token(ALLOW);
                  s2 = span();
      jj_consume_token(PARTIAL);
            allowPartial = SqlLiteral.createBoolean(true, s2.end(this));
      break;
    case DISALLOW:
      jj_consume_token(DISALLOW);
                     s2 = span();
      jj_consume_token(PARTIAL);
            allowPartial = SqlLiteral.createBoolean(false, s2.end(this));
      break;
    default:
      jj_la1[182] = jj_gen;
          allowPartial = null;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlWindow.create(null, id, partitionList, orderList,
            isRows, lowerBound, upperBound, allowPartial, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode WindowRange() throws ParseException {
    final SqlNode e;
    final Span s;
    if (jj_2_50(2)) {
      jj_consume_token(CURRENT);
                s = span();
      jj_consume_token(ROW);
        {if (true) return SqlWindow.createCurrentRow(s.end(this));}
    } else if (jj_2_51(2)) {
      jj_consume_token(UNBOUNDED);
                  s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDING:
        jj_consume_token(PRECEDING);
            {if (true) return SqlWindow.createUnboundedPreceding(s.end(this));}
        break;
      case FOLLOWING:
        jj_consume_token(FOLLOWING);
            {if (true) return SqlWindow.createUnboundedFollowing(s.end(this));}
        break;
      default:
        jj_la1[183] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = Expression(ExprContext.ACCEPT_NON_QUERY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRECEDING:
          jj_consume_token(PRECEDING);
            {if (true) return SqlWindow.createPreceding(e, getPos());}
          break;
        case FOLLOWING:
          jj_consume_token(FOLLOWING);
            {if (true) return SqlWindow.createFollowing(e, getPos());}
          break;
        default:
          jj_la1[184] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[185] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a QUALIFY clause for SELECT. */
  final public SqlNode Qualify() throws ParseException {
    SqlNode e;
    jj_consume_token(QUALIFY);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                             {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an ORDER BY clause.
 */
  final public SqlNodeList OrderBy(boolean accept) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(ORDER);
        s = span();
        if (!accept) {
            // Someone told us ORDER BY wasn't allowed here.  So why
            // did they bother calling us?  To get the correct
            // parser position for error reporting.
            {if (true) throw SqlUtil.newContextException(s.pos(), RESOURCE.illegalOrderBy());}
        }
    jj_consume_token(BY);
    AddOrderItem(list);
    label_27:
    while (true) {
      if (jj_2_52(2)) {
        ;
      } else {
        break label_27;
      }
      jj_consume_token(COMMA);
      AddOrderItem(list);
    }
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one item in an ORDER BY clause, and adds it to a list.
 */
  final public void AddOrderItem(List<SqlNode> list) throws ParseException {
    SqlNode e;
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
        jj_consume_token(ASC);
        break;
      case DESC:
        jj_consume_token(DESC);
            e = SqlStdOperatorTable.DESC.createCall(getPos(), e);
        break;
      default:
        jj_la1[186] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[187] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULLS:
      if (jj_2_53(2)) {
        jj_consume_token(NULLS);
        jj_consume_token(FIRST);
            e = SqlStdOperatorTable.NULLS_FIRST.createCall(getPos(), e);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULLS:
          jj_consume_token(NULLS);
          jj_consume_token(LAST);
            e = SqlStdOperatorTable.NULLS_LAST.createCall(getPos(), e);
          break;
        default:
          jj_la1[188] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[189] = jj_gen;
      ;
    }
        list.add(e);
  }

/** Wraps a table reference in a call to OVER if an optional "OVER" clause
 * is present (if the dialect supports OVER for table expressions). */
  final public SqlNode Over(SqlNode tableRef) throws ParseException {
    final SqlNode over;
    over = TableOverOpt();
        if (over != null) {
            {if (true) return SqlStdOperatorTable.OVER.createCall(
                getPos(), checkNotJoin(tableRef), over);}
        } else {
            {if (true) return tableRef;}
        }
    throw new Error("Missing return statement in function");
  }

  SqlNode addLateral(SqlNode tableRef, boolean lateral) throws ParseException {
    return lateral
        ? SqlStdOperatorTable.LATERAL.createCall(getPos(),
            checkNotJoin(tableRef))
        : tableRef;
  }

/**
 * Parses a FOR SYSTEM_TIME clause following a table expression.
 */
  final public SqlSnapshot Snapshot(SqlNode tableRef) throws ParseException {
    final Span s;
    final SqlNode e;
      s = span();
    jj_consume_token(FOR);
    jj_consume_token(SYSTEM_TIME);
    jj_consume_token(AS);
    jj_consume_token(OF);
    // Syntax for temporal table in
        // standard SQL 2011 IWD 9075-2:201?(E) 7.6 <table reference>
        // supports grammar as following:
        // 1. datetime literal
        // 2. datetime value function, i.e. CURRENT_TIMESTAMP
        // 3. datetime term in 1 or 2 +(or -) interval term
    
        // We extend to support column reference, use Expression
        // to simplify the parsing code.
        e = Expression(ExprContext.ACCEPT_NON_QUERY);
        {if (true) return new SqlSnapshot(s.end(this), tableRef, e);}
    throw new Error("Missing return statement in function");
  }

/** Parses a PIVOT clause following a table expression. */
  final public SqlNode Pivot(SqlNode tableRef) throws ParseException {
    final Span s;
    final Span s2;
    final List<SqlNode> aggList = new ArrayList<SqlNode>();
    final List<SqlNode> valueList = new ArrayList<SqlNode>();
    final SqlNodeList axisList;
    final SqlNodeList inList;
    jj_consume_token(PIVOT);
              s = span(); checkNotJoin(tableRef);
    jj_consume_token(LPAREN);
    AddPivotAgg(aggList);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[190] = jj_gen;
        break label_28;
      }
      jj_consume_token(COMMA);
      AddPivotAgg(aggList);
    }
    jj_consume_token(FOR);
    axisList = SimpleIdentifierOrList();
    jj_consume_token(IN);
    jj_consume_token(LPAREN);
                    s2 = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      AddPivotValue(valueList);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[191] = jj_gen;
          break label_29;
        }
        jj_consume_token(COMMA);
        AddPivotValue(valueList);
      }
      break;
    default:
      jj_la1[192] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        inList = new SqlNodeList(valueList, s2.end(this));
    jj_consume_token(RPAREN);
        {if (true) return new SqlPivot(s.end(this), tableRef,
            new SqlNodeList(aggList, SqlParserPos.sum(aggList)),
            axisList, inList);}
    throw new Error("Missing return statement in function");
  }

  final public void AddPivotAgg(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlIdentifier alias;
    e = NamedFunctionCall();
    if (getToken(1).kind != COMMA && getToken(1).kind != FOR) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[193] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e,
                    alias));
    } else {
          list.add(e);
    }
  }

  final public void AddPivotValue(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlNodeList tuple;
    final SqlIdentifier alias;
    e = RowConstructor();
                           tuple = SqlParserUtil.stripRow(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[194] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(tuple).end(this),
                    tuple, alias));
      break;
    default:
      jj_la1[195] = jj_gen;
          list.add(tuple);
    }
  }

/** Parses an UNPIVOT clause following a table expression. */
  final public SqlNode Unpivot(SqlNode tableRef) throws ParseException {
    final Span s;
    final boolean includeNulls;
    final SqlNodeList measureList;
    final SqlNodeList axisList;
    final Span s2;
    final List<SqlNode> values = new ArrayList<SqlNode>();
    final SqlNodeList inList;
    jj_consume_token(UNPIVOT);
                s = span(); checkNotJoin(tableRef);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCLUDE:
      jj_consume_token(INCLUDE);
      jj_consume_token(NULLS);
                            includeNulls = true;
      break;
    case EXCLUDE:
      jj_consume_token(EXCLUDE);
      jj_consume_token(NULLS);
                            includeNulls = false;
      break;
    default:
      jj_la1[196] = jj_gen;
          includeNulls = false;
    }
    jj_consume_token(LPAREN);
    measureList = SimpleIdentifierOrList();
    jj_consume_token(FOR);
    axisList = SimpleIdentifierOrList();
    jj_consume_token(IN);
    jj_consume_token(LPAREN);
               s2 = span();
    AddUnpivotValue(values);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[197] = jj_gen;
        break label_30;
      }
      jj_consume_token(COMMA);
      AddUnpivotValue(values);
    }
    jj_consume_token(RPAREN);
      inList = new SqlNodeList(values, s2.end(this));
    jj_consume_token(RPAREN);
        {if (true) return new SqlUnpivot(s.end(this), tableRef, includeNulls, measureList,
            axisList, inList);}
    throw new Error("Missing return statement in function");
  }

  final public void AddUnpivotValue(List<SqlNode> list) throws ParseException {
    final SqlNodeList columnList;
    final SqlNode values;
    columnList = SimpleIdentifierOrList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      values = RowConstructor();
            final SqlNodeList valueList = SqlParserUtil.stripRow(values);
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(columnList).end(this),
                    columnList, valueList));
      break;
    default:
      jj_la1[198] = jj_gen;
          list.add(columnList);
    }
  }

/**
 * Parses a MATCH_RECOGNIZE clause following a table expression.
 */
  final public SqlMatchRecognize MatchRecognize(SqlNode tableRef) throws ParseException {
    final Span s, s0, s1, s2;
    final SqlNodeList measureList;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
    final SqlNode pattern;
    final SqlLiteral interval;
    final SqlNodeList patternDefList;
    final SqlNode after;
    final SqlNode var;
    final SqlLiteral rowsPerMatch;
    final SqlNodeList subsetList;
    final SqlLiteral isStrictStarts;
    final SqlLiteral isStrictEnds;
    jj_consume_token(MATCH_RECOGNIZE);
                        s = span(); checkNotJoin(tableRef);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
                      s2 = span();
      jj_consume_token(BY);
      partitionList = ExpressionCommaList(s2, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[199] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderBy(true);
      break;
    default:
      jj_la1[200] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MEASURES:
      jj_consume_token(MEASURES);
      measureList = MeasureColumnCommaList(span());
      break;
    default:
      jj_la1[201] = jj_gen;
          measureList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ONE:
      jj_consume_token(ONE);
                s0 = span();
      jj_consume_token(ROW);
      jj_consume_token(PER);
      jj_consume_token(MATCH);
            rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ONE_ROW.symbol(s0.end(this));
      break;
    case ALL:
      jj_consume_token(ALL);
                s0 = span();
      jj_consume_token(ROWS);
      jj_consume_token(PER);
      jj_consume_token(MATCH);
            rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS.symbol(s0.end(this));
      break;
    default:
      jj_la1[202] = jj_gen;
          rowsPerMatch = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AFTER:
      jj_consume_token(AFTER);
                  s1 = span();
      jj_consume_token(MATCH);
      jj_consume_token(SKIP_);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TO:
        jj_consume_token(TO);
        if (jj_2_55(2)) {
          jj_consume_token(NEXT);
          jj_consume_token(ROW);
                    after = SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW
                        .symbol(s1.end(this));
        } else if (jj_2_56(2)) {
          jj_consume_token(FIRST);
          var = SimpleIdentifier();
                    after = SqlMatchRecognize.SKIP_TO_FIRST.createCall(
                        s1.end(var), var);
        } else if (true) {
          if (jj_2_54(2)) {
            jj_consume_token(LAST);
          } else {
            ;
          }
          var = SimpleIdentifier();
                    after = SqlMatchRecognize.SKIP_TO_LAST.createCall(
                        s1.end(var), var);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case PAST:
        jj_consume_token(PAST);
        jj_consume_token(LAST);
        jj_consume_token(ROW);
                 after = SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW
                     .symbol(s1.end(this));
        break;
      default:
        jj_la1[203] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[204] = jj_gen;
          after = null;
    }
    jj_consume_token(PATTERN);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CARET:
      jj_consume_token(CARET);
                  isStrictStarts = SqlLiteral.createBoolean(true, getPos());
      break;
    default:
      jj_la1[205] = jj_gen;
          isStrictStarts = SqlLiteral.createBoolean(false, getPos());
    }
    pattern = PatternExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      jj_consume_token(DOLLAR);
                   isStrictEnds = SqlLiteral.createBoolean(true, getPos());
      break;
    default:
      jj_la1[206] = jj_gen;
          isStrictEnds = SqlLiteral.createBoolean(false, getPos());
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      jj_consume_token(WITHIN);
      interval = IntervalLiteral();
      break;
    default:
      jj_la1[207] = jj_gen;
          interval = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBSET:
      jj_consume_token(SUBSET);
      subsetList = SubsetDefinitionCommaList(span());
      break;
    default:
      jj_la1[208] = jj_gen;
          subsetList = SqlNodeList.EMPTY;
    }
    jj_consume_token(DEFINE);
    patternDefList = PatternDefinitionCommaList(span());
    jj_consume_token(RPAREN);
        {if (true) return new SqlMatchRecognize(s.end(this), tableRef,
            pattern, isStrictStarts, isStrictEnds, patternDefList, measureList,
            after, subsetList, rowsPerMatch, partitionList, orderList, interval);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList MeasureColumnCommaList(Span s) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddMeasureColumn(list);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[209] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      AddMeasureColumn(list);
    }
      {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

  final public void AddMeasureColumn(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlIdentifier alias;
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(AS);
    alias = SimpleIdentifier();
        list.add(SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e, alias));
  }

  final public SqlNode PatternExpression() throws ParseException {
    SqlNode left;
    SqlNode right;
    left = PatternTerm();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VERTICAL_BAR:
        ;
        break;
      default:
        jj_la1[210] = jj_gen;
        break label_32;
      }
      jj_consume_token(VERTICAL_BAR);
      right = PatternTerm();
            left = SqlStdOperatorTable.PATTERN_ALTER.createCall(
                Span.of(left).end(right), left, right);
    }
        {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternTerm() throws ParseException {
    SqlNode left;
    SqlNode right;
    left = PatternFactor();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERMUTE:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case LPAREN:
      case LBRACE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[211] = jj_gen;
        break label_33;
      }
      right = PatternFactor();
            left = SqlStdOperatorTable.PATTERN_CONCAT.createCall(
                Span.of(left).end(right), left, right);
    }
        {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternFactor() throws ParseException {
    final SqlNode e;
    final SqlNode extra;
    final SqlLiteral startNum;
    final SqlLiteral endNum;
    final SqlLiteral reluctant;
    e = PatternPrimary();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case HOOK:
    case PLUS:
    case STAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
                startNum = LITERAL_ZERO;
                endNum = LITERAL_MINUS_ONE;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                startNum = LITERAL_ONE;
                endNum = LITERAL_MINUS_ONE;
        break;
      case HOOK:
        jj_consume_token(HOOK);
                startNum = LITERAL_ZERO;
                endNum = LITERAL_ONE;
        break;
      case LBRACE:
        jj_consume_token(LBRACE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
          startNum = UnsignedNumericLiteral();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case UNSIGNED_INTEGER_LITERAL:
            case APPROX_NUMERIC_LITERAL:
            case DECIMAL_NUMERIC_LITERAL:
              endNum = UnsignedNumericLiteral();
              break;
            default:
              jj_la1[212] = jj_gen;
                          endNum = LITERAL_MINUS_ONE;
            }
            break;
          default:
            jj_la1[213] = jj_gen;
                       endNum = startNum;
          }
          jj_consume_token(RBRACE);
          break;
        case COMMA:
          jj_consume_token(COMMA);
          endNum = UnsignedNumericLiteral();
          jj_consume_token(RBRACE);
                  startNum = LITERAL_MINUS_ONE;
          break;
        case MINUS:
          jj_consume_token(MINUS);
          extra = PatternExpression();
          jj_consume_token(MINUS);
          jj_consume_token(RBRACE);
                    {if (true) return SqlStdOperatorTable.PATTERN_CONCAT.createCall(
                        Span.of(e).end(this), e,
                        SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(
                            Span.of(extra).end(this), extra));}
          break;
        default:
          jj_la1[214] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOOK:
        jj_consume_token(HOOK);
                reluctant = SqlLiteral.createBoolean(
                    startNum.intValue(true) != endNum.intValue(true),
                    SqlParserPos.ZERO);
        break;
      default:
        jj_la1[216] = jj_gen;
              reluctant = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
      }
      break;
    default:
      jj_la1[217] = jj_gen;
          {if (true) return e;}
    }
        {if (true) return SqlStdOperatorTable.PATTERN_QUANTIFIER.createCall(
            span().end(e), e, startNum, endNum, reluctant);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternPrimary() throws ParseException {
    final Span s;
    SqlNode e;
    final List<SqlNode> list;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = SimpleIdentifier();
                             {if (true) return e;}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      e = PatternExpression();
      jj_consume_token(RPAREN);
                                                {if (true) return e;}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
               s = span();
      jj_consume_token(MINUS);
      e = PatternExpression();
      jj_consume_token(MINUS);
      jj_consume_token(RBRACE);
        {if (true) return SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(s.end(this), e);}
      break;
    case PERMUTE:
      jj_consume_token(PERMUTE);
                    s = span(); list = new ArrayList<SqlNode>();
      jj_consume_token(LPAREN);
      e = PatternExpression();
                                  list.add(e);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[218] = jj_gen;
          break label_34;
        }
        jj_consume_token(COMMA);
        e = PatternExpression();
                                            list.add(e);
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.PATTERN_PERMUTE.createCall(
                s.end(this), list);}
      break;
    default:
      jj_la1[219] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList SubsetDefinitionCommaList(Span s) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddSubsetDefinition(list);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[220] = jj_gen;
        break label_35;
      }
      jj_consume_token(COMMA);
      AddSubsetDefinition(list);
    }
      {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

  final public void AddSubsetDefinition(List<SqlNode> list) throws ParseException {
    final SqlNode var;
    final SqlNodeList varList;
    var = SimpleIdentifier();
    jj_consume_token(EQ);
    jj_consume_token(LPAREN);
    varList = ExpressionCommaList(span(), ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.EQUALS.createCall(span().end(var), var,
                varList));
  }

  final public SqlNodeList PatternDefinitionCommaList(Span s) throws ParseException {
    SqlNode e;
    final List<SqlNode> eList = new ArrayList<SqlNode>();
    e = PatternDefinition();
        eList.add(e);
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[221] = jj_gen;
        break label_36;
      }
      jj_consume_token(COMMA);
      e = PatternDefinition();
            eList.add(e);
    }
        {if (true) return new SqlNodeList(eList, s.addAll(eList).pos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternDefinition() throws ParseException {
    final SqlNode var;
    final SqlNode e;
    var = SimpleIdentifier();
    jj_consume_token(AS);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.AS.createCall(Span.of(var, e).pos(), e, var);}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// Expressions

/**
 * Parses a SQL expression (such as might occur in a WHERE clause) followed by
 * the end-of-file symbol.
 */
  final public SqlNode SqlExpressionEof() throws ParseException {
    SqlNode e;
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(0);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses either a row expression or a query expression without ORDER BY.
 *
 * <p>Examples of valid queries:
 * <ul>
 * <li>{@code SELECT c FROM t}
 * <li>{@code SELECT c} (valid in some dialects)
 * <li>{@code SELECT c FROM t UNION SELECT c2 FROM t2}
 * <li>{@code WITH q AS (SELECT 1) SELECT * FROM q}
 * <li>{@code VALUES (1, 2)}
 * <li>{@code TABLE t}
 * </ul>
 *
 * <p>Non-examples:
 * <ul>
 * <li>{@code emp CROSS JOIN dept}
 * <li>{@code SELECT c FROM t ORDER BY c}
 * <li>{@code (SELECT c FROM t)}
 * </ul>
 */
  final public SqlNode QueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNodeList withList = null;
    final SqlNode e;
    final List<Object> list = new ArrayList<Object>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      withList = WithList();
      break;
    default:
      jj_la1[222] = jj_gen;
      ;
    }
    e = LeafQueryOrExpr(exprContext);
                                       list.add(e);
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
      case INTERSECT:
      case SET_MINUS:
      case UNION:
        ;
        break;
      default:
        jj_la1[223] = jj_gen;
        break label_37;
      }
      AddSetOpQuery(list, exprContext);
    }
      {if (true) return addWith(withList, SqlParserUtil.toTree(list));}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode Query(ExprContext exprContext) throws ParseException {
    SqlNodeList withList = null;
    final SqlNode e;
    final List<Object> list = new ArrayList<Object>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      withList = WithList();
      break;
    default:
      jj_la1[224] = jj_gen;
      ;
    }
    e = LeafQuery(exprContext);
                                 list.add(e);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
      case INTERSECT:
      case SET_MINUS:
      case UNION:
        ;
        break;
      default:
        jj_la1[225] = jj_gen;
        break label_38;
      }
      AddSetOpQuery(list, exprContext);
    }
      {if (true) return addWith(withList, SqlParserUtil.toTree(list));}
    throw new Error("Missing return statement in function");
  }

  SqlNode addWith(SqlNodeList withList, SqlNode e) throws ParseException {
    return withList == null
        ? e
        : new SqlWith(withList.getParserPosition(), withList, e);
  }

/** Parses a set operator (e.g. UNION or INTERSECT)
 * followed by a query or expression,
 * and adds both to {@code list}. */
  final public void AddSetOpQueryOrExpr(List<Object> list, ExprContext exprContext) throws ParseException {
    final SqlOperator op;
    final SqlParserPos pos;
    final SqlNode e;
        if (list.size() == 1 && !((SqlNode) list.get(0)).isA(SqlKind.QUERY)) {
            // whoops, expression we just parsed wasn't a query,
            // but we're about to see something like UNION, so
            // force an exception retroactively
            checkNonQueryExpression(ExprContext.ACCEPT_QUERY);
        }
    op = BinaryQueryOperator();
        // ensure a query is legal in this context
        pos = getPos();
        checkQueryExpression(exprContext);
    e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
  }

/** Parses a set operator (e.g. UNION or INTERSECT)
 * followed by a query,
 * and adds both to {@code list}. */
  final public void AddSetOpQuery(List<Object> list, ExprContext exprContext) throws ParseException {
    final SqlOperator op;
    final SqlParserPos pos;
    final SqlNode e;
        if (list.size() == 1 && !((SqlNode) list.get(0)).isA(SqlKind.QUERY)) {
            // whoops, expression we just parsed wasn't a query,
            // but we're about to see something like UNION, so
            // force an exception retroactively
            checkNonQueryExpression(ExprContext.ACCEPT_QUERY);
        }
    op = BinaryQueryOperator();
        // ensure a query is legal in this context
        pos = getPos();
        checkQueryExpression(exprContext);
    e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
  }

  final public SqlNodeList WithList() throws ParseException {
    final Span s;
    final List<SqlWithItem> list = new ArrayList<SqlWithItem>();
    jj_consume_token(WITH);
             s = span();
    AddWithItem(list);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[226] = jj_gen;
        break label_39;
      }
      jj_consume_token(COMMA);
      AddWithItem(list);
    }
      {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void AddWithItem(List<SqlWithItem> list) throws ParseException {
    final SqlIdentifier id;
    final SqlNodeList columnList;
    final SqlNode definition;
    id = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      columnList = ParenthesizedSimpleIdentifierList();
      break;
    default:
      jj_la1[227] = jj_gen;
                                                           columnList = null;
    }
    jj_consume_token(AS);
    definition = ParenthesizedExpression(ExprContext.ACCEPT_QUERY);
      list.add(new SqlWithItem(id.getParserPosition(), id, columnList, definition));
  }

/**
 * Parses either a row expression, a leaf query expression, or
 * a parenthesized expression of any kind.
 */
  final public SqlNode LeafQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUE:
    case VALUES:
      e = LeafQuery(exprContext);
                                 {if (true) return e;}
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(exprContext);
                                  {if (true) return e;}
      break;
    default:
      jj_la1[228] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** As {@link #Expression} but appends to a list. */
  final public void AddExpression(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    final SqlNode e;
    e = Expression(exprContext);
                                  list.add(e);
  }

/**
 * Parses a row expression or a parenthesized expression of any kind.
 */
  final public SqlNode Expression(ExprContext exprContext) throws ParseException {
    final List<Object> list;
    list = Expression2(exprContext);
                                      {if (true) return SqlParserUtil.toTree(list);}
    throw new Error("Missing return statement in function");
  }

  final public void AddExpression2b(List<Object> list, ExprContext exprContext) throws ParseException {
    SqlNode e;
    SqlOperator op;
    SqlNode ext;
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXISTS:
      case NOT:
      case UNIQUE:
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[229] = jj_gen;
        break label_40;
      }
      op = PrefixRowOperator();
            checkNonQueryExpression(exprContext);
            list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
    }
    e = Expression3(exprContext);
        list.add(e);
    label_41:
    while (true) {
      if (jj_2_57(2)) {
        ;
      } else {
        break label_41;
      }
      jj_consume_token(DOT);
      ext = RowExpressionExtension();
            list.add(
                new SqlParserUtil.ToTreeListItem(
                    SqlStdOperatorTable.DOT, getPos()));
            list.add(ext);
    }
  }

/**
 * Parses a binary row expression, or a parenthesized expression of any
 * kind.
 *
 * <p>The result is as a flat list of operators and operands. The top-level
 * call to get an expression should call {@link #Expression}, but lower-level
 * calls should call this, to give the parser the opportunity to associate
 * operator calls.
 *
 * <p>For example 'a = b like c = d' should come out '((a = b) like c) = d'
 * because LIKE and '=' have the same precedence, but tends to come out as '(a
 * = b) like (c = d)' because (a = b) and (c = d) are parsed as separate
 * expressions.
 */
  final public List<Object> Expression2(ExprContext exprContext) throws ParseException {
    final List<Object> list = new ArrayList();
    List<Object> list2;
    final List<Object> list3 = new ArrayList();
    SqlNodeList nodeList;
    SqlNode e;
    SqlOperator itemOp;
    SqlOperator op;
    SqlIdentifier p;
    final Span s = span();
    AddExpression2b(list, exprContext);
    if (jj_2_65(2)) {
      label_42:
      while (true) {
        if (jj_2_60(2)) {
                    checkNonQueryExpression(exprContext);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            jj_consume_token(IN);
                                 op = SqlStdOperatorTable.NOT_IN;
            break;
          case IN:
            jj_consume_token(IN);
                           op = SqlStdOperatorTable.IN;
            break;
          case EQ:
          case GT:
          case LT:
          case LE:
          case GE:
          case NE:
          case NE2:
                      final SqlKind k;
            k = comp();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SOME:
              jj_consume_token(SOME);
                                 op = SqlStdOperatorTable.some(k);
              break;
            case ANY:
              jj_consume_token(ANY);
                                op = SqlStdOperatorTable.some(k);
              break;
            case ALL:
              jj_consume_token(ALL);
                                op = SqlStdOperatorTable.all(k);
              break;
            default:
              jj_la1[230] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[231] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                  s.clear().add(this);
          nodeList = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_NONCURSOR);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    s.add(nodeList);
                    // special case for stuff like IN (s1 UNION s2)
                    if (nodeList.size() == 1) {
                        SqlNode item = nodeList.get(0);
                        if (item.isA(SqlKind.QUERY)) {
                            list.add(item);
                        } else {
                            list.add(nodeList);
                        }
                    } else {
                        list.add(nodeList);
                    }
        } else if (jj_2_61(2)) {
                    checkNonQueryExpression(exprContext);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            jj_consume_token(BETWEEN);
                        op = SqlStdOperatorTable.NOT_BETWEEN;
                        s.clear().add(this);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASYMMETRIC:
            case SYMMETRIC:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SYMMETRIC:
                jj_consume_token(SYMMETRIC);
                                      op = SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN;
                break;
              case ASYMMETRIC:
                jj_consume_token(ASYMMETRIC);
                break;
              default:
                jj_la1[232] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              jj_la1[233] = jj_gen;
              ;
            }
            break;
          case BETWEEN:
            jj_consume_token(BETWEEN);
                        op = SqlStdOperatorTable.BETWEEN;
                        s.clear().add(this);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASYMMETRIC:
            case SYMMETRIC:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SYMMETRIC:
                jj_consume_token(SYMMETRIC);
                                      op = SqlStdOperatorTable.SYMMETRIC_BETWEEN;
                break;
              case ASYMMETRIC:
                jj_consume_token(ASYMMETRIC);
                break;
              default:
                jj_la1[234] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              jj_la1[235] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[236] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          AddExpression2b(list3, ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list3);
                    list3.clear();
        } else if (jj_2_62(2)) {
                    checkNonQueryExpression(exprContext);
                    s.clear().add(this);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LIKE:
              jj_consume_token(LIKE);
                                     op = SqlStdOperatorTable.NOT_LIKE;
              break;
            case ILIKE:
              jj_consume_token(ILIKE);
                                      op = SqlLibraryOperators.NOT_ILIKE;
              break;
            case RLIKE:
              jj_consume_token(RLIKE);
                                      op = SqlLibraryOperators.NOT_RLIKE;
              break;
            case SIMILAR:
              jj_consume_token(SIMILAR);
              jj_consume_token(TO);
                                             op = SqlStdOperatorTable.NOT_SIMILAR_TO;
              break;
            default:
              jj_la1[237] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          case LIKE:
            jj_consume_token(LIKE);
                                 op = SqlStdOperatorTable.LIKE;
            break;
          case ILIKE:
            jj_consume_token(ILIKE);
                                  op = SqlLibraryOperators.ILIKE;
            break;
          case RLIKE:
            jj_consume_token(RLIKE);
                                  op = SqlLibraryOperators.RLIKE;
            break;
          case SIMILAR:
            jj_consume_token(SIMILAR);
            jj_consume_token(TO);
                                         op = SqlStdOperatorTable.SIMILAR_TO;
            break;
          default:
            jj_la1[238] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          list2 = Expression2(ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list2);
          if (jj_2_58(2)) {
            jj_consume_token(ESCAPE);
            e = Expression3(ExprContext.ACCEPT_SUB_QUERY);
                        s.clear().add(this);
                        list.add(
                            new SqlParserUtil.ToTreeListItem(
                                SqlStdOperatorTable.ESCAPE, s.pos()));
                        list.add(e);
          } else {
            ;
          }
        } else if (jj_2_63(3)) {
          op = BinaryRowOperator();
                    checkNonQueryExpression(exprContext);
                    list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
          AddExpression2b(list, ExprContext.ACCEPT_SUB_QUERY);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            jj_consume_token(LBRACKET);
            itemOp = getItemOp();
            e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            jj_consume_token(RBRACKET);
                    list.add(
                        new SqlParserUtil.ToTreeListItem(
                            itemOp, getPos()));
                    list.add(e);
            label_43:
            while (true) {
              if (jj_2_59(2)) {
                ;
              } else {
                break label_43;
              }
              jj_consume_token(DOT);
              p = SimpleIdentifier();
                        list.add(
                            new SqlParserUtil.ToTreeListItem(
                                SqlStdOperatorTable.DOT, getPos()));
                        list.add(p);
            }
            break;
          case FORMAT:
          case IS:
                    checkNonQueryExpression(exprContext);
            op = PostfixRowOperator();
                    list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
            break;
          default:
            jj_la1[239] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        if (jj_2_64(2)) {
          ;
        } else {
          break label_42;
        }
      }
            {if (true) return list;}
    } else {
            {if (true) return list;}
    }
    throw new Error("Missing return statement in function");
  }

/** Returns the appropriate ITEM operator for indexing arrays. */
  final public SqlOperator getItemOp() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFFSET:
      jj_consume_token(OFFSET);
               {if (true) return SqlLibraryOperators.OFFSET;}
      break;
    case ORDINAL:
      jj_consume_token(ORDINAL);
                {if (true) return SqlLibraryOperators.ORDINAL;}
      break;
    case SAFE_OFFSET:
      jj_consume_token(SAFE_OFFSET);
                    {if (true) return SqlLibraryOperators.SAFE_OFFSET;}
      break;
    case SAFE_ORDINAL:
      jj_consume_token(SAFE_ORDINAL);
                     {if (true) return SqlLibraryOperators.SAFE_ORDINAL;}
      break;
    default:
      jj_la1[240] = jj_gen;
      {if (true) return SqlStdOperatorTable.ITEM;}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a comparison operator inside a SOME / ALL predicate. */
  final public SqlKind comp() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      jj_consume_token(LT);
           {if (true) return SqlKind.LESS_THAN;}
      break;
    case LE:
      jj_consume_token(LE);
           {if (true) return SqlKind.LESS_THAN_OR_EQUAL;}
      break;
    case GT:
      jj_consume_token(GT);
           {if (true) return SqlKind.GREATER_THAN;}
      break;
    case GE:
      jj_consume_token(GE);
           {if (true) return SqlKind.GREATER_THAN_OR_EQUAL;}
      break;
    case EQ:
      jj_consume_token(EQ);
           {if (true) return SqlKind.EQUALS;}
      break;
    case NE:
      jj_consume_token(NE);
           {if (true) return SqlKind.NOT_EQUALS;}
      break;
    case NE2:
      jj_consume_token(NE2);
        if (!this.conformance.isBangEqualAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.bangEqualNotAllowed());}
        }
        {if (true) return SqlKind.NOT_EQUALS;}
      break;
    default:
      jj_la1[241] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a unary row expression, or a parenthesized expression of any
 * kind.
 */
  final public SqlNode Expression3(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    final SqlNodeList list;
    final SqlNodeList list1;
    final Span s;
    final Span rowSpan;
    if (jj_2_67(2)) {
      e = AtomicRowExpression();
        checkNonQueryExpression(exprContext);
        {if (true) return e;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CURSOR:
        e = CursorExpression(exprContext);
                                        {if (true) return e;}
        break;
      default:
        jj_la1[243] = jj_gen;
        if (jj_2_68(3)) {
          jj_consume_token(ROW);
        s = span();
          list = ParenthesizedQueryOrCommaList(exprContext);
        if (exprContext != ExprContext.ACCEPT_ALL
            && exprContext != ExprContext.ACCEPT_CURSOR
            && !this.conformance.allowExplicitRowValueConstructor())
        {
            {if (true) throw SqlUtil.newContextException(s.end(list),
                RESOURCE.illegalRowExpression());}
        }
        {if (true) return SqlStdOperatorTable.ROW.createCall(list);}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ROW:
          case LPAREN:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ROW:
              jj_consume_token(ROW);
                rowSpan = span();
              break;
            default:
              jj_la1[242] = jj_gen;
          rowSpan = null;
            }
            list1 = ParenthesizedQueryOrCommaList(exprContext);
        if (rowSpan != null) {
            // interpret as row constructor
            {if (true) return SqlStdOperatorTable.ROW.createCall(rowSpan.end(list1),
                (List<SqlNode>) list1);}
        }
            if (jj_2_66(2)) {
              e = IntervalQualifier();
                if ((list1.size() == 1)
                    && list1.get(0) instanceof SqlCall)
                {
                    final SqlCall call = (SqlCall) list1.get(0);
                    if (call.getKind() == SqlKind.MINUS
                            && call.operandCount() == 2) {
                        {if (true) return SqlStdOperatorTable.MINUS_DATE.createCall(
                            Span.of(list1).end(this), call.operand(0),
                            call.operand(1), e);}
                     }
                }
                {if (true) throw SqlUtil.newContextException(span().end(list1),
                    RESOURCE.illegalMinusDate());}
            } else {
              ;
            }
        if (list1.size() == 1) {
            // interpret as single value or query
            {if (true) return list1.get(0);}
        } else {
            // interpret as row constructor
            {if (true) return SqlStdOperatorTable.ROW.createCall(span().end(list1),
                (List<SqlNode>) list1);}
        }
            break;
          default:
            jj_la1[244] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlOperator periodOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVERLAPS:
      jj_consume_token(OVERLAPS);
                  {if (true) return SqlStdOperatorTable.OVERLAPS;}
      break;
    default:
      jj_la1[245] = jj_gen;
      if (jj_2_69(2)) {
        jj_consume_token(IMMEDIATELY);
        jj_consume_token(PRECEDES);
                                {if (true) return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRECEDES:
          jj_consume_token(PRECEDES);
                  {if (true) return SqlStdOperatorTable.PRECEDES;}
          break;
        case IMMEDIATELY:
          jj_consume_token(IMMEDIATELY);
          jj_consume_token(SUCCEEDS);
                                {if (true) return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;}
          break;
        case SUCCEEDS:
          jj_consume_token(SUCCEEDS);
                  {if (true) return SqlStdOperatorTable.SUCCEEDS;}
          break;
        case EQUALS:
          jj_consume_token(EQUALS);
                {if (true) return SqlStdOperatorTable.PERIOD_EQUALS;}
          break;
        default:
          jj_la1[246] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a COLLATE clause
 */
  final public SqlCollation CollateClause() throws ParseException {
    jj_consume_token(COLLATE);
    jj_consume_token(COLLATION_ID);
        {if (true) return new SqlCollation(
            getToken(0).image, SqlCollation.Coercibility.EXPLICIT);}
    throw new Error("Missing return statement in function");
  }

/**
 * Numeric literal or parameter; used in LIMIT, OFFSET and FETCH clauses.
 */
  final public SqlNode UnsignedNumericLiteralOrParam() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      e = UnsignedNumericLiteral();
      break;
    case HOOK:
      e = DynamicParam();
      break;
    default:
      jj_la1[247] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a row expression extension, it can be either an identifier,
 * or a call to a named function.
 */
  final public SqlNode RowExpressionExtension() throws ParseException {
    final SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
    final SqlIdentifier p;
    final Span s;
    final List<SqlNode> args;
    final SqlLiteral quantifier;
    p = SimpleIdentifier();
    if (jj_2_72(2147483647)) {
                                s = span();
      if (jj_2_70(2)) {
        jj_consume_token(LPAREN);
        jj_consume_token(STAR);
                quantifier = null;
                args = ImmutableList.of(SqlIdentifier.star(getPos()));
        jj_consume_token(RPAREN);
      } else if (jj_2_71(2)) {
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
                quantifier = null;
                args = ImmutableList.of();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          args = FunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
                quantifier = (SqlLiteral) args.get(0);
                args.remove(0);
          break;
        default:
          jj_la1[248] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          {if (true) return createCall(p, s.end(this), funcType, quantifier, args);}
    } else {
          {if (true) return p;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to the STRING_AGG aggregate function (or to an aggregate
 * function with similar syntax: ARRAY_AGG, ARRAY_CONCAT_AGG, GROUP_CONCAT).
 */
  final public SqlCall StringAggFunctionCall() throws ParseException {
    final Span s, s2;
    final SqlOperator op;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final SqlLiteral qualifier;
    final SqlNodeList orderBy;
    final Pair<SqlParserPos, SqlOperator> nullTreatment;
    final SqlNode separator;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY_AGG:
      jj_consume_token(ARRAY_AGG);
                      s = span(); op = SqlLibraryOperators.ARRAY_AGG;
      break;
    case ARRAY_CONCAT_AGG:
      jj_consume_token(ARRAY_CONCAT_AGG);
                             s = span(); op = SqlLibraryOperators.ARRAY_CONCAT_AGG;
      break;
    case GROUP_CONCAT:
      jj_consume_token(GROUP_CONCAT);
                         s = span(); op = SqlLibraryOperators.GROUP_CONCAT;
      break;
    case STRING_AGG:
      jj_consume_token(STRING_AGG);
                       s = span(); op = SqlLibraryOperators.STRING_AGG;
      break;
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      qualifier = AllOrDistinct();
      break;
    default:
      jj_la1[250] = jj_gen;
          qualifier = null;
    }
    AddArg(args, ExprContext.ACCEPT_SUB_QUERY);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[251] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            // TODO: the following line is a no-op; remove it?
            checkNonQueryExpression(ExprContext.ACCEPT_SUB_QUERY);
      AddArg(args, ExprContext.ACCEPT_SUB_QUERY);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IGNORE:
    case RESPECT:
      nullTreatment = NullTreatment();
      break;
    default:
      jj_la1[252] = jj_gen;
          nullTreatment = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = OrderBy(true);
            args.add(orderBy);
      break;
    default:
      jj_la1[253] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEPARATOR:
      jj_consume_token(SEPARATOR);
                      s2 = span();
      separator = StringLiteral();
            args.add(SqlInternalOperators.SEPARATOR.createCall(s2.end(this), separator));
      break;
    default:
      jj_la1[254] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        SqlCall call = op.createCall(qualifier, s.end(this), args);
        if (nullTreatment != null) {
            // Wrap in RESPECT_NULLS or IGNORE_NULLS.
            call = nullTreatment.right.createCall(nullTreatment.left, call);
        }
        {if (true) return call;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses both the standard and the BigQuery PERCENTILE_CONT/PERCENTILE_DISC
 * functions.
 *
 * <p>The standard is of the form "PERCENTILE_CONT(fraction)" while BigQuery is
 * of the form "PERCENTILE_CONT(value, fraction [ {RESPECT | IGNORE} NULLS ] )".
 * Handles the parsing of the operator and its operands but not the WITHIN GROUP
 * (for the standard) or OVER (for BigQuery) clauses.
 */
  final public SqlCall PercentileFunctionCall() throws ParseException {
   final Span s;
   SqlOperator op;
   final SqlNode e;
   final List<SqlNode> args = new ArrayList<SqlNode>();
   final Pair<SqlParserPos, SqlOperator> nullTreatment;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PERCENTILE_CONT:
      jj_consume_token(PERCENTILE_CONT);
                           op = SqlStdOperatorTable.PERCENTILE_CONT;
      break;
    case PERCENTILE_DISC:
      jj_consume_token(PERCENTILE_DISC);
                           op = SqlStdOperatorTable.PERCENTILE_DISC;
      break;
    default:
      jj_la1[255] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     s = span();
    jj_consume_token(LPAREN);
    AddArg(args, ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RPAREN:
      jj_consume_token(RPAREN);
           {if (true) return op.createCall(s.end(this), args);}
      break;
    case COMMA:
      jj_consume_token(COMMA);
      e = NumericLiteral();
                              args.add(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IGNORE:
      case RESPECT:
        nullTreatment = NullTreatment();
        break;
      default:
        jj_la1[256] = jj_gen;
             nullTreatment = null;
      }
      jj_consume_token(RPAREN);
           op =
               op == SqlStdOperatorTable.PERCENTILE_CONT
                   ? SqlLibraryOperators.PERCENTILE_CONT2
                   : SqlLibraryOperators.PERCENTILE_DISC2;
           SqlCall call = op.createCall(s.end(this), args);
           if (nullTreatment != null) {
               // Wrap in RESPECT_NULLS or IGNORE_NULLS.
               call = nullTreatment.right.createCall(nullTreatment.left, call);
           }
           {if (true) return call;}
      break;
    default:
      jj_la1[257] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an atomic row expression.
 */
  final public SqlNode AtomicRowExpression() throws ParseException {
    final SqlNode e;
    if (jj_2_73(2)) {
      e = LiteralOrIntervalExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOOK:
        e = DynamicParam();
        break;
      default:
        jj_la1[258] = jj_gen;
        if (jj_2_74(2)) {
          e = BuiltinFunctionCall();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE_FN:
            e = JdbcFunctionCall();
            break;
          case MULTISET:
            e = MultisetConstructor();
            break;
          case ARRAY:
            e = ArrayConstructor();
            break;
          default:
            jj_la1[259] = jj_gen;
            if (jj_2_75(3)) {
              e = MapConstructor();
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case PERIOD:
                e = PeriodConstructor();
                break;
              default:
                jj_la1[260] = jj_gen;
                if (jj_2_76(2147483647)) {
                  e = NamedFunctionCall();
                } else {
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case CURRENT_CATALOG:
                  case CURRENT_DATE:
                  case CURRENT_DEFAULT_TRANSFORM_GROUP:
                  case CURRENT_PATH:
                  case CURRENT_ROLE:
                  case CURRENT_SCHEMA:
                  case CURRENT_TIME:
                  case CURRENT_TIMESTAMP:
                  case CURRENT_USER:
                  case LOCALTIME:
                  case LOCALTIMESTAMP:
                  case SESSION_USER:
                  case SYSTEM_USER:
                  case USER:
                    e = ContextVariable();
                    break;
                  case A:
                  case ABSENT:
                  case ABSOLUTE:
                  case ACTION:
                  case ADA:
                  case ADD:
                  case ADMIN:
                  case AFTER:
                  case ALWAYS:
                  case APPLY:
                  case ARRAY_AGG:
                  case ARRAY_CONCAT_AGG:
                  case ASC:
                  case ASSERTION:
                  case ASSIGNMENT:
                  case ATTRIBUTE:
                  case ATTRIBUTES:
                  case BEFORE:
                  case BERNOULLI:
                  case BREADTH:
                  case C:
                  case CASCADE:
                  case CATALOG:
                  case CATALOG_NAME:
                  case CENTURY:
                  case CHAIN:
                  case CHARACTER_SET_CATALOG:
                  case CHARACTER_SET_NAME:
                  case CHARACTER_SET_SCHEMA:
                  case CHARACTERISTICS:
                  case CHARACTERS:
                  case CLASS_ORIGIN:
                  case COBOL:
                  case COLLATION:
                  case COLLATION_CATALOG:
                  case COLLATION_NAME:
                  case COLLATION_SCHEMA:
                  case COLUMN_NAME:
                  case COMMAND_FUNCTION:
                  case COMMAND_FUNCTION_CODE:
                  case COMMITTED:
                  case CONDITIONAL:
                  case CONDITION_NUMBER:
                  case CONNECTION:
                  case CONNECTION_NAME:
                  case CONSTRAINT_CATALOG:
                  case CONSTRAINT_NAME:
                  case CONSTRAINT_SCHEMA:
                  case CONSTRAINTS:
                  case CONSTRUCTOR:
                  case CONTINUE:
                  case CURSOR_NAME:
                  case DATA:
                  case DATABASE:
                  case DATE_DIFF:
                  case DATE_TRUNC:
                  case DATETIME_DIFF:
                  case DATETIME_INTERVAL_CODE:
                  case DATETIME_INTERVAL_PRECISION:
                  case DATETIME_TRUNC:
                  case DAYOFWEEK:
                  case DAYOFYEAR:
                  case DAYS:
                  case DECADE:
                  case DEFAULTS:
                  case DEFERRABLE:
                  case DEFERRED:
                  case DEFINED:
                  case DEFINER:
                  case DEGREE:
                  case DEPTH:
                  case DERIVED:
                  case DESC:
                  case DESCRIPTION:
                  case DESCRIPTOR:
                  case DIAGNOSTICS:
                  case DISPATCH:
                  case DOMAIN:
                  case DOT_FORMAT:
                  case DOW:
                  case DOY:
                  case DYNAMIC_FUNCTION:
                  case DYNAMIC_FUNCTION_CODE:
                  case ENCODING:
                  case EPOCH:
                  case ERROR:
                  case EXCEPTION:
                  case EXCLUDE:
                  case EXCLUDING:
                  case EXTERNAL:
                  case FINAL:
                  case FIRST:
                  case FOLLOWING:
                  case FORMAT:
                  case FORTRAN:
                  case FOUND:
                  case FRAC_SECOND:
                  case G:
                  case GENERAL:
                  case GENERATED:
                  case GEOMETRY:
                  case GO:
                  case GOTO:
                  case GRANTED:
                  case GROUP_CONCAT:
                  case HIERARCHY:
                  case HOP:
                  case HOURS:
                  case IGNORE:
                  case ILIKE:
                  case IMMEDIATE:
                  case IMMEDIATELY:
                  case IMPLEMENTATION:
                  case INCLUDE:
                  case INCLUDING:
                  case INCREMENT:
                  case INITIALLY:
                  case INPUT:
                  case INSTANCE:
                  case INSTANTIABLE:
                  case INVOKER:
                  case ISODOW:
                  case ISOYEAR:
                  case ISOLATION:
                  case JAVA:
                  case JSON:
                  case K:
                  case KEY:
                  case KEY_MEMBER:
                  case KEY_TYPE:
                  case LABEL:
                  case LAST:
                  case LENGTH:
                  case LEVEL:
                  case LIBRARY:
                  case LOCATOR:
                  case M:
                  case MAP:
                  case MATCHED:
                  case MAXVALUE:
                  case MESSAGE_LENGTH:
                  case MESSAGE_OCTET_LENGTH:
                  case MESSAGE_TEXT:
                  case MICROSECOND:
                  case MILLISECOND:
                  case MILLENNIUM:
                  case MINUTES:
                  case MINVALUE:
                  case MONTHS:
                  case MORE_:
                  case MUMPS:
                  case NAME:
                  case NAMES:
                  case NANOSECOND:
                  case NESTING:
                  case NORMALIZED:
                  case NULLABLE:
                  case NULLS:
                  case NUMBER:
                  case OBJECT:
                  case OCTETS:
                  case OPTION:
                  case OPTIONS:
                  case ORDERING:
                  case ORDINALITY:
                  case OTHERS:
                  case OUTPUT:
                  case OVERRIDING:
                  case PAD:
                  case PARAMETER_MODE:
                  case PARAMETER_NAME:
                  case PARAMETER_ORDINAL_POSITION:
                  case PARAMETER_SPECIFIC_CATALOG:
                  case PARAMETER_SPECIFIC_NAME:
                  case PARAMETER_SPECIFIC_SCHEMA:
                  case PARTIAL:
                  case PASCAL:
                  case PASSING:
                  case PASSTHROUGH:
                  case PAST:
                  case PATH:
                  case PERCENTILE_CONT:
                  case PERCENTILE_DISC:
                  case PIVOT:
                  case PLACING:
                  case PLAN:
                  case PLI:
                  case PRECEDING:
                  case PRESERVE:
                  case PRIOR:
                  case PRIVILEGES:
                  case PUBLIC:
                  case QUARTER:
                  case QUARTERS:
                  case READ:
                  case RELATIVE:
                  case REPEATABLE:
                  case REPLACE:
                  case RESPECT:
                  case RESTART:
                  case RESTRICT:
                  case RETURNED_CARDINALITY:
                  case RETURNED_LENGTH:
                  case RETURNED_OCTET_LENGTH:
                  case RETURNED_SQLSTATE:
                  case RETURNING:
                  case RLIKE:
                  case ROLE:
                  case ROUTINE:
                  case ROUTINE_CATALOG:
                  case ROUTINE_NAME:
                  case ROUTINE_SCHEMA:
                  case ROW_COUNT:
                  case SCALAR:
                  case SCALE:
                  case SCHEMA:
                  case SCHEMA_NAME:
                  case SCOPE_CATALOGS:
                  case SCOPE_NAME:
                  case SCOPE_SCHEMA:
                  case SECONDS:
                  case SECTION:
                  case SECURITY:
                  case SELF:
                  case SEPARATOR:
                  case SEQUENCE:
                  case SERIALIZABLE:
                  case SERVER:
                  case SERVER_NAME:
                  case SESSION:
                  case SETS:
                  case SIMPLE:
                  case SIZE:
                  case SOURCE:
                  case SPACE:
                  case SPECIFIC_NAME:
                  case SQL_BIGINT:
                  case SQL_BINARY:
                  case SQL_BIT:
                  case SQL_BLOB:
                  case SQL_BOOLEAN:
                  case SQL_CHAR:
                  case SQL_CLOB:
                  case SQL_DATE:
                  case SQL_DECIMAL:
                  case SQL_DOUBLE:
                  case SQL_FLOAT:
                  case SQL_INTEGER:
                  case SQL_INTERVAL_DAY:
                  case SQL_INTERVAL_DAY_TO_HOUR:
                  case SQL_INTERVAL_DAY_TO_MINUTE:
                  case SQL_INTERVAL_DAY_TO_SECOND:
                  case SQL_INTERVAL_HOUR:
                  case SQL_INTERVAL_HOUR_TO_MINUTE:
                  case SQL_INTERVAL_HOUR_TO_SECOND:
                  case SQL_INTERVAL_MINUTE:
                  case SQL_INTERVAL_MINUTE_TO_SECOND:
                  case SQL_INTERVAL_MONTH:
                  case SQL_INTERVAL_SECOND:
                  case SQL_INTERVAL_YEAR:
                  case SQL_INTERVAL_YEAR_TO_MONTH:
                  case SQL_LONGVARBINARY:
                  case SQL_LONGVARCHAR:
                  case SQL_LONGVARNCHAR:
                  case SQL_NCHAR:
                  case SQL_NCLOB:
                  case SQL_NUMERIC:
                  case SQL_NVARCHAR:
                  case SQL_REAL:
                  case SQL_SMALLINT:
                  case SQL_TIME:
                  case SQL_TIMESTAMP:
                  case SQL_TINYINT:
                  case SQL_TSI_DAY:
                  case SQL_TSI_FRAC_SECOND:
                  case SQL_TSI_HOUR:
                  case SQL_TSI_MICROSECOND:
                  case SQL_TSI_MINUTE:
                  case SQL_TSI_MONTH:
                  case SQL_TSI_QUARTER:
                  case SQL_TSI_SECOND:
                  case SQL_TSI_WEEK:
                  case SQL_TSI_YEAR:
                  case SQL_VARBINARY:
                  case SQL_VARCHAR:
                  case STATE:
                  case STATEMENT:
                  case STRING_AGG:
                  case STRUCTURE:
                  case STYLE:
                  case SUBCLASS_ORIGIN:
                  case SUBSTITUTE:
                  case TABLE_NAME:
                  case TEMPORARY:
                  case TIES:
                  case TIME_DIFF:
                  case TIME_TRUNC:
                  case TIMESTAMPADD:
                  case TIMESTAMPDIFF:
                  case TIMESTAMP_DIFF:
                  case TIMESTAMP_TRUNC:
                  case TOP_LEVEL_COUNT:
                  case TRANSACTION:
                  case TRANSACTIONS_ACTIVE:
                  case TRANSACTIONS_COMMITTED:
                  case TRANSACTIONS_ROLLED_BACK:
                  case TRANSFORM:
                  case TRANSFORMS:
                  case TRIGGER_CATALOG:
                  case TRIGGER_NAME:
                  case TRIGGER_SCHEMA:
                  case TUMBLE:
                  case TYPE:
                  case UNBOUNDED:
                  case UNCOMMITTED:
                  case UNCONDITIONAL:
                  case UNDER:
                  case UNPIVOT:
                  case UNNAMED:
                  case USAGE:
                  case USER_DEFINED_TYPE_CATALOG:
                  case USER_DEFINED_TYPE_CODE:
                  case USER_DEFINED_TYPE_NAME:
                  case USER_DEFINED_TYPE_SCHEMA:
                  case UTF8:
                  case UTF16:
                  case UTF32:
                  case VERSION:
                  case VIEW:
                  case WEEK:
                  case WEEKS:
                  case WORK:
                  case WRAPPER:
                  case WRITE:
                  case XML:
                  case YEARS:
                  case ZONE:
                  case ANALYZE:
                  case CONNECTOR:
                  case JOB:
                  case JOBS:
                  case MAPPING:
                  case MAPPINGS:
                  case RESOURCES:
                  case RESUME:
                  case SHARED:
                  case SINK:
                  case SNAPSHOT:
                  case SUSPEND:
                  case TYPES:
                  case VIEWS:
                  case BRACKET_QUOTED_IDENTIFIER:
                  case QUOTED_IDENTIFIER:
                  case BACK_QUOTED_IDENTIFIER:
                  case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
                  case HYPHENATED_IDENTIFIER:
                  case IDENTIFIER:
                  case UNICODE_QUOTED_IDENTIFIER:
                    e = CompoundIdentifier();
                    break;
                  case NEW:
                    e = NewSpecification();
                    break;
                  case CASE:
                    e = CaseExpression();
                    break;
                  case CURRENT:
                  case NEXT:
                    e = SequenceExpression();
                    break;
                  default:
                    jj_la1[261] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                }
              }
            }
          }
        }
      }
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode CaseExpression() throws ParseException {
    final Span whenSpan = Span.of();
    final Span thenSpan = Span.of();
    final Span s;
    SqlNode e;
    final SqlNode caseIdentifier;
    final SqlNode elseClause;
    final List<SqlNode> whenList = new ArrayList<SqlNode>();
    final List<SqlNode> thenList = new ArrayList<SqlNode>();
    jj_consume_token(CASE);
             s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTERNAL:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SAFE_CAST:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STATEMENT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TRY_CAST:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNPIVOT:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      caseIdentifier = Expression(ExprContext.ACCEPT_SUB_QUERY);
      break;
    default:
      jj_la1[262] = jj_gen;
          caseIdentifier = null;
    }
    label_45:
    while (true) {
      jj_consume_token(WHEN);
                 whenSpan.add(this);
      e = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
            if (((SqlNodeList) e).size() == 1) {
                e = ((SqlNodeList) e).get(0);
            }
            whenList.add(e);
      jj_consume_token(THEN);
                 thenSpan.add(this);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            thenList.add(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[263] = jj_gen;
        break label_45;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseClause = Expression(ExprContext.ACCEPT_SUB_QUERY);
      break;
    default:
      jj_la1[264] = jj_gen;
          elseClause = null;
    }
    jj_consume_token(END);
        {if (true) return SqlCase.createSwitched(s.end(this), caseIdentifier,
            new SqlNodeList(whenList, whenSpan.addAll(whenList).pos()),
            new SqlNodeList(thenList, thenSpan.addAll(thenList).pos()),
            elseClause);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall SequenceExpression() throws ParseException {
    final Span s;
    final SqlOperator f;
    final SqlNode sequenceRef;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEXT:
      jj_consume_token(NEXT);
                 f = SqlStdOperatorTable.NEXT_VALUE; s = span();
      break;
    default:
      jj_la1[265] = jj_gen;
      if (jj_2_77(3)) {
        jj_consume_token(CURRENT);
                    f = SqlStdOperatorTable.CURRENT_VALUE; s = span();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(VALUE);
    jj_consume_token(FOR);
    sequenceRef = CompoundIdentifier();
        {if (true) return f.createCall(s.end(sequenceRef), sequenceRef);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses "SET &lt;NAME&gt; = VALUE" or "RESET &lt;NAME&gt;", without a leading
 * "ALTER &lt;SCOPE&gt;".
 */
  final public SqlSetOption SqlSetOption(Span s, String scope) throws ParseException {
    SqlIdentifier name;
    final SqlNode val;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SET:
      jj_consume_token(SET);
            s.add(this);
      name = CompoundIdentifier();
      jj_consume_token(EQ);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATE:
      case DATETIME:
      case FALSE:
      case INTERVAL:
      case NULL:
      case TIME:
      case TIMESTAMP:
      case TRUE:
      case UNKNOWN:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case PLUS:
      case MINUS:
        val = Literal();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        val = SimpleIdentifier();
        break;
      case ON:
        jj_consume_token(ON);
                // OFF is handled by SimpleIdentifier, ON handled here.
                val = new SqlIdentifier(token.image.toUpperCase(Locale.ROOT),
                    getPos());
        break;
      default:
        jj_la1[266] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return new SqlSetOption(s.end(val), scope, name, val);}
      break;
    case RESET:
      jj_consume_token(RESET);
            s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        name = CompoundIdentifier();
        break;
      case ALL:
        jj_consume_token(ALL);
                name = new SqlIdentifier(token.image.toUpperCase(Locale.ROOT),
                    getPos());
        break;
      default:
        jj_la1[267] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return new SqlSetOption(s.end(name), scope, name, null);}
      break;
    default:
      jj_la1[268] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an expression for setting or resetting an option in SQL, such as QUOTED_IDENTIFIERS,
 * or explain plan level (physical/logical).
 */
  final public SqlAlter SqlAlter() throws ParseException {
    final Span s;
    final String scope;
    final SqlAlter alterNode;
    jj_consume_token(ALTER);
              s = span();
    scope = Scope();
    alterNode = SqlSetOption(s, scope);
        {if (true) return alterNode;}
    throw new Error("Missing return statement in function");
  }

  final public String Scope() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SYSTEM:
      jj_consume_token(SYSTEM);
      break;
    case SESSION:
      jj_consume_token(SESSION);
      break;
    default:
      jj_la1[269] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                               {if (true) return token.image.toUpperCase(Locale.ROOT);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CREATE statement.
 */
  final public SqlCreate SqlCreate() throws ParseException {
    final Span s;
    boolean replace = false;
    final SqlCreate create;
    jj_consume_token(CREATE);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OR:
      jj_consume_token(OR);
      jj_consume_token(REPLACE);
            replace = true;
      break;
    default:
      jj_la1[270] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATA:
      create = SqlCreateDataConnection(s, replace);
      break;
    default:
      jj_la1[271] = jj_gen;
      if (jj_2_78(2)) {
        create = SqlCreateIndex(s, replace);
      } else if (jj_2_79(2)) {
        create = SqlCreateJob(s, replace);
      } else if (jj_2_80(2)) {
        create = SqlCreateMapping(s, replace);
      } else if (jj_2_81(2)) {
        create = SqlCreateSnapshot(s, replace);
      } else if (jj_2_82(2)) {
        create = SqlCreateType(s, replace);
      } else if (jj_2_83(2)) {
        create = SqlCreateView(s, replace);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return create;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a DROP statement.
 */
  final public SqlDrop SqlDrop() throws ParseException {
    final Span s;
    boolean replace = false;
    final SqlDrop drop;
    jj_consume_token(DROP);
             s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATA:
      drop = SqlDropDataConnection(s, replace);
      break;
    case INDEX:
      drop = SqlDropIndex(s, replace);
      break;
    case JOB:
      drop = SqlDropJob(s, replace);
      break;
    case EXTERNAL:
    case MAPPING:
      drop = SqlDropMapping(s, replace);
      break;
    case SNAPSHOT:
      drop = SqlDropSnapshot(s, replace);
      break;
    case TYPE:
      drop = SqlDropType(s, replace);
      break;
    case VIEW:
      drop = SqlDropView(s, replace);
      break;
    default:
      jj_la1[272] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return drop;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a literal expression, allowing continued string literals.
 * Usually returns an SqlLiteral, but a continued string literal
 * is an SqlCall expression, which concatenates 2 or more string
 * literals; the validator reduces this.
 *
 * <p>If the context allows both literals and expressions,
 * use {@link #LiteralOrIntervalExpression}, which requires less
 * lookahead.
 */
  final public SqlNode Literal() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case DATETIME:
    case FALSE:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = NonIntervalLiteral();
      break;
    case INTERVAL:
      e = IntervalLiteral();
      break;
    default:
      jj_la1[273] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal that is not an interval literal. */
  final public SqlNode NonIntervalLiteral() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case PLUS:
    case MINUS:
      e = NumericLiteral();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      e = StringLiteral();
      break;
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
      e = SpecialLiteral();
      break;
    case DATE:
    case DATETIME:
    case TIME:
    case TIMESTAMP:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
      e = DateTimeLiteral();
      break;
    default:
      jj_la1[274] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal or an interval expression.
 *
 * <p>We include them in the same production because it is difficult to
 * distinguish interval literals from interval expression (both of which
 * start with the {@code INTERVAL} keyword); this way, we can use less
 * LOOKAHEAD. */
  final public SqlNode LiteralOrIntervalExpression() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERVAL:
      e = IntervalLiteralOrExpression();
      break;
    case DATE:
    case DATETIME:
    case FALSE:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = NonIntervalLiteral();
      break;
    default:
      jj_la1[275] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a unsigned numeric literal */
  final public SqlNumericLiteral UnsignedNumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        {if (true) return SqlLiteral.createExactNumeric(token.image, getPos());}
      break;
    case DECIMAL_NUMERIC_LITERAL:
      jj_consume_token(DECIMAL_NUMERIC_LITERAL);
        {if (true) return SqlLiteral.createExactNumeric(token.image, getPos());}
      break;
    case APPROX_NUMERIC_LITERAL:
      jj_consume_token(APPROX_NUMERIC_LITERAL);
        {if (true) return SqlLiteral.createApproxNumeric(token.image, getPos());}
      break;
    default:
      jj_la1[276] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a numeric literal (can be signed) */
  final public SqlLiteral NumericLiteral() throws ParseException {
    final SqlNumericLiteral num;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      num = UnsignedNumericLiteral();
        {if (true) return num;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              s = span();
      num = UnsignedNumericLiteral();
        {if (true) return SqlLiteral.createNegative(num, s.end(this));}
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      num = UnsignedNumericLiteral();
        {if (true) return num;}
      break;
    default:
      jj_la1[277] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parse a special literal keyword */
  final public SqlLiteral SpecialLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             {if (true) return SqlLiteral.createBoolean(true, getPos());}
      break;
    case FALSE:
      jj_consume_token(FALSE);
              {if (true) return SqlLiteral.createBoolean(false, getPos());}
      break;
    case UNKNOWN:
      jj_consume_token(UNKNOWN);
                {if (true) return SqlLiteral.createUnknown(getPos());}
      break;
    case NULL:
      jj_consume_token(NULL);
             {if (true) return SqlLiteral.createNull(getPos());}
      break;
    default:
      jj_la1[278] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a string literal. The literal may be continued onto several
 * lines.  For a simple literal, the result is an SqlLiteral.  For a continued
 * literal, the result is an SqlCall expression, which concatenates 2 or more
 * string literals; the validator reduces this.
 *
 * @see SqlLiteral#unchain(SqlNode)
 * @see SqlLiteral#stringValue(SqlNode)
 *
 * @return a literal expression
 */
  final public SqlNode StringLiteral() throws ParseException {
    String p;
    final List<SqlLiteral> frags;
    char unicodeEscapeChar = 0;
    String charSet = null;
    SqlCharStringLiteral literal;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
      jj_consume_token(BINARY_STRING_LITERAL);
        frags = new ArrayList<SqlLiteral>();
        try {
            p = SqlParserUtil.trim(token.image, "xX'");
            frags.add(SqlLiteral.createBinaryString(p, getPos()));
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.illegalBinaryString(token.image));}
        }
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case QUOTED_STRING:
          ;
          break;
        default:
          jj_la1[279] = jj_gen;
          break label_46;
        }
        jj_consume_token(QUOTED_STRING);
            try {
                p = SqlParserUtil.trim(token.image, "'"); // no embedded quotes
                frags.add(SqlLiteral.createBinaryString(p, getPos()));
            } catch (NumberFormatException ex) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.illegalBinaryString(token.image));}
            }
      }
        assert !frags.isEmpty();
        if (frags.size() == 1) {
            {if (true) return frags.get(0);} // just the head fragment
        } else {
            SqlParserPos pos2 = SqlParserPos.sum(frags);
            {if (true) return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, frags);}
        }
      break;
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PREFIXED_STRING_LITERAL:
        jj_consume_token(PREFIXED_STRING_LITERAL);
          charSet = SqlParserUtil.getCharacterSet(token.image);
        break;
      case QUOTED_STRING:
        jj_consume_token(QUOTED_STRING);
        break;
      case UNICODE_STRING_LITERAL:
        jj_consume_token(UNICODE_STRING_LITERAL);
            // TODO jvs 2-Feb-2009:  support the explicit specification of
            // a character set for Unicode string literals, per SQL:2003
            unicodeEscapeChar = BACKSLASH;
            charSet = "UTF16";
        break;
      default:
        jj_la1[280] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        frags = new ArrayList<SqlLiteral>();
        p = SqlParserUtil.parseString(token.image);
        try {
            literal = SqlLiteral.createCharString(p, charSet, getPos());
            frags.add(literal);
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case QUOTED_STRING:
          ;
          break;
        default:
          jj_la1[281] = jj_gen;
          break label_47;
        }
        jj_consume_token(QUOTED_STRING);
            p = SqlParserUtil.parseString(token.image);
            try {
                literal = SqlLiteral.createCharString(p, charSet, getPos());
                frags.add(literal);
            } catch (java.nio.charset.UnsupportedCharsetException e) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.unknownCharacterSet(charSet));}
            }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UESCAPE:
        jj_consume_token(UESCAPE);
        jj_consume_token(QUOTED_STRING);
            if (unicodeEscapeChar == 0) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.unicodeEscapeUnexpected());}
            }
            String s = SqlParserUtil.parseString(token.image);
            unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
        break;
      default:
        jj_la1[282] = jj_gen;
        ;
      }
        assert !frags.isEmpty();
        if (frags.size() == 1) {
            // just the head fragment
            SqlLiteral lit = (SqlLiteral) frags.get(0);
            {if (true) return lit.unescapeUnicode(unicodeEscapeChar);}
        } else {
            SqlNode[] rands = (SqlNode[]) frags.toArray(new SqlNode[0]);
            for (int i = 0; i < rands.length; ++i) {
                rands[i] = ((SqlLiteral) rands[i]).unescapeUnicode(
                    unicodeEscapeChar);
            }
            SqlParserPos pos2 = SqlParserPos.sum(rands);
            {if (true) return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, rands);}
        }
      break;
    case C_STYLE_ESCAPED_STRING_LITERAL:
      jj_consume_token(C_STYLE_ESCAPED_STRING_LITERAL);
        try {
            p = SqlParserUtil.parseCString(getToken(0).image);
        } catch (SqlParserUtil.MalformedUnicodeEscape e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unicodeEscapeMalformed(e.i));}
       }
       {if (true) return SqlLiteral.createCharString(p, "UTF16", getPos());}
      break;
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_DOUBLE_QUOTED_STRING);
        p = SqlParserUtil.stripQuotes(getToken(0).image, DQ, DQ, "\\\"",
            Casing.UNCHANGED);
        try {
            {if (true) return SqlLiteral.createCharString(p, charSet, getPos());}
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      break;
    case BIG_QUERY_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_QUOTED_STRING);
        p = SqlParserUtil.stripQuotes(getToken(0).image, "'", "'", "\\'",
            Casing.UNCHANGED);
        try {
            {if (true) return SqlLiteral.createCharString(p, charSet, getPos());}
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      break;
    default:
      jj_la1[283] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a character literal.
 * Matches a single-quoted string, such as 'foo';
 * on BigQuery also matches a double-quoted string, such as "foo".
 * Returns the value of the string with quotes removed. */
  final public String SimpleStringLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
        {if (true) return SqlParserUtil.parseString(token.image);}
      break;
    case BIG_QUERY_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_QUOTED_STRING);
        {if (true) return SqlParserUtil.stripQuotes(token.image, "'", "'", "\\'", Casing.UNCHANGED);}
      break;
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_DOUBLE_QUOTED_STRING);
        {if (true) return SqlParserUtil.stripQuotes(token.image, DQ, DQ, "\\\"", Casing.UNCHANGED);}
      break;
    default:
      jj_la1[284] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a date/time literal.
 */
  final public SqlLiteral DateTimeLiteral() throws ParseException {
    final String p;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE_D:
      jj_consume_token(LBRACE_D);
      jj_consume_token(QUOTED_STRING);
        p = SqlParserUtil.parseString(token.image);
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseDateLiteral(p, getPos());}
      break;
    case LBRACE_T:
      jj_consume_token(LBRACE_T);
      jj_consume_token(QUOTED_STRING);
        p = SqlParserUtil.parseString(token.image);
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseTimeLiteral(p, getPos());}
      break;
    case LBRACE_TS:
      jj_consume_token(LBRACE_TS);
                  s = span();
      jj_consume_token(QUOTED_STRING);
        p = SqlParserUtil.parseString(token.image);
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseTimestampLiteral(p, s.end(this));}
      break;
    case DATE:
      jj_consume_token(DATE);
             s = span();
      p = SimpleStringLiteral();
      {if (true) return SqlLiteral.createUnknown("DATE", p, s.end(this));}
      break;
    case DATETIME:
      jj_consume_token(DATETIME);
                 s = span();
      p = SimpleStringLiteral();
        {if (true) return SqlLiteral.createUnknown("DATETIME", p, s.end(this));}
      break;
    case TIME:
      jj_consume_token(TIME);
             s = span();
      p = SimpleStringLiteral();
      {if (true) return SqlLiteral.createUnknown("TIME", p, s.end(this));}
      break;
    default:
      jj_la1[285] = jj_gen;
      if (jj_2_84(2)) {
        jj_consume_token(TIMESTAMP);
                  s = span();
        p = SimpleStringLiteral();
        {if (true) return SqlLiteral.createUnknown("TIMESTAMP", p, s.end(this));}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIMESTAMP:
          jj_consume_token(TIMESTAMP);
                  s = span();
          jj_consume_token(WITH);
          jj_consume_token(LOCAL);
          jj_consume_token(TIME);
          jj_consume_token(ZONE);
          p = SimpleStringLiteral();
        {if (true) return SqlLiteral.createUnknown("TIMESTAMP WITH LOCAL TIME ZONE", p, s.end(this));}
          break;
        default:
          jj_la1[286] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a Date/Time constructor function, for example "DATE(1969, 7, 21)"
 * or "DATETIME(d, t)". Enabled in some libraries (e.g. BigQuery). */
  final public SqlNode DateTimeConstructorCall() throws ParseException {
    final SqlFunctionCategory funcType = SqlFunctionCategory.TIMEDATE;
    final SqlIdentifier qualifiedName;
    final Span s;
    final SqlLiteral quantifier;
    final List<? extends SqlNode> args;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
      jj_consume_token(DATE);
      break;
    case TIME:
      jj_consume_token(TIME);
      break;
    case DATETIME:
      jj_consume_token(DATETIME);
      break;
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
      break;
    default:
      jj_la1[287] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        s = span();
        qualifiedName = new SqlIdentifier(unquotedIdentifier(), getPos());
    args = FunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
        quantifier = (SqlLiteral) args.get(0);
        args.remove(0);
        {if (true) return createCall(qualifiedName, s.end(this), funcType, quantifier, args);}
    throw new Error("Missing return statement in function");
  }

/** Parses a MULTISET constructor */
  final public SqlNode MultisetConstructor() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    final Span s;
    jj_consume_token(MULTISET);
                 s = span();
    if (jj_2_85(2)) {
      jj_consume_token(LPAREN);
      // by sub query "MULTISET(SELECT * FROM T)"
              e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.MULTISET_QUERY.createCall(
                s.end(this), e);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
        label_48:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[288] = jj_gen;
            break label_48;
          }
          jj_consume_token(COMMA);
          AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
        }
        jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.MULTISET_VALUE.createCall(
                s.end(this), args);}
        break;
      default:
        jj_la1[289] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an ARRAY constructor */
  final public SqlNode ArrayConstructor() throws ParseException {
    final SqlNodeList args;
    SqlNode e;
    final Span s;
    final String p;
    jj_consume_token(ARRAY);
              s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      if (jj_2_86(2)) {
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
                                args = SqlNodeList.EMPTY;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          args = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_ALL);
          break;
        default:
          jj_la1[290] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
            if (args.size() == 1 && args.get(0).isA(SqlKind.QUERY)) {
                // Array query constructor, 'ARRAY (SELECT * FROM t)'
                {if (true) return SqlStdOperatorTable.ARRAY_QUERY.createCall(s.end(this), args.get(0));}
            } else {
                // Spark ARRAY function, 'ARRAY(1, 2)',
                // equivalent to standard 'ARRAY [1, 2]'
                {if (true) return SqlLibraryOperators.ARRAY.createCall(s.end(this), args.getList());}
            }
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        args = ExpressionCommaList(s, ExprContext.ACCEPT_NON_QUERY);
        break;
      default:
        jj_la1[291] = jj_gen;
              args = SqlNodeList.EMPTY;
      }
      jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(
                s.end(this), args.getList());}
      break;
    default:
      jj_la1[292] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall ArrayLiteral() throws ParseException {
    final List<SqlNode> list;
    SqlNode e;
    final Span s;
    jj_consume_token(LBRACE);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case DATETIME:
    case FALSE:
    case INTERVAL:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case C_STYLE_ESCAPED_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = Literal();
                        list = startList(e);
      label_49:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[293] = jj_gen;
          break label_49;
        }
        jj_consume_token(COMMA);
        e = Literal();
                                  list.add(e);
      }
      break;
    case LBRACE:
      e = ArrayLiteral();
                             list = startList(e);
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[294] = jj_gen;
          break label_50;
        }
        jj_consume_token(COMMA);
        e = ArrayLiteral();
                                       list.add(e);
      }
      break;
    default:
      jj_la1[295] = jj_gen;
          list = Collections.emptyList();
    }
    jj_consume_token(RBRACE);
       {if (true) return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(s.end(this), list);}
    throw new Error("Missing return statement in function");
  }

/** Parses a MAP constructor */
  final public SqlNode MapConstructor() throws ParseException {
    SqlNodeList args;
    SqlNode e;
    final Span s;
    jj_consume_token(MAP);
            s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      // by sub query "MAP (SELECT empno, deptno FROM emp)"
              e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.MAP_QUERY.createCall(
                s.end(this), e);}
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        args = ExpressionCommaList(s, ExprContext.ACCEPT_NON_QUERY);
        break;
      default:
        jj_la1[296] = jj_gen;
              args = SqlNodeList.EMPTY;
      }
      jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR.createCall(
                s.end(this), args.getList());}
      break;
    default:
      jj_la1[297] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a PERIOD constructor */
  final public SqlNode PeriodConstructor() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(PERIOD);
               s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.ROW.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an interval literal.
 */
  final public SqlLiteral IntervalLiteral() throws ParseException {
    final String p;
    final SqlIntervalQualifier intervalQualifier;
    int sign = 1;
    final Span s;
    jj_consume_token(INTERVAL);
                 s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
                  sign = -1;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                 sign = 1;
        break;
      default:
        jj_la1[298] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[299] = jj_gen;
      ;
    }
    p = SimpleStringLiteral();
    intervalQualifier = IntervalQualifier();
        {if (true) return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier),
            sign, p, intervalQualifier);}
    throw new Error("Missing return statement in function");
  }

/** Parses an interval literal (e.g. {@code INTERVAL '2:3' HOUR TO MINUTE})
 * or an interval expression (e.g. {@code INTERVAL emp.empno MINUTE}
 * or {@code INTERVAL 3 MONTHS}). */
  final public SqlNode IntervalLiteralOrExpression() throws ParseException {
    final String p;
    final SqlIntervalQualifier intervalQualifier;
    int sign = 1;
    final Span s;
    SqlNode e;
    jj_consume_token(INTERVAL);
                 s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
                  sign = -1;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                 sign = 1;
        break;
      default:
        jj_la1[300] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[301] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      // literal (with quoted string)
              p = SimpleStringLiteral();
      intervalQualifier = IntervalQualifier();
            {if (true) return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier),
                sign, p, intervalQualifier);}
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case LPAREN:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        break;
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
        e = UnsignedNumericLiteral();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = CompoundIdentifier();
        break;
      default:
        jj_la1[302] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      intervalQualifier = IntervalQualifierStart();
            if (sign == -1) {
                e = SqlStdOperatorTable.UNARY_MINUS.createCall(e.getParserPosition(), e);
            }
            {if (true) return SqlStdOperatorTable.INTERVAL.createCall(s.end(this), e,
                intervalQualifier);}
      break;
    default:
      jj_la1[303] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Year() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YEAR:
      jj_consume_token(YEAR);
             {if (true) return TimeUnit.YEAR;}
      break;
    case YEARS:
      jj_consume_token(YEARS);
              {if (true) return warn(TimeUnit.YEAR);}
      break;
    default:
      jj_la1[304] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Quarter() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUARTER:
      jj_consume_token(QUARTER);
                {if (true) return TimeUnit.QUARTER;}
      break;
    case QUARTERS:
      jj_consume_token(QUARTERS);
                 {if (true) return warn(TimeUnit.QUARTER);}
      break;
    default:
      jj_la1[305] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Month() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MONTH:
      jj_consume_token(MONTH);
              {if (true) return TimeUnit.MONTH;}
      break;
    case MONTHS:
      jj_consume_token(MONTHS);
               {if (true) return warn(TimeUnit.MONTH);}
      break;
    default:
      jj_la1[306] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Week() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WEEK:
      jj_consume_token(WEEK);
             {if (true) return TimeUnit.WEEK;}
      break;
    case WEEKS:
      jj_consume_token(WEEKS);
              {if (true) return warn(TimeUnit.WEEK);}
      break;
    default:
      jj_la1[307] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Day() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DAY:
      jj_consume_token(DAY);
            {if (true) return TimeUnit.DAY;}
      break;
    case DAYS:
      jj_consume_token(DAYS);
             {if (true) return warn(TimeUnit.DAY);}
      break;
    default:
      jj_la1[308] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Hour() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOUR:
      jj_consume_token(HOUR);
             {if (true) return TimeUnit.HOUR;}
      break;
    case HOURS:
      jj_consume_token(HOURS);
              {if (true) return warn(TimeUnit.HOUR);}
      break;
    default:
      jj_la1[309] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Minute() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUTE:
      jj_consume_token(MINUTE);
               {if (true) return TimeUnit.MINUTE;}
      break;
    case MINUTES:
      jj_consume_token(MINUTES);
                {if (true) return warn(TimeUnit.MINUTE);}
      break;
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Second() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SECOND:
      jj_consume_token(SECOND);
               {if (true) return TimeUnit.SECOND;}
      break;
    case SECONDS:
      jj_consume_token(SECONDS);
                {if (true) return warn(TimeUnit.SECOND);}
      break;
    default:
      jj_la1[311] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlIntervalQualifier IntervalQualifier() throws ParseException {
    final Span s;
    final TimeUnit start;
    final TimeUnit end;
    final int startPrec;
    int secondFracPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YEAR:
    case YEARS:
      start = Year();
                         s = span();
      startPrec = PrecisionOpt();
      if (jj_2_87(2)) {
        jj_consume_token(TO);
        end = Month();
      } else {
              end = null;
      }
      break;
    case QUARTER:
    case QUARTERS:
      start = Quarter();
                            s = span();
      startPrec = PrecisionOpt();
          end = null;
      break;
    case MONTH:
    case MONTHS:
      start = Month();
                          s = span();
      startPrec = PrecisionOpt();
          end = null;
      break;
    case WEEK:
    case WEEKS:
      start = Week();
                         s = span();
      startPrec = PrecisionOpt();
          end = null;
      break;
    case DAY:
    case DAYS:
      start = Day();
                        s = span();
      startPrec = PrecisionOpt();
      if (jj_2_88(2)) {
        jj_consume_token(TO);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HOUR:
        case HOURS:
          end = Hour();
          break;
        case MINUTE:
        case MINUTES:
          end = Minute();
          break;
        case SECOND:
        case SECONDS:
          end = Second();
          secondFracPrec = PrecisionOpt();
          break;
        default:
          jj_la1[312] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
              end = null;
      }
      break;
    case HOUR:
    case HOURS:
      start = Hour();
                         s = span();
      startPrec = PrecisionOpt();
      if (jj_2_89(2)) {
        jj_consume_token(TO);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUTE:
        case MINUTES:
          end = Minute();
          break;
        case SECOND:
        case SECONDS:
          end = Second();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            jj_consume_token(LPAREN);
            secondFracPrec = UnsignedIntLiteral();
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[313] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[314] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
              end = null;
      }
      break;
    case MINUTE:
    case MINUTES:
      start = Minute();
                           s = span();
      startPrec = PrecisionOpt();
      if (jj_2_90(2)) {
        jj_consume_token(TO);
        end = Second();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          secondFracPrec = UnsignedIntLiteral();
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[315] = jj_gen;
          ;
        }
      } else {
              end = null;
      }
      break;
    case SECOND:
    case SECONDS:
      start = Second();
                           s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        startPrec = UnsignedIntLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          secondFracPrec = UnsignedIntLiteral();
          break;
        default:
          jj_la1[316] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[317] = jj_gen;
              startPrec = -1;
      }
          end = null;
      break;
    default:
      jj_la1[318] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIntervalQualifier(start, startPrec, end, secondFracPrec,
            s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** Interval qualifier without 'TO unit'. */
  final public SqlIntervalQualifier IntervalQualifierStart() throws ParseException {
    final Span s;
    final TimeUnit start;
    int startPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    int secondFracPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DAY:
    case DAYS:
    case HOUR:
    case HOURS:
    case MINUTE:
    case MINUTES:
    case MONTH:
    case MONTHS:
    case QUARTER:
    case QUARTERS:
    case WEEK:
    case WEEKS:
    case YEAR:
    case YEARS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case YEAR:
      case YEARS:
        start = Year();
        break;
      case QUARTER:
      case QUARTERS:
        start = Quarter();
        break;
      case MONTH:
      case MONTHS:
        start = Month();
        break;
      case WEEK:
      case WEEKS:
        start = Week();
        break;
      case DAY:
      case DAYS:
        start = Day();
        break;
      case HOUR:
      case HOURS:
        start = Hour();
        break;
      case MINUTE:
      case MINUTES:
        start = Minute();
        break;
      default:
        jj_la1[319] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          s = span();
      startPrec = PrecisionOpt();
      break;
    case SECOND:
    case SECONDS:
      start = Second();
                           s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        startPrec = UnsignedIntLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          secondFracPrec = UnsignedIntLiteral();
          break;
        default:
          jj_la1[320] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[321] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[322] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIntervalQualifier(start, startPrec, null, secondFracPrec,
            s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** Parses a built-in time unit (e.g. "YEAR")
 * or user-defined time frame (e.g. "MINUTE15")
 * and in each case returns a {@link SqlIntervalQualifier}.
 *
 * <p>The units are used in several functions, incuding CEIL, FLOOR, EXTRACT.
 * Includes NANOSECOND, MILLISECOND, which were previously allowed in EXTRACT
 * but not CEIL, FLOOR.
 *
 * <p>Includes {@code WEEK} and {@code WEEK(SUNDAY)} through
  {@code WEEK(SATURDAY)}.
 *
 * <p>Does not include SQL_TSI_DAY, SQL_TSI_FRAC_SECOND etc. These will be
 * parsed as identifiers and can be resolved in the validator if they are
 * registered as abbreviations in your time frame set.
 */
  final public SqlIntervalQualifier TimeUnitOrName() throws ParseException {
    final SqlIdentifier unitName;
    final SqlIntervalQualifier intervalQualifier;
    if (jj_2_91(2)) {
      intervalQualifier = TimeUnit();
        {if (true) return intervalQualifier;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        unitName = SimpleIdentifier();
        {if (true) return new SqlIntervalQualifier(unitName.getSimple(),
            unitName.getParserPosition());}
        break;
      default:
        jj_la1[323] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a built-in time unit (e.g. "YEAR")
 * and returns a {@link SqlIntervalQualifier}.
 *
 * <p>Includes {@code WEEK} and {@code WEEK(SUNDAY)} through
  {@code WEEK(SATURDAY)}.
 *
 * <p>Does not include SQL_TSI_DAY, SQL_TSI_FRAC_SECOND etc. These will be
 * parsed as identifiers and can be resolved in the validator if they are
 * registered as abbreviations in your time frame set.
 */
  final public SqlIntervalQualifier TimeUnit() throws ParseException {
    final Span span;
    final String w;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NANOSECOND:
      jj_consume_token(NANOSECOND);
                   {if (true) return new SqlIntervalQualifier(TimeUnit.NANOSECOND, null, getPos());}
      break;
    case MICROSECOND:
      jj_consume_token(MICROSECOND);
                    {if (true) return new SqlIntervalQualifier(TimeUnit.MICROSECOND, null, getPos());}
      break;
    case MILLISECOND:
      jj_consume_token(MILLISECOND);
                    {if (true) return new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, getPos());}
      break;
    case SECOND:
      jj_consume_token(SECOND);
               {if (true) return new SqlIntervalQualifier(TimeUnit.SECOND, null, getPos());}
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
               {if (true) return new SqlIntervalQualifier(TimeUnit.MINUTE, null, getPos());}
      break;
    case HOUR:
      jj_consume_token(HOUR);
             {if (true) return new SqlIntervalQualifier(TimeUnit.HOUR, null, getPos());}
      break;
    case DAY:
      jj_consume_token(DAY);
            {if (true) return new SqlIntervalQualifier(TimeUnit.DAY, null, getPos());}
      break;
    case DAYOFWEEK:
      jj_consume_token(DAYOFWEEK);
                  {if (true) return new SqlIntervalQualifier(TimeUnit.DOW, null, getPos());}
      break;
    case DAYOFYEAR:
      jj_consume_token(DAYOFYEAR);
                  {if (true) return new SqlIntervalQualifier(TimeUnit.DOY, null, getPos());}
      break;
    case DOW:
      jj_consume_token(DOW);
            {if (true) return new SqlIntervalQualifier(TimeUnit.DOW, null, getPos());}
      break;
    case DOY:
      jj_consume_token(DOY);
            {if (true) return new SqlIntervalQualifier(TimeUnit.DOY, null, getPos());}
      break;
    case ISODOW:
      jj_consume_token(ISODOW);
               {if (true) return new SqlIntervalQualifier(TimeUnit.ISODOW, null, getPos());}
      break;
    case ISOYEAR:
      jj_consume_token(ISOYEAR);
                {if (true) return new SqlIntervalQualifier(TimeUnit.ISOYEAR, null, getPos());}
      break;
    case WEEK:
      jj_consume_token(WEEK);
             span = span();
      if (jj_2_92(2)) {
        jj_consume_token(LPAREN);
        w = weekdayName();
        jj_consume_token(RPAREN);
            {if (true) return new SqlIntervalQualifier(w, span.end(this));}
      } else {
          {if (true) return new SqlIntervalQualifier(TimeUnit.WEEK, null, getPos());}
      }
      break;
    case MONTH:
      jj_consume_token(MONTH);
              {if (true) return new SqlIntervalQualifier(TimeUnit.MONTH, null, getPos());}
      break;
    case QUARTER:
      jj_consume_token(QUARTER);
                {if (true) return new SqlIntervalQualifier(TimeUnit.QUARTER, null, getPos());}
      break;
    case YEAR:
      jj_consume_token(YEAR);
             {if (true) return new SqlIntervalQualifier(TimeUnit.YEAR, null, getPos());}
      break;
    case EPOCH:
      jj_consume_token(EPOCH);
              {if (true) return new SqlIntervalQualifier(TimeUnit.EPOCH, null, getPos());}
      break;
    case DECADE:
      jj_consume_token(DECADE);
               {if (true) return new SqlIntervalQualifier(TimeUnit.DECADE, null, getPos());}
      break;
    case CENTURY:
      jj_consume_token(CENTURY);
                {if (true) return new SqlIntervalQualifier(TimeUnit.CENTURY, null, getPos());}
      break;
    case MILLENNIUM:
      jj_consume_token(MILLENNIUM);
                   {if (true) return new SqlIntervalQualifier(TimeUnit.MILLENNIUM, null, getPos());}
      break;
    default:
      jj_la1[324] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String weekdayName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUNDAY:
      jj_consume_token(SUNDAY);
               {if (true) return "WEEK_SUNDAY";}
      break;
    case MONDAY:
      jj_consume_token(MONDAY);
               {if (true) return "WEEK_MONDAY";}
      break;
    case TUESDAY:
      jj_consume_token(TUESDAY);
                {if (true) return "WEEK_TUESDAY";}
      break;
    case WEDNESDAY:
      jj_consume_token(WEDNESDAY);
                  {if (true) return "WEEK_WEDNESDAY";}
      break;
    case THURSDAY:
      jj_consume_token(THURSDAY);
                 {if (true) return "WEEK_THURSDAY";}
      break;
    case FRIDAY:
      jj_consume_token(FRIDAY);
               {if (true) return "WEEK_FRIDAY";}
      break;
    case SATURDAY:
      jj_consume_token(SATURDAY);
                 {if (true) return "WEEK_SATURDAY";}
      break;
    default:
      jj_la1[325] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a dynamic parameter marker.
 */
  final public SqlDynamicParam DynamicParam() throws ParseException {
    jj_consume_token(HOOK);
        {if (true) return new SqlDynamicParam(nDynamicParams++, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one segment of an identifier that may be composite.
 *
 * <p>Each time it reads an identifier it writes one element to each list;
 * the entry in {@code positions} records its position and whether the
 * segment was quoted.
 */
  final public void AddIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
    final String id;
    char unicodeEscapeChar = BACKSLASH;
    final SqlParserPos pos;
    final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
            id = unquotedIdentifier();
            pos = getPos();
      break;
    case HYPHENATED_IDENTIFIER:
      jj_consume_token(HYPHENATED_IDENTIFIER);
            id = unquotedIdentifier();
            pos = getPos();
      break;
    case QUOTED_IDENTIFIER:
      jj_consume_token(QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, DQ, DQ, DQDQ,
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BACK_QUOTED_IDENTIFIER:
      jj_consume_token(BACK_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "`", "`", "``",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      jj_consume_token(BIG_QUERY_BACK_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "`", "`", "\\`",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BRACKET_QUOTED_IDENTIFIER:
      jj_consume_token(BRACKET_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "[", "]", "]]",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case UNICODE_QUOTED_IDENTIFIER:
      jj_consume_token(UNICODE_QUOTED_IDENTIFIER);
            span = span();
            String image = getToken(0).image;
            image = image.substring(image.indexOf('"'));
            image = SqlParserUtil.stripQuotes(image, DQ, DQ, DQDQ, quotedCasing);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UESCAPE:
        jj_consume_token(UESCAPE);
        jj_consume_token(QUOTED_STRING);
                String s = SqlParserUtil.parseString(token.image);
                unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
        break;
      default:
        jj_la1[326] = jj_gen;
        ;
      }
            pos = span.end(this).withQuoting(true);
            SqlLiteral lit = SqlLiteral.createCharString(image, "UTF16", pos);
            lit = lit.unescapeUnicode(unicodeEscapeChar);
            id = lit.toValue();
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
      id = NonReservedKeyWord();
            pos = getPos();
      break;
    default:
      jj_la1[327] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (id.length() > this.identifierMaxLength) {
            {if (true) throw SqlUtil.newContextException(pos,
                RESOURCE.identifierTooLong(id, this.identifierMaxLength));}
        }
        names.add(id);
        if (positions != null) {
            positions.add(pos);
        }
  }

/** As {@link #AddIdentifierSegment} but part of a table name (for example,
 * following {@code FROM}, {@code INSERT} or {@code UPDATE}).
 *
 * <p>In some dialects the lexical rules for table names are different from
 * for other identifiers. For example, in BigQuery, table names may contain
 * hyphens. */
  final public void AddTableIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
    AddIdentifierSegment(names, positions);
        final int n = names.size();
        if (n > 0
                && positions.size() == n
                && names.get(n - 1).contains(".")
                && positions.get(n - 1).isQuoted()
                && this.conformance.splitQuotedTableName()) {
            final String name = names.remove(n - 1);
            final SqlParserPos pos = positions.remove(n - 1);
            final String[] splitNames = name.split("\\.");
            for (String splitName : splitNames) {
                names.add(splitName);
                positions.add(pos);
            }
        }
  }

/**
 * Parses a simple identifier as a String.
 */
  final public String Identifier() throws ParseException {
    final List<String> names = new ArrayList<String>();
    AddIdentifierSegment(names, null);
        {if (true) return names.get(0);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a simple identifier as an SqlIdentifier.
 */
  final public SqlIdentifier SimpleIdentifier() throws ParseException {
    final List<String> names = new ArrayList<String>();
    final List<SqlParserPos> positions = new ArrayList<SqlParserPos>();
    AddIdentifierSegment(names, positions);
        {if (true) return new SqlIdentifier(names.get(0), positions.get(0));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a character literal as an SqlIdentifier.
 * Only valid for column aliases in certain dialects.
 */
  final public SqlIdentifier SimpleIdentifierFromStringLiteral() throws ParseException {
    jj_consume_token(QUOTED_STRING);
        if (!this.conformance.allowCharLiteralAlias()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.charLiteralAliasNotValid());}
        }
        final String s = SqlParserUtil.parseString(token.image);
        {if (true) return new SqlIdentifier(s, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a comma-separated list of simple identifiers.
 */
  final public void AddSimpleIdentifiers(List<SqlNode> list) throws ParseException {
    SqlIdentifier id;
    id = SimpleIdentifier();
                             list.add(id);
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[328] = jj_gen;
        break label_51;
      }
      jj_consume_token(COMMA);
      id = SimpleIdentifier();
            list.add(id);
    }
  }

/**
  * List of simple identifiers in parentheses. The position extends from the
  * open parenthesis to the close parenthesis.
  */
  final public SqlNodeList ParenthesizedSimpleIdentifierList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    AddSimpleIdentifiers(list);
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** List of simple identifiers in parentheses or one simple identifier.
 *
 * <ul>Examples:
 * <li>{@code DEPTNO}
 * <li>{@code (EMPNO, DEPTNO)}
 * </ul>
 */
  final public SqlNodeList SimpleIdentifierOrList() throws ParseException {
    SqlIdentifier id;
    SqlNodeList list;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      id = SimpleIdentifier();
        {if (true) return new SqlNodeList(Collections.singletonList(id), id.getParserPosition());}
      break;
    case LPAREN:
      list = ParenthesizedSimpleIdentifierList();
        {if (true) return list;}
      break;
    default:
      jj_la1[329] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a compound identifier.
 */
  final public SqlIdentifier CompoundIdentifier() throws ParseException {
    final List<String> nameList = new ArrayList<String>();
    final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();
    boolean star = false;
    AddIdentifierSegment(nameList, posList);
    label_52:
    while (true) {
      if (jj_2_93(2)) {
        ;
      } else {
        break label_52;
      }
      jj_consume_token(DOT);
      AddIdentifierSegment(nameList, posList);
    }
    if (jj_2_94(2)) {
      jj_consume_token(DOT);
      jj_consume_token(STAR);
            star = true;
            nameList.add("");
            posList.add(getPos());
    } else {
      ;
    }
        SqlParserPos pos = SqlParserPos.sum(posList);
        if (star) {
            {if (true) return SqlIdentifier.star(nameList, pos, posList);}
        }
        {if (true) return new SqlIdentifier(nameList, null, pos, posList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a compound identifier in the FROM clause.
 */
  final public SqlIdentifier CompoundTableIdentifier() throws ParseException {
    final List<String> nameList = new ArrayList<String>();
    final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();
    AddTableIdentifierSegment(nameList, posList);
    label_53:
    while (true) {
      if (jj_2_95(2)) {
        ;
      } else {
        break label_53;
      }
      jj_consume_token(DOT);
      AddTableIdentifierSegment(nameList, posList);
    }
        SqlParserPos pos = SqlParserPos.sum(posList);
        {if (true) return new SqlIdentifier(nameList, null, pos, posList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a comma-separated list of compound identifiers.
 */
  final public void AddCompoundIdentifierTypes(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
    AddCompoundIdentifierType(list, extendList);
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[330] = jj_gen;
        break label_54;
      }
      jj_consume_token(COMMA);
      AddCompoundIdentifierType(list, extendList);
    }
  }

/**
 * List of compound identifiers in parentheses. The position extends from the
 * open parenthesis to the close parenthesis.
 */
  final public Pair<SqlNodeList, SqlNodeList> ParenthesizedCompoundIdentifierList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final List<SqlNode> extendList = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    AddCompoundIdentifierTypes(list, extendList);
    jj_consume_token(RPAREN);
        {if (true) return Pair.of(new SqlNodeList(list, s.end(this)), new SqlNodeList(extendList, s.end(this)));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a NEW UDT(...) expression.
 */
  final public SqlNode NewSpecification() throws ParseException {
    final Span s;
    final SqlNode routineCall;
    jj_consume_token(NEW);
            s = span();
    routineCall = NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR,
                ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.NEW.createCall(s.end(routineCall), routineCall);}
    throw new Error("Missing return statement in function");
  }

//TODO: real parse errors.
  final public int UnsignedIntLiteral() throws ParseException {
    Token t;
    t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        try {
            {if (true) return Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
    throw new Error("Missing return statement in function");
  }

  final public int IntLiteral() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case PLUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNED_INTEGER_LITERAL:
        t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        break;
      case PLUS:
        jj_consume_token(PLUS);
        t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        break;
      default:
        jj_la1[331] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        try {
            {if (true) return Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
      break;
    case MINUS:
      jj_consume_token(MINUS);
      t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        try {
            {if (true) return -Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
      break;
    default:
      jj_la1[332] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Type name with optional scale and precision.
  final public SqlDataTypeSpec DataType() throws ParseException {
    SqlTypeNameSpec typeName;
    final Span s;
    typeName = TypeName();
        s = Span.of(typeName.getParserPos());
    label_55:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case MULTISET:
        ;
        break;
      default:
        jj_la1[333] = jj_gen;
        break label_55;
      }
      typeName = CollectionsTypeName(typeName);
    }
        {if (true) return new SqlDataTypeSpec(typeName, s.add(typeName.getParserPos()).pos());}
    throw new Error("Missing return statement in function");
  }

// Some SQL type names need special handling due to the fact that they have
// spaces in them but are not quoted.
  final public SqlTypeNameSpec TypeName() throws ParseException {
    final SqlTypeNameSpec typeNameSpec;
    final SqlIdentifier typeName;
    final Span s = Span.of();
    if (jj_2_96(2)) {
      typeNameSpec = HazelcastDateTimeTypeName();
    } else if (jj_2_97(2)) {
      typeNameSpec = SqlTypeName(s);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        typeNameSpec = RowTypeName();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        typeName = CompoundIdentifier();
            typeNameSpec = new SqlUserDefinedTypeNameSpec(typeName, s.end(this));
        break;
      default:
        jj_la1[334] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return typeNameSpec;}
    throw new Error("Missing return statement in function");
  }

// Types used for JDBC and ODBC scalar conversion function
  final public SqlTypeNameSpec SqlTypeName(Span s) throws ParseException {
    final SqlTypeNameSpec sqlTypeNameSpec;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIGINT:
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case GEOMETRY:
    case INT:
    case INTEGER:
    case REAL:
    case SMALLINT:
    case TINYINT:
      sqlTypeNameSpec = SqlTypeName1(s);
      break;
    case BINARY:
    case VARBINARY:
      sqlTypeNameSpec = SqlTypeName2(s);
      break;
    case ANY:
    case DEC:
    case DECIMAL:
    case NUMERIC:
      sqlTypeNameSpec = SqlTypeName3(s);
      break;
    case CHAR:
    case CHARACTER:
    case VARCHAR:
      sqlTypeNameSpec = CharacterTypeName(s);
      break;
    case DATE:
    case TIME:
    case TIMESTAMP:
      sqlTypeNameSpec = DateTimeTypeName();
      break;
    default:
      jj_la1[335] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return sqlTypeNameSpec;}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that don't allow any extra specifications except the type name.
// For extra specification, we mean precision, scale, charSet, etc.
  final public SqlTypeNameSpec SqlTypeName1(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GEOMETRY:
      jj_consume_token(GEOMETRY);
            if (!this.conformance.allowGeometry()) {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.geometryDisabled());}
            }
            s.add(this);
            sqlTypeName = SqlTypeName.GEOMETRY;
      break;
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
                    s.add(this); sqlTypeName = SqlTypeName.BOOLEAN;
      break;
    case INT:
    case INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      case INT:
        jj_consume_token(INT);
        break;
      default:
        jj_la1[336] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                s.add(this); sqlTypeName = SqlTypeName.INTEGER;
      break;
    case TINYINT:
      jj_consume_token(TINYINT);
                    s.add(this); sqlTypeName = SqlTypeName.TINYINT;
      break;
    case SMALLINT:
      jj_consume_token(SMALLINT);
                     s.add(this); sqlTypeName = SqlTypeName.SMALLINT;
      break;
    case BIGINT:
      jj_consume_token(BIGINT);
                   s.add(this); sqlTypeName = SqlTypeName.BIGINT;
      break;
    case REAL:
      jj_consume_token(REAL);
                 s.add(this); sqlTypeName = SqlTypeName.REAL;
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
                   s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECISION:
        jj_consume_token(PRECISION);
        break;
      default:
        jj_la1[337] = jj_gen;
        ;
      }
                          sqlTypeName = SqlTypeName.DOUBLE;
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
                  s.add(this); sqlTypeName = SqlTypeName.FLOAT;
      break;
    default:
      jj_la1[338] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that allows precision specification.
  final public SqlTypeNameSpec SqlTypeName2(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    int precision = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY:
      jj_consume_token(BINARY);
                   s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VARYING:
        jj_consume_token(VARYING);
                        sqlTypeName = SqlTypeName.VARBINARY;
        break;
      default:
        jj_la1[339] = jj_gen;
              sqlTypeName = SqlTypeName.BINARY;
      }
      break;
    case VARBINARY:
      jj_consume_token(VARBINARY);
                      s.add(this); sqlTypeName = SqlTypeName.VARBINARY;
      break;
    default:
      jj_la1[340] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    precision = PrecisionOpt();
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that allows precision and scale specifications.
  final public SqlTypeNameSpec SqlTypeName3(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    int precision = -1;
    int scale = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEC:
    case DECIMAL:
    case NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      case DEC:
        jj_consume_token(DEC);
        break;
      case NUMERIC:
        jj_consume_token(NUMERIC);
        break;
      default:
        jj_la1[341] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                          s.add(this); sqlTypeName = SqlTypeName.DECIMAL;
      break;
    case ANY:
      jj_consume_token(ANY);
                s.add(this); sqlTypeName = SqlTypeName.ANY;
      break;
    default:
      jj_la1[342] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      precision = UnsignedIntLiteral();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        scale = UnsignedIntLiteral();
        break;
      default:
        jj_la1[343] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[344] = jj_gen;
      ;
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, scale, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Types used for for JDBC and ODBC scalar conversion function
  final public SqlJdbcDataTypeName JdbcOdbcDataTypeName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case SQL_CHAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_CHAR:
        jj_consume_token(SQL_CHAR);
        break;
      case CHAR:
        jj_consume_token(CHAR);
        break;
      default:
        jj_la1[345] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_CHAR;}
      break;
    case SQL_VARCHAR:
    case VARCHAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_VARCHAR:
        jj_consume_token(SQL_VARCHAR);
        break;
      case VARCHAR:
        jj_consume_token(VARCHAR);
        break;
      default:
        jj_la1[346] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_VARCHAR;}
      break;
    case DATE:
    case SQL_DATE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DATE:
        jj_consume_token(SQL_DATE);
        break;
      case DATE:
        jj_consume_token(DATE);
        break;
      default:
        jj_la1[347] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_DATE;}
      break;
    case SQL_TIME:
    case TIME:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TIME:
        jj_consume_token(SQL_TIME);
        break;
      case TIME:
        jj_consume_token(TIME);
        break;
      default:
        jj_la1[348] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_TIME;}
      break;
    case SQL_TIMESTAMP:
    case TIMESTAMP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TIMESTAMP:
        jj_consume_token(SQL_TIMESTAMP);
        break;
      case TIMESTAMP:
        jj_consume_token(TIMESTAMP);
        break;
      default:
        jj_la1[349] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                      {if (true) return SqlJdbcDataTypeName.SQL_TIMESTAMP;}
      break;
    case DECIMAL:
    case SQL_DECIMAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DECIMAL:
        jj_consume_token(SQL_DECIMAL);
        break;
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      default:
        jj_la1[350] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_DECIMAL;}
      break;
    case NUMERIC:
    case SQL_NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_NUMERIC:
        jj_consume_token(SQL_NUMERIC);
        break;
      case NUMERIC:
        jj_consume_token(NUMERIC);
        break;
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_NUMERIC;}
      break;
    case BOOLEAN:
    case SQL_BOOLEAN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BOOLEAN:
        jj_consume_token(SQL_BOOLEAN);
        break;
      case BOOLEAN:
        jj_consume_token(BOOLEAN);
        break;
      default:
        jj_la1[352] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_BOOLEAN;}
      break;
    case INTEGER:
    case SQL_INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_INTEGER:
        jj_consume_token(SQL_INTEGER);
        break;
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      default:
        jj_la1[353] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_INTEGER;}
      break;
    case BINARY:
    case SQL_BINARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BINARY:
        jj_consume_token(SQL_BINARY);
        break;
      case BINARY:
        jj_consume_token(BINARY);
        break;
      default:
        jj_la1[354] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_BINARY;}
      break;
    case SQL_VARBINARY:
    case VARBINARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_VARBINARY:
        jj_consume_token(SQL_VARBINARY);
        break;
      case VARBINARY:
        jj_consume_token(VARBINARY);
        break;
      default:
        jj_la1[355] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                      {if (true) return SqlJdbcDataTypeName.SQL_VARBINARY;}
      break;
    case SQL_TINYINT:
    case TINYINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TINYINT:
        jj_consume_token(SQL_TINYINT);
        break;
      case TINYINT:
        jj_consume_token(TINYINT);
        break;
      default:
        jj_la1[356] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_TINYINT;}
      break;
    case SMALLINT:
    case SQL_SMALLINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_SMALLINT:
        jj_consume_token(SQL_SMALLINT);
        break;
      case SMALLINT:
        jj_consume_token(SMALLINT);
        break;
      default:
        jj_la1[357] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                    {if (true) return SqlJdbcDataTypeName.SQL_SMALLINT;}
      break;
    case BIGINT:
    case SQL_BIGINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BIGINT:
        jj_consume_token(SQL_BIGINT);
        break;
      case BIGINT:
        jj_consume_token(BIGINT);
        break;
      default:
        jj_la1[358] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_BIGINT;}
      break;
    case REAL:
    case SQL_REAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_REAL:
        jj_consume_token(SQL_REAL);
        break;
      case REAL:
        jj_consume_token(REAL);
        break;
      default:
        jj_la1[359] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                           {if (true) return SqlJdbcDataTypeName.SQL_REAL;}
      break;
    case DOUBLE:
    case SQL_DOUBLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DOUBLE:
        jj_consume_token(SQL_DOUBLE);
        break;
      case DOUBLE:
        jj_consume_token(DOUBLE);
        break;
      default:
        jj_la1[360] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_DOUBLE;}
      break;
    case FLOAT:
    case SQL_FLOAT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_FLOAT:
        jj_consume_token(SQL_FLOAT);
        break;
      case FLOAT:
        jj_consume_token(FLOAT);
        break;
      default:
        jj_la1[361] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                              {if (true) return SqlJdbcDataTypeName.SQL_FLOAT;}
      break;
    case SQL_INTERVAL_YEAR:
      jj_consume_token(SQL_INTERVAL_YEAR);
                          {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR;}
      break;
    case SQL_INTERVAL_YEAR_TO_MONTH:
      jj_consume_token(SQL_INTERVAL_YEAR_TO_MONTH);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR_TO_MONTH;}
      break;
    case SQL_INTERVAL_MONTH:
      jj_consume_token(SQL_INTERVAL_MONTH);
                           {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MONTH;}
      break;
    case SQL_INTERVAL_DAY:
      jj_consume_token(SQL_INTERVAL_DAY);
                         {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY;}
      break;
    case SQL_INTERVAL_DAY_TO_HOUR:
      jj_consume_token(SQL_INTERVAL_DAY_TO_HOUR);
                                 {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_HOUR;}
      break;
    case SQL_INTERVAL_DAY_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_DAY_TO_MINUTE);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_MINUTE;}
      break;
    case SQL_INTERVAL_DAY_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_DAY_TO_SECOND);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_SECOND;}
      break;
    case SQL_INTERVAL_HOUR:
      jj_consume_token(SQL_INTERVAL_HOUR);
                          {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR;}
      break;
    case SQL_INTERVAL_HOUR_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_MINUTE);
                                    {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_MINUTE;}
      break;
    case SQL_INTERVAL_HOUR_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_SECOND);
                                    {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_SECOND;}
      break;
    case SQL_INTERVAL_MINUTE:
      jj_consume_token(SQL_INTERVAL_MINUTE);
                            {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE;}
      break;
    case SQL_INTERVAL_MINUTE_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_MINUTE_TO_SECOND);
                                      {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE_TO_SECOND;}
      break;
    case SQL_INTERVAL_SECOND:
      jj_consume_token(SQL_INTERVAL_SECOND);
                            {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_SECOND;}
      break;
    default:
      jj_la1[362] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral JdbcOdbcDataType() throws ParseException {
    SqlJdbcDataTypeName typeName;
    typeName = JdbcOdbcDataTypeName();
        {if (true) return typeName.symbol(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a collection type name, the input element type name may
* also be a collection type.
*/
  final public SqlTypeNameSpec CollectionsTypeName(SqlTypeNameSpec elementTypeName) throws ParseException {
    final SqlTypeName collectionTypeName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MULTISET:
      jj_consume_token(MULTISET);
                     collectionTypeName = SqlTypeName.MULTISET;
      break;
    case ARRAY:
      jj_consume_token(ARRAY);
                  collectionTypeName = SqlTypeName.ARRAY;
      break;
    default:
      jj_la1[363] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlCollectionTypeNameSpec(elementTypeName,
                collectionTypeName, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a nullable option, default is true.
*/
  final public boolean NullableOptDefaultTrue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
             {if (true) return true;}
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[364] = jj_gen;
      {if (true) return true;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a nullable option, default is false.
*/
  final public boolean NullableOptDefaultFalse() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
             {if (true) return true;}
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[365] = jj_gen;
      {if (true) return false;}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses NOT NULL and returns false, or parses nothing and returns true. */
  final public boolean NotNullOpt() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[366] = jj_gen;
      {if (true) return true;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "name1 type1 [NULL | NOT NULL], name2 type2 [NULL | NOT NULL] ..." list,
* the field type default is not nullable.
*/
  final public void AddFieldNameTypes(List<SqlIdentifier> fieldNames,
    List<SqlDataTypeSpec> fieldTypes) throws ParseException {
    AddFieldNameType(fieldNames, fieldTypes);
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[367] = jj_gen;
        break label_56;
      }
      jj_consume_token(COMMA);
      AddFieldNameType(fieldNames, fieldTypes);
    }
  }

  final public void AddFieldNameType(List<SqlIdentifier> fieldNames,
    List<SqlDataTypeSpec> fieldTypes) throws ParseException {
    final SqlIdentifier fName;
    final SqlDataTypeSpec fType;
    final boolean nullable;
    fName = SimpleIdentifier();
    fType = DataType();
    nullable = NullableOptDefaultFalse();
        fieldNames.add(fName);
        fieldTypes.add(fType.withNullable(nullable, getPos()));
  }

/**
* Parse Row type with format: Row(name1 type1, name2 type2).
* Every field type can have suffix of `NULL` or `NOT NULL` to indicate if this type is nullable.
* i.e. Row(f0 int not null, f1 varchar null).
*/
  final public SqlTypeNameSpec RowTypeName() throws ParseException {
    List<SqlIdentifier> fieldNames = new ArrayList<SqlIdentifier>();
    List<SqlDataTypeSpec> fieldTypes = new ArrayList<SqlDataTypeSpec>();
    jj_consume_token(ROW);
    jj_consume_token(LPAREN);
    AddFieldNameTypes(fieldNames, fieldTypes);
    jj_consume_token(RPAREN);
        {if (true) return new SqlRowTypeNameSpec(getPos(), fieldNames, fieldTypes);}
    throw new Error("Missing return statement in function");
  }

/**
* Parse character types: char, varchar.
*/
  final public SqlTypeNameSpec CharacterTypeName(Span s) throws ParseException {
    int precision = -1;
    final SqlTypeName sqlTypeName;
    String charSetName = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CHARACTER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHARACTER:
        jj_consume_token(CHARACTER);
        break;
      case CHAR:
        jj_consume_token(CHAR);
        break;
      default:
        jj_la1[368] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                 s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VARYING:
        jj_consume_token(VARYING);
                        sqlTypeName = SqlTypeName.VARCHAR;
        break;
      default:
        jj_la1[369] = jj_gen;
              sqlTypeName = SqlTypeName.CHAR;
      }
      break;
    case VARCHAR:
      jj_consume_token(VARCHAR);
                    s.add(this); sqlTypeName = SqlTypeName.VARCHAR;
      break;
    default:
      jj_la1[370] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    precision = PrecisionOpt();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARACTER:
      jj_consume_token(CHARACTER);
      jj_consume_token(SET);
      charSetName = Identifier();
      break;
    default:
      jj_la1[371] = jj_gen;
      ;
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, charSetName, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
* Parse datetime types: date, time, timestamp.
*/
  final public SqlTypeNameSpec DateTimeTypeName() throws ParseException {
    int precision = -1;
    SqlTypeName typeName;
    boolean withLocalTimeZone = false;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
      jj_consume_token(DATE);
        typeName = SqlTypeName.DATE;
        {if (true) return new SqlBasicTypeNameSpec(typeName, getPos());}
      break;
    default:
      jj_la1[372] = jj_gen;
      if (jj_2_98(2)) {
        jj_consume_token(TIME);
             s = span();
        precision = PrecisionOpt();
        withLocalTimeZone = TimeZoneOpt();
        if (withLocalTimeZone) {
            typeName = SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE;
        } else {
            typeName = SqlTypeName.TIME;
        }
        {if (true) return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIMESTAMP:
          jj_consume_token(TIMESTAMP);
                  s = span();
          precision = PrecisionOpt();
          withLocalTimeZone = TimeZoneOpt();
        if (withLocalTimeZone) {
            typeName = SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
        } else {
            typeName = SqlTypeName.TIMESTAMP;
        }
        {if (true) return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));}
          break;
        default:
          jj_la1[373] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

// Parse an optional data type precision, default is -1.
  final public int PrecisionOpt() throws ParseException {
    int precision = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      precision = UnsignedIntLiteral();
      jj_consume_token(RPAREN);
      {if (true) return precision;}
      break;
    default:
      jj_la1[374] = jj_gen;
      {if (true) return -1;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a time zone suffix for DateTime types. According to SQL-2011,
* "with time zone" and "without time zone" belong to standard SQL but we
* only implement the "without time zone".
*
* <p>We also support "with local time zone".
*
* @return true if this is "with local time zone".
*/
  final public boolean TimeZoneOpt() throws ParseException {
    if (jj_2_99(3)) {
      jj_consume_token(WITHOUT);
      jj_consume_token(TIME);
      jj_consume_token(ZONE);
                              {if (true) return false;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(LOCAL);
        jj_consume_token(TIME);
        jj_consume_token(ZONE);
                                   {if (true) return true;}
        break;
      default:
        jj_la1[375] = jj_gen;
      {if (true) return false;}
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CURSOR(query) expression.  The parser allows these
 * anywhere, but the validator restricts them to appear only as
 * arguments to table functions.
 */
  final public SqlNode CursorExpression(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    final Span s;
    jj_consume_token(CURSOR);
        s = span();
        if (exprContext != ExprContext.ACCEPT_ALL
                && exprContext != ExprContext.ACCEPT_CURSOR) {
            {if (true) throw SqlUtil.newContextException(s.end(this),
                RESOURCE.illegalCursorExpression());}
        }
    e = Expression(ExprContext.ACCEPT_QUERY);
        {if (true) return SqlStdOperatorTable.CURSOR.createCall(s.end(e), e);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a builtin function with special syntax.
 */
  final public SqlNode BuiltinFunctionCall() throws ParseException {
    final SqlIdentifier name;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    final Span s;
    SqlDataTypeSpec dt;
    final SqlIntervalQualifier unit;
    final SqlNode node;
    final SqlLiteral style; // mssql convert 'style' operand
    final SqlFunction f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CAST:
    case SAFE_CAST:
    case TRY_CAST:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CAST:
        jj_consume_token(CAST);
                    f = SqlStdOperatorTable.CAST;
        break;
      case SAFE_CAST:
        jj_consume_token(SAFE_CAST);
                        f = SqlLibraryOperators.SAFE_CAST;
        break;
      case TRY_CAST:
        jj_consume_token(TRY_CAST);
                       f = SqlLibraryOperators.TRY_CAST;
        break;
      default:
        jj_la1[376] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(AS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case ANY:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BIGINT:
      case BINARY:
      case BOOLEAN:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHARACTER:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DEC:
      case DECADE:
      case DECIMAL:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOUBLE:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FLOAT:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INT:
      case INTEGER:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case NUMERIC:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case REAL:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SMALLINT:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TINYINT:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VARBINARY:
      case VARCHAR:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        dt = DataType();
                              args.add(dt);
        break;
      case INTERVAL:
        jj_consume_token(INTERVAL);
        e = IntervalQualifier();
                                                 args.add(e);
        break;
      default:
        jj_la1[377] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
            {if (true) return f.createCall(s.end(this), args);}
      break;
    case EXTRACT:
      jj_consume_token(EXTRACT);
                    s = span();
      jj_consume_token(LPAREN);
      unit = TimeUnitOrName();
            args.add(unit);
      jj_consume_token(FROM);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.EXTRACT.createCall(s.end(this), args);}
      break;
    case POSITION:
      jj_consume_token(POSITION);
                     s = span();
      jj_consume_token(LPAREN);
      // FIXME jvs 31-Aug-2006:  FRG-192:  This should be
              // Expression(ExprContext.ACCEPT_SUB_QUERY), but that doesn't work
              // because it matches the other kind of IN.
              e = AtomicRowExpression();
                                    args.add(e);
      jj_consume_token(IN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        break;
      default:
        jj_la1[378] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.POSITION.createCall(s.end(this), args);}
      break;
    case CONVERT:
      jj_consume_token(CONVERT);
                    s = span();
      jj_consume_token(LPAREN);
      if (jj_2_100(2)) {
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case USING:
          jj_consume_token(USING);
          name = SimpleIdentifier();
                                                    args.add(name);
          jj_consume_token(RPAREN);
                    {if (true) return SqlStdOperatorTable.TRANSLATE.createCall(s.end(this), args);}
          break;
        case COMMA:
          jj_consume_token(COMMA);
          e = SimpleIdentifier();
                                                 args.add(e);
          jj_consume_token(COMMA);
          e = SimpleIdentifier();
                                                 args.add(e);
          jj_consume_token(RPAREN);
                    {if (true) return SqlStdOperatorTable.CONVERT.createCall(s.end(this), args);}
          break;
        default:
          jj_la1[379] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case ANY:
        case APPLY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case BEFORE:
        case BERNOULLI:
        case BIGINT:
        case BINARY:
        case BOOLEAN:
        case BREADTH:
        case C:
        case CASCADE:
        case CATALOG:
        case CATALOG_NAME:
        case CENTURY:
        case CHAIN:
        case CHAR:
        case CHARACTER:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASS_ORIGIN:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATE:
        case DATE_DIFF:
        case DATE_TRUNC:
        case DATETIME_DIFF:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DATETIME_TRUNC:
        case DAYOFWEEK:
        case DAYOFYEAR:
        case DAYS:
        case DEC:
        case DECADE:
        case DECIMAL:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOT_FORMAT:
        case DOUBLE:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXTERNAL:
        case FINAL:
        case FIRST:
        case FLOAT:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case HIERARCHY:
        case HOP:
        case HOURS:
        case IGNORE:
        case ILIKE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDE:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INT:
        case INTEGER:
        case INTERVAL:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAST:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LOCATOR:
        case M:
        case MAP:
        case MATCHED:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MINUTES:
        case MINVALUE:
        case MONTHS:
        case MORE_:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NORMALIZED:
        case NULLABLE:
        case NULLS:
        case NUMBER:
        case NUMERIC:
        case OBJECT:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENTILE_CONT:
        case PERCENTILE_DISC:
        case PIVOT:
        case PLACING:
        case PLAN:
        case PLI:
        case PRECEDING:
        case PRESERVE:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case QUARTERS:
        case READ:
        case REAL:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RLIKE:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW:
        case ROW_COUNT:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEPARATOR:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SMALLINT:
        case SOURCE:
        case SPACE:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case STATE:
        case STATEMENT:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIME:
        case TIME_DIFF:
        case TIME_TRUNC:
        case TIMESTAMP:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TIMESTAMP_DIFF:
        case TIMESTAMP_TRUNC:
        case TINYINT:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNPIVOT:
        case UNNAMED:
        case USAGE:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VARBINARY:
        case VARCHAR:
        case VERSION:
        case VIEW:
        case WEEK:
        case WEEKS:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEARS:
        case ZONE:
        case ANALYZE:
        case CONNECTOR:
        case JOB:
        case JOBS:
        case MAPPING:
        case MAPPINGS:
        case RESOURCES:
        case RESUME:
        case SHARED:
        case SINK:
        case SNAPSHOT:
        case SUSPEND:
        case TYPES:
        case VIEWS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case A:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case ANY:
          case APPLY:
          case ARRAY_AGG:
          case ARRAY_CONCAT_AGG:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case BEFORE:
          case BERNOULLI:
          case BIGINT:
          case BINARY:
          case BOOLEAN:
          case BREADTH:
          case C:
          case CASCADE:
          case CATALOG:
          case CATALOG_NAME:
          case CENTURY:
          case CHAIN:
          case CHAR:
          case CHARACTER:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASS_ORIGIN:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATE:
          case DATE_DIFF:
          case DATE_TRUNC:
          case DATETIME_DIFF:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DATETIME_TRUNC:
          case DAYOFWEEK:
          case DAYOFYEAR:
          case DAYS:
          case DEC:
          case DECADE:
          case DECIMAL:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOT_FORMAT:
          case DOUBLE:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case EXTERNAL:
          case FINAL:
          case FIRST:
          case FLOAT:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case GROUP_CONCAT:
          case HIERARCHY:
          case HOP:
          case HOURS:
          case IGNORE:
          case ILIKE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDE:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INT:
          case INTEGER:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAST:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LOCATOR:
          case M:
          case MAP:
          case MATCHED:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MINUTES:
          case MINVALUE:
          case MONTHS:
          case MORE_:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NORMALIZED:
          case NULLABLE:
          case NULLS:
          case NUMBER:
          case NUMERIC:
          case OBJECT:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PERCENTILE_CONT:
          case PERCENTILE_DISC:
          case PIVOT:
          case PLACING:
          case PLAN:
          case PLI:
          case PRECEDING:
          case PRESERVE:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case QUARTERS:
          case READ:
          case REAL:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case RLIKE:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW:
          case ROW_COUNT:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEPARATOR:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SMALLINT:
          case SOURCE:
          case SPACE:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case STATE:
          case STATEMENT:
          case STRING_AGG:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIME:
          case TIME_DIFF:
          case TIME_TRUNC:
          case TIMESTAMP:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TIMESTAMP_DIFF:
          case TIMESTAMP_TRUNC:
          case TINYINT:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNPIVOT:
          case UNNAMED:
          case USAGE:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VARBINARY:
          case VARCHAR:
          case VERSION:
          case VIEW:
          case WEEK:
          case WEEKS:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEARS:
          case ZONE:
          case ANALYZE:
          case CONNECTOR:
          case JOB:
          case JOBS:
          case MAPPING:
          case MAPPINGS:
          case RESOURCES:
          case RESUME:
          case SHARED:
          case SINK:
          case SNAPSHOT:
          case SUSPEND:
          case TYPES:
          case VIEWS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            dt = DataType();
                                  args.add(dt);
            break;
          case INTERVAL:
            jj_consume_token(INTERVAL);
            e = IntervalQualifier();
                                                     args.add(e);
            break;
          default:
            jj_la1[380] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(COMMA);
          AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case UNSIGNED_INTEGER_LITERAL:
            case APPROX_NUMERIC_LITERAL:
            case DECIMAL_NUMERIC_LITERAL:
              style = UnsignedNumericLiteral();
                                                       args.add(style);
              break;
            case NULL:
              jj_consume_token(NULL);
                             args.add(SqlLiteral.createNull(getPos()));
              break;
            default:
              jj_la1[381] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[382] = jj_gen;
            ;
          }
          jj_consume_token(RPAREN);
                {if (true) return SqlLibraryOperators.MSSQL_CONVERT.createCall(s.end(this), args);}
          break;
        default:
          jj_la1[383] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case TRANSLATE:
      jj_consume_token(TRANSLATE);
                      s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        name = SimpleIdentifier();
                                                args.add(name);
        jj_consume_token(RPAREN);
                {if (true) return SqlStdOperatorTable.TRANSLATE.createCall(s.end(this),
                    args);}
        break;
      case RPAREN:
      case COMMA:
        label_57:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[384] = jj_gen;
            break label_57;
          }
          jj_consume_token(COMMA);
          AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        }
        jj_consume_token(RPAREN);
                {if (true) return SqlLibraryOperators.TRANSLATE3.createCall(s.end(this),
                    args);}
        break;
      default:
        jj_la1[385] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case OVERLAY:
      jj_consume_token(OVERLAY);
                    s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(PLACING);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(FROM);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        break;
      default:
        jj_la1[386] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.OVERLAY.createCall(s.end(this), args);}
      break;
    case FLOOR:
      jj_consume_token(FLOOR);
                  s = span();
      e = FloorCeilOptions(s, true);
            {if (true) return e;}
      break;
    case CEIL:
    case CEILING:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CEIL:
        jj_consume_token(CEIL);
        break;
      case CEILING:
        jj_consume_token(CEILING);
        break;
      default:
        jj_la1[387] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                s = span();
      e = FloorCeilOptions(s, false);
            {if (true) return e;}
      break;
    case SUBSTRING:
      jj_consume_token(SUBSTRING);
                      s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
        break;
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[388] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
      case COMMA:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FOR:
          jj_consume_token(FOR);
          break;
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[389] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        break;
      default:
        jj_la1[390] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.SUBSTRING.createCall(
                s.end(this), args);}
      break;
    case TRIM:
      jj_consume_token(TRIM);
            SqlLiteral flag = null;
            SqlNode trimChars = null;
            s = span();
      jj_consume_token(LPAREN);
      if (jj_2_101(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOTH:
        case LEADING:
        case TRAILING:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BOTH:
            jj_consume_token(BOTH);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.BOTH.symbol(getPos());
            break;
          case TRAILING:
            jj_consume_token(TRAILING);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.TRAILING.symbol(getPos());
            break;
          case LEADING:
            jj_consume_token(LEADING);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.LEADING.symbol(getPos());
            break;
          default:
            jj_la1[391] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[392] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ARRAY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CASE:
        case CAST:
        case CATALOG:
        case CATALOG_NAME:
        case CEIL:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASSIFIER:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CONVERT:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT:
        case CURRENT_CATALOG:
        case CURRENT_DATE:
        case CURRENT_DEFAULT_TRANSFORM_GROUP:
        case CURRENT_PATH:
        case CURRENT_ROLE:
        case CURRENT_SCHEMA:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURRENT_USER:
        case CURSOR:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATE:
        case DATE_DIFF:
        case DATE_TRUNC:
        case DATETIME:
        case DATETIME_DIFF:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DATETIME_TRUNC:
        case DAYOFWEEK:
        case DAYOFYEAR:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOT_FORMAT:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXISTS:
        case EXP:
        case EXTERNAL:
        case EXTRACT:
        case FALSE:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case ILIKE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDE:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INTERVAL:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case JSON_ARRAY:
        case JSON_ARRAYAGG:
        case JSON_EXISTS:
        case JSON_OBJECT:
        case JSON_OBJECTAGG:
        case JSON_QUERY:
        case JSON_VALUE:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MATCH_NUMBER:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MULTISET:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NEW:
        case NEXT:
        case NORMALIZED:
        case NOT:
        case NTH_VALUE:
        case NTILE:
        case NULL:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERLAY:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENTILE_CONT:
        case PERCENTILE_DISC:
        case PERCENT_RANK:
        case PERIOD:
        case PIVOT:
        case PLACING:
        case PLAN:
        case PLI:
        case POSITION:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PREV:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case QUARTERS:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case RLIKE:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW:
        case ROW_COUNT:
        case ROW_NUMBER:
        case RUNNING:
        case SAFE_CAST:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEPARATOR:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SESSION_USER:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STATEMENT:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case SYSTEM_USER:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIME:
        case TIME_DIFF:
        case TIME_TRUNC:
        case TIMESTAMP:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TIMESTAMP_DIFF:
        case TIMESTAMP_TRUNC:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRANSLATE:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRIM:
        case TRUE:
        case TRUNCATE:
        case TRY_CAST:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNIQUE:
        case UNKNOWN:
        case UNPIVOT:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WEEKS:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case ANALYZE:
        case CONNECTOR:
        case JOB:
        case JOBS:
        case MAPPING:
        case MAPPINGS:
        case RESOURCES:
        case RESUME:
        case SHARED:
        case SINK:
        case SNAPSHOT:
        case SUSPEND:
        case TYPES:
        case VIEWS:
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
        case BINARY_STRING_LITERAL:
        case QUOTED_STRING:
        case PREFIXED_STRING_LITERAL:
        case UNICODE_STRING_LITERAL:
        case C_STYLE_ESCAPED_STRING_LITERAL:
        case BIG_QUERY_DOUBLE_QUOTED_STRING:
        case BIG_QUERY_QUOTED_STRING:
        case LPAREN:
        case LBRACE_D:
        case LBRACE_T:
        case LBRACE_TS:
        case LBRACE_FN:
        case HOOK:
        case PLUS:
        case MINUS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          trimChars = Expression(ExprContext.ACCEPT_SUB_QUERY);
          break;
        default:
          jj_la1[393] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          jj_consume_token(FROM);
                    if (null == flag && null == trimChars) {
                        {if (true) throw SqlUtil.newContextException(getPos(),
                            RESOURCE.illegalFromEmpty());}
                    }
          break;
        case RPAREN:
          jj_consume_token(RPAREN);
                    // This is to handle the case of TRIM(x)
                    // (FRG-191).
                    if (flag == null) {
                        flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
                    }
                    args.add(flag);
                    args.add(null); // no trim chars
                    args.add(trimChars); // reinterpret trimChars as source
                    {if (true) return SqlStdOperatorTable.TRIM.createCall(s.end(this),
                        args);}
          break;
        default:
          jj_la1[394] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            if (flag == null) {
                flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
            }
            args.add(flag);
            args.add(trimChars);
            args.add(e);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.TRIM.createCall(s.end(this), args);}
      break;
    case DATE:
    case DATETIME:
    case TIME:
    case TIMESTAMP:
      node = DateTimeConstructorCall();
                                           {if (true) return node;}
      break;
    case DATE_DIFF:
      node = DateDiffFunctionCall();
                                        {if (true) return node;}
      break;
    case DATE_TRUNC:
      node = DateTruncFunctionCall();
                                         {if (true) return node;}
      break;
    case DATETIME_TRUNC:
      node = DatetimeTruncFunctionCall();
                                             {if (true) return node;}
      break;
    case TIMESTAMPADD:
      node = TimestampAddFunctionCall();
                                            {if (true) return node;}
      break;
    case DATETIME_DIFF:
      node = DatetimeDiffFunctionCall();
                                            {if (true) return node;}
      break;
    case TIMESTAMPDIFF:
      node = TimestampDiffFunctionCall();
                                             {if (true) return node;}
      break;
    case TIMESTAMP_DIFF:
      node = TimestampDiff3FunctionCall();
                                              {if (true) return node;}
      break;
    case TIMESTAMP_TRUNC:
      node = TimestampTruncFunctionCall();
                                              {if (true) return node;}
      break;
    case TIME_DIFF:
      node = TimeDiffFunctionCall();
                                        {if (true) return node;}
      break;
    case TIME_TRUNC:
      node = TimeTruncFunctionCall();
                                         {if (true) return node;}
      break;
    case CLASSIFIER:
    case FINAL:
    case FIRST:
    case LAST:
    case MATCH_NUMBER:
    case NEXT:
    case PREV:
    case RUNNING:
      node = MatchRecognizeFunctionCall();
                                              {if (true) return node;}
      break;
    case JSON_EXISTS:
      node = JsonExistsFunctionCall();
                                          {if (true) return node;}
      break;
    case JSON_VALUE:
      node = JsonValueFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_QUERY:
      node = JsonQueryFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_OBJECT:
      node = JsonObjectFunctionCall();
                                          {if (true) return node;}
      break;
    case JSON_OBJECTAGG:
      node = JsonObjectAggFunctionCall();
                                             {if (true) return node;}
      break;
    case JSON_ARRAY:
      node = JsonArrayFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_ARRAYAGG:
      node = JsonArrayAggFunctionCall();
                                            {if (true) return node;}
      break;
    case HOP:
    case SESSION:
    case TUMBLE:
      node = GroupByWindowingCall();
                                        {if (true) return node;}
      break;
    default:
      jj_la1[395] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlJsonEncoding JsonRepresentation() throws ParseException {
    jj_consume_token(JSON);
    if (jj_2_102(2)) {
      jj_consume_token(ENCODING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UTF8:
        jj_consume_token(UTF8);
                     {if (true) return SqlJsonEncoding.UTF8;}
        break;
      case UTF16:
        jj_consume_token(UTF16);
                      {if (true) return SqlJsonEncoding.UTF16;}
        break;
      case UTF32:
        jj_consume_token(UTF32);
                      {if (true) return SqlJsonEncoding.UTF32;}
        break;
      default:
        jj_la1[396] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
        {if (true) return SqlJsonEncoding.UTF8;}
    throw new Error("Missing return statement in function");
  }

  final public void JsonInputClause() throws ParseException {
    jj_consume_token(FORMAT);
    JsonRepresentation();
  }

  final public SqlDataTypeSpec JsonReturningClause() throws ParseException {
    SqlDataTypeSpec dt;
    jj_consume_token(RETURNING);
    dt = DataType();
                                  {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public SqlDataTypeSpec JsonOutputClause() throws ParseException {
    SqlDataTypeSpec dataType;
    dataType = JsonReturningClause();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FORMAT:
      jj_consume_token(FORMAT);
      JsonRepresentation();
      break;
    default:
      jj_la1[397] = jj_gen;
      ;
    }
        {if (true) return dataType;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonPathSpec() throws ParseException {
    SqlNode e;
    e = StringLiteral();
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonApiCommonSyntax() throws ParseException {
    SqlNode e;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
      e = Expression(ExprContext.ACCEPT_NON_QUERY);

      jj_consume_token(AS);
      e = SimpleIdentifier();

      label_58:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[398] = jj_gen;
          break label_58;
        }
        jj_consume_token(COMMA);
        e = Expression(ExprContext.ACCEPT_NON_QUERY);

        jj_consume_token(AS);
        e = SimpleIdentifier();

      }
      break;
    default:
      jj_la1[399] = jj_gen;
      ;
    }
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public SqlJsonExistsErrorBehavior JsonExistsErrorBehavior() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             {if (true) return SqlJsonExistsErrorBehavior.TRUE;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
              {if (true) return SqlJsonExistsErrorBehavior.FALSE;}
      break;
    case UNKNOWN:
      jj_consume_token(UNKNOWN);
                {if (true) return SqlJsonExistsErrorBehavior.UNKNOWN;}
      break;
    case ERROR:
      jj_consume_token(ERROR);
              {if (true) return SqlJsonExistsErrorBehavior.ERROR;}
      break;
    default:
      jj_la1[400] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonExistsFunctionCall() throws ParseException {
    List<SqlNode> args = new ArrayList<SqlNode>();
    List<SqlNode> commonSyntax;
    final Span span;
    SqlJsonExistsErrorBehavior errorBehavior;
    jj_consume_token(JSON_EXISTS);
                    span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args.addAll(commonSyntax);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
    case FALSE:
    case TRUE:
    case UNKNOWN:
      errorBehavior = JsonExistsErrorBehavior();
                                                    args.add(errorBehavior.symbol(getPos()));
      jj_consume_token(ON);
      jj_consume_token(ERROR);
      break;
    default:
      jj_la1[401] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_EXISTS.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonValueEmptyOrErrorBehavior() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlJsonValueEmptyOrErrorBehavior.ERROR.symbol(getPos()));
      break;
    case NULL:
      jj_consume_token(NULL);
            list.add(SqlJsonValueEmptyOrErrorBehavior.NULL.symbol(getPos()));
      break;
    case DEFAULT_:
      jj_consume_token(DEFAULT_);
            list.add(SqlJsonValueEmptyOrErrorBehavior.DEFAULT.symbol(getPos()));
      AddExpression(list, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[402] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMPTY:
      jj_consume_token(EMPTY);
            list.add(SqlJsonEmptyOrError.EMPTY.symbol(getPos()));
      break;
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlJsonEmptyOrError.ERROR.symbol(getPos()));
      break;
    default:
      jj_la1[403] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonValueFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>(7);
    SqlNode e;
    List<SqlNode> commonSyntax;
    final Span span;
    List<SqlNode> behavior;
    jj_consume_token(JSON_VALUE);
                   span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args.addAll(commonSyntax);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNING:
      e = JsonReturningClause();
            args.add(SqlJsonValueReturning.RETURNING.symbol(getPos()));
            args.add(e);
      break;
    default:
      jj_la1[404] = jj_gen;
      ;
    }
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_:
      case ERROR:
      case NULL:
        ;
        break;
      default:
        jj_la1[405] = jj_gen;
        break label_59;
      }
      behavior = JsonValueEmptyOrErrorBehavior();
            args.addAll(behavior);
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_VALUE.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonQueryEmptyOrErrorBehavior() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.ERROR, getPos()));
      break;
    case NULL:
      jj_consume_token(NULL);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, getPos()));
      break;
    default:
      jj_la1[406] = jj_gen;
      if (jj_2_103(2)) {
        jj_consume_token(EMPTY);
        jj_consume_token(ARRAY);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, getPos()));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EMPTY:
          jj_consume_token(EMPTY);
          jj_consume_token(OBJECT);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, getPos()));
          break;
        default:
          jj_la1[407] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(ON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMPTY:
      jj_consume_token(EMPTY);
            list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.EMPTY, getPos()));
      break;
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.ERROR, getPos()));
      break;
    default:
      jj_la1[408] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonQueryWrapperBehavior() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHOUT:
      jj_consume_token(WITHOUT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
        jj_consume_token(ARRAY);
        break;
      default:
        jj_la1[409] = jj_gen;
        ;
      }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, getPos());}
      break;
    default:
      jj_la1[413] = jj_gen;
      if (jj_2_104(2)) {
        jj_consume_token(WITH);
        jj_consume_token(CONDITIONAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ARRAY:
          jj_consume_token(ARRAY);
          break;
        default:
          jj_la1[410] = jj_gen;
          ;
        }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, getPos());}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UNCONDITIONAL:
            jj_consume_token(UNCONDITIONAL);
            break;
          default:
            jj_la1[411] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ARRAY:
            jj_consume_token(ARRAY);
            break;
          default:
            jj_la1[412] = jj_gen;
            ;
          }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, getPos());}
          break;
        default:
          jj_la1[414] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonQueryFunctionCall() throws ParseException {
    final SqlNode[] args = new SqlNode[5];
    SqlNode e;
    List<SqlNode> commonSyntax;
    final Span span;
    List<SqlNode> behavior;
    jj_consume_token(JSON_QUERY);
                   span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args[0] = commonSyntax.get(0);
        args[1] = commonSyntax.get(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
    case WITHOUT:
      e = JsonQueryWrapperBehavior();
      jj_consume_token(WRAPPER);
            args[2] = e;
      break;
    default:
      jj_la1[415] = jj_gen;
      ;
    }
    label_60:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EMPTY:
      case ERROR:
      case NULL:
        ;
        break;
      default:
        jj_la1[416] = jj_gen;
        break label_60;
      }
      behavior = JsonQueryEmptyOrErrorBehavior();
            final SqlJsonEmptyOrError symbol =
                ((SqlLiteral) behavior.get(1)).getValueAs(SqlJsonEmptyOrError.class);
            switch (symbol) {
            case EMPTY:
                args[3] = behavior.get(0);
                break;
            case ERROR:
                args[4] = behavior.get(0);
                break;
            }
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_QUERY.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonName() throws ParseException {
    final SqlNode e;
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonNameAndValue() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final SqlNode e;
    boolean kvMode = false;
    if (jj_2_105(2)) {
      jj_consume_token(KEY);
                kvMode = true;
    } else {
      ;
    }
    e = JsonName();
        list.add(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUE:
      jj_consume_token(VALUE);
      break;
    case COLON:
      jj_consume_token(COLON);
            if (kvMode) {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.illegalColon());}
            }
      break;
    default:
      jj_la1[417] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    AddExpression(list, ExprContext.ACCEPT_NON_QUERY);
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonConstructorNullClause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
      jj_consume_token(ON);
      jj_consume_token(NULL);
        {if (true) return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.NULL_ON_NULL, getPos());}
      break;
    case ABSENT:
      jj_consume_token(ABSENT);
      jj_consume_token(ON);
      jj_consume_token(NULL);
        {if (true) return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.ABSENT_ON_NULL, getPos());}
      break;
    default:
      jj_la1[418] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonObjectFunctionCall() throws ParseException {
    final List<SqlNode> nvArgs = new ArrayList<SqlNode>();
    final SqlNode[] otherArgs = new SqlNode[1];
    SqlNode e;
    List<SqlNode> list;
    final Span span;
    jj_consume_token(JSON_OBJECT);
                    span = span();
    jj_consume_token(LPAREN);
    if (jj_2_106(2)) {
      list = JsonNameAndValue();
            nvArgs.addAll(list);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[419] = jj_gen;
          break label_61;
        }
        jj_consume_token(COMMA);
        list = JsonNameAndValue();
                nvArgs.addAll(list);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            otherArgs[0] = e;
      break;
    default:
      jj_la1[420] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        final List<SqlNode> args = new ArrayList();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(nvArgs);
        {if (true) return SqlStdOperatorTable.JSON_OBJECT.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonObjectAggFunctionCall() throws ParseException {
    final SqlNode[] args = new SqlNode[2];
    List<SqlNode> list;
    final Span span;
    SqlJsonConstructorNullClause nullClause =
        SqlJsonConstructorNullClause.NULL_ON_NULL;
    final SqlNode e;
    jj_consume_token(JSON_OBJECTAGG);
                       span = span();
    jj_consume_token(LPAREN);
    list = JsonNameAndValue();
        args[0] = list.get(0);
        args[1] = list.get(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            nullClause = (SqlJsonConstructorNullClause) ((SqlLiteral) e).getValue();
      break;
    default:
      jj_la1[421] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_OBJECTAGG.with(nullClause)
            .createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonArrayFunctionCall() throws ParseException {
    final List<SqlNode> elements = new ArrayList<SqlNode>();
    final SqlNode[] otherArgs = new SqlNode[1];
    SqlNode e;
    final Span span;
    jj_consume_token(JSON_ARRAY);
                   span = span();
    jj_consume_token(LPAREN);
    if (jj_2_107(2)) {
      AddExpression(elements, ExprContext.ACCEPT_NON_QUERY);
      label_62:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[422] = jj_gen;
          break label_62;
        }
        jj_consume_token(COMMA);
        AddExpression(elements, ExprContext.ACCEPT_NON_QUERY);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            otherArgs[0] = e;
      break;
    default:
      jj_la1[423] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        final List<SqlNode> args = new ArrayList();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(elements);
        {if (true) return SqlStdOperatorTable.JSON_ARRAY.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList JsonArrayAggOrderByClause() throws ParseException {
    final SqlNodeList orderList;
    orderList = OrderBy(true);
      {if (true) return orderList;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonArrayAggFunctionCall() throws ParseException {
    final SqlNode valueExpr;
    final SqlNodeList orderList;
    final Span span;
    final SqlJsonConstructorNullClause nullClause;
    SqlNode e;
    final SqlNode aggCall;
    jj_consume_token(JSON_ARRAYAGG);
                      span = span();
    jj_consume_token(LPAREN);
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        valueExpr = e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = JsonArrayAggOrderByClause();
      break;
    default:
      jj_la1[424] = jj_gen;
                                                  orderList = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            nullClause = (SqlJsonConstructorNullClause) ((SqlLiteral) e).getValue();
      break;
    default:
      jj_la1[425] = jj_gen;
          nullClause = SqlJsonConstructorNullClause.ABSENT_ON_NULL;
    }
    jj_consume_token(RPAREN);
        aggCall = SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
            .createCall(span.end(this), valueExpr, orderList);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      e = withinGroup(aggCall);
            if (orderList != null) {
                {if (true) throw SqlUtil.newContextException(span.pos().plus(e.getParserPosition()),
                    RESOURCE.ambiguousSortOrderInJsonArrayAggFunc());}
            }
            {if (true) return (SqlCall) e;}
      break;
    default:
      jj_la1[426] = jj_gen;
      ;
    }
        if (orderList == null) {
            {if (true) return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
                .createCall(span.end(this), valueExpr);}
        }
        {if (true) return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
            .createCall(span.end(this), valueExpr, orderList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to BigQuery's DATE_DIFF.
 */
  final public SqlCall DateDiffFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(DATE_DIFF);
                  s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.DATE_DIFF.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIMESTAMPADD.
 */
  final public SqlCall TimestampAddFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(TIMESTAMPADD);
                     s = span();
    jj_consume_token(LPAREN);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.TIMESTAMP_ADD.createCall(
            s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIMESTAMPDIFF.
 */
  final public SqlCall TimestampDiffFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(TIMESTAMPDIFF);
                      s = span();
    jj_consume_token(LPAREN);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(
            s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to BigQuery's TIMESTAMP_DIFF.
 *
 * <p>The difference between TIMESTAMPDIFF and TIMESTAMP_DIFF is the ordering of
 * the parameters and the arrangement of the subtraction.
 * TIMESTAMPDIFF uses (unit, timestamp1, timestamp2) with (t2 - t1), while
 * TIMESTAMP_DIFF uses (timestamp1, timestamp2, unit) with (t1 - t2).
 */
  final public SqlCall TimestampDiff3FunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(TIMESTAMP_DIFF);
                       s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.TIMESTAMP_DIFF3.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses BigQuery's built-in DATETIME_DIFF() function.
 */
  final public SqlCall DatetimeDiffFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(DATETIME_DIFF);
                      s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.DATETIME_DIFF.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to DATE_TRUNC.
 */
  final public SqlCall DateTruncFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(DATE_TRUNC);
                   s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    if (jj_2_108(2)) {
      unit = TimeUnit();
                            args.add(unit);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTERNAL:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SAFE_CAST:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TRY_CAST:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case C_STYLE_ESCAPED_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        break;
      default:
        jj_la1[427] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.DATE_TRUNC.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIMESTAMP_TRUNC.
 */
  final public SqlCall TimestampTruncFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(TIMESTAMP_TRUNC);
                        s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.TIMESTAMP_TRUNC.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to BigQuery's TIME_DIFF.
 */
  final public SqlCall TimeDiffFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(TIME_DIFF);
                  s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.TIME_DIFF.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to DATETIME_TRUNC.
 */
  final public SqlNode DatetimeTruncFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    final SqlNode literal;
    jj_consume_token(DATETIME_TRUNC);
                       s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.DATETIME_TRUNC.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIME_TRUNC.
 */
  final public SqlCall TimeTruncFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final SqlIntervalQualifier unit;
    jj_consume_token(TIME_TRUNC);
                   s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    unit = TimeUnitOrName();
                              args.add(unit);
    jj_consume_token(RPAREN);
        {if (true) return SqlLibraryOperators.TIME_TRUNC.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a grouping function inside the GROUP BY clause,
 * for example {@code TUMBLE(rowtime, INTERVAL '1' MINUTE)}.
 */
  final public SqlCall GroupByWindowingCall() throws ParseException {
    final Span s;
    final List<SqlNode> args;
    final SqlOperator op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TUMBLE:
      jj_consume_token(TUMBLE);
                   op = SqlStdOperatorTable.TUMBLE_OLD;
      break;
    case HOP:
      jj_consume_token(HOP);
                op = SqlStdOperatorTable.HOP_OLD;
      break;
    case SESSION:
      jj_consume_token(SESSION);
                    op = SqlStdOperatorTable.SESSION_OLD;
      break;
    default:
      jj_la1[428] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    args = UnquantifiedFunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return op.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeFunctionCall() throws ParseException {
    final SqlCall func;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASSIFIER:
      jj_consume_token(CLASSIFIER);
                       s = span();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            func = SqlStdOperatorTable.CLASSIFIER.createCall(s.end(this));
      break;
    case MATCH_NUMBER:
      jj_consume_token(MATCH_NUMBER);
                         s = span();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            func = SqlStdOperatorTable.MATCH_NUMBER.createCall(s.end(this));
      break;
    default:
      jj_la1[429] = jj_gen;
      if (jj_2_109(3)) {
        func = MatchRecognizeNavigationLogical();
      } else if (jj_2_110(2)) {
        func = MatchRecognizeNavigationPhysical();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FINAL:
        case RUNNING:
          func = MatchRecognizeCallWithModifier();
          break;
        default:
          jj_la1[430] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
      {if (true) return func;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeCallWithModifier() throws ParseException {
    final Span s;
    final SqlOperator runningOp;
    final SqlNode func;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RUNNING:
      jj_consume_token(RUNNING);
                    runningOp = SqlStdOperatorTable.RUNNING;
      break;
    case FINAL:
      jj_consume_token(FINAL);
                  runningOp = SqlStdOperatorTable.FINAL;
      break;
    default:
      jj_la1[431] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    func = NamedFunctionCall();
        {if (true) return runningOp.createCall(s.end(func), func);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeNavigationLogical() throws ParseException {
    final Span s = Span.of();
    SqlCall func;
    final SqlOperator funcOp;
    final SqlOperator runningOp;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RUNNING:
      jj_consume_token(RUNNING);
                    runningOp = SqlStdOperatorTable.RUNNING; s.add(this);
      break;
    case FINAL:
      jj_consume_token(FINAL);
                  runningOp = SqlStdOperatorTable.FINAL; s.add(this);
      break;
    default:
      jj_la1[432] = jj_gen;
          runningOp = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
                  funcOp = SqlStdOperatorTable.FIRST;
      break;
    case LAST:
      jj_consume_token(LAST);
                 funcOp = SqlStdOperatorTable.LAST;
      break;
    default:
      jj_la1[433] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s.add(this);
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      e = NumericLiteral();
                                       args.add(e);
      break;
    default:
      jj_la1[434] = jj_gen;
          args.add(LITERAL_ZERO);
    }
    jj_consume_token(RPAREN);
        func = funcOp.createCall(s.end(this), args);
        if (runningOp != null) {
            {if (true) return runningOp.createCall(s.end(this), func);}
        } else {
            {if (true) return func;}
        }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeNavigationPhysical() throws ParseException {
    final Span s;
    final SqlOperator funcOp;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PREV:
      jj_consume_token(PREV);
                 funcOp = SqlStdOperatorTable.PREV;
      break;
    case NEXT:
      jj_consume_token(NEXT);
                 funcOp = SqlStdOperatorTable.NEXT;
      break;
    default:
      jj_la1[435] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      e = NumericLiteral();
                                       args.add(e);
      break;
    default:
      jj_la1[436] = jj_gen;
          args.add(LITERAL_ONE);
    }
    jj_consume_token(RPAREN);
        {if (true) return funcOp.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall withinDistinct(SqlNode arg) throws ParseException {
    final Span s;
    final SqlNodeList distinctList;
    jj_consume_token(WITHIN);
               s = span();
    jj_consume_token(DISTINCT);
    jj_consume_token(LPAREN);
    distinctList = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.WITHIN_DISTINCT.createCall(
            s.end(this), arg, distinctList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall withinGroup(SqlNode arg) throws ParseException {
    final Span s;
    final SqlNodeList orderList;
    jj_consume_token(WITHIN);
               s = span();
    jj_consume_token(GROUP);
    jj_consume_token(LPAREN);
    orderList = OrderBy(true);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.WITHIN_GROUP.createCall(
            s.end(this), arg, orderList);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<SqlParserPos, SqlOperator> NullTreatment() throws ParseException {
    final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IGNORE:
      jj_consume_token(IGNORE);
               span = span();
      jj_consume_token(NULLS);
        {if (true) return Pair.of(span.end(this), SqlStdOperatorTable.IGNORE_NULLS);}
      break;
    case RESPECT:
      jj_consume_token(RESPECT);
                span = span();
      jj_consume_token(NULLS);
        {if (true) return Pair.of(span.end(this), SqlStdOperatorTable.RESPECT_NULLS);}
      break;
    default:
      jj_la1[437] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall nullTreatment(SqlCall arg) throws ParseException {
    final Pair<SqlParserPos, SqlOperator> pair;
    pair = NullTreatment();
                             {if (true) return pair.right.createCall(pair.left, arg);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a named function (could be a builtin with regular
 * syntax, or else a UDF).
 *
 * <p>NOTE: every UDF has two names: an <em>invocation name</em> and a
 * <em>specific name</em>.  Normally, function calls are resolved via overload
 * resolution and invocation names.  The SPECIFIC prefix allows overload
 * resolution to be bypassed.  Note that usage of the SPECIFIC prefix in
 * queries is non-standard; it is used internally by Farrago, e.g. in stored
 * view definitions to permanently bind references to a particular function
 * after the overload resolution performed by view creation.
 *
 * <p>TODO jvs 25-Mar-2005:  Once we have SQL-Flagger support, flag SPECIFIC
 * as non-standard.
 */
  final public SqlNode NamedFunctionCall() throws ParseException {
    SqlCall call;
    final Span filterSpan;
    final SqlNode filter;
    final Span overSpan;
    final SqlNode over;
    if (jj_2_111(2)) {
      call = StringAggFunctionCall();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
        call = PercentileFunctionCall();
        break;
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT_DATE:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXP:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NTH_VALUE:
      case NTILE:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENT_RANK:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case ROW_NUMBER:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUM:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        call = NamedCall();
        break;
      default:
        jj_la1[438] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_112(2)) {
      call = nullTreatment(call);
    } else {
      ;
    }
    if (jj_2_113(2)) {
      // decide between WITHIN DISTINCT and WITHIN GROUP
              call = withinDistinct(call);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      call = withinGroup(call);
      break;
    default:
      jj_la1[439] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FILTER:
      jj_consume_token(FILTER);
                   filterSpan = span();
      jj_consume_token(LPAREN);
      jj_consume_token(WHERE);
      filter = Expression(ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(RPAREN);
            call = SqlStdOperatorTable.FILTER.createCall(
                filterSpan.end(this), call, filter);
      break;
    default:
      jj_la1[440] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVER:
      jj_consume_token(OVER);
                 overSpan = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        over = SimpleIdentifier();
        break;
      case LPAREN:
        over = WindowSpecification();
        break;
      default:
        jj_la1[441] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            call = SqlStdOperatorTable.OVER.createCall(overSpan.end(over), call, over);
      break;
    default:
      jj_la1[442] = jj_gen;
      ;
    }
        {if (true) return call;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall NamedCall() throws ParseException {
    final SqlFunctionCategory funcType;
    final SqlIdentifier qualifiedName;
    final Span s;
    final List<SqlNode> args;
    SqlLiteral quantifier = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPECIFIC:
      jj_consume_token(SPECIFIC);
            funcType = SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION;
      break;
    default:
      jj_la1[443] = jj_gen;
          funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
    }
    qualifiedName = FunctionName();
        s = span();
    if (jj_2_114(2)) {
      jj_consume_token(LPAREN);
      jj_consume_token(STAR);
            args = ImmutableList.of(SqlIdentifier.star(getPos()));
      jj_consume_token(RPAREN);
    } else if (jj_2_115(2)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            args = ImmutableList.of();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        args = FunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
            quantifier = (SqlLiteral) args.get(0);
            args.remove(0);
        break;
      default:
        jj_la1[444] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return createCall(qualifiedName, s.end(this), funcType, quantifier, args);}
    throw new Error("Missing return statement in function");
  }

/*
* Parse Floor/Ceil function parameters
*/
  final public SqlNode StandardFloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
    SqlNode e;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final SqlIntervalQualifier unit;
    SqlCall function;
    final Span s1;
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TO:
      jj_consume_token(TO);
      unit = TimeUnitOrName();
            args.add(unit);
      break;
    default:
      jj_la1[445] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        SqlOperator op = SqlStdOperatorTable.floorCeil(floorFlag, this.conformance);
        function =  op.createCall(s.end(this), args);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVER:
      jj_consume_token(OVER);
                 s1 = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE_DIFF:
      case DATE_TRUNC:
      case DATETIME_DIFF:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DATETIME_TRUNC:
      case DAYOFWEEK:
      case DAYOFYEAR:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOT_FORMAT:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXTERNAL:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case ILIKE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDE:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PIVOT:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case QUARTERS:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RLIKE:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEPARATOR:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STATEMENT:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME_DIFF:
      case TIME_TRUNC:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TIMESTAMP_DIFF:
      case TIMESTAMP_TRUNC:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNPIVOT:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WEEKS:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case ANALYZE:
      case CONNECTOR:
      case JOB:
      case JOBS:
      case MAPPING:
      case MAPPINGS:
      case RESOURCES:
      case RESUME:
      case SHARED:
      case SINK:
      case SNAPSHOT:
      case SUSPEND:
      case TYPES:
      case VIEWS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = SimpleIdentifier();
        break;
      case LPAREN:
        e = WindowSpecification();
        break;
      default:
        jj_la1[446] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return SqlStdOperatorTable.OVER.createCall(s1.end(this), function, e);}
      break;
    default:
      jj_la1[447] = jj_gen;
          {if (true) return function;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the name of a JDBC function that is a token but is not reserved.
 */
  final public String NonReservedJdbcFunctionName() throws ParseException {
    jj_consume_token(SUBSTRING);
        {if (true) return unquotedIdentifier();}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the name of a function (either a compound identifier or
 * a reserved word which can be used as a function name).
 */
  final public SqlIdentifier FunctionName() throws ParseException {
    SqlIdentifier qualifiedName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE_DIFF:
    case DATE_TRUNC:
    case DATETIME_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DATETIME_TRUNC:
    case DAYOFWEEK:
    case DAYOFYEAR:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOT_FORMAT:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXTERNAL:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case ILIKE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDE:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PIVOT:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case QUARTERS:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RLIKE:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEPARATOR:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STATEMENT:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME_DIFF:
    case TIME_TRUNC:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TIMESTAMP_DIFF:
    case TIMESTAMP_TRUNC:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNPIVOT:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WEEKS:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case ANALYZE:
    case CONNECTOR:
    case JOB:
    case JOBS:
    case MAPPING:
    case MAPPINGS:
    case RESOURCES:
    case RESUME:
    case SHARED:
    case SINK:
    case SNAPSHOT:
    case SUSPEND:
    case TYPES:
    case VIEWS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      qualifiedName = CompoundIdentifier();
      break;
    case ABS:
    case AVG:
    case CARDINALITY:
    case CEILING:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case COALESCE:
    case COLLECT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT_DATE:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case DENSE_RANK:
    case ELEMENT:
    case EVERY:
    case EXP:
    case FIRST_VALUE:
    case FLOOR:
    case FUSION:
    case GROUPING:
    case HOUR:
    case INTERSECTION:
    case LAG:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOWER:
    case MAX:
    case MIN:
    case MINUTE:
    case MOD:
    case MONTH:
    case NTH_VALUE:
    case NTILE:
    case NULLIF:
    case OCTET_LENGTH:
    case PERCENT_RANK:
    case POWER:
    case RANK:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RIGHT:
    case ROW_NUMBER:
    case SECOND:
    case SOME:
    case SQRT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case SUM:
    case TRUNCATE:
    case UPPER:
    case USER:
    case VAR_POP:
    case VAR_SAMP:
    case YEAR:
      qualifiedName = ReservedFunctionName();
      break;
    default:
      jj_la1[448] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return qualifiedName;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a reserved word which is used as the name of a function.
 */
  final public SqlIdentifier ReservedFunctionName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABS:
      jj_consume_token(ABS);
      break;
    case AVG:
      jj_consume_token(AVG);
      break;
    case CARDINALITY:
      jj_consume_token(CARDINALITY);
      break;
    case CEILING:
      jj_consume_token(CEILING);
      break;
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case CHAR_LENGTH:
      jj_consume_token(CHAR_LENGTH);
      break;
    case CHARACTER_LENGTH:
      jj_consume_token(CHARACTER_LENGTH);
      break;
    case COALESCE:
      jj_consume_token(COALESCE);
      break;
    case COLLECT:
      jj_consume_token(COLLECT);
      break;
    case COVAR_POP:
      jj_consume_token(COVAR_POP);
      break;
    case COVAR_SAMP:
      jj_consume_token(COVAR_SAMP);
      break;
    case CUME_DIST:
      jj_consume_token(CUME_DIST);
      break;
    case COUNT:
      jj_consume_token(COUNT);
      break;
    case CURRENT_DATE:
      jj_consume_token(CURRENT_DATE);
      break;
    case CURRENT_TIME:
      jj_consume_token(CURRENT_TIME);
      break;
    case CURRENT_TIMESTAMP:
      jj_consume_token(CURRENT_TIMESTAMP);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    case ELEMENT:
      jj_consume_token(ELEMENT);
      break;
    case EVERY:
      jj_consume_token(EVERY);
      break;
    case EXP:
      jj_consume_token(EXP);
      break;
    case FIRST_VALUE:
      jj_consume_token(FIRST_VALUE);
      break;
    case FLOOR:
      jj_consume_token(FLOOR);
      break;
    case FUSION:
      jj_consume_token(FUSION);
      break;
    case INTERSECTION:
      jj_consume_token(INTERSECTION);
      break;
    case GROUPING:
      jj_consume_token(GROUPING);
      break;
    case HOUR:
      jj_consume_token(HOUR);
      break;
    case LAG:
      jj_consume_token(LAG);
      break;
    case LEAD:
      jj_consume_token(LEAD);
      break;
    case LEFT:
      jj_consume_token(LEFT);
      break;
    case LAST_VALUE:
      jj_consume_token(LAST_VALUE);
      break;
    case LN:
      jj_consume_token(LN);
      break;
    case LOCALTIME:
      jj_consume_token(LOCALTIME);
      break;
    case LOCALTIMESTAMP:
      jj_consume_token(LOCALTIMESTAMP);
      break;
    case LOWER:
      jj_consume_token(LOWER);
      break;
    case MAX:
      jj_consume_token(MAX);
      break;
    case MIN:
      jj_consume_token(MIN);
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    case MONTH:
      jj_consume_token(MONTH);
      break;
    case NTH_VALUE:
      jj_consume_token(NTH_VALUE);
      break;
    case NTILE:
      jj_consume_token(NTILE);
      break;
    case NULLIF:
      jj_consume_token(NULLIF);
      break;
    case OCTET_LENGTH:
      jj_consume_token(OCTET_LENGTH);
      break;
    case PERCENT_RANK:
      jj_consume_token(PERCENT_RANK);
      break;
    case POWER:
      jj_consume_token(POWER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case REGR_COUNT:
      jj_consume_token(REGR_COUNT);
      break;
    case REGR_SXX:
      jj_consume_token(REGR_SXX);
      break;
    case REGR_SYY:
      jj_consume_token(REGR_SYY);
      break;
    case RIGHT:
      jj_consume_token(RIGHT);
      break;
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case SECOND:
      jj_consume_token(SECOND);
      break;
    case SOME:
      jj_consume_token(SOME);
      break;
    case SQRT:
      jj_consume_token(SQRT);
      break;
    case STDDEV_POP:
      jj_consume_token(STDDEV_POP);
      break;
    case STDDEV_SAMP:
      jj_consume_token(STDDEV_SAMP);
      break;
    case SUM:
      jj_consume_token(SUM);
      break;
    case UPPER:
      jj_consume_token(UPPER);
      break;
    case TRUNCATE:
      jj_consume_token(TRUNCATE);
      break;
    case USER:
      jj_consume_token(USER);
      break;
    case VAR_POP:
      jj_consume_token(VAR_POP);
      break;
    case VAR_SAMP:
      jj_consume_token(VAR_SAMP);
      break;
    case YEAR:
      jj_consume_token(YEAR);
      break;
    default:
      jj_la1[449] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIdentifier(unquotedIdentifier(), getPos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlIdentifier ContextVariable() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CURRENT_CATALOG:
      jj_consume_token(CURRENT_CATALOG);
      break;
    case CURRENT_DATE:
      jj_consume_token(CURRENT_DATE);
      break;
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
      jj_consume_token(CURRENT_DEFAULT_TRANSFORM_GROUP);
      break;
    case CURRENT_PATH:
      jj_consume_token(CURRENT_PATH);
      break;
    case CURRENT_ROLE:
      jj_consume_token(CURRENT_ROLE);
      break;
    case CURRENT_SCHEMA:
      jj_consume_token(CURRENT_SCHEMA);
      break;
    case CURRENT_TIME:
      jj_consume_token(CURRENT_TIME);
      break;
    case CURRENT_TIMESTAMP:
      jj_consume_token(CURRENT_TIMESTAMP);
      break;
    case CURRENT_USER:
      jj_consume_token(CURRENT_USER);
      break;
    case LOCALTIME:
      jj_consume_token(LOCALTIME);
      break;
    case LOCALTIMESTAMP:
      jj_consume_token(LOCALTIMESTAMP);
      break;
    case SESSION_USER:
      jj_consume_token(SESSION_USER);
      break;
    case SYSTEM_USER:
      jj_consume_token(SYSTEM_USER);
      break;
    case USER:
      jj_consume_token(USER);
      break;
    default:
      jj_la1[450] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIdentifier(unquotedIdentifier(), getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a function call expression with JDBC syntax.
 */
  final public SqlNode JdbcFunctionCall() throws ParseException {
    String name;
    SqlIdentifier id;
    SqlNode e;
    SqlLiteral tl;
    SqlNodeList args;
    SqlCall call;
    final Span s, s1;
    jj_consume_token(LBRACE_FN);
        s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE_DIFF:
      call = DateDiffFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    case DATETIME_DIFF:
      call = DatetimeDiffFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    case TIMESTAMPADD:
      call = TimestampAddFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    case DATE_TRUNC:
      call = DateTruncFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    case TIMESTAMP_TRUNC:
      call = TimestampTruncFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    case TIME_TRUNC:
      call = TimeTruncFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    case TIMESTAMP_DIFF:
      call = TimestampDiff3FunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    case TIME_DIFF:
      call = TimeDiffFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    default:
      jj_la1[454] = jj_gen;
      if (jj_2_118(3)) {
        call = TimestampDiffFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CONVERT:
          jj_consume_token(CONVERT);
                    name = unquotedIdentifier();
          jj_consume_token(LPAREN);
          e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args = new SqlNodeList(getPos());
            args.add(e);
          jj_consume_token(COMMA);
          tl = JdbcOdbcDataType();
                                  args.add(tl);
          jj_consume_token(RPAREN);
          break;
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CATALOG:
        case CATALOG_NAME:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT_DATE:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATE_DIFF:
        case DATE_TRUNC:
        case DATETIME_DIFF:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DATETIME_TRUNC:
        case DAYOFWEEK:
        case DAYOFYEAR:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOT_FORMAT:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXP:
        case EXTERNAL:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case ILIKE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDE:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSERT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NORMALIZED:
        case NTH_VALUE:
        case NTILE:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENTILE_CONT:
        case PERCENTILE_DISC:
        case PERCENT_RANK:
        case PIVOT:
        case PLACING:
        case PLAN:
        case PLI:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case QUARTERS:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case RLIKE:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW_COUNT:
        case ROW_NUMBER:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEPARATOR:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STATEMENT:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIME_DIFF:
        case TIME_TRUNC:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TIMESTAMP_DIFF:
        case TIMESTAMP_TRUNC:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRUNCATE:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNPIVOT:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WEEKS:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case ANALYZE:
        case CONNECTOR:
        case JOB:
        case JOBS:
        case MAPPING:
        case MAPPINGS:
        case RESOURCES:
        case RESUME:
        case SHARED:
        case SINK:
        case SNAPSHOT:
        case SUSPEND:
        case TYPES:
        case VIEWS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INSERT:
          case LEFT:
          case RIGHT:
          case TRUNCATE:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INSERT:
              jj_consume_token(INSERT);
              break;
            case LEFT:
              jj_consume_token(LEFT);
              break;
            case RIGHT:
              jj_consume_token(RIGHT);
              break;
            case TRUNCATE:
              jj_consume_token(TRUNCATE);
              break;
            default:
              jj_la1[451] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
                                                           name = unquotedIdentifier();
            break;
          case ABS:
          case AVG:
          case CARDINALITY:
          case CEILING:
          case CHAR:
          case CHAR_LENGTH:
          case CHARACTER_LENGTH:
          case COALESCE:
          case COLLECT:
          case COUNT:
          case COVAR_POP:
          case COVAR_SAMP:
          case CUME_DIST:
          case CURRENT_DATE:
          case CURRENT_TIME:
          case CURRENT_TIMESTAMP:
          case DENSE_RANK:
          case ELEMENT:
          case EVERY:
          case EXP:
          case FIRST_VALUE:
          case FLOOR:
          case FUSION:
          case GROUPING:
          case HOUR:
          case INTERSECTION:
          case LAG:
          case LAST_VALUE:
          case LEAD:
          case LN:
          case LOCALTIME:
          case LOCALTIMESTAMP:
          case LOWER:
          case MAX:
          case MIN:
          case MINUTE:
          case MOD:
          case MONTH:
          case NTH_VALUE:
          case NTILE:
          case NULLIF:
          case OCTET_LENGTH:
          case PERCENT_RANK:
          case POWER:
          case RANK:
          case REGR_COUNT:
          case REGR_SXX:
          case REGR_SYY:
          case ROW_NUMBER:
          case SECOND:
          case SOME:
          case SQRT:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case SUM:
          case UPPER:
          case USER:
          case VAR_POP:
          case VAR_SAMP:
          case YEAR:
            // For cases like {fn power(1,2)} and {fn lower('a')}
                        id = ReservedFunctionName();
                                          name = id.getSimple();
            break;
          case SUBSTRING:
            // For cases like {fn substring('foo', 1,2)}
                        name = NonReservedJdbcFunctionName();
            break;
          case A:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ARRAY_AGG:
          case ARRAY_CONCAT_AGG:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CASCADE:
          case CATALOG:
          case CATALOG_NAME:
          case CENTURY:
          case CHAIN:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASS_ORIGIN:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATE_DIFF:
          case DATE_TRUNC:
          case DATETIME_DIFF:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DATETIME_TRUNC:
          case DAYOFWEEK:
          case DAYOFYEAR:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOT_FORMAT:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case EXTERNAL:
          case FINAL:
          case FIRST:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case GROUP_CONCAT:
          case HIERARCHY:
          case HOP:
          case HOURS:
          case IGNORE:
          case ILIKE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDE:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAST:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LOCATOR:
          case M:
          case MAP:
          case MATCHED:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MINUTES:
          case MINVALUE:
          case MONTHS:
          case MORE_:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NORMALIZED:
          case NULLABLE:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PERCENTILE_CONT:
          case PERCENTILE_DISC:
          case PIVOT:
          case PLACING:
          case PLAN:
          case PLI:
          case PRECEDING:
          case PRESERVE:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case QUARTERS:
          case READ:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case RLIKE:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW_COUNT:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEPARATOR:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOURCE:
          case SPACE:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case STATE:
          case STATEMENT:
          case STRING_AGG:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIME_DIFF:
          case TIME_TRUNC:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TIMESTAMP_DIFF:
          case TIMESTAMP_TRUNC:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNPIVOT:
          case UNNAMED:
          case USAGE:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VERSION:
          case VIEW:
          case WEEK:
          case WEEKS:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEARS:
          case ZONE:
          case ANALYZE:
          case CONNECTOR:
          case JOB:
          case JOBS:
          case MAPPING:
          case MAPPINGS:
          case RESOURCES:
          case RESUME:
          case SHARED:
          case SINK:
          case SNAPSHOT:
          case SUSPEND:
          case TYPES:
          case VIEWS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            name = Identifier();
            break;
          default:
            jj_la1[452] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_116(2)) {
            jj_consume_token(LPAREN);
            jj_consume_token(STAR);
                                           s1 = span();
            jj_consume_token(RPAREN);
                args = new SqlNodeList(s1.pos());
                args.add(SqlIdentifier.star(s1.pos()));
          } else if (jj_2_117(2)) {
            jj_consume_token(LPAREN);
            jj_consume_token(RPAREN);
                                             args = SqlNodeList.EMPTY;
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LPAREN:
              args = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_SUB_QUERY);
              break;
            default:
              jj_la1[453] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
        default:
          jj_la1[455] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(RBRACE);
        {if (true) return new SqlJdbcFunctionCall(name).createCall(s.end(this),
            args.getList());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary query operator like UNION.
 */
  final public SqlBinaryOperator BinaryQueryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      jj_consume_token(UNION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.UNION_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.UNION;}
        break;
      default:
        jj_la1[456] = jj_gen;
              {if (true) return SqlStdOperatorTable.UNION;}
      }
      break;
    case INTERSECT:
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.INTERSECT_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.INTERSECT;}
        break;
      default:
        jj_la1[457] = jj_gen;
              {if (true) return SqlStdOperatorTable.INTERSECT;}
      }
      break;
    case EXCEPT:
    case SET_MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
        jj_consume_token(EXCEPT);
        break;
      case SET_MINUS:
        jj_consume_token(SET_MINUS);
                if (!this.conformance.isMinusAllowed()) {
                    {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.minusNotAllowed());}
                }
        break;
      default:
        jj_la1[458] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.EXCEPT_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.EXCEPT;}
        break;
      default:
        jj_la1[459] = jj_gen;
              {if (true) return SqlStdOperatorTable.EXCEPT;}
      }
      break;
    default:
      jj_la1[460] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary multiset operator.
 */
  final public SqlBinaryOperator BinaryMultisetOperator() throws ParseException {
    jj_consume_token(MULTISET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      jj_consume_token(UNION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_UNION_DISTINCT;}
          break;
        default:
          jj_la1[461] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[462] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_UNION;}
      break;
    case INTERSECT:
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT;}
          break;
        default:
          jj_la1[463] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[464] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_INTERSECT;}
      break;
    case EXCEPT:
      jj_consume_token(EXCEPT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT;}
          break;
        default:
          jj_la1[465] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[466] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_EXCEPT;}
      break;
    default:
      jj_la1[467] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary row operator like AND.
 */
  final public SqlBinaryOperator BinaryRowOperator() throws ParseException {
    SqlBinaryOperator op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
           {if (true) return SqlStdOperatorTable.EQUALS;}
      break;
    case GT:
      jj_consume_token(GT);
           {if (true) return SqlStdOperatorTable.GREATER_THAN;}
      break;
    case LT:
      jj_consume_token(LT);
           {if (true) return SqlStdOperatorTable.LESS_THAN;}
      break;
    case LE:
      jj_consume_token(LE);
           {if (true) return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;}
      break;
    case GE:
      jj_consume_token(GE);
           {if (true) return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;}
      break;
    case NE:
      jj_consume_token(NE);
           {if (true) return SqlStdOperatorTable.NOT_EQUALS;}
      break;
    case NE2:
      jj_consume_token(NE2);
        if (!this.conformance.isBangEqualAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.bangEqualNotAllowed());}
        }
        {if (true) return SqlStdOperatorTable.NOT_EQUALS;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
             {if (true) return SqlStdOperatorTable.PLUS;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return SqlStdOperatorTable.MINUS;}
      break;
    case STAR:
      jj_consume_token(STAR);
             {if (true) return SqlStdOperatorTable.MULTIPLY;}
      break;
    case SLASH:
      jj_consume_token(SLASH);
              {if (true) return SqlStdOperatorTable.DIVIDE;}
      break;
    case PERCENT_REMAINDER:
      jj_consume_token(PERCENT_REMAINDER);
        if (!this.conformance.isPercentRemainderAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.percentRemainderNotAllowed());}
        }
        {if (true) return SqlStdOperatorTable.PERCENT_REMAINDER;}
      break;
    case CONCAT:
      jj_consume_token(CONCAT);
               {if (true) return SqlStdOperatorTable.CONCAT;}
      break;
    case AND:
      jj_consume_token(AND);
            {if (true) return SqlStdOperatorTable.AND;}
      break;
    case OR:
      jj_consume_token(OR);
           {if (true) return SqlStdOperatorTable.OR;}
      break;
    default:
      jj_la1[468] = jj_gen;
      if (jj_2_119(2)) {
        jj_consume_token(IS);
        jj_consume_token(DISTINCT);
        jj_consume_token(FROM);
                                          {if (true) return SqlStdOperatorTable.IS_DISTINCT_FROM;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IS:
          jj_consume_token(IS);
          jj_consume_token(NOT);
          jj_consume_token(DISTINCT);
          jj_consume_token(FROM);
                                   {if (true) return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;}
          break;
        case MEMBER:
          jj_consume_token(MEMBER);
          jj_consume_token(OF);
                    {if (true) return SqlStdOperatorTable.MEMBER_OF;}
          break;
        default:
          jj_la1[469] = jj_gen;
          if (jj_2_120(2)) {
            jj_consume_token(SUBMULTISET);
            jj_consume_token(OF);
                                      {if (true) return SqlStdOperatorTable.SUBMULTISET_OF;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case NOT:
              jj_consume_token(NOT);
              jj_consume_token(SUBMULTISET);
              jj_consume_token(OF);
                               {if (true) return SqlStdOperatorTable.NOT_SUBMULTISET_OF;}
              break;
            case CONTAINS:
              jj_consume_token(CONTAINS);
                 {if (true) return SqlStdOperatorTable.CONTAINS;}
              break;
            case OVERLAPS:
              jj_consume_token(OVERLAPS);
                 {if (true) return SqlStdOperatorTable.OVERLAPS;}
              break;
            case EQUALS:
              jj_consume_token(EQUALS);
               {if (true) return SqlStdOperatorTable.PERIOD_EQUALS;}
              break;
            case PRECEDES:
              jj_consume_token(PRECEDES);
                 {if (true) return SqlStdOperatorTable.PRECEDES;}
              break;
            case SUCCEEDS:
              jj_consume_token(SUCCEEDS);
                 {if (true) return SqlStdOperatorTable.SUCCEEDS;}
              break;
            default:
              jj_la1[470] = jj_gen;
              if (jj_2_121(2)) {
                jj_consume_token(IMMEDIATELY);
                jj_consume_token(PRECEDES);
                                            {if (true) return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;}
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case IMMEDIATELY:
                  jj_consume_token(IMMEDIATELY);
                  jj_consume_token(SUCCEEDS);
                               {if (true) return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;}
                  break;
                case MULTISET:
                  op = BinaryMultisetOperator();
                                    {if (true) return op;}
                  break;
                default:
                  jj_la1[471] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a prefix row operator like NOT.
 */
  final public SqlPrefixOperator PrefixRowOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
             {if (true) return SqlStdOperatorTable.UNARY_PLUS;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return SqlStdOperatorTable.UNARY_MINUS;}
      break;
    case NOT:
      jj_consume_token(NOT);
            {if (true) return SqlStdOperatorTable.NOT;}
      break;
    case EXISTS:
      jj_consume_token(EXISTS);
               {if (true) return SqlStdOperatorTable.EXISTS;}
      break;
    case UNIQUE:
      jj_consume_token(UNIQUE);
               {if (true) return SqlStdOperatorTable.UNIQUE;}
      break;
    default:
      jj_la1[472] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a postfix row operator like IS NOT NULL.
 */
  final public SqlPostfixOperator PostfixRowOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
        jj_consume_token(A);
        jj_consume_token(SET);
                    {if (true) return SqlStdOperatorTable.IS_A_SET;}
        break;
      case NOT:
        jj_consume_token(NOT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                     {if (true) return SqlStdOperatorTable.IS_NOT_NULL;}
          break;
        case TRUE:
          jj_consume_token(TRUE);
                     {if (true) return SqlStdOperatorTable.IS_NOT_TRUE;}
          break;
        case FALSE:
          jj_consume_token(FALSE);
                      {if (true) return SqlStdOperatorTable.IS_NOT_FALSE;}
          break;
        case UNKNOWN:
          jj_consume_token(UNKNOWN);
                        {if (true) return SqlStdOperatorTable.IS_NOT_UNKNOWN;}
          break;
        case A:
          jj_consume_token(A);
          jj_consume_token(SET);
                        {if (true) return SqlStdOperatorTable.IS_NOT_A_SET;}
          break;
        case EMPTY:
          jj_consume_token(EMPTY);
                      {if (true) return SqlStdOperatorTable.IS_NOT_EMPTY;}
          break;
        default:
          jj_la1[473] = jj_gen;
          if (jj_2_122(2)) {
            jj_consume_token(JSON);
            jj_consume_token(VALUE);
                                          {if (true) return SqlStdOperatorTable.IS_NOT_JSON_VALUE;}
          } else if (jj_2_123(2)) {
            jj_consume_token(JSON);
            jj_consume_token(OBJECT);
                                           {if (true) return SqlStdOperatorTable.IS_NOT_JSON_OBJECT;}
          } else if (jj_2_124(2)) {
            jj_consume_token(JSON);
            jj_consume_token(ARRAY);
                                          {if (true) return SqlStdOperatorTable.IS_NOT_JSON_ARRAY;}
          } else if (jj_2_125(2)) {
            jj_consume_token(JSON);
            jj_consume_token(SCALAR);
                                           {if (true) return SqlStdOperatorTable.IS_NOT_JSON_SCALAR;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case JSON:
              jj_consume_token(JSON);
                     {if (true) return SqlStdOperatorTable.IS_NOT_JSON_VALUE;}
              break;
            default:
              jj_la1[474] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
      case EMPTY:
      case FALSE:
      case JSON:
      case NULL:
      case TRUE:
      case UNKNOWN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                     {if (true) return SqlStdOperatorTable.IS_NULL;}
          break;
        case TRUE:
          jj_consume_token(TRUE);
                     {if (true) return SqlStdOperatorTable.IS_TRUE;}
          break;
        case FALSE:
          jj_consume_token(FALSE);
                      {if (true) return SqlStdOperatorTable.IS_FALSE;}
          break;
        case UNKNOWN:
          jj_consume_token(UNKNOWN);
                        {if (true) return SqlStdOperatorTable.IS_UNKNOWN;}
          break;
        case EMPTY:
          jj_consume_token(EMPTY);
                      {if (true) return SqlStdOperatorTable.IS_EMPTY;}
          break;
        default:
          jj_la1[475] = jj_gen;
          if (jj_2_126(2)) {
            jj_consume_token(JSON);
            jj_consume_token(VALUE);
                                          {if (true) return SqlStdOperatorTable.IS_JSON_VALUE;}
          } else if (jj_2_127(2)) {
            jj_consume_token(JSON);
            jj_consume_token(OBJECT);
                                           {if (true) return SqlStdOperatorTable.IS_JSON_OBJECT;}
          } else if (jj_2_128(2)) {
            jj_consume_token(JSON);
            jj_consume_token(ARRAY);
                                          {if (true) return SqlStdOperatorTable.IS_JSON_ARRAY;}
          } else if (jj_2_129(2)) {
            jj_consume_token(JSON);
            jj_consume_token(SCALAR);
                                           {if (true) return SqlStdOperatorTable.IS_JSON_SCALAR;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case JSON:
              jj_consume_token(JSON);
                     {if (true) return SqlStdOperatorTable.IS_JSON_VALUE;}
              break;
            default:
              jj_la1[476] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
      default:
        jj_la1[477] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case FORMAT:
      jj_consume_token(FORMAT);
      JsonRepresentation();
            {if (true) return SqlStdOperatorTable.JSON_VALUE_EXPRESSION;}
      break;
    default:
      jj_la1[478] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a non-reserved keyword for use as an identifier.
 *
 * <p>The method is broken up into several sub-methods; without this
 * decomposition, parsers such as Babel with more than ~1,000 non-reserved
 * keywords would generate such deeply nested 'if' statements that javac would
 * fail with a {@link StackOverflowError}.
 *
 * <p>The list is generated from the FMPP config data. To add or remove
 * keywords, modify config.fmpp. For parsers except Babel, make sure that
 * keywords are not reserved by the SQL standard.
 *
 * @see Glossary#SQL2003 SQL:2003 Part 2 Section 5.2
 */
  final public String NonReservedKeyWord() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ACTION:
    case ADMIN:
    case APPLY:
    case ASC:
    case ATTRIBUTE:
    case BERNOULLI:
    case CASCADE:
    case CENTURY:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERS:
    case COLLATION:
    case COLLATION_SCHEMA:
    case COMMAND_FUNCTION_CODE:
    case CONDITION_NUMBER:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_SCHEMA:
    case CURSOR_NAME:
    case DATE_DIFF:
    case DATETIME_INTERVAL_CODE:
    case DAYOFWEEK:
    case DECADE:
    case DEFERRED:
    case DEGREE:
    case DESC:
    case DIAGNOSTICS:
    case DOW:
    case DYNAMIC_FUNCTION:
    case EPOCH:
    case EXCLUDE:
    case FIRST:
    case FORTRAN:
    case G:
    case GEOMETRY:
    case GRANTED:
    case HOP:
    case ILIKE:
    case IMPLEMENTATION:
    case INCREMENT:
    case INSTANCE:
    case ISODOW:
    case JAVA:
    case KEY:
    case LABEL:
    case LEVEL:
    case M:
    case MAXVALUE:
    case MESSAGE_TEXT:
    case MILLISECOND:
    case MONTHS:
    case NAME:
    case NESTING:
    case NULLS:
    case OCTETS:
    case ORDERING:
    case OUTPUT:
    case PARAMETER_MODE:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARTIAL:
    case PASSTHROUGH:
    case PERCENTILE_CONT:
    case PLACING:
    case PRECEDING:
    case PRIVILEGES:
    case QUARTERS:
    case REPEATABLE:
    case RESTART:
    case RETURNED_LENGTH:
    case RETURNING:
    case ROUTINE:
    case ROUTINE_SCHEMA:
    case SCALE:
    case SCOPE_CATALOGS:
    case SECONDS:
    case SELF:
    case SERIALIZABLE:
    case SESSION:
    case SIZE:
    case SPECIFIC_NAME:
    case SQL_BIT:
    case SQL_CHAR:
    case SQL_DECIMAL:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_LONGVARCHAR:
    case SQL_NCLOB:
    case SQL_REAL:
    case SQL_TIMESTAMP:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_SECOND:
    case SQL_VARBINARY:
    case STATEMENT:
    case STYLE:
    case TABLE_NAME:
    case TIME_DIFF:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTIONS_COMMITTED:
    case TRANSFORMS:
    case TRIGGER_SCHEMA:
    case UNBOUNDED:
    case UNDER:
    case USAGE:
    case USER_DEFINED_TYPE_NAME:
    case UTF32:
    case VIEW:
    case WORK:
    case XML:
    case ANALYZE:
    case JOB:
    case MAPPINGS:
    case SHARED:
    case SUSPEND:
      NonReservedKeyWord0of3();
      break;
    case ABSENT:
    case ADA:
    case AFTER:
    case ARRAY_AGG:
    case ASSERTION:
    case ATTRIBUTES:
    case BREADTH:
    case CATALOG:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CLASS_ORIGIN:
    case COLLATION_CATALOG:
    case COLUMN_NAME:
    case COMMITTED:
    case CONNECTION:
    case CONSTRAINT_NAME:
    case CONSTRUCTOR:
    case DATA:
    case DATE_TRUNC:
    case DATETIME_INTERVAL_PRECISION:
    case DAYOFYEAR:
    case DEFAULTS:
    case DEFINED:
    case DEPTH:
    case DESCRIPTION:
    case DISPATCH:
    case DOY:
    case DYNAMIC_FUNCTION_CODE:
    case ERROR:
    case EXCLUDING:
    case FOLLOWING:
    case FOUND:
    case GENERAL:
    case GO:
    case GROUP_CONCAT:
    case HOURS:
    case IMMEDIATE:
    case INCLUDE:
    case INITIALLY:
    case INSTANTIABLE:
    case ISOLATION:
    case JSON:
    case KEY_MEMBER:
    case LAST:
    case LIBRARY:
    case MAP:
    case MESSAGE_LENGTH:
    case MICROSECOND:
    case MINUTES:
    case MORE_:
    case NAMES:
    case NORMALIZED:
    case NUMBER:
    case OPTION:
    case ORDINALITY:
    case OVERRIDING:
    case PARAMETER_NAME:
    case PARAMETER_SPECIFIC_NAME:
    case PASCAL:
    case PAST:
    case PERCENTILE_DISC:
    case PLAN:
    case PRESERVE:
    case PUBLIC:
    case READ:
    case REPLACE:
    case RESTRICT:
    case RETURNED_OCTET_LENGTH:
    case RLIKE:
    case ROUTINE_CATALOG:
    case ROW_COUNT:
    case SCHEMA:
    case SCOPE_NAME:
    case SECTION:
    case SEPARATOR:
    case SERVER:
    case SETS:
    case SOURCE:
    case SQL_BIGINT:
    case SQL_BLOB:
    case SQL_CLOB:
    case SQL_DOUBLE:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARNCHAR:
    case SQL_NUMERIC:
    case SQL_SMALLINT:
    case SQL_TINYINT:
    case SQL_TSI_HOUR:
    case SQL_TSI_MONTH:
    case SQL_TSI_WEEK:
    case SQL_VARCHAR:
    case STRING_AGG:
    case SUBCLASS_ORIGIN:
    case TEMPORARY:
    case TIME_TRUNC:
    case TIMESTAMP_DIFF:
    case TRANSACTION:
    case TRANSACTIONS_ROLLED_BACK:
    case TRIGGER_CATALOG:
    case TUMBLE:
    case UNCOMMITTED:
    case UNPIVOT:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case WEEK:
    case WRAPPER:
    case YEARS:
    case CONNECTOR:
    case JOBS:
    case RESOURCES:
    case SINK:
    case TYPES:
      NonReservedKeyWord1of3();
      break;
    case ABSOLUTE:
    case ADD:
    case ALWAYS:
    case ARRAY_CONCAT_AGG:
    case ASSIGNMENT:
    case BEFORE:
    case C:
    case CATALOG_NAME:
    case CHARACTER_SET_NAME:
    case CHARACTERISTICS:
    case COBOL:
    case COLLATION_NAME:
    case COMMAND_FUNCTION:
    case CONDITIONAL:
    case CONNECTION_NAME:
    case CONSTRAINTS:
    case CONTINUE:
    case DATABASE:
    case DATETIME_DIFF:
    case DATETIME_TRUNC:
    case DAYS:
    case DEFERRABLE:
    case DEFINER:
    case DERIVED:
    case DESCRIPTOR:
    case DOMAIN:
    case DOT_FORMAT:
    case ENCODING:
    case EXCEPTION:
    case EXTERNAL:
    case FINAL:
    case FORMAT:
    case FRAC_SECOND:
    case GENERATED:
    case GOTO:
    case HIERARCHY:
    case IGNORE:
    case IMMEDIATELY:
    case INCLUDING:
    case INPUT:
    case INVOKER:
    case ISOYEAR:
    case K:
    case KEY_TYPE:
    case LENGTH:
    case LOCATOR:
    case MATCHED:
    case MESSAGE_OCTET_LENGTH:
    case MILLENNIUM:
    case MINVALUE:
    case MUMPS:
    case NANOSECOND:
    case NULLABLE:
    case OBJECT:
    case OPTIONS:
    case OTHERS:
    case PAD:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PASSING:
    case PATH:
    case PIVOT:
    case PLI:
    case PRIOR:
    case QUARTER:
    case RELATIVE:
    case RESPECT:
    case RETURNED_CARDINALITY:
    case RETURNED_SQLSTATE:
    case ROLE:
    case ROUTINE_NAME:
    case SCALAR:
    case SCHEMA_NAME:
    case SCOPE_SCHEMA:
    case SECURITY:
    case SEQUENCE:
    case SERVER_NAME:
    case SIMPLE:
    case SPACE:
    case SQL_BINARY:
    case SQL_BOOLEAN:
    case SQL_DATE:
    case SQL_FLOAT:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_SECOND:
    case SQL_LONGVARBINARY:
    case SQL_NCHAR:
    case SQL_NVARCHAR:
    case SQL_TIME:
    case SQL_TSI_DAY:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case STATE:
    case STRUCTURE:
    case SUBSTITUTE:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMP_TRUNC:
    case TRANSACTIONS_ACTIVE:
    case TRANSFORM:
    case TRIGGER_NAME:
    case TYPE:
    case UNCONDITIONAL:
    case UNNAMED:
    case USER_DEFINED_TYPE_CODE:
    case UTF16:
    case VERSION:
    case WEEKS:
    case WRITE:
    case ZONE:
    case MAPPING:
    case RESUME:
    case SNAPSHOT:
    case VIEWS:
      NonReservedKeyWord2of3();
      break;
    default:
      jj_la1[479] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return unquotedIdentifier();}
    throw new Error("Missing return statement in function");
  }

/** @see #NonReservedKeyWord */
  final public void NonReservedKeyWord0of3() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
      jj_consume_token(A);
      break;
    case ACTION:
      jj_consume_token(ACTION);
      break;
    case ADMIN:
      jj_consume_token(ADMIN);
      break;
    case APPLY:
      jj_consume_token(APPLY);
      break;
    case ASC:
      jj_consume_token(ASC);
      break;
    case ATTRIBUTE:
      jj_consume_token(ATTRIBUTE);
      break;
    case BERNOULLI:
      jj_consume_token(BERNOULLI);
      break;
    case CASCADE:
      jj_consume_token(CASCADE);
      break;
    case CENTURY:
      jj_consume_token(CENTURY);
      break;
    case CHARACTERS:
      jj_consume_token(CHARACTERS);
      break;
    case CHARACTER_SET_SCHEMA:
      jj_consume_token(CHARACTER_SET_SCHEMA);
      break;
    case COLLATION:
      jj_consume_token(COLLATION);
      break;
    case COLLATION_SCHEMA:
      jj_consume_token(COLLATION_SCHEMA);
      break;
    case COMMAND_FUNCTION_CODE:
      jj_consume_token(COMMAND_FUNCTION_CODE);
      break;
    case CONDITION_NUMBER:
      jj_consume_token(CONDITION_NUMBER);
      break;
    case CONSTRAINT_CATALOG:
      jj_consume_token(CONSTRAINT_CATALOG);
      break;
    case CONSTRAINT_SCHEMA:
      jj_consume_token(CONSTRAINT_SCHEMA);
      break;
    case CURSOR_NAME:
      jj_consume_token(CURSOR_NAME);
      break;
    case DATE_DIFF:
      jj_consume_token(DATE_DIFF);
      break;
    case DATETIME_INTERVAL_CODE:
      jj_consume_token(DATETIME_INTERVAL_CODE);
      break;
    case DAYOFWEEK:
      jj_consume_token(DAYOFWEEK);
      break;
    case DECADE:
      jj_consume_token(DECADE);
      break;
    case DEFERRED:
      jj_consume_token(DEFERRED);
      break;
    case DEGREE:
      jj_consume_token(DEGREE);
      break;
    case DESC:
      jj_consume_token(DESC);
      break;
    case DIAGNOSTICS:
      jj_consume_token(DIAGNOSTICS);
      break;
    case DOW:
      jj_consume_token(DOW);
      break;
    case DYNAMIC_FUNCTION:
      jj_consume_token(DYNAMIC_FUNCTION);
      break;
    case EPOCH:
      jj_consume_token(EPOCH);
      break;
    case EXCLUDE:
      jj_consume_token(EXCLUDE);
      break;
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case FORTRAN:
      jj_consume_token(FORTRAN);
      break;
    case G:
      jj_consume_token(G);
      break;
    case GEOMETRY:
      jj_consume_token(GEOMETRY);
      break;
    case GRANTED:
      jj_consume_token(GRANTED);
      break;
    case HOP:
      jj_consume_token(HOP);
      break;
    case ILIKE:
      jj_consume_token(ILIKE);
      break;
    case IMPLEMENTATION:
      jj_consume_token(IMPLEMENTATION);
      break;
    case INCREMENT:
      jj_consume_token(INCREMENT);
      break;
    case INSTANCE:
      jj_consume_token(INSTANCE);
      break;
    case ISODOW:
      jj_consume_token(ISODOW);
      break;
    case JAVA:
      jj_consume_token(JAVA);
      break;
    case KEY:
      jj_consume_token(KEY);
      break;
    case LABEL:
      jj_consume_token(LABEL);
      break;
    case LEVEL:
      jj_consume_token(LEVEL);
      break;
    case M:
      jj_consume_token(M);
      break;
    case MAXVALUE:
      jj_consume_token(MAXVALUE);
      break;
    case MESSAGE_TEXT:
      jj_consume_token(MESSAGE_TEXT);
      break;
    case MILLISECOND:
      jj_consume_token(MILLISECOND);
      break;
    case MONTHS:
      jj_consume_token(MONTHS);
      break;
    case NAME:
      jj_consume_token(NAME);
      break;
    case NESTING:
      jj_consume_token(NESTING);
      break;
    case NULLS:
      jj_consume_token(NULLS);
      break;
    case OCTETS:
      jj_consume_token(OCTETS);
      break;
    case ORDERING:
      jj_consume_token(ORDERING);
      break;
    case OUTPUT:
      jj_consume_token(OUTPUT);
      break;
    case PARAMETER_MODE:
      jj_consume_token(PARAMETER_MODE);
      break;
    case PARAMETER_SPECIFIC_CATALOG:
      jj_consume_token(PARAMETER_SPECIFIC_CATALOG);
      break;
    case PARTIAL:
      jj_consume_token(PARTIAL);
      break;
    case PASSTHROUGH:
      jj_consume_token(PASSTHROUGH);
      break;
    case PERCENTILE_CONT:
      jj_consume_token(PERCENTILE_CONT);
      break;
    case PLACING:
      jj_consume_token(PLACING);
      break;
    case PRECEDING:
      jj_consume_token(PRECEDING);
      break;
    case PRIVILEGES:
      jj_consume_token(PRIVILEGES);
      break;
    case QUARTERS:
      jj_consume_token(QUARTERS);
      break;
    case REPEATABLE:
      jj_consume_token(REPEATABLE);
      break;
    case RESTART:
      jj_consume_token(RESTART);
      break;
    case RETURNED_LENGTH:
      jj_consume_token(RETURNED_LENGTH);
      break;
    case RETURNING:
      jj_consume_token(RETURNING);
      break;
    case ROUTINE:
      jj_consume_token(ROUTINE);
      break;
    case ROUTINE_SCHEMA:
      jj_consume_token(ROUTINE_SCHEMA);
      break;
    case SCALE:
      jj_consume_token(SCALE);
      break;
    case SCOPE_CATALOGS:
      jj_consume_token(SCOPE_CATALOGS);
      break;
    case SECONDS:
      jj_consume_token(SECONDS);
      break;
    case SELF:
      jj_consume_token(SELF);
      break;
    case SERIALIZABLE:
      jj_consume_token(SERIALIZABLE);
      break;
    case SESSION:
      jj_consume_token(SESSION);
      break;
    case SIZE:
      jj_consume_token(SIZE);
      break;
    case SPECIFIC_NAME:
      jj_consume_token(SPECIFIC_NAME);
      break;
    case SQL_BIT:
      jj_consume_token(SQL_BIT);
      break;
    case SQL_CHAR:
      jj_consume_token(SQL_CHAR);
      break;
    case SQL_DECIMAL:
      jj_consume_token(SQL_DECIMAL);
      break;
    case SQL_INTEGER:
      jj_consume_token(SQL_INTEGER);
      break;
    case SQL_INTERVAL_DAY_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_DAY_TO_MINUTE);
      break;
    case SQL_INTERVAL_HOUR_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_MINUTE);
      break;
    case SQL_INTERVAL_MINUTE_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_MINUTE_TO_SECOND);
      break;
    case SQL_INTERVAL_YEAR:
      jj_consume_token(SQL_INTERVAL_YEAR);
      break;
    case SQL_LONGVARCHAR:
      jj_consume_token(SQL_LONGVARCHAR);
      break;
    case SQL_NCLOB:
      jj_consume_token(SQL_NCLOB);
      break;
    case SQL_REAL:
      jj_consume_token(SQL_REAL);
      break;
    case SQL_TIMESTAMP:
      jj_consume_token(SQL_TIMESTAMP);
      break;
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_VARBINARY:
      jj_consume_token(SQL_VARBINARY);
      break;
    case STATEMENT:
      jj_consume_token(STATEMENT);
      break;
    case STYLE:
      jj_consume_token(STYLE);
      break;
    case TABLE_NAME:
      jj_consume_token(TABLE_NAME);
      break;
    case TIME_DIFF:
      jj_consume_token(TIME_DIFF);
      break;
    case TIMESTAMPDIFF:
      jj_consume_token(TIMESTAMPDIFF);
      break;
    case TOP_LEVEL_COUNT:
      jj_consume_token(TOP_LEVEL_COUNT);
      break;
    case TRANSACTIONS_COMMITTED:
      jj_consume_token(TRANSACTIONS_COMMITTED);
      break;
    case TRANSFORMS:
      jj_consume_token(TRANSFORMS);
      break;
    case TRIGGER_SCHEMA:
      jj_consume_token(TRIGGER_SCHEMA);
      break;
    case UNBOUNDED:
      jj_consume_token(UNBOUNDED);
      break;
    case UNDER:
      jj_consume_token(UNDER);
      break;
    case USAGE:
      jj_consume_token(USAGE);
      break;
    case USER_DEFINED_TYPE_NAME:
      jj_consume_token(USER_DEFINED_TYPE_NAME);
      break;
    case UTF32:
      jj_consume_token(UTF32);
      break;
    case VIEW:
      jj_consume_token(VIEW);
      break;
    case WORK:
      jj_consume_token(WORK);
      break;
    case XML:
      jj_consume_token(XML);
      break;
    case ANALYZE:
      jj_consume_token(ANALYZE);
      break;
    case JOB:
      jj_consume_token(JOB);
      break;
    case MAPPINGS:
      jj_consume_token(MAPPINGS);
      break;
    case SHARED:
      jj_consume_token(SHARED);
      break;
    case SUSPEND:
      jj_consume_token(SUSPEND);
      break;
    default:
      jj_la1[480] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** @see #NonReservedKeyWord */
  final public void NonReservedKeyWord1of3() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
      jj_consume_token(ABSENT);
      break;
    case ADA:
      jj_consume_token(ADA);
      break;
    case AFTER:
      jj_consume_token(AFTER);
      break;
    case ARRAY_AGG:
      jj_consume_token(ARRAY_AGG);
      break;
    case ASSERTION:
      jj_consume_token(ASSERTION);
      break;
    case ATTRIBUTES:
      jj_consume_token(ATTRIBUTES);
      break;
    case BREADTH:
      jj_consume_token(BREADTH);
      break;
    case CATALOG:
      jj_consume_token(CATALOG);
      break;
    case CHAIN:
      jj_consume_token(CHAIN);
      break;
    case CHARACTER_SET_CATALOG:
      jj_consume_token(CHARACTER_SET_CATALOG);
      break;
    case CLASS_ORIGIN:
      jj_consume_token(CLASS_ORIGIN);
      break;
    case COLLATION_CATALOG:
      jj_consume_token(COLLATION_CATALOG);
      break;
    case COLUMN_NAME:
      jj_consume_token(COLUMN_NAME);
      break;
    case COMMITTED:
      jj_consume_token(COMMITTED);
      break;
    case CONNECTION:
      jj_consume_token(CONNECTION);
      break;
    case CONSTRAINT_NAME:
      jj_consume_token(CONSTRAINT_NAME);
      break;
    case CONSTRUCTOR:
      jj_consume_token(CONSTRUCTOR);
      break;
    case DATA:
      jj_consume_token(DATA);
      break;
    case DATE_TRUNC:
      jj_consume_token(DATE_TRUNC);
      break;
    case DATETIME_INTERVAL_PRECISION:
      jj_consume_token(DATETIME_INTERVAL_PRECISION);
      break;
    case DAYOFYEAR:
      jj_consume_token(DAYOFYEAR);
      break;
    case DEFAULTS:
      jj_consume_token(DEFAULTS);
      break;
    case DEFINED:
      jj_consume_token(DEFINED);
      break;
    case DEPTH:
      jj_consume_token(DEPTH);
      break;
    case DESCRIPTION:
      jj_consume_token(DESCRIPTION);
      break;
    case DISPATCH:
      jj_consume_token(DISPATCH);
      break;
    case DOY:
      jj_consume_token(DOY);
      break;
    case DYNAMIC_FUNCTION_CODE:
      jj_consume_token(DYNAMIC_FUNCTION_CODE);
      break;
    case ERROR:
      jj_consume_token(ERROR);
      break;
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      break;
    case FOLLOWING:
      jj_consume_token(FOLLOWING);
      break;
    case FOUND:
      jj_consume_token(FOUND);
      break;
    case GENERAL:
      jj_consume_token(GENERAL);
      break;
    case GO:
      jj_consume_token(GO);
      break;
    case GROUP_CONCAT:
      jj_consume_token(GROUP_CONCAT);
      break;
    case HOURS:
      jj_consume_token(HOURS);
      break;
    case IMMEDIATE:
      jj_consume_token(IMMEDIATE);
      break;
    case INCLUDE:
      jj_consume_token(INCLUDE);
      break;
    case INITIALLY:
      jj_consume_token(INITIALLY);
      break;
    case INSTANTIABLE:
      jj_consume_token(INSTANTIABLE);
      break;
    case ISOLATION:
      jj_consume_token(ISOLATION);
      break;
    case JSON:
      jj_consume_token(JSON);
      break;
    case KEY_MEMBER:
      jj_consume_token(KEY_MEMBER);
      break;
    case LAST:
      jj_consume_token(LAST);
      break;
    case LIBRARY:
      jj_consume_token(LIBRARY);
      break;
    case MAP:
      jj_consume_token(MAP);
      break;
    case MESSAGE_LENGTH:
      jj_consume_token(MESSAGE_LENGTH);
      break;
    case MICROSECOND:
      jj_consume_token(MICROSECOND);
      break;
    case MINUTES:
      jj_consume_token(MINUTES);
      break;
    case MORE_:
      jj_consume_token(MORE_);
      break;
    case NAMES:
      jj_consume_token(NAMES);
      break;
    case NORMALIZED:
      jj_consume_token(NORMALIZED);
      break;
    case NUMBER:
      jj_consume_token(NUMBER);
      break;
    case OPTION:
      jj_consume_token(OPTION);
      break;
    case ORDINALITY:
      jj_consume_token(ORDINALITY);
      break;
    case OVERRIDING:
      jj_consume_token(OVERRIDING);
      break;
    case PARAMETER_NAME:
      jj_consume_token(PARAMETER_NAME);
      break;
    case PARAMETER_SPECIFIC_NAME:
      jj_consume_token(PARAMETER_SPECIFIC_NAME);
      break;
    case PASCAL:
      jj_consume_token(PASCAL);
      break;
    case PAST:
      jj_consume_token(PAST);
      break;
    case PERCENTILE_DISC:
      jj_consume_token(PERCENTILE_DISC);
      break;
    case PLAN:
      jj_consume_token(PLAN);
      break;
    case PRESERVE:
      jj_consume_token(PRESERVE);
      break;
    case PUBLIC:
      jj_consume_token(PUBLIC);
      break;
    case READ:
      jj_consume_token(READ);
      break;
    case REPLACE:
      jj_consume_token(REPLACE);
      break;
    case RESTRICT:
      jj_consume_token(RESTRICT);
      break;
    case RETURNED_OCTET_LENGTH:
      jj_consume_token(RETURNED_OCTET_LENGTH);
      break;
    case RLIKE:
      jj_consume_token(RLIKE);
      break;
    case ROUTINE_CATALOG:
      jj_consume_token(ROUTINE_CATALOG);
      break;
    case ROW_COUNT:
      jj_consume_token(ROW_COUNT);
      break;
    case SCHEMA:
      jj_consume_token(SCHEMA);
      break;
    case SCOPE_NAME:
      jj_consume_token(SCOPE_NAME);
      break;
    case SECTION:
      jj_consume_token(SECTION);
      break;
    case SEPARATOR:
      jj_consume_token(SEPARATOR);
      break;
    case SERVER:
      jj_consume_token(SERVER);
      break;
    case SETS:
      jj_consume_token(SETS);
      break;
    case SOURCE:
      jj_consume_token(SOURCE);
      break;
    case SQL_BIGINT:
      jj_consume_token(SQL_BIGINT);
      break;
    case SQL_BLOB:
      jj_consume_token(SQL_BLOB);
      break;
    case SQL_CLOB:
      jj_consume_token(SQL_CLOB);
      break;
    case SQL_DOUBLE:
      jj_consume_token(SQL_DOUBLE);
      break;
    case SQL_INTERVAL_DAY:
      jj_consume_token(SQL_INTERVAL_DAY);
      break;
    case SQL_INTERVAL_DAY_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_DAY_TO_SECOND);
      break;
    case SQL_INTERVAL_HOUR_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_SECOND);
      break;
    case SQL_INTERVAL_MONTH:
      jj_consume_token(SQL_INTERVAL_MONTH);
      break;
    case SQL_INTERVAL_YEAR_TO_MONTH:
      jj_consume_token(SQL_INTERVAL_YEAR_TO_MONTH);
      break;
    case SQL_LONGVARNCHAR:
      jj_consume_token(SQL_LONGVARNCHAR);
      break;
    case SQL_NUMERIC:
      jj_consume_token(SQL_NUMERIC);
      break;
    case SQL_SMALLINT:
      jj_consume_token(SQL_SMALLINT);
      break;
    case SQL_TINYINT:
      jj_consume_token(SQL_TINYINT);
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_VARCHAR:
      jj_consume_token(SQL_VARCHAR);
      break;
    case STRING_AGG:
      jj_consume_token(STRING_AGG);
      break;
    case SUBCLASS_ORIGIN:
      jj_consume_token(SUBCLASS_ORIGIN);
      break;
    case TEMPORARY:
      jj_consume_token(TEMPORARY);
      break;
    case TIME_TRUNC:
      jj_consume_token(TIME_TRUNC);
      break;
    case TIMESTAMP_DIFF:
      jj_consume_token(TIMESTAMP_DIFF);
      break;
    case TRANSACTION:
      jj_consume_token(TRANSACTION);
      break;
    case TRANSACTIONS_ROLLED_BACK:
      jj_consume_token(TRANSACTIONS_ROLLED_BACK);
      break;
    case TRIGGER_CATALOG:
      jj_consume_token(TRIGGER_CATALOG);
      break;
    case TUMBLE:
      jj_consume_token(TUMBLE);
      break;
    case UNCOMMITTED:
      jj_consume_token(UNCOMMITTED);
      break;
    case UNPIVOT:
      jj_consume_token(UNPIVOT);
      break;
    case USER_DEFINED_TYPE_CATALOG:
      jj_consume_token(USER_DEFINED_TYPE_CATALOG);
      break;
    case USER_DEFINED_TYPE_SCHEMA:
      jj_consume_token(USER_DEFINED_TYPE_SCHEMA);
      break;
    case UTF8:
      jj_consume_token(UTF8);
      break;
    case WEEK:
      jj_consume_token(WEEK);
      break;
    case WRAPPER:
      jj_consume_token(WRAPPER);
      break;
    case YEARS:
      jj_consume_token(YEARS);
      break;
    case CONNECTOR:
      jj_consume_token(CONNECTOR);
      break;
    case JOBS:
      jj_consume_token(JOBS);
      break;
    case RESOURCES:
      jj_consume_token(RESOURCES);
      break;
    case SINK:
      jj_consume_token(SINK);
      break;
    case TYPES:
      jj_consume_token(TYPES);
      break;
    default:
      jj_la1[481] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** @see #NonReservedKeyWord */
  final public void NonReservedKeyWord2of3() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSOLUTE:
      jj_consume_token(ABSOLUTE);
      break;
    case ADD:
      jj_consume_token(ADD);
      break;
    case ALWAYS:
      jj_consume_token(ALWAYS);
      break;
    case ARRAY_CONCAT_AGG:
      jj_consume_token(ARRAY_CONCAT_AGG);
      break;
    case ASSIGNMENT:
      jj_consume_token(ASSIGNMENT);
      break;
    case BEFORE:
      jj_consume_token(BEFORE);
      break;
    case C:
      jj_consume_token(C);
      break;
    case CATALOG_NAME:
      jj_consume_token(CATALOG_NAME);
      break;
    case CHARACTERISTICS:
      jj_consume_token(CHARACTERISTICS);
      break;
    case CHARACTER_SET_NAME:
      jj_consume_token(CHARACTER_SET_NAME);
      break;
    case COBOL:
      jj_consume_token(COBOL);
      break;
    case COLLATION_NAME:
      jj_consume_token(COLLATION_NAME);
      break;
    case COMMAND_FUNCTION:
      jj_consume_token(COMMAND_FUNCTION);
      break;
    case CONDITIONAL:
      jj_consume_token(CONDITIONAL);
      break;
    case CONNECTION_NAME:
      jj_consume_token(CONNECTION_NAME);
      break;
    case CONSTRAINTS:
      jj_consume_token(CONSTRAINTS);
      break;
    case CONTINUE:
      jj_consume_token(CONTINUE);
      break;
    case DATABASE:
      jj_consume_token(DATABASE);
      break;
    case DATETIME_DIFF:
      jj_consume_token(DATETIME_DIFF);
      break;
    case DATETIME_TRUNC:
      jj_consume_token(DATETIME_TRUNC);
      break;
    case DAYS:
      jj_consume_token(DAYS);
      break;
    case DEFERRABLE:
      jj_consume_token(DEFERRABLE);
      break;
    case DEFINER:
      jj_consume_token(DEFINER);
      break;
    case DERIVED:
      jj_consume_token(DERIVED);
      break;
    case DESCRIPTOR:
      jj_consume_token(DESCRIPTOR);
      break;
    case DOMAIN:
      jj_consume_token(DOMAIN);
      break;
    case DOT_FORMAT:
      jj_consume_token(DOT_FORMAT);
      break;
    case ENCODING:
      jj_consume_token(ENCODING);
      break;
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
      break;
    case FINAL:
      jj_consume_token(FINAL);
      break;
    case FORMAT:
      jj_consume_token(FORMAT);
      break;
    case FRAC_SECOND:
      jj_consume_token(FRAC_SECOND);
      break;
    case GENERATED:
      jj_consume_token(GENERATED);
      break;
    case GOTO:
      jj_consume_token(GOTO);
      break;
    case HIERARCHY:
      jj_consume_token(HIERARCHY);
      break;
    case IGNORE:
      jj_consume_token(IGNORE);
      break;
    case IMMEDIATELY:
      jj_consume_token(IMMEDIATELY);
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      break;
    case INPUT:
      jj_consume_token(INPUT);
      break;
    case INVOKER:
      jj_consume_token(INVOKER);
      break;
    case ISOYEAR:
      jj_consume_token(ISOYEAR);
      break;
    case K:
      jj_consume_token(K);
      break;
    case KEY_TYPE:
      jj_consume_token(KEY_TYPE);
      break;
    case LENGTH:
      jj_consume_token(LENGTH);
      break;
    case LOCATOR:
      jj_consume_token(LOCATOR);
      break;
    case MATCHED:
      jj_consume_token(MATCHED);
      break;
    case MESSAGE_OCTET_LENGTH:
      jj_consume_token(MESSAGE_OCTET_LENGTH);
      break;
    case MILLENNIUM:
      jj_consume_token(MILLENNIUM);
      break;
    case MINVALUE:
      jj_consume_token(MINVALUE);
      break;
    case MUMPS:
      jj_consume_token(MUMPS);
      break;
    case NANOSECOND:
      jj_consume_token(NANOSECOND);
      break;
    case NULLABLE:
      jj_consume_token(NULLABLE);
      break;
    case OBJECT:
      jj_consume_token(OBJECT);
      break;
    case OPTIONS:
      jj_consume_token(OPTIONS);
      break;
    case OTHERS:
      jj_consume_token(OTHERS);
      break;
    case PAD:
      jj_consume_token(PAD);
      break;
    case PARAMETER_ORDINAL_POSITION:
      jj_consume_token(PARAMETER_ORDINAL_POSITION);
      break;
    case PARAMETER_SPECIFIC_SCHEMA:
      jj_consume_token(PARAMETER_SPECIFIC_SCHEMA);
      break;
    case PASSING:
      jj_consume_token(PASSING);
      break;
    case PATH:
      jj_consume_token(PATH);
      break;
    case PIVOT:
      jj_consume_token(PIVOT);
      break;
    case PLI:
      jj_consume_token(PLI);
      break;
    case PRIOR:
      jj_consume_token(PRIOR);
      break;
    case QUARTER:
      jj_consume_token(QUARTER);
      break;
    case RELATIVE:
      jj_consume_token(RELATIVE);
      break;
    case RESPECT:
      jj_consume_token(RESPECT);
      break;
    case RETURNED_CARDINALITY:
      jj_consume_token(RETURNED_CARDINALITY);
      break;
    case RETURNED_SQLSTATE:
      jj_consume_token(RETURNED_SQLSTATE);
      break;
    case ROLE:
      jj_consume_token(ROLE);
      break;
    case ROUTINE_NAME:
      jj_consume_token(ROUTINE_NAME);
      break;
    case SCALAR:
      jj_consume_token(SCALAR);
      break;
    case SCHEMA_NAME:
      jj_consume_token(SCHEMA_NAME);
      break;
    case SCOPE_SCHEMA:
      jj_consume_token(SCOPE_SCHEMA);
      break;
    case SECURITY:
      jj_consume_token(SECURITY);
      break;
    case SEQUENCE:
      jj_consume_token(SEQUENCE);
      break;
    case SERVER_NAME:
      jj_consume_token(SERVER_NAME);
      break;
    case SIMPLE:
      jj_consume_token(SIMPLE);
      break;
    case SPACE:
      jj_consume_token(SPACE);
      break;
    case SQL_BINARY:
      jj_consume_token(SQL_BINARY);
      break;
    case SQL_BOOLEAN:
      jj_consume_token(SQL_BOOLEAN);
      break;
    case SQL_DATE:
      jj_consume_token(SQL_DATE);
      break;
    case SQL_FLOAT:
      jj_consume_token(SQL_FLOAT);
      break;
    case SQL_INTERVAL_DAY_TO_HOUR:
      jj_consume_token(SQL_INTERVAL_DAY_TO_HOUR);
      break;
    case SQL_INTERVAL_HOUR:
      jj_consume_token(SQL_INTERVAL_HOUR);
      break;
    case SQL_INTERVAL_MINUTE:
      jj_consume_token(SQL_INTERVAL_MINUTE);
      break;
    case SQL_INTERVAL_SECOND:
      jj_consume_token(SQL_INTERVAL_SECOND);
      break;
    case SQL_LONGVARBINARY:
      jj_consume_token(SQL_LONGVARBINARY);
      break;
    case SQL_NCHAR:
      jj_consume_token(SQL_NCHAR);
      break;
    case SQL_NVARCHAR:
      jj_consume_token(SQL_NVARCHAR);
      break;
    case SQL_TIME:
      jj_consume_token(SQL_TIME);
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_MICROSECOND:
      jj_consume_token(SQL_TSI_MICROSECOND);
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
      break;
    case STATE:
      jj_consume_token(STATE);
      break;
    case STRUCTURE:
      jj_consume_token(STRUCTURE);
      break;
    case SUBSTITUTE:
      jj_consume_token(SUBSTITUTE);
      break;
    case TIES:
      jj_consume_token(TIES);
      break;
    case TIMESTAMPADD:
      jj_consume_token(TIMESTAMPADD);
      break;
    case TIMESTAMP_TRUNC:
      jj_consume_token(TIMESTAMP_TRUNC);
      break;
    case TRANSACTIONS_ACTIVE:
      jj_consume_token(TRANSACTIONS_ACTIVE);
      break;
    case TRANSFORM:
      jj_consume_token(TRANSFORM);
      break;
    case TRIGGER_NAME:
      jj_consume_token(TRIGGER_NAME);
      break;
    case TYPE:
      jj_consume_token(TYPE);
      break;
    case UNCONDITIONAL:
      jj_consume_token(UNCONDITIONAL);
      break;
    case UNNAMED:
      jj_consume_token(UNNAMED);
      break;
    case USER_DEFINED_TYPE_CODE:
      jj_consume_token(USER_DEFINED_TYPE_CODE);
      break;
    case UTF16:
      jj_consume_token(UTF16);
      break;
    case VERSION:
      jj_consume_token(VERSION);
      break;
    case WEEKS:
      jj_consume_token(WEEKS);
      break;
    case WRITE:
      jj_consume_token(WRITE);
      break;
    case ZONE:
      jj_consume_token(ZONE);
      break;
    case EXTERNAL:
      jj_consume_token(EXTERNAL);
      break;
    case MAPPING:
      jj_consume_token(MAPPING);
      break;
    case RESUME:
      jj_consume_token(RESUME);
      break;
    case SNAPSHOT:
      jj_consume_token(SNAPSHOT);
      break;
    case VIEWS:
      jj_consume_token(VIEWS);
      break;
    default:
      jj_la1[482] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Defines a production which can never be accepted by the parser.
 * In effect, it tells the parser, "If you got here, you've gone too far."
 * It is used as the default production for parser extension points;
 * derived parsers replace it with a real production when they want to
 * implement a particular extension point.
 */
  final public void UnusedExtension() throws ParseException {
    if (false) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ZONE);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_106(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_107(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_108(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_109(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_110(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_111(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_112(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_113(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_114(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_115(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_116(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  final private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_117(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  final private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_118(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  final private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_119(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  final private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_120(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  final private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_121(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  final private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_122(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  final private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_123(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  final private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_124(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  final private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_125(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  final private boolean jj_2_126(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_126(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  final private boolean jj_2_127(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_127(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  final private boolean jj_2_128(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_128(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  final private boolean jj_2_129(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_129(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(BETWEEN)) return true;
    return false;
  }

  final private boolean jj_3R_344() {
    if (jj_scan_token(WEEK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3R_492()) return true;
    }
    return false;
  }

  final private boolean jj_3R_343() {
    if (jj_scan_token(ISOYEAR)) return true;
    return false;
  }

  final private boolean jj_3R_483() {
    if (jj_scan_token(JSON_ARRAYAGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_342() {
    if (jj_scan_token(ISODOW)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(JSON)) return true;
    return false;
  }

  final private boolean jj_3R_341() {
    if (jj_scan_token(DOY)) return true;
    return false;
  }

  final private boolean jj_3R_340() {
    if (jj_scan_token(DOW)) return true;
    return false;
  }

  final private boolean jj_3R_339() {
    if (jj_scan_token(DAYOFYEAR)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_scan_token(OBJECT)) return true;
    return false;
  }

  final private boolean jj_3R_338() {
    if (jj_scan_token(DAYOFWEEK)) return true;
    return false;
  }

  final private boolean jj_3R_337() {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  final private boolean jj_3R_197() {
    if (jj_scan_token(OUTER)) return true;
    if (jj_scan_token(APPLY)) return true;
    return false;
  }

  final private boolean jj_3_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    if (jj_3R_113()) return true;
    return false;
  }

  final private boolean jj_3R_336() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  final private boolean jj_3R_335() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  final private boolean jj_3R_334() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  final private boolean jj_3R_333() {
    if (jj_scan_token(MILLISECOND)) return true;
    return false;
  }

  final private boolean jj_3R_332() {
    if (jj_scan_token(MICROSECOND)) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) {
    jj_scanpos = xsp;
    if (jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_3R_341()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) {
    jj_scanpos = xsp;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_331() {
    if (jj_scan_token(NANOSECOND)) return true;
    return false;
  }

  final private boolean jj_3R_225() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3R_196() {
    if (jj_scan_token(CROSS)) return true;
    if (jj_scan_token(APPLY)) return true;
    return false;
  }

  final private boolean jj_3R_224() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  final private boolean jj_3R_223() {
    if (jj_scan_token(SOME)) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_222()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_107() {
    if (jj_3R_101()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_163()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3R_502() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3R_395() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_91()) {
    jj_scanpos = xsp;
    if (jj_3R_502()) return true;
    }
    return false;
  }

  final private boolean jj_3R_482() {
    if (jj_scan_token(JSON_ARRAY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) return true;
    }
    }
    if (jj_3R_110()) return true;
    return false;
  }

  final private boolean jj_3_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_65() {
    Token xsp;
    if (jj_3_64()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_64()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_3R_82()) return true;
    if (jj_3R_83()) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3R_481() {
    if (jj_scan_token(JSON_OBJECTAGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    if (jj_3R_113()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3R_603()) return true;
    }
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3_106() {
    if (jj_3R_162()) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  final private boolean jj_3R_480() {
    if (jj_scan_token(JSON_OBJECT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_449() {
    return false;
  }

  final private boolean jj_3R_448() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_227() {
    if (jj_3R_431()) return true;
    return false;
  }

  final private boolean jj_3R_447() {
    return false;
  }

  final private boolean jj_3R_266() {
    if (jj_3R_143()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_448()) {
    jj_scanpos = xsp;
    if (jj_3R_449()) return true;
    }
    return false;
  }

  final private boolean jj_3R_113() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_227()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_106()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_57()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_scan_token(TO)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3R_446() {
    return false;
  }

  final private boolean jj_3R_141() {
    if (jj_3R_328()) return true;
    return false;
  }

  final private boolean jj_3R_265() {
    if (jj_3R_328()) return true;
    if (jj_3R_150()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_90()) {
    jj_scanpos = xsp;
    if (jj_3R_447()) return true;
    }
    return false;
  }

  final private boolean jj_3R_193() {
    if (jj_3R_119()) return true;
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_scan_token(TO)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) return true;
    }
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_scan_token(KEY)) return true;
    if (jj_3R_161()) return true;
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_3R_328()) return true;
    return false;
  }

  final private boolean jj_3R_445() {
    return false;
  }

  final private boolean jj_3R_382() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_264() {
    if (jj_3R_327()) return true;
    if (jj_3R_150()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_89()) {
    jj_scanpos = xsp;
    if (jj_3R_446()) return true;
    }
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_3R_327()) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_3R_193()) return true;
    return false;
  }

  final private boolean jj_3R_204() {
    if (jj_scan_token(CROSS)) return true;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_203() {
    if (jj_scan_token(FULL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(393)) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_scan_token(TO)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_202() {
    if (jj_scan_token(RIGHT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(393)) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_381() {
    if (jj_scan_token(KEY)) return true;
    return false;
  }

  final private boolean jj_3R_201() {
    if (jj_scan_token(LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(393)) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_200() {
    if (jj_scan_token(INNER)) return true;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_324() {
    if (jj_3R_193()) return true;
    return false;
  }

  final private boolean jj_3R_263() {
    if (jj_3R_444()) return true;
    if (jj_3R_150()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) {
    jj_scanpos = xsp;
    if (jj_3R_445()) return true;
    }
    return false;
  }

  final private boolean jj_3R_162() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_381()) jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(682)) {
    jj_scanpos = xsp;
    if (jj_3R_382()) return true;
    }
    return false;
  }

  final private boolean jj_3R_136() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) return true;
    }
    return false;
  }

  final private boolean jj_3R_323() {
    if (jj_3R_171()) return true;
    return false;
  }

  final private boolean jj_3R_262() {
    if (jj_3R_443()) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_261() {
    if (jj_3R_137()) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_441() {
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_scan_token(TO)) return true;
    if (jj_3R_137()) return true;
    return false;
  }

  final private boolean jj_3R_260() {
    if (jj_3R_442()) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_3R_193()) return true;
    return false;
  }

  final private boolean jj_3R_199() {
    return false;
  }

  final private boolean jj_3R_259() {
    if (jj_3R_440()) return true;
    if (jj_3R_150()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3R_441()) return true;
    }
    return false;
  }

  final private boolean jj_3R_198() {
    if (jj_scan_token(NATURAL)) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) return true;
    }
    return false;
  }

  final private boolean jj_3R_503() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_396() {
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_503()) return true;
    return false;
  }

  final private boolean jj_3R_330() {
    if (jj_scan_token(SECONDS)) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) {
    jj_scanpos = xsp;
    if (jj_3R_330()) return true;
    }
    return false;
  }

  final private boolean jj_3R_329() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  final private boolean jj_3R_491() {
    if (jj_scan_token(MINUTES)) return true;
    return false;
  }

  final private boolean jj_3R_328() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_490()) {
    jj_scanpos = xsp;
    if (jj_3R_491()) return true;
    }
    return false;
  }

  final private boolean jj_3R_490() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  final private boolean jj_3R_479() {
    if (jj_scan_token(JSON_QUERY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_489() {
    if (jj_scan_token(HOURS)) return true;
    return false;
  }

  final private boolean jj_3R_327() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_488()) {
    jj_scanpos = xsp;
    if (jj_3R_489()) return true;
    }
    return false;
  }

  final private boolean jj_3R_488() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  final private boolean jj_3R_541() {
    if (jj_scan_token(DAYS)) return true;
    return false;
  }

  final private boolean jj_3R_540() {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  final private boolean jj_3R_444() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_540()) {
    jj_scanpos = xsp;
    if (jj_3R_541()) return true;
    }
    return false;
  }

  final private boolean jj_3_104() {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(CONDITIONAL)) return true;
    return false;
  }

  final private boolean jj_3R_539() {
    if (jj_scan_token(WEEKS)) return true;
    return false;
  }

  final private boolean jj_3R_538() {
    if (jj_scan_token(WEEK)) return true;
    return false;
  }

  final private boolean jj_3R_443() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_538()) {
    jj_scanpos = xsp;
    if (jj_3R_539()) return true;
    }
    return false;
  }

  final private boolean jj_3R_318() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  final private boolean jj_3R_326() {
    if (jj_scan_token(MONTHS)) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_scan_token(TYPE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_318()) jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) return true;
    }
    return false;
  }

  final private boolean jj_3R_325() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3R_537() {
    if (jj_scan_token(QUARTERS)) return true;
    return false;
  }

  final private boolean jj_3R_536() {
    if (jj_scan_token(QUARTER)) return true;
    return false;
  }

  final private boolean jj_3R_442() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_536()) {
    jj_scanpos = xsp;
    if (jj_3R_537()) return true;
    }
    return false;
  }

  final private boolean jj_3_103() {
    if (jj_scan_token(EMPTY)) return true;
    if (jj_scan_token(ARRAY)) return true;
    return false;
  }

  final private boolean jj_3R_535() {
    if (jj_scan_token(YEARS)) return true;
    return false;
  }

  final private boolean jj_3R_534() {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  final private boolean jj_3R_440() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_534()) {
    jj_scanpos = xsp;
    if (jj_3R_535()) return true;
    }
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_3R_396()) return true;
    return false;
  }

  final private boolean jj_3R_640() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) jj_scanpos = xsp;
    if (jj_3R_171()) return true;
    return false;
  }

  final private boolean jj_3R_639() {
    if (jj_3R_402()) return true;
    return false;
  }

  final private boolean jj_3R_638() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_564() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_638()) {
    jj_scanpos = xsp;
    if (jj_3R_639()) {
    jj_scanpos = xsp;
    if (jj_3R_640()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_561() {
    if (jj_3R_396()) return true;
    return false;
  }

  final private boolean jj_3R_459() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_561()) jj_scanpos = xsp;
    if (jj_3R_136()) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_scan_token(MATCHED)) return true;
    return false;
  }

  final private boolean jj_3R_563() {
    if (jj_3R_135()) return true;
    return false;
  }

  final private boolean jj_3R_637() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_478() {
    if (jj_scan_token(JSON_VALUE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_636() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_562() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_636()) {
    jj_scanpos = xsp;
    if (jj_3R_637()) return true;
    }
    return false;
  }

  final private boolean jj_3R_460() {
    if (jj_scan_token(INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_562()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_563()) {
    jj_scanpos = xsp;
    if (jj_3R_564()) return true;
    }
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_317() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  final private boolean jj_3R_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(205)) jj_scanpos = xsp;
    if (jj_scan_token(MAPPING)) return true;
    xsp = jj_scanpos;
    if (jj_3R_317()) jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_453() {
    if (jj_scan_token(PERIOD)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_477() {
    if (jj_scan_token(JSON_EXISTS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_486() {
    return false;
  }

  final private boolean jj_3R_513() {
    if (jj_scan_token(UPDATE)) return true;
    return false;
  }

  final private boolean jj_3R_485() {
    if (jj_3R_578()) return true;
    return false;
  }

  final private boolean jj_3R_312() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_485()) {
    jj_scanpos = xsp;
    if (jj_3R_486()) return true;
    }
    return false;
  }

  final private boolean jj_3R_311() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_136()) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_scan_token(MAP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) return true;
    }
    return false;
  }

  final private boolean jj_3R_512() {
    if (jj_scan_token(DELETE)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_69()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_554() {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_633() {
    if (jj_3R_110()) return true;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_553() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3R_633()) return true;
    }
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_scan_token(UTF32)) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_scan_token(UTF16)) return true;
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_scan_token(UTF8)) return true;
    return false;
  }

  final private boolean jj_3R_452() {
    if (jj_scan_token(ARRAY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_553()) {
    jj_scanpos = xsp;
    if (jj_3R_554()) return true;
    }
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_scan_token(ENCODING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (j