/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.VersionedIdentifiedDataSerializable;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.sql.impl.FieldUtils;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeMismatchException;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import com.hazelcast.sql.impl.type.converter.BigIntegerConverter;
import com.hazelcast.sql.impl.type.converter.BooleanConverter;
import com.hazelcast.sql.impl.type.converter.ByteConverter;
import com.hazelcast.sql.impl.type.converter.CalendarConverter;
import com.hazelcast.sql.impl.type.converter.CharacterConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import com.hazelcast.sql.impl.type.converter.DateConverter;
import com.hazelcast.sql.impl.type.converter.DoubleConverter;
import com.hazelcast.sql.impl.type.converter.FloatConverter;
import com.hazelcast.sql.impl.type.converter.InstantConverter;
import com.hazelcast.sql.impl.type.converter.IntegerConverter;
import com.hazelcast.sql.impl.type.converter.IntervalConverter;
import com.hazelcast.sql.impl.type.converter.JsonConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.LocalTimeConverter;
import com.hazelcast.sql.impl.type.converter.LongConverter;
import com.hazelcast.sql.impl.type.converter.MapConverter;
import com.hazelcast.sql.impl.type.converter.NullConverter;
import com.hazelcast.sql.impl.type.converter.ObjectConverter;
import com.hazelcast.sql.impl.type.converter.OffsetDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.RowConverter;
import com.hazelcast.sql.impl.type.converter.ShortConverter;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import com.hazelcast.sql.impl.type.converter.ZonedDateTimeConverter;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class QueryDataType
implements VersionedIdentifiedDataSerializable,
Serializable {
    public static final int MAX_DECIMAL_PRECISION = 76;
    public static final int MAX_DECIMAL_SCALE = 38;
    public static final QueryDataType VARCHAR = new QueryDataType(StringConverter.INSTANCE);
    public static final QueryDataType VARCHAR_CHARACTER = new QueryDataType(CharacterConverter.INSTANCE);
    public static final QueryDataType BOOLEAN = new QueryDataType(BooleanConverter.INSTANCE);
    public static final QueryDataType TINYINT = new QueryDataType(ByteConverter.INSTANCE);
    public static final QueryDataType SMALLINT = new QueryDataType(ShortConverter.INSTANCE);
    public static final QueryDataType INT = new QueryDataType(IntegerConverter.INSTANCE);
    public static final QueryDataType BIGINT = new QueryDataType(LongConverter.INSTANCE);
    public static final QueryDataType DECIMAL = new QueryDataType(BigDecimalConverter.INSTANCE);
    public static final QueryDataType DECIMAL_BIG_INTEGER = new QueryDataType(BigIntegerConverter.INSTANCE);
    public static final QueryDataType REAL = new QueryDataType(FloatConverter.INSTANCE);
    public static final QueryDataType DOUBLE = new QueryDataType(DoubleConverter.INSTANCE);
    public static final QueryDataType TIME = new QueryDataType(LocalTimeConverter.INSTANCE);
    public static final QueryDataType DATE = new QueryDataType(LocalDateConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP = new QueryDataType(LocalDateTimeConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_DATE = new QueryDataType(DateConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_CALENDAR = new QueryDataType(CalendarConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_INSTANT = new QueryDataType(InstantConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME = new QueryDataType(OffsetDateTimeConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_ZONED_DATE_TIME = new QueryDataType(ZonedDateTimeConverter.INSTANCE);
    public static final QueryDataType OBJECT = new QueryDataType(ObjectConverter.INSTANCE);
    public static final QueryDataType NULL = new QueryDataType(NullConverter.INSTANCE);
    public static final QueryDataType INTERVAL_YEAR_MONTH = new QueryDataType(IntervalConverter.YEAR_MONTH);
    public static final QueryDataType INTERVAL_DAY_SECOND = new QueryDataType(IntervalConverter.DAY_SECOND);
    public static final QueryDataType MAP = new QueryDataType(MapConverter.INSTANCE);
    public static final QueryDataType JSON = new QueryDataType(JsonConverter.INSTANCE);
    public static final QueryDataType ROW = new QueryDataType(RowConverter.INSTANCE);
    private static final Map<String, QueryDataType> TYPES_BY_NAME = FieldUtils.getEnumConstants(QueryDataType.class);
    private static final Map<QueryDataType, String> NAMES = TYPES_BY_NAME.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    private static final QueryDataType[] TYPES = (QueryDataType[])TYPES_BY_NAME.values().stream().sorted(Comparator.comparingInt(type -> type.converter.getId())).toArray(QueryDataType[]::new);
    private Converter converter;
    private String objectTypeName;
    private TypeKind objectTypeKind = TypeKind.NONE;
    private String objectTypeMetadata;
    private ImmutableList.Builder<QueryDataTypeField> objectFieldsBuilder;
    private List<QueryDataTypeField> objectFields;
    private volatile String digest;

    public QueryDataType() {
    }

    public QueryDataType(String objectTypeName) {
        this(objectTypeName, TypeKind.NONE, null);
    }

    public QueryDataType(String objectTypeName, TypeKind typeKind, String typeMetadata) {
        this.converter = OBJECT.getConverter();
        this.objectTypeName = objectTypeName;
        this.objectTypeKind = typeKind;
        this.objectTypeMetadata = typeMetadata;
    }

    QueryDataType(Converter converter) {
        this.converter = converter;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public List<QueryDataTypeField> getObjectFields() {
        if (this.objectFields == null) {
            if (this.objectFieldsBuilder != null) {
                throw new IllegalStateException("Type fields are not finalized");
            }
            this.objectFields = Collections.emptyList();
        }
        return this.objectFields;
    }

    public String getObjectTypeMetadata() {
        return this.objectTypeMetadata;
    }

    public QueryDataTypeFamily getTypeFamily() {
        return this.converter.getTypeFamily();
    }

    public Converter getConverter() {
        return this.converter;
    }

    public TypeKind getObjectTypeKind() {
        return this.objectTypeKind;
    }

    public void addField(String name, QueryDataType type) {
        this.assertFieldsCanBeAdded();
        if (this.objectFieldsBuilder == null) {
            this.objectFieldsBuilder = ImmutableList.builder();
        }
        this.objectFieldsBuilder.add((Object)new QueryDataTypeField(name, type));
    }

    public void finalizeFields() {
        this.assertFieldsCanBeAdded();
        if (this.objectFieldsBuilder == null) {
            throw new IllegalStateException("Type has no fields");
        }
        this.objectFields = this.objectFieldsBuilder.build();
        this.objectFieldsBuilder = null;
    }

    private void assertFieldsCanBeAdded() {
        if (this.objectFields != null) {
            throw new IllegalStateException(this.objectFields.isEmpty() ? "Placeholder types are not expected to have fields" : "Type fields are already finalized");
        }
    }

    protected String getDigest() {
        if (this.digest == null) {
            StringBuilder sb = new StringBuilder();
            this.computeDigest(sb, new HashSet<String>());
            this.digest = sb.toString();
        }
        return this.digest;
    }

    public Object normalize(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == this.converter.getNormalizedValueClass()) {
            return value;
        }
        if (!this.converter.getValueClass().isAssignableFrom(valueClass)) {
            throw new QueryDataTypeMismatchException(this.converter.getValueClass(), valueClass);
        }
        return this.converter.convertToSelf(this.converter, value);
    }

    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == this.converter.getNormalizedValueClass()) {
            return value;
        }
        return this.converter.convertToSelf(Converters.getConverter(valueClass), value);
    }

    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    public int getClassId(Version clusterVersion) {
        return !this.isCustomType() && clusterVersion.isGreaterOrEqual(Versions.V5_4) ? 68 + this.converter.getId() : 0;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        if (!this.isCustomType() && out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            return;
        }
        out.writeInt(this.converter.getId());
        if (this.converter != OBJECT.getConverter()) {
            return;
        }
        QueryDataType.writeObjectTypeMetadata(this, out);
        if (!this.isCustomType()) {
            return;
        }
        HashMap<String, QueryDataType> typeMap = new HashMap<String, QueryDataType>();
        this.collectCustomTypes(this, typeMap);
        out.writeInt(typeMap.size());
        for (QueryDataType nestedType : typeMap.values()) {
            QueryDataType.writeObjectTypeMetadata(nestedType, out);
            out.writeInt(nestedType.getObjectFields().size());
            for (QueryDataTypeField field : nestedType.getObjectFields()) {
                out.writeString(field.name);
                out.writeInt(field.type.converter.getId());
                QueryDataType.writeObjectTypeMetadata(field.type, out);
            }
        }
    }

    private static void writeObjectTypeMetadata(QueryDataType type, ObjectDataOutput out) throws IOException {
        out.writeInt(type.objectTypeKind.value());
        out.writeString(type.objectTypeName);
        out.writeString(type.objectTypeMetadata);
    }

    private void collectCustomTypes(QueryDataType type, Map<String, QueryDataType> typeMap) {
        typeMap.put(type.objectTypeName, type);
        for (QueryDataTypeField field : type.getObjectFields()) {
            if (!field.getType().isCustomType() || typeMap.containsKey(field.type.objectTypeName)) continue;
            this.collectCustomTypes(field.type, typeMap);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        if (this.converter != null) {
            return;
        }
        this.converter = Converters.getConverter(in.readInt());
        if (this.converter != OBJECT.getConverter()) {
            return;
        }
        QueryDataType.readObjectTypeMetadata(this, in);
        if (!this.isCustomType()) {
            return;
        }
        HashMap<String, QueryDataType> typeMap = new HashMap<String, QueryDataType>();
        typeMap.put(this.objectTypeName, this);
        int typeMapSize = in.readInt();
        for (int i = 0; i < typeMapSize; ++i) {
            QueryDataType type = QueryDataType.readNestedType(OBJECT.getConverter(), in, typeMap);
            int fields = in.readInt();
            for (int j = 0; j < fields; ++j) {
                String fieldName = in.readString();
                Converter converter = Converters.getConverter(in.readInt());
                QueryDataType nestedType = QueryDataType.readNestedType(converter, in, typeMap);
                type.addField(fieldName, nestedType);
            }
            type.finalizeFields();
        }
    }

    private static void readObjectTypeMetadata(QueryDataType type, ObjectDataInput in) throws IOException {
        type.objectTypeKind = TypeKind.of(in.readInt());
        type.objectTypeName = in.readString();
        type.objectTypeMetadata = in.readString();
    }

    private static QueryDataType readNestedType(Converter converter, ObjectDataInput in, Map<String, QueryDataType> typeMap) throws IOException {
        QueryDataType type = new QueryDataType(converter);
        QueryDataType.readObjectTypeMetadata(type, in);
        return !type.isCustomType() ? QueryDataType.resolveForConverter(converter) : typeMap.computeIfAbsent(type.objectTypeName, k -> type);
    }

    public boolean isCustomType() {
        return this.converter == OBJECT.getConverter() && this.objectTypeName != null;
    }

    public int hashCode() {
        return !this.isCustomType() ? this.converter.getId() : this.getDigest().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDataType that = (QueryDataType)o;
        return !this.isCustomType() ? this.converter == that.converter : this.getDigest().equals(that.getDigest());
    }

    public String toString() {
        return this.objectTypeName != null ? this.objectTypeName : NAMES.get(this);
    }

    public static QueryDataType valueOf(String name) {
        QueryDataType type = TYPES_BY_NAME.get(name);
        if (type == null) {
            throw new IllegalArgumentException("No predefined QueryDataType with name " + name);
        }
        return type;
    }

    public static QueryDataType resolveForConverter(Converter converter) {
        return TYPES[converter.getId()];
    }

    public static QueryDataType[] values() {
        return (QueryDataType[])TYPES.clone();
    }

    private void computeDigest(StringBuilder sb, Set<String> seen) {
        QueryDataType.escape(sb, this.objectTypeName);
        if (seen.contains(this.objectTypeName)) {
            return;
        }
        seen.add(this.objectTypeName);
        sb.append('[').append((Object)this.objectTypeKind).append('=').append(this.objectTypeMetadata).append("](");
        Iterator<QueryDataTypeField> it = this.getObjectFields().iterator();
        while (it.hasNext()) {
            QueryDataTypeField field = it.next();
            QueryDataType.escape(sb, field.getName());
            sb.append(':');
            if (field.getType().isCustomType()) {
                field.getType().computeDigest(sb, seen);
            } else {
                sb.append(field.getType());
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }

    private static void escape(StringBuilder sb, String value) {
        for (char c : value.toCharArray()) {
            if (c == '[' || c == '=' || c == ']' || c == '(' || c == ':' || c == ',' || c == ')') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.isCustomType() ? this : QueryDataType.resolveForConverter(this.converter);
    }

    public static class QueryDataTypeField
    implements IdentifiedDataSerializable,
    Serializable {
        private String name;
        private QueryDataType type;

        public QueryDataTypeField() {
        }

        public QueryDataTypeField(String name, QueryDataType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public QueryDataType getType() {
            return this.type;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.name);
            out.writeObject((Object)this.type);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.name = in.readString();
            this.type = (QueryDataType)in.readObject();
        }

        public int getFactoryId() {
            return SqlDataSerializerHook.F_ID;
        }

        public int getClassId() {
            return 67;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryDataTypeField that = (QueryDataTypeField)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }
    }
}

