/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.type;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.jet.sql.impl.parse.SqlCreateType;
import com.hazelcast.jet.sql.impl.schema.TypeDefinitionColumn;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.schema.SqlCatalogObject;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Type
implements Serializable,
SqlCatalogObject {
    private String name;
    private List<TypeField> fields;
    private Map<String, String> options;

    public Type() {
    }

    public Type(String name, List<TypeDefinitionColumn> columns, Map<String, String> options) {
        this.name = name;
        this.fields = columns.stream().map(column -> new TypeField(column.name(), column.type())).collect(Collectors.toList());
        this.options = options;
    }

    @Override
    public String name() {
        return this.name;
    }

    public List<TypeField> getFields() {
        return this.fields;
    }

    public void setFields(List<TypeField> fields) {
        this.fields = fields;
    }

    public Map<String, String> options() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    @Nonnull
    public String unparse() {
        return SqlCreateType.unparse(this);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        SerializationUtil.writeList(this.fields, (ObjectDataOutput)out);
        SerializationUtil.writeMap(this.options, (ObjectDataOutput)out);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.fields = SerializationUtil.readList((ObjectDataInput)in);
        this.options = SerializationUtil.readMap((ObjectDataInput)in);
    }

    public int getClassId() {
        return 63;
    }

    public static class TypeField
    implements IdentifiedDataSerializable,
    Serializable {
        private String name;
        private QueryDataType type;

        public TypeField() {
        }

        public TypeField(String name, QueryDataType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public QueryDataType getType() {
            return this.type;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.type.getConverter().getId());
            out.writeString(this.type.getObjectTypeName());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.name = in.readString();
            Converter converter = Converters.getConverter(in.readInt());
            String typeName = in.readString();
            this.type = converter.getTypeFamily() == QueryDataTypeFamily.OBJECT && typeName != null ? new QueryDataType(typeName) : QueryDataType.resolveForConverter(converter);
        }

        public int getFactoryId() {
            return SqlDataSerializerHook.F_ID;
        }

        public int getClassId() {
            return 64;
        }
    }
}

