/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.planargraph;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.planargraph.DirectedEdge;
import com.hazelcast.shaded.org.locationtech.jts.planargraph.Edge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar {
    protected List<DirectedEdge> outEdges = new ArrayList<DirectedEdge>();
    private boolean sorted = false;

    public void add(DirectedEdge de) {
        this.outEdges.add(de);
        this.sorted = false;
    }

    public void remove(DirectedEdge de) {
        this.outEdges.remove(de);
    }

    public Iterator<DirectedEdge> iterator() {
        this.sortEdges();
        return this.outEdges.iterator();
    }

    public int getDegree() {
        return this.outEdges.size();
    }

    public Coordinate getCoordinate() {
        Iterator<DirectedEdge> it = this.iterator();
        if (!it.hasNext()) {
            return null;
        }
        DirectedEdge e = it.next();
        return e.getCoordinate();
    }

    public List<DirectedEdge> getEdges() {
        this.sortEdges();
        return this.outEdges;
    }

    private void sortEdges() {
        if (!this.sorted) {
            Collections.sort(this.outEdges);
            this.sorted = true;
        }
    }

    public int getIndex(Edge edge) {
        this.sortEdges();
        for (int i = 0; i < this.outEdges.size(); ++i) {
            DirectedEdge de = this.outEdges.get(i);
            if (de.getEdge() != edge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(DirectedEdge dirEdge) {
        this.sortEdges();
        for (int i = 0; i < this.outEdges.size(); ++i) {
            DirectedEdge de = this.outEdges.get(i);
            if (de != dirEdge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(int i) {
        int modi = i % this.outEdges.size();
        if (modi < 0) {
            modi += this.outEdges.size();
        }
        return modi;
    }

    public DirectedEdge getNextEdge(DirectedEdge dirEdge) {
        int i = this.getIndex(dirEdge);
        return this.outEdges.get(this.getIndex(i + 1));
    }

    public DirectedEdge getNextCWEdge(DirectedEdge dirEdge) {
        int i = this.getIndex(dirEdge);
        return this.outEdges.get(this.getIndex(i - 1));
    }
}

