/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json.path;

import com.hazelcast.shaded.org.jsfr.json.filter.JsonPathFilter;
import com.hazelcast.shaded.org.jsfr.json.path.FilterableChildNode;
import com.hazelcast.shaded.org.jsfr.json.path.PathOperator;
import com.hazelcast.shaded.org.jsfr.json.resolver.DocumentResolver;

public class ArrayIndex
extends FilterableChildNode {
    private int arrayIndex = -1;

    public ArrayIndex(String key) {
        super(key);
    }

    public ArrayIndex(String key, JsonPathFilter jsonPathFilter, int arrayIndex) {
        super(key, jsonPathFilter);
        this.arrayIndex = arrayIndex;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public void reset() {
        this.arrayIndex = -1;
    }

    public void increaseArrayIndex() {
        ++this.arrayIndex;
    }

    @Override
    public boolean match(PathOperator pathOperator) {
        if (!super.match(pathOperator)) {
            return false;
        }
        if (pathOperator instanceof ArrayIndex) {
            return this.arrayIndex == ((ArrayIndex)pathOperator).arrayIndex;
        }
        return false;
    }

    @Override
    public Object resolve(Object document, DocumentResolver resolver) {
        return resolver.resolve(document, this.arrayIndex);
    }

    @Override
    public PathOperator.Type getType() {
        return PathOperator.Type.ARRAY;
    }

    @Override
    public String toString() {
        String filter;
        String string = filter = super.getJsonPathFilter() != null ? "?(@...)" : "";
        if (this.getKey() == null) {
            return "[" + this.arrayIndex + "]" + filter;
        }
        return super.toString() + "[" + this.arrayIndex + "]" + filter;
    }
}

