/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlInOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public class SqlQuantifyOperator
extends SqlInOperator {
    public final SqlKind comparisonKind;

    SqlQuantifyOperator(SqlKind kind, SqlKind comparisonKind) {
        super(comparisonKind.sql + " " + (Object)((Object)kind), kind);
        this.comparisonKind = Objects.requireNonNull(comparisonKind, "comparisonKind");
        Preconditions.checkArgument(comparisonKind == SqlKind.EQUALS || comparisonKind == SqlKind.NOT_EQUALS || comparisonKind == SqlKind.LESS_THAN_OR_EQUAL || comparisonKind == SqlKind.LESS_THAN || comparisonKind == SqlKind.GREATER_THAN_OR_EQUAL || comparisonKind == SqlKind.GREATER_THAN);
        Preconditions.checkArgument(kind == SqlKind.SOME || kind == SqlKind.ALL);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        RelDataType typeForCollectionArgument = this.tryDeriveTypeForCollection(validator, scope, call);
        if (typeForCollectionArgument != null) {
            return typeForCollectionArgument;
        }
        return super.deriveType(validator, scope, call);
    }

    public @Nullable RelDataType tryDeriveTypeForCollection(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType leftType;
        RelDataType componentRightType;
        RelDataType rightType;
        Object left = call.operand(0);
        Object right = call.operand(1);
        if (right instanceof SqlNodeList && ((SqlNodeList)right).size() == 1 && SqlTypeUtil.isCollection(rightType = validator.deriveType(scope, ((SqlNodeList)right).get(0))) && (SqlTypeUtil.sameNamedType(componentRightType = Objects.requireNonNull(rightType.getComponentType()), leftType = validator.deriveType(scope, (SqlNode)left)) || SqlTypeUtil.isNull(leftType) || SqlTypeUtil.isNull(componentRightType))) {
            return validator.getTypeFactory().createTypeWithNullability(validator.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN), rightType.isNullable() || componentRightType.isNullable() || leftType.isNullable());
        }
        return null;
    }
}

