/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.advise;

import com.hazelcast.shaded.com.google.common.collect.Iterables;
import com.hazelcast.shaded.org.apache.calcite.DataContext;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.CallImplementor;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.NullPolicy;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.RexImpTable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.schema.FunctionParameter;
import com.hazelcast.shaded.org.apache.calcite.schema.ImplementableFunction;
import com.hazelcast.shaded.org.apache.calcite.schema.TableFunction;
import com.hazelcast.shaded.org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import com.hazelcast.shaded.org.apache.calcite.sql.advise.SqlAdvisor;
import com.hazelcast.shaded.org.apache.calcite.sql.advise.SqlAdvisorHint2;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.shaded.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlAdvisorGetHintsFunction2
implements TableFunction,
ImplementableFunction {
    private static final Expression ADVISOR = Expressions.convert_(Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant(DataContext.Variable.SQL_ADVISOR.camelName)), SqlAdvisor.class);
    private static final Method GET_COMPLETION_HINTS = Types.lookupMethod(SqlAdvisorGetHintsFunction2.class, "getCompletionHints", SqlAdvisor.class, String.class, Integer.TYPE);
    private static final CallImplementor IMPLEMENTOR = RexImpTable.createImplementor((translator, call, operands) -> Expressions.call(GET_COMPLETION_HINTS, Iterables.concat(Collections.singleton(ADVISOR), operands)), NullPolicy.ANY, false);
    private static final List<FunctionParameter> PARAMETERS = ReflectiveFunctionBase.builder().add(String.class, "sql").add(Integer.TYPE, "pos").build();

    @Override
    public CallImplementor getImplementor() {
        return IMPLEMENTOR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<? extends @Nullable Object> arguments) {
        return typeFactory.createJavaType(SqlAdvisorHint2.class);
    }

    @Override
    public Type getElementType(List<? extends @Nullable Object> arguments) {
        return SqlAdvisorHint2.class;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    public static Enumerable<SqlAdvisorHint2> getCompletionHints(SqlAdvisor advisor, String sql, int pos) {
        String[] replaced = new String[1];
        List<SqlMoniker> hints = advisor.getCompletionHints(sql, pos, replaced);
        ArrayList<SqlAdvisorHint2> res = new ArrayList<SqlAdvisorHint2>(hints.size() + 1);
        res.add(new SqlAdvisorHint2(replaced[0], null, "MATCH", null));
        String word = replaced[0];
        for (SqlMoniker hint : hints) {
            res.add(new SqlAdvisorHint2(hint, advisor.getReplacement(hint, word)));
        }
        return Linq4j.asEnumerable(res).asQueryable();
    }
}

