/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.NlsString;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.util.Objects;

public class SqlUnknownLiteral
extends SqlLiteral {
    public final String tag;

    SqlUnknownLiteral(String tag, String value, SqlParserPos pos) {
        super(Objects.requireNonNull(value, "value"), SqlTypeName.UNKNOWN, pos);
        this.tag = Objects.requireNonNull(tag, "tag");
    }

    @Override
    public String getValue() {
        return (String)Objects.requireNonNull(super.getValue(), "value");
    }

    @Override
    public SqlLiteral clone(SqlParserPos pos) {
        return new SqlUnknownLiteral(this.tag, this.getValue(), pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        NlsString nlsString = new NlsString(this.getValue(), null, null);
        writer.keyword(this.tag);
        writer.literal(nlsString.asSql(true, true, writer.getDialect()));
    }

    public SqlLiteral resolve(SqlTypeName typeName) {
        switch (typeName) {
            case DATE: {
                return SqlParserUtil.parseDateLiteral(this.getValue(), this.pos);
            }
            case TIME: {
                return SqlParserUtil.parseTimeLiteral(this.getValue(), this.pos);
            }
            case TIMESTAMP: {
                return SqlParserUtil.parseTimestampLiteral(this.getValue(), this.pos);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return SqlParserUtil.parseTimestampWithLocalTimeZoneLiteral(this.getValue(), this.pos);
            }
        }
        throw Util.unexpected(typeName);
    }
}

