/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public enum SqlSyntax {
    FUNCTION{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(operator, writer, call, false);
        }
    }
    ,
    FUNCTION_STAR{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(operator, writer, call, false);
        }
    }
    ,
    ORDERED_FUNCTION(FUNCTION){

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(operator, writer, call, true);
        }
    }
    ,
    BINARY{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseBinarySyntax(operator, call, writer, leftPrec, rightPrec);
        }
    }
    ,
    PREFIX{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            assert (call.operandCount() == 1);
            writer.keyword(operator.getName());
            ((SqlNode)call.operand(0)).unparse(writer, operator.getLeftPrec(), operator.getRightPrec());
        }
    }
    ,
    POSTFIX{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            assert (call.operandCount() == 1);
            ((SqlNode)call.operand(0)).unparse(writer, operator.getLeftPrec(), operator.getRightPrec());
            writer.keyword(operator.getName());
        }
    }
    ,
    SPECIAL{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            throw Util.needToImplement((Object)this);
        }
    }
    ,
    FUNCTION_ID{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            SqlUtil.unparseFunctionSyntax(operator, writer, call, false);
        }
    }
    ,
    INTERNAL{

        @Override
        public void unparse(SqlWriter writer, SqlOperator operator, SqlCall call, int leftPrec, int rightPrec) {
            throw new UnsupportedOperationException("Internal operator '" + operator + "' cannot be un-parsed");
        }
    };

    @NotOnlyInitialized
    public final SqlSyntax family;

    private SqlSyntax() {
        this((SqlSyntax)null);
    }

    private SqlSyntax(SqlSyntax family) {
        this.family = family == null ? this : family;
    }

    public abstract void unparse(SqlWriter var1, SqlOperator var2, SqlCall var3, int var4, int var5);
}

