/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.type;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeComparability;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.StructKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.checkerframework.dataflow.qual.Pure;
import java.nio.charset.Charset;
import java.util.List;
import org.apiguardian.api.API;

public interface RelDataType {
    public static final int SCALE_NOT_SPECIFIED = Integer.MIN_VALUE;
    public static final int PRECISION_NOT_SPECIFIED = -1;

    @Pure
    public boolean isStruct();

    public List<RelDataTypeField> getFieldList();

    public List<String> getFieldNames();

    public int getFieldCount();

    public StructKind getStructKind();

    public @Nullable RelDataTypeField getField(String var1, boolean var2, boolean var3);

    @Pure
    public boolean isNullable();

    @Pure
    public @Nullable RelDataType getComponentType();

    public @Nullable RelDataType getKeyType();

    public @Nullable RelDataType getValueType();

    default public @Nullable RelDataType getMeasureElementType() {
        return null;
    }

    @Pure
    public @Nullable Charset getCharset();

    @Pure
    public @Nullable SqlCollation getCollation();

    @Pure
    public @Nullable SqlIntervalQualifier getIntervalQualifier();

    public int getPrecision();

    public int getScale();

    public SqlTypeName getSqlTypeName();

    @Pure
    public @Nullable SqlIdentifier getSqlIdentifier();

    public String toString();

    public String getFullTypeString();

    public RelDataTypeFamily getFamily();

    public RelDataTypePrecedenceList getPrecedenceList();

    public RelDataTypeComparability getComparability();

    public boolean isDynamicStruct();

    @API(since="1.24", status=API.Status.INTERNAL)
    default public boolean equalsSansFieldNames(@Nullable RelDataType that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (this.isStruct()) {
            List<RelDataTypeField> l1 = this.getFieldList();
            List<RelDataTypeField> l2 = that.getFieldList();
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (l1.get(i).getType().equals(l2.get(i).getType())) continue;
                return false;
            }
            return true;
        }
        return this.equals(that);
    }
}

