/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.plan;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.ViewExpanders;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelShuttleImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Filter;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Project;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.CoreRules;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.shaded.org.apache.calcite.schema.Table;
import com.hazelcast.shaded.org.apache.calcite.schema.impl.StarTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainFormat;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.shaded.org.apache.calcite.tools.Program;
import com.hazelcast.shaded.org.apache.calcite.tools.Programs;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.apache.calcite.util.mapping.Mappings;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RelOptMaterialization {
    public final RelNode tableRel;
    public final @Nullable RelOptTable starRelOptTable;
    public final @Nullable StarTable starTable;
    public final List<String> qualifiedTableName;
    public final RelNode queryRel;

    public RelOptMaterialization(RelNode tableRel, RelNode queryRel, @Nullable RelOptTable starRelOptTable, List<String> qualifiedTableName) {
        this.tableRel = RelOptUtil.createCastRel(Objects.requireNonNull(tableRel, "tableRel"), Objects.requireNonNull(queryRel, "queryRel").getRowType(), false);
        this.starRelOptTable = starRelOptTable;
        this.starTable = starRelOptTable == null ? null : starRelOptTable.unwrapOrThrow(StarTable.class);
        this.qualifiedTableName = qualifiedTableName;
        this.queryRel = queryRel;
    }

    public static @Nullable RelNode tryUseStar(RelNode rel, final RelOptTable starRelOptTable) {
        final StarTable starTable = starRelOptTable.unwrapOrThrow(StarTable.class);
        RelNode rel2 = rel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(TableScan scan) {
                RelOptTable relOptTable = scan.getTable();
                Table table = relOptTable.unwrap(Table.class);
                if (Objects.equals(table, starTable.tables.get(0))) {
                    Mappings.TargetMapping mapping = Mappings.createShiftMapping(starRelOptTable.getRowType().getFieldCount(), 0, 0, relOptTable.getRowType().getFieldCount());
                    RelOptCluster cluster = scan.getCluster();
                    RelNode scan2 = starRelOptTable.toRel(ViewExpanders.simpleContext(cluster));
                    return RelOptUtil.createProject(scan2, Mappings.asListNonNull(mapping.inverse()));
                }
                return scan;
            }

            @Override
            public RelNode visit(LogicalJoin join) {
                RelNode rel;
                while ((rel = super.visit(join)) != join && rel instanceof LogicalJoin) {
                    ProjectFilterTable right;
                    join = (LogicalJoin)rel;
                    ProjectFilterTable left = ProjectFilterTable.of(join.getLeft());
                    if (left == null || (right = ProjectFilterTable.of(join.getRight())) == null) continue;
                    try {
                        this.match(left, right, join.getCluster());
                    }
                    catch (Util.FoundOne e) {
                        return (RelNode)Objects.requireNonNull(e.getNode(), "FoundOne.getNode");
                    }
                }
                return rel;
            }

            private void match(ProjectFilterTable left, ProjectFilterTable right, RelOptCluster cluster) {
                Mappings.TargetMapping leftMapping = left.mapping();
                Mappings.TargetMapping rightMapping = right.mapping();
                RelOptTable leftRelOptTable = left.getTable();
                Table leftTable = leftRelOptTable.unwrap(Table.class);
                int leftCount = leftRelOptTable.getRowType().getFieldCount();
                RelOptTable rightRelOptTable = right.getTable();
                Table rightTable = rightRelOptTable.unwrap(Table.class);
                if (leftTable instanceof StarTable && rightTable != null && ((StarTable)leftTable).tables.contains(rightTable)) {
                    int offset = ((StarTable)leftTable).columnOffset(rightTable);
                    Mappings.TargetMapping mapping = Mappings.merge(leftMapping, Mappings.offsetTarget(Mappings.offsetSource(rightMapping, offset), leftMapping.getTargetCount()));
                    RelNode project = RelOptUtil.createProject(leftRelOptTable.toRel(ViewExpanders.simpleContext(cluster)), Mappings.asListNonNull(mapping.inverse()));
                    ArrayList<RexNode> conditions = new ArrayList<RexNode>();
                    if (left.condition != null) {
                        conditions.add(left.condition);
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(right.condition, offset)));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
                if (rightTable instanceof StarTable && leftTable != null && ((StarTable)rightTable).tables.contains(leftTable)) {
                    int offset = ((StarTable)rightTable).columnOffset(leftTable);
                    Mappings.TargetMapping mapping = Mappings.merge(Mappings.offsetSource(leftMapping, offset), Mappings.offsetTarget(rightMapping, leftCount));
                    RelNode project = RelOptUtil.createProject(rightRelOptTable.toRel(ViewExpanders.simpleContext(cluster)), Mappings.asListNonNull(mapping.inverse()));
                    ArrayList<RexNode> conditions = new ArrayList<RexNode>();
                    if (left.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(left.condition, offset)));
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, right.condition));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
            }
        });
        if (rel2 == rel) {
            return null;
        }
        Program program = Programs.hep(ImmutableList.of(CoreRules.PROJECT_FILTER_TRANSPOSE, CoreRules.AGGREGATE_PROJECT_MERGE, CoreRules.AGGREGATE_FILTER_TRANSPOSE), false, DefaultRelMetadataProvider.INSTANCE);
        return program.run(Nullness.castNonNull(null), rel2, Nullness.castNonNull(null), ImmutableList.of(), ImmutableList.of());
    }

    public static RelNode toLeafJoinForm(RelNode rel) {
        Program program = Programs.hep(ImmutableList.of(CoreRules.JOIN_PROJECT_RIGHT_TRANSPOSE, CoreRules.JOIN_PROJECT_LEFT_TRANSPOSE, CoreRules.FILTER_INTO_JOIN, CoreRules.PROJECT_REMOVE, CoreRules.PROJECT_MERGE), false, DefaultRelMetadataProvider.INSTANCE);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            System.out.println(RelOptUtil.dumpPlan("before", rel, SqlExplainFormat.TEXT, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        RelNode rel2 = program.run(Nullness.castNonNull(null), rel, Nullness.castNonNull(null), ImmutableList.of(), ImmutableList.of());
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            System.out.println(RelOptUtil.dumpPlan("after", rel2, SqlExplainFormat.TEXT, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        return rel2;
    }

    private static class ProjectFilterTable {
        final @Nullable RexNode condition;
        final @Nullable Mappings.TargetMapping mapping;
        final TableScan scan;

        private ProjectFilterTable(@Nullable RexNode condition, @Nullable Mappings.TargetMapping mapping, TableScan scan) {
            this.condition = condition;
            this.mapping = mapping;
            this.scan = Objects.requireNonNull(scan, "scan");
        }

        static @Nullable ProjectFilterTable of(RelNode node) {
            if (node instanceof Filter) {
                Filter filter = (Filter)node;
                return ProjectFilterTable.of2(filter.getCondition(), filter.getInput());
            }
            return ProjectFilterTable.of2(null, node);
        }

        private static @Nullable ProjectFilterTable of2(@Nullable RexNode condition, RelNode node) {
            if (node instanceof Project) {
                Project project = (Project)node;
                return ProjectFilterTable.of3(condition, project.getMapping(), project.getInput());
            }
            return ProjectFilterTable.of3(condition, null, node);
        }

        private static @Nullable ProjectFilterTable of3(@Nullable RexNode condition, @Nullable Mappings.TargetMapping mapping, RelNode node) {
            if (node instanceof TableScan) {
                return new ProjectFilterTable(condition, mapping, (TableScan)node);
            }
            return null;
        }

        public Mappings.TargetMapping mapping() {
            return this.mapping != null ? this.mapping : Mappings.createIdentity(this.scan.getRowType().getFieldCount());
        }

        public RelOptTable getTable() {
            return this.scan.getTable();
        }
    }
}

