/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.jdbc;

import com.hazelcast.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.hazelcast.shaded.org.apache.calcite.avatica.NoSuchStatementException;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteConnectionImpl;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalcitePrepare;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Queryable;
import com.hazelcast.shaded.org.apache.calcite.server.CalciteServerStatement;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.sql.SQLException;

public abstract class CalciteStatement
extends AvaticaStatement {
    CalciteStatement(CalciteConnectionImpl connection,  @Nullable Meta.StatementHandle h2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, h2, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == CalciteServerStatement.class) {
            CalciteServerStatement statement;
            try {
                statement = this.getConnection().server.getStatement(this.handle);
            }
            catch (NoSuchStatementException e) {
                throw new AssertionError("invalid statement", e);
            }
            return iface.cast(statement);
        }
        return super.unwrap(iface);
    }

    @Override
    public CalciteConnectionImpl getConnection() {
        return (CalciteConnectionImpl)this.connection;
    }

    protected <T> CalcitePrepare.CalciteSignature<T> prepare(Queryable<T> queryable) {
        CalciteServerStatement serverStatement;
        CalciteConnectionImpl calciteConnection = this.getConnection();
        CalcitePrepare prepare = calciteConnection.prepareFactory.get();
        try {
            serverStatement = calciteConnection.server.getStatement(this.handle);
        }
        catch (NoSuchStatementException e) {
            throw new AssertionError("invalid statement", e);
        }
        CalcitePrepare.Context prepareContext = serverStatement.createPrepareContext();
        return prepare.prepareQueryable(prepareContext, queryable);
    }

    @Override
    protected void close_() {
        if (!this.closed) {
            ((CalciteConnectionImpl)this.connection).server.removeStatement(this.handle);
            super.close_();
        }
    }
}

