/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.clone;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.adapter.java.AbstractQueryableTable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.AbstractQueryable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.shaded.org.apache.calcite.linq4j.QueryProvider;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Queryable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelProtoDataType;
import com.hazelcast.shaded.org.apache.calcite.schema.SchemaPlus;
import com.hazelcast.shaded.org.apache.calcite.schema.Statistic;
import com.hazelcast.shaded.org.apache.calcite.schema.Statistics;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;

class ListTable
extends AbstractQueryableTable {
    private final RelProtoDataType protoRowType;
    private final Expression expression;
    private final List list;

    ListTable(Type elementType, RelProtoDataType protoRowType, Expression expression, List list) {
        super(elementType);
        this.protoRowType = protoRowType;
        this.expression = expression;
        this.list = list;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.of(this.list.size(), ImmutableList.of());
    }

    @Override
    public <T> Queryable<T> asQueryable(final QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractQueryable<T>(){

            @Override
            public Type getElementType() {
                return ListTable.this.elementType;
            }

            @Override
            public Expression getExpression() {
                return ListTable.this.expression;
            }

            @Override
            public QueryProvider getProvider() {
                return queryProvider;
            }

            @Override
            public Iterator<T> iterator() {
                return ListTable.this.list.iterator();
            }

            @Override
            public Enumerator<T> enumerator() {
                return Linq4j.enumerator(ListTable.this.list);
            }
        };
    }
}

