/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operand;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.operand.AbstractOperandChecker;
import com.hazelcast.jet.sql.impl.validate.param.AbstractParameterConverter;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.type.QueryDataType;

public class TypedOperandChecker
extends AbstractOperandChecker {
    public static final TypedOperandChecker BOOLEAN = new TypedOperandChecker(SqlTypeName.BOOLEAN);
    public static final TypedOperandChecker VARCHAR = new TypedOperandChecker(SqlTypeName.VARCHAR);
    public static final TypedOperandChecker TINYINT = new TypedOperandChecker(SqlTypeName.TINYINT);
    public static final TypedOperandChecker SMALLINT = new TypedOperandChecker(SqlTypeName.SMALLINT);
    public static final TypedOperandChecker INTEGER = new TypedOperandChecker(SqlTypeName.INTEGER);
    public static final TypedOperandChecker BIGINT = new TypedOperandChecker(SqlTypeName.BIGINT);
    public static final TypedOperandChecker DECIMAL = new TypedOperandChecker(SqlTypeName.DECIMAL);
    public static final TypedOperandChecker REAL = new TypedOperandChecker(SqlTypeName.REAL);
    public static final TypedOperandChecker DOUBLE = new TypedOperandChecker(SqlTypeName.DOUBLE);
    public static final TypedOperandChecker TIMESTAMP_WITH_TIME_ZONE = new TypedOperandChecker(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
    public static final TypedOperandChecker MAP = new TypedOperandChecker(SqlTypeName.MAP);
    public static final TypedOperandChecker COLUMN_LIST = new TypedOperandChecker(SqlTypeName.COLUMN_LIST);
    public static final TypedOperandChecker ROW = new TypedOperandChecker(SqlTypeName.ROW);
    public static final TypedOperandChecker SYMBOL = new TypedOperandChecker(SqlTypeName.SYMBOL);
    public static final TypedOperandChecker JSON = new TypedOperandChecker(HazelcastJsonType.TYPE);
    protected final SqlTypeName targetTypeName;
    protected final RelDataType type;

    protected TypedOperandChecker(SqlTypeName targetTypeName) {
        this.targetTypeName = targetTypeName;
        this.type = null;
    }

    protected TypedOperandChecker(RelDataType type) {
        this.targetTypeName = type.getSqlTypeName();
        this.type = type;
    }

    public static TypedOperandChecker forType(RelDataType type) {
        return new TypedOperandChecker(type);
    }

    @Override
    protected boolean matchesTargetType(RelDataType operandType) {
        if (this.type != null && this.type.getSqlTypeName() == SqlTypeName.OTHER) {
            return this.type.getFamily().equals(operandType.getFamily());
        }
        return operandType.getSqlTypeName() == this.targetTypeName;
    }

    @Override
    protected RelDataType getTargetType(RelDataTypeFactory factory, boolean nullable) {
        if (this.type != null) {
            return factory.createTypeWithNullability(this.type, nullable);
        }
        return HazelcastTypeUtils.createType(factory, this.targetTypeName, nullable);
    }

    @Override
    protected boolean coerce(HazelcastSqlValidator validator, HazelcastCallBinding callBinding, SqlNode operand, RelDataType operandType, int operandIndex) {
        boolean canCoerce;
        if (this.targetTypeName == SqlTypeName.ROW || this.targetTypeName == SqlTypeName.COLUMN_LIST) {
            return false;
        }
        QueryDataType targetType0 = this.getTargetHazelcastType();
        QueryDataType operandType0 = HazelcastTypeUtils.toHazelcastType(operandType);
        boolean bl = canCoerce = HazelcastTypeUtils.isTemporalType(operandType) && HazelcastTypeUtils.isTemporalType(this.targetTypeName) || HazelcastTypeUtils.isNumericType(operandType) && HazelcastTypeUtils.isNumericType(this.targetTypeName) || operandType.getSqlTypeName() == SqlTypeName.VARCHAR && this.type != null && this.type.getFamily() == HazelcastJsonType.FAMILY;
        if (!canCoerce) {
            return false;
        }
        if (targetType0.getTypeFamily().getPrecedence() < operandType0.getTypeFamily().getPrecedence()) {
            return false;
        }
        RelDataType newOperandType = this.getTargetType(validator.getTypeFactory(), operandType.isNullable());
        validator.getTypeCoercion().coerceOperandType(callBinding.getScope(), callBinding.getCall(), operandIndex, newOperandType);
        return true;
    }

    @Override
    protected ParameterConverter parameterConverter(SqlDynamicParam operand) {
        QueryDataType targetHazelcastType = this.getTargetHazelcastType();
        return AbstractParameterConverter.from(targetHazelcastType, operand.getIndex(), operand.getParserPosition());
    }

    public boolean isNumeric() {
        return this.getTargetHazelcastType().getTypeFamily().isNumeric();
    }

    private QueryDataType getTargetHazelcastType() {
        return this.type != null ? HazelcastTypeUtils.toHazelcastType(this.type) : HazelcastTypeUtils.toHazelcastTypeFromSqlTypeName(this.targetTypeName);
    }
}

