/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.sql.impl.processors.StreamToStreamJoinBuffer;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

class StreamToStreamJoinHeapBuffer
extends StreamToStreamJoinBuffer {
    private final PriorityQueue<JetSqlRow> buffer;
    private final ToLongFunctionEx<JetSqlRow> timeExtractor;

    StreamToStreamJoinHeapBuffer(List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> timeExtractors) {
        super(timeExtractors);
        assert (timeExtractors.size() == 1);
        this.timeExtractor = timeExtractors.get(0).getValue();
        this.buffer = new PriorityQueue<JetSqlRow>(Comparator.comparingLong(this.timeExtractor));
    }

    @Override
    public void add(JetSqlRow row) {
        this.buffer.add(row);
    }

    @Override
    public Iterator<JetSqlRow> iterator() {
        return this.buffer.iterator();
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    @Override
    public Collection<JetSqlRow> content() {
        return this.buffer;
    }

    @Override
    public void clearExpiredItems(long[] limits, @Nonnull Consumer<JetSqlRow> clearedRowsConsumer) {
        JetSqlRow row;
        assert (limits.length == 1);
        while ((row = this.buffer.peek()) != null && this.timeExtractor.applyAsLong((Object)row) < limits[0]) {
            clearedRowsConsumer.accept(row);
            this.buffer.remove();
        }
    }
}

