/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.sql.impl.parse.ParseUtils;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.UnparseUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlCreateJob
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE JOB", SqlKind.OTHER_DDL);
    private final SqlIdentifier name;
    private final SqlNodeList options;
    private final SqlExtendedInsert sqlInsert;
    private final JobConfig jobConfig = new JobConfig();

    public SqlCreateJob(SqlIdentifier name, SqlNodeList options, SqlExtendedInsert sqlInsert, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.options = Objects.requireNonNull(options, "Options should not be null");
        this.sqlInsert = Objects.requireNonNull(sqlInsert, "A DML statement is mandatory");
        Preconditions.checkTrue((boolean)name.isSimple(), (String)name.toString());
        this.jobConfig.setName(name.toString());
    }

    public JobConfig jobConfig() {
        return this.jobConfig;
    }

    public SqlExtendedInsert dmlStatement() {
        return this.sqlInsert;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.options, this.sqlInsert);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE JOB");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        UnparseUtil.unparseOptions(writer, this.options);
        writer.newlineAndIndent();
        writer.keyword("AS");
        this.sqlInsert.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace()) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.notSupported("OR REPLACE", "CREATE JOB"));
        }
        HashSet<String> optionNames = new HashSet<String>();
        block24: for (SqlNode option0 : this.options) {
            SqlOption option = (SqlOption)option0;
            String key = option.keyString();
            String value = option.valueString();
            if (!optionNames.add(key)) {
                throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(key));
            }
            switch (key) {
                case "processingGuarantee": {
                    this.jobConfig.setProcessingGuarantee(ParseUtils.parseProcessingGuarantee(validator, option));
                    continue block24;
                }
                case "snapshotIntervalMillis": {
                    this.jobConfig.setSnapshotIntervalMillis(ParseUtils.parseLong(validator, option));
                    continue block24;
                }
                case "autoScaling": {
                    this.jobConfig.setAutoScaling(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "splitBrainProtectionEnabled": {
                    this.jobConfig.setSplitBrainProtection(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "metricsEnabled": {
                    this.jobConfig.setMetricsEnabled(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "storeMetricsAfterJobCompletion": {
                    this.jobConfig.setStoreMetricsAfterJobCompletion(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "initialSnapshotName": {
                    this.jobConfig.setInitialSnapshotName(value);
                    continue block24;
                }
                case "maxProcessorAccumulatedRecords": {
                    this.jobConfig.setMaxProcessorAccumulatedRecords(ParseUtils.parseLong(validator, option));
                    continue block24;
                }
                case "suspendOnFailure": {
                    this.jobConfig.setSuspendOnFailure(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "userCodeNamespace": {
                    throw validator.newValidationError(option.key(), ParserResource.RESOURCE.notSupported(key, "CREATE JOB"));
                }
            }
            throw validator.newValidationError(option.key(), ParserResource.RESOURCE.unknownJobOption(key));
        }
        validator.validate(this.sqlInsert);
    }
}

