/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;

public class ParseUtils {
    private ParseUtils() {
    }

    static ProcessingGuarantee parseProcessingGuarantee(SqlValidator validator, SqlOption option) {
        switch (option.valueString()) {
            case "exactlyOnce": {
                return ProcessingGuarantee.EXACTLY_ONCE;
            }
            case "atLeastOnce": {
                return ProcessingGuarantee.AT_LEAST_ONCE;
            }
            case "none": {
                return ProcessingGuarantee.NONE;
            }
        }
        throw validator.newValidationError(option.value(), ParserResource.RESOURCE.processingGuaranteeBadValue(option.keyString(), option.valueString()));
    }

    static long parseLong(SqlValidator validator, SqlOption option) {
        try {
            return Long.parseLong(option.valueString());
        }
        catch (NumberFormatException e) {
            throw validator.newValidationError(option.value(), ParserResource.RESOURCE.jobOptionIncorrectNumber(option.keyString(), option.valueString()));
        }
    }
}

