/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.prepare.Prepare;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class UpdatePhysicalRel
extends AbstractRelNode
implements PhysicalRel {
    private final RelOptTable table;
    private final Prepare.CatalogReader catalogReader;
    private RelNode input;
    private final List<String> updateColumnList;
    private final List<RexNode> sourceExpressionList;
    private final boolean flattened;
    private final RexNode predicate;

    UpdatePhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened, RexNode predicate) {
        super(cluster, traitSet);
        this.table = table;
        this.catalogReader = catalogReader;
        this.input = input;
        this.updateColumnList = updateColumnList;
        this.sourceExpressionList = sourceExpressionList;
        this.flattened = flattened;
        this.predicate = predicate;
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RelOptTable getTable() {
        return this.table;
    }

    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    public RelNode getInput() {
        return this.input;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.input != null ? Collections.singletonList(this.input) : Collections.emptyList();
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode rel) {
        assert (this.input != null);
        assert (ordinalInParent == 0);
        this.input = rel;
        this.recomputeDigest();
    }

    public List<String> getUpdateColumnList() {
        return this.updateColumnList;
    }

    public List<RexNode> getSourceExpressionList() {
        return this.sourceExpressionList;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public RexNode getPredicate() {
        return this.predicate;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.UPDATE, this.getCluster().getTypeFactory());
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        return visitor.onUpdate(this);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new UpdatePhysicalRel(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), UpdatePhysicalRel.sole(inputs), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened(), this.predicate);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        RelWriter w = super.explainTerms(pw);
        if (this.input != null) {
            w.input("input", this.getInput());
        }
        return w.item("table", this.table.getQualifiedName()).item("updateColumnList", this.updateColumnList).item("sourceExpressionList", this.sourceExpressionList).item("flattened", this.flattened).itemIf("predicate", this.predicate, this.predicate != null);
    }
}

