/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.prepare.Prepare;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeletePhysicalRel
extends AbstractRelNode
implements PhysicalRel {
    private final RelOptTable table;
    private final Prepare.CatalogReader catalogReader;
    private RelNode input;
    private final boolean flattened;
    private final RexNode predicate;

    DeletePhysicalRel(@Nonnull RelOptCluster cluster, @Nonnull RelTraitSet traitSet, @Nonnull RelOptTable table, @Nonnull Prepare.CatalogReader catalogReader, @Nullable RelNode input, boolean flattened, @Nullable RexNode predicate) {
        super(cluster, traitSet);
        this.table = table;
        this.catalogReader = catalogReader;
        this.input = input;
        this.flattened = flattened;
        this.predicate = predicate;
    }

    @Override
    @Nonnull
    public RelOptTable getTable() {
        return this.table;
    }

    @Nonnull
    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Nullable
    public RelNode getInput() {
        return this.input;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.input != null ? Collections.singletonList(this.input) : Collections.emptyList();
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode rel) {
        assert (this.input != null);
        assert (ordinalInParent == 0);
        this.input = rel;
        this.recomputeDigest();
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    @Nullable
    public RexNode getPredicate() {
        return this.predicate;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.DELETE, this.getCluster().getTypeFactory());
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        return visitor.onDelete(this);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DeletePhysicalRel(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), DeletePhysicalRel.sole(inputs), this.isFlattened(), this.predicate);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        RelWriter w = super.explainTerms(pw);
        if (this.input != null) {
            w.input("input", this.getInput());
        }
        return w.item("table", this.table.getQualifiedName()).item("flattened", this.flattened).itemIf("predicate", this.predicate, this.predicate != null);
    }
}

