/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class LazyDefiningSpecificMemberPms
implements ProcessorMetaSupplier,
IdentifiedDataSerializable {
    private ProcessorSupplier supplier;
    private SupplierEx<Expression<?>> partitionKeyExprSupplier;
    private Integer partitionArgIndex;
    private Address ownerAddress;

    public LazyDefiningSpecificMemberPms() {
    }

    private LazyDefiningSpecificMemberPms(ProcessorSupplier supplier, int partitionArgumentIndex) {
        this.supplier = supplier;
        this.partitionArgIndex = partitionArgumentIndex;
    }

    private LazyDefiningSpecificMemberPms(ProcessorSupplier supplier, SupplierEx<Expression<?>> partitionExprSupplier) {
        this.supplier = supplier;
        this.partitionKeyExprSupplier = partitionExprSupplier;
    }

    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        PermissionsUtil.checkPermission((SecuredFunction)this.supplier, (ProcessorMetaSupplier.Context)context);
        if (context.localParallelism() != 1) {
            throw new IllegalArgumentException("Local parallelism of " + context.localParallelism() + " was requested for a vertex that supports only total parallelism of 1. Local parallelism must be 1.");
        }
        ExpressionEvalContext eec = ExpressionEvalContext.from(context);
        Object partitionKey = this.partitionArgIndex != null ? eec.getArgument(this.partitionArgIndex) : Objects.requireNonNull((Expression)this.partitionKeyExprSupplier.get()).eval(null, eec);
        this.ownerAddress = ProcessorMetaSupplier.getOwnerAddress((ProcessorMetaSupplier.Context)context, (Object)partitionKey);
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        return addr -> addr.equals((Object)this.ownerAddress) ? this.supplier : new ProcessorMetaSupplier.ExpectNothingProcessorSupplier();
    }

    public int preferredLocalParallelism() {
        return 1;
    }

    public boolean initIsCooperative() {
        if (this.partitionKeyExprSupplier != null) {
            return ((Expression)this.partitionKeyExprSupplier.get()).isCooperative();
        }
        return true;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.supplier);
        out.writeInt(this.partitionArgIndex.intValue());
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.supplier = (ProcessorSupplier)in.readObject();
        this.partitionArgIndex = in.readInt();
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 91;
    }

    public static ProcessorMetaSupplier lazyForceTotalParallelismOne(@Nonnull ProcessorSupplier supplier, @Nonnull SupplierEx<Expression<?>> partitionKeyExprSupplier) {
        return new LazyDefiningSpecificMemberPms(supplier, partitionKeyExprSupplier);
    }

    public static ProcessorMetaSupplier lazyForceTotalParallelismOne(@Nonnull ProcessorSupplier supplier, @Nonnull Integer partitionArgumentIndex) {
        return new LazyDefiningSpecificMemberPms(supplier, partitionArgumentIndex);
    }
}

