/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;

public class KvRowProjector
implements Row {
    private final QueryTarget keyTarget;
    private final QueryTarget valueTarget;
    private final QueryExtractor[] extractors;
    private final Expression<Boolean> predicate;
    private final List<Expression<?>> projections;
    private final ExpressionEvalContext evalContext;

    KvRowProjector(QueryPath[] paths, QueryDataType[] types, QueryTarget keyTarget, QueryTarget valueTarget, Expression<Boolean> predicate, List<Expression<?>> projections, ExpressionEvalContext evalContext) {
        Preconditions.checkTrue((paths.length == types.length ? 1 : 0) != 0, (String)"paths.length != types.length");
        this.keyTarget = keyTarget;
        this.valueTarget = valueTarget;
        this.extractors = KvRowProjector.createExtractors(paths, types, keyTarget, valueTarget);
        this.predicate = predicate != null ? predicate : ConstantExpression.create(true, QueryDataType.BOOLEAN);
        this.projections = projections;
        this.evalContext = evalContext;
    }

    private static QueryExtractor[] createExtractors(QueryPath[] paths, QueryDataType[] types, QueryTarget keyTarget, QueryTarget valueTarget) {
        QueryExtractor[] extractors = new QueryExtractor[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            QueryPath path = paths[i];
            QueryDataType type = types[i];
            extractors[i] = path.isKey() ? keyTarget.createExtractor(path.getPath(), type) : valueTarget.createExtractor(path.getPath(), type);
        }
        return extractors;
    }

    public JetSqlRow project(Object key, Object value) {
        return this.project(key, null, value, null);
    }

    public JetSqlRow project(Data key, Data value) {
        return this.project(null, key, null, value);
    }

    private JetSqlRow project(Object key, Data keyData, Object value, Data valueData) {
        this.keyTarget.setTarget(key, keyData);
        this.valueTarget.setTarget(value, valueData);
        return ExpressionUtil.projection(this.predicate, this.projections, this, this.evalContext);
    }

    public <T> T get(int index) {
        return (T)this.extractors[index].get();
    }

    public <T> T get(int index, boolean useLazyDeserialization) {
        return (T)this.extractors[index].get(useLazyDeserialization);
    }

    public int getColumnCount() {
        return this.projections.size();
    }

    public boolean isCooperative() {
        for (Expression<?> e : this.projections) {
            if (e.isCooperative()) continue;
            return false;
        }
        return this.predicate.isCooperative();
    }

    public static Supplier supplier(QueryPath[] paths, QueryDataType[] types, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Expression<Boolean> predicate, List<Expression<?>> projections) {
        return new Supplier(paths, types, keyDescriptor, valueDescriptor, predicate, projections);
    }

    public static class Supplier
    implements IdentifiedDataSerializable {
        private QueryPath[] paths;
        private QueryDataType[] types;
        private QueryTargetDescriptor keyDescriptor;
        private QueryTargetDescriptor valueDescriptor;
        private Expression<Boolean> predicate;
        private List<Expression<?>> projections;

        public Supplier() {
        }

        Supplier(QueryPath[] paths, QueryDataType[] types, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Expression<Boolean> predicate, List<Expression<?>> projections) {
            this.paths = paths;
            this.types = types;
            this.keyDescriptor = keyDescriptor;
            this.valueDescriptor = valueDescriptor;
            this.predicate = predicate;
            this.projections = projections;
        }

        public int columnCount() {
            return this.paths.length;
        }

        public QueryPath[] paths() {
            return this.paths;
        }

        public KvRowProjector get(ExpressionEvalContext evalContext, Extractors extractors) {
            return new KvRowProjector(this.paths, this.types, this.keyDescriptor.create(evalContext.getSerializationService(), extractors, true), this.valueDescriptor.create(evalContext.getSerializationService(), extractors, false), this.predicate, this.projections, evalContext);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.paths.length);
            for (QueryPath path : this.paths) {
                out.writeObject((Object)path);
            }
            out.writeInt(this.types.length);
            for (QueryDataType type : this.types) {
                out.writeObject((Object)type);
            }
            out.writeObject((Object)this.keyDescriptor);
            out.writeObject((Object)this.valueDescriptor);
            out.writeObject(this.predicate);
            out.writeObject(this.projections);
        }

        public void readData(ObjectDataInput in) throws IOException {
            int i;
            this.paths = new QueryPath[in.readInt()];
            for (i = 0; i < this.paths.length; ++i) {
                this.paths[i] = (QueryPath)in.readObject();
            }
            this.types = new QueryDataType[in.readInt()];
            for (i = 0; i < this.types.length; ++i) {
                this.types[i] = (QueryDataType)in.readObject();
            }
            this.keyDescriptor = (QueryTargetDescriptor)in.readObject();
            this.valueDescriptor = (QueryTargetDescriptor)in.readObject();
            this.predicate = (Expression)in.readObject();
            this.projections = (List)in.readObject();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 7;
        }
    }
}

