/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.mssql;

import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import java.util.Iterator;
import java.util.List;

public class MSSQLUpsertQueryBuilder
extends AbstractQueryBuilder {
    public MSSQLUpsertQueryBuilder(JdbcTable jdbcTable, SqlDialect dialect) {
        super(jdbcTable, dialect);
        StringBuilder sb = new StringBuilder();
        this.appendMergeClause(sb);
        sb.append(' ');
        this.appendMatchedClause(sb);
        this.query = sb.toString();
    }

    void appendMergeClause(StringBuilder sb) {
        sb.append("MERGE ");
        this.dialect.quoteIdentifier(sb, this.jdbcTable.getExternalNameList());
        sb.append(" USING (");
        this.appendValuesClause(sb);
        sb.append(") AS source ");
        this.appendFieldNames(sb, this.jdbcTable.dbFieldNames());
        sb.append(" ON ");
        this.appendPrimaryKeys(sb);
    }

    void appendValuesClause(StringBuilder sb) {
        sb.append("VALUES ");
        this.appendValues(sb, this.jdbcTable.dbFieldNames().size());
    }

    void appendMatchedClause(StringBuilder sb) {
        sb.append("WHEN MATCHED THEN ");
        sb.append("UPDATE ");
        sb.append("SET");
        Iterator<String> it = this.jdbcTable.dbFieldNames().iterator();
        while (it.hasNext()) {
            String dbFieldName = it.next();
            sb.append(' ');
            this.dialect.quoteIdentifier(sb, dbFieldName);
            sb.append(" = source.");
            this.dialect.quoteIdentifier(sb, dbFieldName);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(" WHEN NOT MATCHED THEN INSERT ");
        this.appendFieldNames(sb, this.jdbcTable.dbFieldNames());
        sb.append(" VALUES");
        this.appendSourceFieldNames(sb, this.jdbcTable.dbFieldNames());
        sb.append(";");
    }

    void appendPrimaryKeys(StringBuilder sb) {
        List<String> pkFields = this.jdbcTable.getPrimaryKeyList();
        for (int i = 0; i < pkFields.size(); ++i) {
            String field = pkFields.get(i);
            this.dialect.quoteIdentifier(sb, this.jdbcTable.getExternalNameList());
            sb.append(".");
            this.dialect.quoteIdentifier(sb, field);
            sb.append(" = source.");
            this.dialect.quoteIdentifier(sb, field);
            if (i >= pkFields.size() - 1) continue;
            sb.append(" AND ");
        }
    }

    void appendSourceFieldNames(StringBuilder sb, List<String> fieldNames) {
        sb.append('(');
        Iterator<String> it = fieldNames.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            sb.append("source.");
            this.dialect.quoteIdentifier(sb, fieldName);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }

    @Override
    protected void appendFieldNames(StringBuilder sb, List<String> fieldNames) {
        sb.append('(');
        Iterator<String> it = fieldNames.iterator();
        while (it.hasNext()) {
            String fieldName = it.next();
            this.dialect.quoteIdentifier(sb, fieldName);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }

    @Override
    protected void appendValues(StringBuilder sb, int count) {
        sb.append('(');
        for (int i = 0; i < count; ++i) {
            sb.append('?');
            if (i >= count - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
    }
}

