/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import java.util.Arrays;
import java.util.Iterator;

class InsertQueryBuilder {
    private final String query;

    InsertQueryBuilder(JdbcTable jdbcTable, SqlDialect dialect) {
        StringBuilder sb = new StringBuilder().append("INSERT INTO ");
        dialect.quoteIdentifier(sb, Arrays.asList(jdbcTable.getExternalName()));
        sb.append(" ( ");
        Iterator<String> it = jdbcTable.dbFieldNames().iterator();
        while (it.hasNext()) {
            String dbFieldName = it.next();
            dialect.quoteIdentifier(sb, dbFieldName);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(" ) ").append(" VALUES (");
        for (int i = 0; i < jdbcTable.dbFieldNames().size(); ++i) {
            sb.append('?');
            if (i >= jdbcTable.dbFieldNames().size() - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        this.query = sb.toString();
    }

    String query() {
        return this.query;
    }
}

