/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Locale;

public class DefaultTypeResolver {
    private DefaultTypeResolver() {
    }

    public static QueryDataType resolveType(String columnTypeName, int precision, int scale) {
        switch (columnTypeName.toUpperCase(Locale.ROOT)) {
            case "BOOLEAN": 
            case "BOOL": 
            case "BIT": {
                return QueryDataType.BOOLEAN;
            }
            case "VARCHAR": 
            case "CHARACTER VARYING": 
            case "TEXT": 
            case "VARCHAR2": 
            case "CHAR": 
            case "CHARACTER": {
                return QueryDataType.VARCHAR;
            }
            case "TINYINT": {
                return QueryDataType.TINYINT;
            }
            case "SMALLINT": 
            case "INT2": {
                return QueryDataType.SMALLINT;
            }
            case "INT": 
            case "INT4": 
            case "INTEGER": {
                return QueryDataType.INT;
            }
            case "INT8": 
            case "BIGINT": {
                return QueryDataType.BIGINT;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                return QueryDataType.DECIMAL;
            }
            case "REAL": 
            case "FLOAT": 
            case "FLOAT4": {
                return QueryDataType.REAL;
            }
            case "DOUBLE": 
            case "DOUBLE PRECISION": 
            case "FLOAT8": {
                return QueryDataType.DOUBLE;
            }
            case "DATE": {
                return QueryDataType.DATE;
            }
            case "TIME": {
                return QueryDataType.TIME;
            }
            case "TIMESTAMP": 
            case "DATETIME": 
            case "TIMESTAMP(6)": {
                return QueryDataType.TIMESTAMP;
            }
            case "TIMESTAMP WITH TIME ZONE": 
            case "DATETIMEOFFSET": 
            case "TIMESTAMP(6) WITH TIME ZONE": {
                return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            }
            case "NULL": {
                return QueryDataType.NULL;
            }
        }
        throw new IllegalArgumentException("Unsupported column type: " + columnTypeName);
    }
}

