/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.SingleIntRow;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SeriesTable
extends JetTable {
    private final List<Expression<?>> argumentExpressions;

    SeriesTable(SqlConnector sqlConnector, List<TableField> fields, String schemaName, String name, List<Expression<?>> argumentExpressions) {
        super(sqlConnector, fields, schemaName, name, new ConstantTableStatistics(0L), null, false);
        this.argumentExpressions = argumentExpressions;
    }

    BatchSource<JetSqlRow> items(@Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections) {
        List<Expression<?>> argumentExpressions = this.argumentExpressions;
        return SourceBuilder.batch((String)"series", (FunctionEx & Serializable)ctx -> {
            ExpressionEvalContext evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)ctx);
            Integer start = SeriesTable.evaluate((Expression)argumentExpressions.get(0), null, evalContext);
            Integer stop = SeriesTable.evaluate((Expression)argumentExpressions.get(1), null, evalContext);
            Integer step = SeriesTable.evaluate((Expression)argumentExpressions.get(2), 1, evalContext);
            if (start == null || stop == null || step == null) {
                throw QueryException.error((String)"Invalid argument of a call to function GENERATE_SERIES - null argument(s)");
            }
            if (step == 0) {
                throw QueryException.error((String)"Invalid argument of a call to function GENERATE_SERIES - step cannot be equal to zero");
            }
            return new DataGenerator(start, stop, step, predicate, projections, evalContext);
        }).fillBufferFn(DataGenerator::fillBuffer).build();
    }

    private static Integer evaluate(Expression<?> argumentExpression, Integer defaultValue, ExpressionEvalContext evalContext) {
        if (argumentExpression == null) {
            return defaultValue;
        }
        Integer value = (Integer)argumentExpression.eval(EmptyRow.INSTANCE, evalContext);
        return value == null ? defaultValue : value;
    }

    @Override
    public PlanObjectKey getObjectKey() {
        return null;
    }

    private static final class DataGenerator {
        private static final int MAX_BATCH_SIZE = 1024;
        private final Iterator<JetSqlRow> iterator;

        private DataGenerator(int start, int stop, int step, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections, @Nonnull ExpressionEvalContext evalContext) {
            this.iterator = IntStream.iterate(start, i -> i + step).limit(DataGenerator.numberOfItems(start, stop, step)).mapToObj(i -> ExpressionUtil.projection(predicate, projections, new SingleIntRow(i), evalContext)).filter(Objects::nonNull).iterator();
        }

        private void fillBuffer(SourceBuilder.SourceBuffer<JetSqlRow> buffer) {
            for (int i = 0; i < 1024; ++i) {
                if (this.iterator.hasNext()) {
                    buffer.add((Object)this.iterator.next());
                    continue;
                }
                buffer.close();
            }
        }

        private static long numberOfItems(int start, int stop, int step) {
            if (start <= stop) {
                return step < 0 ? 0L : ((long)stop - (long)start) / (long)step + 1L;
            }
            return step > 0 ? 0L : ((long)start - (long)stop) / (long)(-step) + 1L;
        }
    }
}

