/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.FileSourceBuilder;
import com.hazelcast.jet.pipeline.file.FileSources;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

class ProcessorMetaSupplierProvider
implements Supplier<ProcessorMetaSupplier> {
    private final Map<String, ?> options;
    private final FileFormat<?> format;

    ProcessorMetaSupplierProvider(Map<String, ?> options, FileFormat<?> format) {
        this.options = options;
        this.format = format;
    }

    @Override
    public ProcessorMetaSupplier get() {
        String ignoreFileNotFound;
        String sharedFileSystem;
        FileSourceBuilder builder = FileSources.files((String)((String)this.options.get("path"))).format(this.format);
        String glob = (String)this.options.get("glob");
        if (glob != null) {
            builder.glob(glob);
        }
        if ((sharedFileSystem = (String)this.options.get("sharedFileSystem")) != null) {
            builder.sharedFileSystem(Boolean.parseBoolean(sharedFileSystem));
        }
        if ((ignoreFileNotFound = (String)this.options.get("ignoreFileNotFound")) != null) {
            builder.ignoreFileNotFound(Boolean.parseBoolean(ignoreFileNotFound));
        }
        for (Map.Entry<String, ?> entry : this.options.entrySet()) {
            String key = entry.getKey();
            if ("path".equals(key) || "glob".equals(key) || "sharedFileSystem".equals(key) || "ignoreFileNotFound".equals(key)) continue;
            Object value = entry.getValue();
            if (value instanceof String) {
                builder.option(key, (String)value);
                continue;
            }
            if (value instanceof Map) {
                for (Map.Entry option : ((Map)value).entrySet()) {
                    builder.option((String)option.getKey(), (String)option.getValue());
                }
                continue;
            }
            throw new IllegalArgumentException("Unexpected option type: " + String.valueOf(value.getClass()));
        }
        return builder.buildMetaSupplier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorMetaSupplierProvider that = (ProcessorMetaSupplierProvider)o;
        return Objects.equals(this.options, that.options) && Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.format);
    }
}

