/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.jet.sql.impl.expression.json.JsonCreationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.util.ArrayList;

public class JsonObjectAggAggregation
implements SqlAggregation {
    private final ArrayList<Pair<Object, Object>> keyValues = new ArrayList();
    private int keyIndex;
    private int valueIndex;
    private boolean isAbsentOnNull;

    public JsonObjectAggAggregation() {
    }

    public JsonObjectAggAggregation(int keyIndex, int valueIndex, boolean isAbsentOnNull) {
        this.keyIndex = keyIndex;
        this.valueIndex = valueIndex;
        this.isAbsentOnNull = isAbsentOnNull;
    }

    @Override
    public void accumulate(Object value) {
        JetSqlRow row = (JetSqlRow)value;
        Pair<Object, Object> pair = new Pair<Object, Object>(row.get(this.keyIndex), row.get(this.valueIndex));
        if (pair.getKey() == null) {
            throw QueryException.error((String)"NULL key is not supported for JSON_OBJECTAGG");
        }
        this.keyValues.add(pair);
    }

    @Override
    public void combine(SqlAggregation other) {
        JsonObjectAggAggregation other0 = (JsonObjectAggAggregation)other;
        this.keyValues.addAll(other0.keyValues);
    }

    @Override
    public Object collect() {
        StringBuilder sb = new StringBuilder();
        boolean firstValue = true;
        sb.append("{");
        for (Pair<Object, Object> pair : this.keyValues) {
            Object value = pair.getValue();
            if (value == null && this.isAbsentOnNull) continue;
            if (firstValue) {
                firstValue = false;
            } else {
                sb.append(",");
            }
            sb.append(JsonCreationUtil.serializeValue(pair.getKey()));
            sb.append(":");
            sb.append(JsonCreationUtil.serializeValue(value));
        }
        sb.append("}");
        if (firstValue) {
            return null;
        }
        return new HazelcastJsonValue(sb.toString());
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.keyIndex);
        out.writeInt(this.valueIndex);
        out.writeBoolean(this.isAbsentOnNull);
        out.writeInt(this.keyValues.size());
        for (Pair<Object, Object> entry : this.keyValues) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.keyIndex = in.readInt();
        this.valueIndex = in.readInt();
        this.isAbsentOnNull = in.readBoolean();
        int size = in.readInt();
        this.keyValues.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.keyValues.add(new Pair<Object, Object>(key, value));
        }
    }
}

