/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastTypeUtils {
    private static final Map<SqlTypeName, QueryDataType> CALCITE_TO_HZ = new HashMap<SqlTypeName, QueryDataType>();
    private static final Map<QueryDataTypeFamily, SqlTypeName> HZ_TO_CALCITE = new HashMap<QueryDataTypeFamily, SqlTypeName>();

    private HazelcastTypeUtils() {
    }

    public static SqlTypeName toCalciteType(QueryDataType type) {
        return HazelcastTypeUtils.toCalciteType(type.getTypeFamily());
    }

    public static SqlTypeName toCalciteType(QueryDataTypeFamily typeFamily) {
        return HZ_TO_CALCITE.get(typeFamily);
    }

    public static QueryDataType toHazelcastType(SqlTypeName sqlTypeName) {
        QueryDataType queryDataType = CALCITE_TO_HZ.get(sqlTypeName);
        if (queryDataType == null) {
            throw new IllegalArgumentException("unexpected SQL type: " + sqlTypeName);
        }
        return queryDataType;
    }

    public static RelDataType createType(RelDataTypeFactory typeFactory, SqlTypeName typeName, boolean nullable) {
        RelDataType type = typeFactory.createSqlType(typeName);
        if (nullable) {
            type = HazelcastTypeUtils.createNullableType(typeFactory, type);
        }
        return type;
    }

    public static RelDataType createNullableType(RelDataTypeFactory typeFactory, RelDataType type) {
        if (!type.isNullable()) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    }

    public static boolean isObjectIdentifier(SqlIdentifier identifier) {
        return identifier.isSimple() && SqlColumnType.OBJECT.name().equalsIgnoreCase(identifier.getSimple());
    }

    public static boolean isTimestampWithTimeZoneIdentifier(SqlIdentifier identifier) {
        return identifier.isSimple() && SqlColumnType.TIMESTAMP_WITH_TIME_ZONE.name().equalsIgnoreCase(identifier.getSimple());
    }

    public static boolean isNumericType(RelDataType type) {
        return HazelcastTypeUtils.isNumericType(type.getSqlTypeName());
    }

    public static boolean isNumericType(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericIntegerType(RelDataType type) {
        return HazelcastTypeUtils.isNumericIntegerType(type.getSqlTypeName());
    }

    public static boolean isNumericIntegerType(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericInexactType(RelDataType type) {
        return HazelcastTypeUtils.isNumericInexactType(type.getSqlTypeName());
    }

    public static boolean isNumericInexactType(SqlTypeName typeName) {
        switch (typeName) {
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static RelDataType withHigherPrecedence(RelDataType type1, RelDataType type2) {
        int precedence1 = HazelcastTypeUtils.precedenceOf(type1);
        int precedence2 = HazelcastTypeUtils.precedenceOf(type2);
        assert (precedence1 != precedence2 || type1.getSqlTypeName() == type2.getSqlTypeName());
        if (precedence1 == precedence2 && HazelcastTypeUtils.isNumericIntegerType(type1) && HazelcastTypeUtils.isNumericIntegerType(type2)) {
            int bitWidth2;
            int bitWidth1 = ((HazelcastIntegerType)type1).getBitWidth();
            return bitWidth1 > (bitWidth2 = ((HazelcastIntegerType)type2).getBitWidth()) ? type1 : type2;
        }
        return precedence1 > precedence2 ? type1 : type2;
    }

    private static int precedenceOf(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (SqlTypeName.YEAR_INTERVAL_TYPES.contains(typeName)) {
            typeName = SqlTypeName.INTERVAL_YEAR_MONTH;
        } else if (SqlTypeName.DAY_INTERVAL_TYPES.contains(typeName)) {
            typeName = SqlTypeName.INTERVAL_DAY_SECOND;
        }
        QueryDataType hzType = HazelcastTypeUtils.toHazelcastType(typeName);
        return hzType.getTypeFamily().getPrecedence();
    }

    public static boolean canCast(RelDataType sourceType, RelDataType targetType) {
        if (targetType.equals(sourceType)) {
            return true;
        }
        if (sourceType.isStruct() || targetType.isStruct()) {
            if (sourceType.getSqlTypeName() != SqlTypeName.ROW) {
                throw new IllegalArgumentException("Unexpected source type: " + sourceType);
            }
            if (targetType.getSqlTypeName() != SqlTypeName.ROW) {
                throw new IllegalArgumentException("Unexpected target type: " + targetType);
            }
            int n = targetType.getFieldCount();
            if (sourceType.getFieldCount() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                RelDataTypeField toField = (RelDataTypeField)targetType.getFieldList().get(i);
                RelDataTypeField fromField = (RelDataTypeField)sourceType.getFieldList().get(i);
                if (HazelcastTypeUtils.canCast(toField.getType(), fromField.getType())) continue;
                return false;
            }
            return true;
        }
        QueryDataType queryFrom = HazelcastTypeUtils.toHazelcastType(sourceType.getSqlTypeName());
        QueryDataType queryTo = HazelcastTypeUtils.toHazelcastType(targetType.getSqlTypeName());
        return queryFrom.getConverter().canConvertTo(queryTo.getTypeFamily());
    }

    static {
        HZ_TO_CALCITE.put(QueryDataTypeFamily.VARCHAR, SqlTypeName.VARCHAR);
        CALCITE_TO_HZ.put(SqlTypeName.VARCHAR, QueryDataType.VARCHAR);
        CALCITE_TO_HZ.put(SqlTypeName.CHAR, QueryDataType.VARCHAR);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.BOOLEAN, SqlTypeName.BOOLEAN);
        CALCITE_TO_HZ.put(SqlTypeName.BOOLEAN, QueryDataType.BOOLEAN);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TINYINT, SqlTypeName.TINYINT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.SMALLINT, SqlTypeName.SMALLINT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.INTEGER, SqlTypeName.INTEGER);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.BIGINT, SqlTypeName.BIGINT);
        CALCITE_TO_HZ.put(SqlTypeName.TINYINT, QueryDataType.TINYINT);
        CALCITE_TO_HZ.put(SqlTypeName.SMALLINT, QueryDataType.SMALLINT);
        CALCITE_TO_HZ.put(SqlTypeName.INTEGER, QueryDataType.INT);
        CALCITE_TO_HZ.put(SqlTypeName.BIGINT, QueryDataType.BIGINT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.DECIMAL, SqlTypeName.DECIMAL);
        CALCITE_TO_HZ.put(SqlTypeName.DECIMAL, QueryDataType.DECIMAL);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.REAL, SqlTypeName.REAL);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.DOUBLE, SqlTypeName.DOUBLE);
        CALCITE_TO_HZ.put(SqlTypeName.REAL, QueryDataType.REAL);
        CALCITE_TO_HZ.put(SqlTypeName.DOUBLE, QueryDataType.DOUBLE);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TIME, SqlTypeName.TIME);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.DATE, SqlTypeName.DATE);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TIMESTAMP, SqlTypeName.TIMESTAMP);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        CALCITE_TO_HZ.put(SqlTypeName.TIME, QueryDataType.TIME);
        CALCITE_TO_HZ.put(SqlTypeName.DATE, QueryDataType.DATE);
        CALCITE_TO_HZ.put(SqlTypeName.TIMESTAMP, QueryDataType.TIMESTAMP);
        CALCITE_TO_HZ.put(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.OBJECT, SqlTypeName.ANY);
        CALCITE_TO_HZ.put(SqlTypeName.ANY, QueryDataType.OBJECT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.NULL, SqlTypeName.NULL);
        CALCITE_TO_HZ.put(SqlTypeName.NULL, QueryDataType.NULL);
    }
}

