/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBindingSignatureErrorAware;
import com.hazelcast.sql.impl.calcite.validate.HazelcastResources;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collection;
import java.util.StringJoiner;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class HazelcastCallBinding
extends SqlCallBinding {
    public HazelcastCallBinding(SqlCallBinding binding) {
        super(binding.getValidator(), binding.getScope(), binding.getCall());
    }

    public HazelcastSqlValidator getValidator() {
        return (HazelcastSqlValidator)super.getValidator();
    }

    public CalciteException newValidationSignatureError() {
        Resources.ExInst<SqlValidatorException> error;
        SqlOperator operator = this.getOperator();
        HazelcastSqlValidator validator = this.getValidator();
        SqlCall call = this.getCall();
        String operandTypes = HazelcastCallBinding.getOperandTypes((SqlValidator)validator, call, this.getScope());
        String operatorName = '\'' + operator.getName() + '\'';
        switch (operator.getSyntax()) {
            case FUNCTION: 
            case FUNCTION_STAR: 
            case FUNCTION_ID: {
                error = HazelcastResources.RESOURCES.invalidFunctionOperands(operatorName, operandTypes);
                break;
            }
            default: {
                error = HazelcastResources.RESOURCES.invalidOperatorOperands(operatorName, operandTypes);
            }
        }
        return validator.newValidationError((SqlNode)call, error);
    }

    private static String getOperandTypes(SqlValidator validator, SqlCall call, SqlValidatorScope scope) {
        StringJoiner res = new StringJoiner(", ", "[", "]");
        for (SqlNode operand : HazelcastCallBinding.getOperands(call)) {
            String typeName;
            RelDataType calciteType = validator.deriveType(scope, operand);
            if (calciteType.getSqlTypeName() == SqlTypeName.NULL) {
                typeName = validator.getUnknownType().toString();
            } else {
                QueryDataType hazelcastType = HazelcastTypeUtils.toHazelcastType(calciteType.getSqlTypeName());
                typeName = hazelcastType.getTypeFamily().getPublicType().name();
            }
            res.add(typeName);
        }
        return res.toString();
    }

    private static Collection<SqlNode> getOperands(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (operator instanceof HazelcastCallBindingSignatureErrorAware) {
            return ((HazelcastCallBindingSignatureErrorAware)operator).getOperandsForSignatureError(call);
        }
        return call.getOperandList();
    }
}

