/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.param;

import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import org.apache.calcite.sql.parser.SqlParserPos;

public abstract class AbstractParameterConverter
implements ParameterConverter {
    protected final int ordinal;
    protected final SqlParserPos parserPos;
    protected final QueryDataType targetType;

    protected AbstractParameterConverter(int ordinal, SqlParserPos parserPos, QueryDataType targetType) {
        this.ordinal = ordinal;
        this.parserPos = parserPos;
        this.targetType = targetType;
    }

    public QueryDataType getTargetType() {
        return this.targetType;
    }

    public final Object convert(Object value) {
        if (value == null) {
            return null;
        }
        Converter valueConverter = Converters.getConverter(value.getClass());
        if (!this.isValid(value, valueConverter)) {
            String actualTypeName = valueConverter.getTypeFamily().getPublicType().name();
            String targetTypeName = this.targetType.getTypeFamily().getPublicType().name();
            String error = String.format("Parameter at position %d must be of %s type, but %s was found (consider adding an explicit CAST)", this.ordinal, targetTypeName, actualTypeName);
            throw QueryException.error((int)2000, (String)this.withContext(error));
        }
        try {
            return this.targetType.getConverter().convertToSelf(valueConverter, value);
        }
        catch (Exception e) {
            String error = String.format("Failed to convert parameter at position %d from %s to %s: %s", this.ordinal, valueConverter.getTypeFamily().getPublicType(), this.targetType.getConverter().getTypeFamily().getPublicType(), e.getMessage());
            throw QueryException.error((int)2000, (String)this.withContext(error), (Throwable)e);
        }
    }

    protected abstract boolean isValid(Object var1, Converter var2);

    private String withContext(String message) {
        int line = this.parserPos.getLineNum();
        int col = this.parserPos.getColumnNum();
        int endLine = this.parserPos.getEndLineNum();
        int endCol = this.parserPos.getEndColumnNum();
        String context = line == endLine && col == endCol ? String.format("At line %d, column %d", line, col) : String.format("From line %d, column %d to line %d, column %d", line, col, endLine, endCol);
        return context + ": " + message;
    }
}

