/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.cost;

import org.apache.calcite.plan.RelOptCost;

public class Cost
implements RelOptCost {
    public static final Cost ZERO = new Cost(0.0, 0.0, 0.0);
    public static final Cost TINY = new Cost(1.0, 1.0, 0.0);
    public static final Cost HUGE = new Cost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    public static final Cost INFINITY = new Cost(Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final double rows;
    private final double cpu;
    private final double network;

    Cost(double rows, double cpu, double network) {
        this.rows = rows;
        this.cpu = cpu;
        this.network = network;
    }

    public double getRowsInternal() {
        return this.rows;
    }

    public double getCpuInternal() {
        return this.cpu;
    }

    public double getNetworkInternal() {
        return this.network;
    }

    public double getRows() {
        throw new UnsupportedOperationException("Should not be called.");
    }

    public double getCpu() {
        throw new UnsupportedOperationException("Should not be called.");
    }

    public double getIo() {
        throw new UnsupportedOperationException("Should not be called.");
    }

    public boolean isInfinite() {
        return this.cpu == Double.POSITIVE_INFINITY || this.network == Double.POSITIVE_INFINITY;
    }

    public boolean isEqWithEpsilon(RelOptCost other) {
        if (!(other instanceof Cost)) {
            return false;
        }
        Cost other0 = (Cost)other;
        if (this.isInfinite() || other0.isInfinite()) {
            return false;
        }
        if (this == other0) {
            return true;
        }
        return Math.abs(this.getValue() - other0.getValue()) < 1.0E-5;
    }

    public boolean isLe(RelOptCost other) {
        Cost other0 = (Cost)other;
        if (this.equals(other0)) {
            return true;
        }
        return this.getValue() <= other0.getValue();
    }

    public boolean isLt(RelOptCost other) {
        return this.isLe(other) && !this.equals(other);
    }

    public Cost plus(RelOptCost other) {
        Cost other0 = (Cost)other;
        if (this.isInfinite() || other.isInfinite()) {
            return INFINITY;
        }
        return new Cost(this.rows + other0.rows, this.cpu + other0.cpu, this.network + other0.network);
    }

    public RelOptCost minus(RelOptCost other) {
        throw new UnsupportedOperationException("Should not be called.");
    }

    public Cost multiplyBy(double factor) {
        if (this.isInfinite()) {
            return INFINITY;
        }
        return new Cost(this.rows * factor, this.cpu * factor, this.network * factor);
    }

    public double divideBy(RelOptCost cost) {
        throw new UnsupportedOperationException("Should not be called.");
    }

    private double getValue() {
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.cpu * 1.0 + this.network * 10.0;
    }

    public int hashCode() {
        int res = Double.hashCode(this.rows);
        res += 31 * Double.hashCode(this.cpu);
        return res += 31 * Double.hashCode(this.network);
    }

    public boolean equals(Object other) {
        if (other instanceof Cost) {
            return this.equals((RelOptCost)other);
        }
        return false;
    }

    public boolean equals(RelOptCost other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Cost)) {
            return false;
        }
        Cost other0 = (Cost)other;
        return Double.compare(other0.rows, this.rows) == 0 && Double.compare(other0.cpu, this.cpu) == 0 && Double.compare(other0.network, this.network) == 0;
    }

    public String toString() {
        String content = this.equals(INFINITY) ? "infinity" : (this.equals(HUGE) ? "huge" : (this.equals(TINY) ? "tiny" : (this.equals(ZERO) ? "zero" : "rows=" + this.rows + ", cpu=" + this.cpu + ", network=" + this.network)));
        return this.getClass().getSimpleName() + '{' + content + '}';
    }
}

