/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.string;

import com.google.common.collect.ImmutableList;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastFunction;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastSubstringFunction
extends HazelcastFunction {
    public static final HazelcastSubstringFunction INSTANCE = new HazelcastSubstringFunction();

    private HazelcastSubstringFunction() {
        super("SUBSTRING", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, new ReplaceUnknownOperandTypeInference(new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.INTEGER}), SqlFunctionCategory.STRING);
    }

    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} FROM {2})";
            }
            case 3: {
                return "{0}({1} FROM {2} FOR {3})";
            }
        }
        throw new AssertionError();
    }

    public String getAllowedSignatures(String opName) {
        StringBuilder ret = new StringBuilder();
        for (Ord typeName : Ord.zip((List)SqlTypeName.CHAR_TYPES)) {
            if (typeName.i > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature((SqlOperator)this, (String)opName, (List)ImmutableList.of((Object)typeName.e, (Object)SqlTypeName.INTEGER)));
            ret.append(NL);
            ret.append(SqlUtil.getAliasedSignature((SqlOperator)this, (String)opName, (List)ImmutableList.of((Object)typeName.e, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER)));
        }
        return ret.toString();
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between((int)2, (int)3);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (binding.getOperandCount() == 2) {
            return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.INTEGER).check(binding, throwOnFailure);
        }
        assert (binding.getOperandCount() == 3);
        return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.INTEGER, TypedOperandChecker.INTEGER).check(binding, throwOnFailure);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        call.operand(0).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        call.operand(1).unparse(writer, leftPrec, rightPrec);
        if (call.operandCount() == 3) {
            writer.sep("FOR");
            call.operand(2).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }
}

