/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operand;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;

public final class NumericOperandChecker
implements OperandChecker {
    public static final NumericOperandChecker INSTANCE = new NumericOperandChecker();

    private NumericOperandChecker() {
    }

    @Override
    public boolean check(HazelcastCallBinding binding, boolean throwOnFailure, int index) {
        SqlNode operand = binding.getCall().operand(index);
        RelDataType operandType = binding.getValidator().deriveType(binding.getScope(), operand);
        TypedOperandChecker checker = NumericOperandChecker.checkerForTypeName(operandType.getSqlTypeName());
        if (checker != null) {
            return checker.check(binding, throwOnFailure, index);
        }
        if (throwOnFailure) {
            throw binding.newValidationSignatureError();
        }
        return false;
    }

    private static TypedOperandChecker checkerForTypeName(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: {
                return TypedOperandChecker.TINYINT;
            }
            case SMALLINT: {
                return TypedOperandChecker.SMALLINT;
            }
            case INTEGER: {
                return TypedOperandChecker.INTEGER;
            }
            case BIGINT: {
                return TypedOperandChecker.BIGINT;
            }
            case DECIMAL: {
                return TypedOperandChecker.DECIMAL;
            }
            case REAL: 
            case FLOAT: {
                return TypedOperandChecker.REAL;
            }
            case DOUBLE: {
                return TypedOperandChecker.DOUBLE;
            }
        }
        return null;
    }
}

