/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical.visitor;

import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.RexToExpression;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ParameterExpression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;

public final class RexToExpressionVisitor
implements RexVisitor<Expression<?>> {
    private static final Expression<?>[] EMPTY_EXPRESSION_OPERANDS = new Expression[0];
    private final PlanNodeFieldTypeProvider fieldTypeProvider;
    private final QueryParameterMetadata parameterMetadata;

    public RexToExpressionVisitor(PlanNodeFieldTypeProvider fieldTypeProvider, QueryParameterMetadata parameterMetadata) {
        this.fieldTypeProvider = fieldTypeProvider;
        this.parameterMetadata = parameterMetadata;
    }

    public Expression<?> visitInputRef(RexInputRef inputRef) {
        int index = inputRef.getIndex();
        return ColumnExpression.create((int)index, (QueryDataType)this.fieldTypeProvider.getType(index));
    }

    public Expression<?> visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitLiteral(RexLiteral literal) {
        return RexToExpression.convertLiteral(literal);
    }

    public Expression<?> visitCall(RexCall call) {
        Expression<?>[] expressionOperands;
        List rexOperands = call.getOperands();
        if (rexOperands == null || rexOperands.isEmpty()) {
            expressionOperands = EMPTY_EXPRESSION_OPERANDS;
        } else {
            expressionOperands = new Expression[rexOperands.size()];
            for (int i = 0; i < rexOperands.size(); ++i) {
                Expression expressionOperand;
                expressionOperands[i] = expressionOperand = (Expression)((RexNode)rexOperands.get(i)).accept((RexVisitor)this);
            }
        }
        return RexToExpression.convertCall(call, expressionOperands);
    }

    public Expression<?> visitOver(RexOver over) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitDynamicParam(RexDynamicParam dynamicParam) {
        int index = dynamicParam.getIndex();
        return ParameterExpression.create((int)index, (QueryDataType)this.parameterMetadata.getParameterConverter(index).getTargetType());
    }

    public Expression<?> visitRangeRef(RexRangeRef rangeRef) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitFieldAccess(RexFieldAccess fieldAccess) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitSubQuery(RexSubQuery subQuery) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitTableInputRef(RexTableInputRef fieldRef) {
        throw new UnsupportedOperationException();
    }

    public Expression<?> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        throw new UnsupportedOperationException();
    }
}

