/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerTypeNameSpec;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.List;
import java.util.function.Consumer;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;

public final class HazelcastTypeCoercion
extends TypeCoercionImpl {
    public HazelcastTypeCoercion(HazelcastSqlValidator validator) {
        super((RelDataTypeFactory)HazelcastTypeFactory.INSTANCE, (SqlValidator)validator);
    }

    public boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int index, RelDataType targetType) {
        SqlNode operand = (SqlNode)call.getOperandList().get(index);
        return this.coerceNode(scope, operand, targetType, cast -> call.setOperand(index, cast));
    }

    private boolean coerceNode(SqlValidatorScope scope, SqlNode node, RelDataType targetType, Consumer<SqlNode> replaceFn) {
        if (!this.requiresCast(scope, node, targetType)) {
            this.updateInferredType(node, targetType);
            return false;
        }
        SqlDataTypeSpec targetTypeSpec = targetType instanceof HazelcastIntegerType ? new SqlDataTypeSpec((SqlTypeNameSpec)new HazelcastIntegerTypeNameSpec((HazelcastIntegerType)targetType), SqlParserPos.ZERO) : SqlTypeUtil.convertTypeToSpec((RelDataType)targetType);
        SqlCall cast = HazelcastSqlOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{node, targetTypeSpec});
        replaceFn.accept((SqlNode)cast);
        this.validator.deriveType(scope, (SqlNode)cast);
        return true;
    }

    protected boolean coerceColumnType(SqlValidatorScope scope, SqlNodeList nodeList, int index, RelDataType targetType) {
        throw new UnsupportedOperationException("Should not be called");
    }

    private boolean requiresCast(SqlValidatorScope scope, SqlNode node, RelDataType to) {
        RelDataType from = this.validator.deriveType(scope, node);
        if (from.getSqlTypeName() == SqlTypeName.NULL || SqlUtil.isNullLiteral((SqlNode)node, (boolean)false) || node.getKind() == SqlKind.DYNAMIC_PARAM) {
            return false;
        }
        return from.getSqlTypeName() != to.getSqlTypeName();
    }

    public boolean binaryArithmeticCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean binaryComparisonCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean rowTypeCoercion(SqlValidatorScope scope, SqlNode query, int columnIndex, RelDataType targetType) {
        switch (query.getKind()) {
            case SELECT: {
                SqlSelect selectNode = (SqlSelect)query;
                SqlValidatorScope scope1 = this.validator.getSelectScope(selectNode);
                if (!this.rowTypeElementCoercion(scope1, selectNode.getSelectList().get(columnIndex), targetType, newNode -> selectNode.getSelectList().set(columnIndex, newNode))) {
                    return false;
                }
                this.updateInferredColumnType(scope1, query, columnIndex, targetType);
                return true;
            }
            case VALUES: {
                for (SqlNode rowConstructor : ((SqlCall)query).getOperandList()) {
                    if (this.rowTypeElementCoercion(scope, ((SqlCall)rowConstructor).operand(columnIndex), targetType, newNode -> ((SqlCall)rowConstructor).setOperand(columnIndex, newNode))) continue;
                    return false;
                }
                this.updateInferredColumnType(scope, query, columnIndex, targetType);
                return true;
            }
        }
        throw new UnsupportedOperationException("unexpected: " + query.getKind());
    }

    private boolean rowTypeElementCoercion(SqlValidatorScope scope, SqlNode rowElement, RelDataType targetType, Consumer<SqlNode> replaceFn) {
        boolean valid;
        RelDataType sourceType = this.validator.deriveType(scope, rowElement);
        QueryDataType sourceHzType = HazelcastTypeUtils.toHazelcastType(sourceType.getSqlTypeName());
        QueryDataType targetHzType = HazelcastTypeUtils.toHazelcastType(targetType.getSqlTypeName());
        if (sourceHzType.getTypeFamily() == targetHzType.getTypeFamily()) {
            return true;
        }
        boolean bl = valid = HazelcastTypeCoercion.sourceAndTargetAreNumeric(targetHzType, sourceHzType) || HazelcastTypeCoercion.sourceAndTargetAreTemporalAndSourceCanBeConvertedToTarget(targetHzType, sourceHzType) || HazelcastTypeCoercion.targetIsTemporalAndSourceIsVarcharLiteral(targetHzType, sourceHzType, rowElement);
        if (!valid) {
            return false;
        }
        this.coerceNode(scope, rowElement, targetType, replaceFn);
        return true;
    }

    private static boolean sourceAndTargetAreNumeric(QueryDataType highHZType, QueryDataType lowHZType) {
        return highHZType.getTypeFamily().isNumeric() && lowHZType.getTypeFamily().isNumeric();
    }

    private static boolean sourceAndTargetAreTemporalAndSourceCanBeConvertedToTarget(QueryDataType targetHzType, QueryDataType sourceHzType) {
        return targetHzType.getTypeFamily().isTemporal() && sourceHzType.getTypeFamily().isTemporal() && sourceHzType.getConverter().canConvertTo(targetHzType.getTypeFamily());
    }

    private static boolean targetIsTemporalAndSourceIsVarcharLiteral(QueryDataType targetHzType, QueryDataType sourceHzType, SqlNode sourceNode) {
        return targetHzType.getTypeFamily().isTemporal() && sourceHzType.getTypeFamily() == QueryDataTypeFamily.VARCHAR && sourceNode instanceof SqlLiteral;
    }

    public boolean caseWhenCoercion(SqlCallBinding callBinding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean inOperationCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean builtinFunctionCoercion(SqlCallBinding binding, List<RelDataType> operandTypes, List<SqlTypeFamily> expectedFamilies) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean userDefinedFunctionCoercion(SqlValidatorScope scope, SqlCall call, SqlFunction function) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean querySourceCoercion(SqlValidatorScope scope, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        RelDataType targetType;
        List sourceFields = sourceRowType.getFieldList();
        List targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            RelDataType sourceType = ((RelDataTypeField)sourceFields.get(i)).getType();
            targetType = ((RelDataTypeField)targetFields.get(i)).getType();
            if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.validator.getTypeFactory(), (RelDataType)sourceType, (RelDataType)targetType) || HazelcastTypeUtils.canCast(sourceType, targetType)) continue;
            return false;
        }
        boolean canAssign = true;
        for (int i = 0; i < sourceFields.size() && canAssign; ++i) {
            targetType = ((RelDataTypeField)targetFields.get(i)).getType();
            canAssign = this.coerceSourceRowType(scope, query, i, targetType);
        }
        return canAssign;
    }

    private boolean coerceSourceRowType(SqlValidatorScope sourceScope, SqlNode query, int columnIndex, RelDataType targetType) {
        switch (query.getKind()) {
            case INSERT: {
                SqlInsert insert = (SqlInsert)query;
                return this.coerceSourceRowType(sourceScope, insert.getSource(), columnIndex, targetType);
            }
            case UPDATE: {
                SqlUpdate update = (SqlUpdate)query;
                if (update.getSourceExpressionList() != null) {
                    SqlNodeList sourceExpressionList = update.getSourceExpressionList();
                    return this.coerceColumnType(sourceScope, sourceExpressionList, columnIndex, targetType);
                }
                return this.coerceSourceRowType(sourceScope, (SqlNode)update.getSourceSelect(), columnIndex, targetType);
            }
        }
        return this.rowTypeCoercion(sourceScope, query, columnIndex, targetType);
    }
}

