/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.misc;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastPrefixOperator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastUnaryOperator
extends HazelcastPrefixOperator {
    public static final HazelcastUnaryOperator PLUS = new HazelcastUnaryOperator(SqlStdOperatorTable.UNARY_PLUS, false);
    public static final HazelcastUnaryOperator MINUS = new HazelcastUnaryOperator(SqlStdOperatorTable.UNARY_MINUS, true);
    private final boolean extend;

    private HazelcastUnaryOperator(SqlPrefixOperator base, boolean extend) {
        super(base.getName(), base.getKind(), base.getLeftPrec(), ReturnTypes.ARG0, new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT));
        this.extend = extend;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)1);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        TypedOperandChecker checker;
        Object operandType = binding.getOperandType(0);
        if (HazelcastTypeUtils.isNumericIntegerType(operandType) && this.extend) {
            int bitWidth = ((HazelcastIntegerType)((Object)operandType)).getBitWidth();
            operandType = HazelcastIntegerType.create(bitWidth + 1, operandType.isNullable());
        }
        if ((checker = TypedOperandChecker.forType(operandType)).isNumeric()) {
            return checker.check(binding, throwOnFailure, 0);
        }
        if (throwOnFailure) {
            throw binding.newValidationSignatureError();
        }
        return false;
    }
}

