/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.validate.HazelcastResources;
import com.hazelcast.sql.impl.calcite.validate.literal.Literal;
import com.hazelcast.sql.impl.calcite.validate.literal.LiteralUtils;
import com.hazelcast.sql.impl.calcite.validate.operators.HazelcastReturnTypeInference;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.util.TimeString;

public class HazelcastSqlToRelConverter
extends SqlToRelConverter {
    private final Set<SqlNode> callSet = Collections.newSetFromMap(new IdentityHashMap());

    public HazelcastSqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config config) {
        super(viewExpander, validator, catalogReader, cluster, convertletTable, config);
    }

    protected RexNode convertExtendedExpression(SqlNode node, SqlToRelConverter.Blackboard blackboard) {
        if (node.getKind() == SqlKind.LITERAL) {
            return this.convertLiteral((SqlLiteral)node);
        }
        if (node.getKind() == SqlKind.CAST) {
            return this.convertCast((SqlCall)node, blackboard);
        }
        if (node instanceof SqlCall) {
            return this.convertCall(node, blackboard);
        }
        return null;
    }

    private RexNode convertLiteral(SqlLiteral literal) {
        RelDataType type = this.validator.getValidatedNodeType((SqlNode)literal);
        return this.getRexBuilder().makeLiteral(literal.getValue(), type, true);
    }

    private RexNode convertCast(SqlCall call, SqlToRelConverter.Blackboard blackboard) {
        SqlNode operand = call.operand(0);
        RexNode convertedOperand = blackboard.convertExpression(operand);
        RelDataType from = this.validator.getValidatedNodeType(operand);
        RelDataType to = this.validator.getValidatedNodeType((SqlNode)call);
        QueryDataType fromType = HazelcastTypeUtils.toHazelcastType(from.getSqlTypeName());
        QueryDataType toType = HazelcastTypeUtils.toHazelcastType(to.getSqlTypeName());
        Literal literal = LiteralUtils.literal(operand);
        if (literal != null && literal.getTypeName() != SqlTypeName.NULL) {
            try {
                toType.getConverter().convertToSelf(fromType.getConverter(), literal.getValue());
            }
            catch (Exception e) {
                throw HazelcastSqlToRelConverter.literalConversionException(this.validator, call, literal, toType, e);
            }
            if (SqlTypeName.CHAR_TYPES.contains(to.getSqlTypeName())) {
                return this.getRexBuilder().makeLiteral((Object)literal.getStringValue(), to, true);
            }
            if (SqlTypeName.CHAR_TYPES.contains(from.getSqlTypeName()) && to.getSqlTypeName() == SqlTypeName.TIME) {
                LocalTime time = fromType.getConverter().asTime((Object)literal.getStringValue());
                TimeString timeString = new TimeString(time.getHour(), time.getMinute(), time.getSecond());
                return this.getRexBuilder().makeLiteral((Object)timeString, to, true);
            }
            if (fromType.getTypeFamily().isNumeric() && toType.getTypeFamily().isNumericApproximate()) {
                BigDecimal originalValue = (BigDecimal)((SqlLiteral)operand).getValueAs(BigDecimal.class);
                Object convertedValue = toType.getConverter().convertToSelf((Converter)BigDecimalConverter.INSTANCE, (Object)originalValue);
                return this.getRexBuilder().makeLiteral(convertedValue, to, false);
            }
        }
        return this.getRexBuilder().makeCast(to, convertedOperand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RexNode convertCall(SqlNode node, SqlToRelConverter.Blackboard blackboard) {
        if (node.getKind() == SqlKind.DEFAULT) {
            return null;
        }
        if (this.callSet.add(node)) {
            try {
                RexNode rexNode;
                RelDataType type = this.validator.getValidatedNodeType(node);
                HazelcastReturnTypeInference.push(type);
                try {
                    rexNode = blackboard.convertExpression(node);
                }
                catch (Throwable throwable) {
                    HazelcastReturnTypeInference.pop();
                    throw throwable;
                }
                HazelcastReturnTypeInference.pop();
                return rexNode;
            }
            finally {
                this.callSet.remove(node);
            }
        }
        return null;
    }

    private static QueryException literalConversionException(SqlValidator validator, SqlCall call, Literal literal, QueryDataType toType, Exception e) {
        String literalValue = literal.getStringValue();
        if (SqlTypeName.CHAR_TYPES.contains(literal.getTypeName())) {
            literalValue = "'" + literalValue + "'";
        }
        Resources.ExInst<SqlValidatorException> contextError = HazelcastResources.RESOURCES.cannotCastLiteralValue(literalValue, toType.getTypeFamily().getPublicType().name(), e.getMessage());
        CalciteContextException calciteContextError = validator.newValidationError((SqlNode)call, contextError);
        throw QueryException.error((int)1008, (String)calciteContextError.getMessage(), (Throwable)calciteContextError);
    }
}

