/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.SqlToQueryType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastTypeSystem
extends RelDataTypeSystemImpl {
    public static final RelDataTypeSystem INSTANCE = new HazelcastTypeSystem();
    public static final int MAX_DECIMAL_PRECISION = 38;
    public static final int MAX_DECIMAL_SCALE = 38;

    private HazelcastTypeSystem() {
    }

    public static boolean isObject(SqlIdentifier identifier) {
        return identifier.isSimple() && QueryDataTypeFamily.OBJECT.name().equalsIgnoreCase(identifier.getSimple());
    }

    public static boolean isTimestampWithTimeZone(SqlIdentifier identifier) {
        return identifier.isSimple() && QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE.name().equalsIgnoreCase(identifier.getSimple());
    }

    public static boolean canCast(RelDataType from, RelDataType to) {
        QueryDataType queryFrom = SqlToQueryType.map(HazelcastTypeSystem.typeName(from));
        QueryDataType queryTo = SqlToQueryType.map(HazelcastTypeSystem.typeName(to));
        return queryFrom.getConverter().canConvertTo(queryTo.getTypeFamily());
    }

    public static boolean canRepresent(SqlLiteral literal, RelDataType target) {
        if (literal.getTypeName() == target.getSqlTypeName()) {
            return true;
        }
        return HazelcastTypeSystem.canConvert(HazelcastTypeSystem.literalValue(literal), HazelcastTypeSystem.literalType(literal), target);
    }

    public static boolean canConvert(Object value, RelDataType from, RelDataType to) {
        QueryDataType queryFrom = SqlToQueryType.map(HazelcastTypeSystem.typeName(from));
        QueryDataType queryTo = SqlToQueryType.map(HazelcastTypeSystem.typeName(to));
        Converter fromConverter = queryFrom.getConverter();
        Converter toConverter = queryTo.getConverter();
        if (!fromConverter.canConvertTo(queryTo.getTypeFamily())) {
            return false;
        }
        if (value == null) {
            return true;
        }
        Converter valueConverter = Converters.getConverter(value.getClass());
        try {
            Object fromValue = fromConverter.convertToSelf(valueConverter, value);
            toConverter.convertToSelf(fromConverter, fromValue);
        }
        catch (QueryException e) {
            assert (e.getCode() == 2000);
            return false;
        }
        return true;
    }

    public static RelDataType withHigherPrecedence(RelDataType type1, RelDataType type2) {
        int precedence1 = HazelcastTypeSystem.precedenceOf(type1);
        int precedence2 = HazelcastTypeSystem.precedenceOf(type2);
        assert (precedence1 != precedence2 || type1.getSqlTypeName() == type2.getSqlTypeName());
        if (precedence1 == precedence2 && HazelcastTypeSystem.isInteger(type1) && HazelcastTypeSystem.isInteger(type2)) {
            int bitWidth2;
            int bitWidth1 = HazelcastIntegerType.bitWidthOf(type1);
            return bitWidth1 > (bitWidth2 = HazelcastIntegerType.bitWidthOf(type2)) ? type1 : type2;
        }
        return precedence1 > precedence2 ? type1 : type2;
    }

    public static RelDataType narrowestTypeFor(Number value, SqlTypeName otherType) {
        if (value instanceof BigDecimal) {
            BigDecimal decimalValue = (BigDecimal)value;
            if (decimalValue.scale() <= 0) {
                try {
                    long longValue = decimalValue.longValueExact();
                    int bitWidth = HazelcastIntegerType.bitWidthOf(longValue);
                    return HazelcastIntegerType.of(bitWidth, false);
                }
                catch (ArithmeticException e) {
                    return HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.FRACTIONAL_TYPES.contains(otherType) ? otherType : SqlTypeName.BIGINT);
                }
            }
            return HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.APPROX_TYPES.contains(otherType) ? otherType : SqlTypeName.DECIMAL);
        }
        assert (value instanceof Double);
        return HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.APPROX_TYPES.contains(otherType) ? otherType : SqlTypeName.DOUBLE);
    }

    public static SqlTypeName typeName(RelDataType type) {
        return type.getSqlTypeName();
    }

    public static boolean isNumeric(RelDataType type) {
        return SqlTypeName.NUMERIC_TYPES.contains(HazelcastTypeSystem.typeName(type));
    }

    public static boolean isChar(RelDataType type) {
        return SqlTypeName.CHAR_TYPES.contains(HazelcastTypeSystem.typeName(type));
    }

    public static boolean isFloatingPoint(RelDataType type) {
        return SqlTypeName.FRACTIONAL_TYPES.contains(HazelcastTypeSystem.typeName(type));
    }

    public static boolean isInteger(RelDataType type) {
        return SqlTypeName.INT_TYPES.contains(type.getSqlTypeName());
    }

    public static boolean isTemporal(RelDataType type) {
        return SqlTypeName.DATETIME_TYPES.contains(HazelcastTypeSystem.typeName(type)) || SqlTypeName.INTERVAL_TYPES.contains(HazelcastTypeSystem.typeName(type));
    }

    public int getMaxNumericPrecision() {
        return 38;
    }

    public int getMaxNumericScale() {
        return 38;
    }

    private static int precedenceOf(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (SqlTypeName.YEAR_INTERVAL_TYPES.contains(typeName)) {
            typeName = SqlTypeName.INTERVAL_YEAR_MONTH;
        } else if (SqlTypeName.DAY_INTERVAL_TYPES.contains(typeName)) {
            typeName = SqlTypeName.INTERVAL_DAY_SECOND;
        }
        QueryDataType hzType = SqlToQueryType.map(typeName);
        return hzType.getTypeFamily().getPrecedence();
    }

    private static Object literalValue(SqlLiteral literal) {
        switch (literal.getTypeName()) {
            case VARCHAR: 
            case CHAR: {
                return literal.getValueAs(String.class);
            }
            case BOOLEAN: {
                return literal.getValueAs(Boolean.class);
            }
            case TINYINT: {
                return literal.getValueAs(Byte.class);
            }
            case SMALLINT: {
                return literal.getValueAs(Short.class);
            }
            case INTEGER: {
                return literal.getValueAs(Integer.class);
            }
            case BIGINT: {
                BigDecimal decimalValue = (BigDecimal)literal.getValueAs(BigDecimal.class);
                return decimalValue == null ? null : Long.valueOf(decimalValue.longValue());
            }
            case DECIMAL: {
                return literal.getValueAs(BigDecimal.class);
            }
            case REAL: {
                return literal.getValueAs(Float.class);
            }
            case DOUBLE: {
                return literal.getValueAs(Double.class);
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return literal.getValueAs(Calendar.class);
            }
            case ANY: {
                return literal.getValueAs(Object.class);
            }
            case NULL: {
                return null;
            }
            case SYMBOL: {
                return literal.getValue();
            }
        }
        throw new IllegalArgumentException("unexpected literal type: " + literal.getTypeName());
    }

    private static RelDataType literalType(SqlLiteral literal) {
        return HazelcastTypeFactory.INSTANCE.createSqlType(literal.getTypeName());
    }

    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (argumentType instanceof BasicSqlType) {
            SqlTypeName type = HazelcastTypeSystem.deriveSumType(argumentType.getSqlTypeName());
            if (type.allowsPrec() && argumentType.getPrecision() != -1) {
                int precision = typeFactory.getTypeSystem().getMaxPrecision(type);
                if (type.allowsScale()) {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(type, precision, argumentType.getScale()), argumentType.isNullable());
                }
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(type, precision), argumentType.isNullable());
            }
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(type), argumentType.isNullable());
        }
        return argumentType;
    }

    private static SqlTypeName deriveSumType(SqlTypeName type) {
        switch (type) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return SqlTypeName.BIGINT;
            }
            case DECIMAL: {
                return SqlTypeName.DECIMAL;
            }
            case REAL: 
            case DOUBLE: {
                return SqlTypeName.DOUBLE;
            }
        }
        return type;
    }

    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        switch (argumentType.getSqlTypeName()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL), argumentType.isNullable());
            }
            case REAL: 
            case DOUBLE: {
                return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), argumentType.isNullable());
            }
        }
        return argumentType;
    }
}

