/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.SqlNodeUtil;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;

public final class HazelcastTypeCoercion
extends TypeCoercionImpl {
    private static final HazelcastTypeFactory TYPE_FACTORY = HazelcastTypeFactory.INSTANCE;

    public HazelcastTypeCoercion(HazelcastSqlValidator validator) {
        super((RelDataTypeFactory)TYPE_FACTORY, (SqlValidator)validator);
    }

    public boolean binaryArithmeticCoercion(SqlCallBinding binding) {
        SqlKind kind = binding.getOperator().getKind();
        if (!kind.belongsTo((Collection)SqlKind.BINARY_ARITHMETIC) && kind != SqlKind.PLUS_PREFIX && kind != SqlKind.MINUS_PREFIX) {
            return super.binaryArithmeticCoercion(binding);
        }
        RelDataType[] types = this.inferTypes(binding.getScope(), binding.operands(), true);
        if (types == null) {
            return false;
        }
        boolean coerced = false;
        for (int i = 0; i < types.length - 1; ++i) {
            boolean operandCoerced = this.coerceOperandType(binding.getScope(), binding.getCall(), i, types[i]);
            coerced |= operandCoerced;
        }
        return coerced;
    }

    public boolean binaryComparisonCoercion(SqlCallBinding binding) {
        SqlKind kind = binding.getOperator().getKind();
        if (!kind.belongsTo((Collection)SqlKind.BINARY_EQUALITY) && !kind.belongsTo((Collection)SqlKind.BINARY_COMPARISON) && kind != SqlKind.BETWEEN) {
            return super.binaryComparisonCoercion(binding);
        }
        RelDataType[] types = this.inferTypes(binding.getScope(), binding.operands(), false);
        if (types == null) {
            return false;
        }
        for (int i = 0; i < types.length - 1; ++i) {
            RelDataType type = types[i];
            if (!HazelcastTypeSystem.isTemporal(type)) continue;
            throw QueryException.error((int)1008, (String)("Cannot apply comparison operation to " + type.getFullTypeString()));
        }
        RelDataType commonType = types[types.length - 1];
        boolean coerced = false;
        for (int i = 0; i < types.length - 1; ++i) {
            RelDataType type = types[i];
            type = TYPE_FACTORY.createTypeWithNullability(commonType, type.isNullable());
            boolean operandCoerced = this.coerceOperandType(binding.getScope(), binding.getCall(), i, type);
            coerced |= operandCoerced;
            if (!operandCoerced || !HazelcastTypeSystem.isInteger(type)) continue;
            this.updateInferredType(binding.operand(i), type);
        }
        return coerced;
    }

    public RelDataType implicitCast(RelDataType in, SqlTypeFamily expected) {
        if (SqlTypeName.CHAR_TYPES.contains(HazelcastTypeSystem.typeName(in)) && expected == SqlTypeFamily.BOOLEAN) {
            return TYPE_FACTORY.createSqlType(SqlTypeName.BOOLEAN, in.isNullable());
        }
        return super.implicitCast(in, expected);
    }

    protected void updateInferredType(SqlNode node, RelDataType type) {
        ((HazelcastSqlValidator)this.validator).setKnownNodeType(node, type);
        super.updateInferredType(node, type);
    }

    protected boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int index, RelDataType to) {
        SqlNode operand = (SqlNode)call.getOperandList().get(index);
        if (!this.needToCast(scope, operand, to)) {
            this.updateInferredType(operand, to);
            return false;
        }
        SqlNode cast = HazelcastTypeCoercion.makeCast(operand, to);
        call.setOperand(index, cast);
        this.validator.deriveType(scope, cast);
        return true;
    }

    protected boolean needToCast(SqlValidatorScope scope, SqlNode node, RelDataType to) {
        RelDataType from = this.validator.deriveType(scope, node);
        if (HazelcastTypeSystem.typeName(from) == HazelcastTypeSystem.typeName(to)) {
            return false;
        }
        if (HazelcastTypeSystem.typeName(from) == SqlTypeName.NULL || SqlUtil.isNullLiteral((SqlNode)node, (boolean)false)) {
            return false;
        }
        if (HazelcastTypeSystem.typeName(to) == SqlTypeName.ANY) {
            return false;
        }
        if (SqlNodeUtil.isParameter(node)) {
            return false;
        }
        if (!(!SqlNodeUtil.isLiteral(node) || HazelcastTypeSystem.isTemporal(from) || HazelcastTypeSystem.isTemporal(to) || HazelcastTypeSystem.isChar(from) || HazelcastTypeSystem.isChar(to))) {
            return false;
        }
        return super.needToCast(scope, node, to);
    }

    private static SqlNode makeCast(SqlNode node, RelDataType type) {
        return HazelcastSqlOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{node, SqlTypeUtil.convertTypeToSpec((RelDataType)type)});
    }

    private RelDataType[] inferTypes(SqlValidatorScope scope, List<SqlNode> operands, boolean assumeNumeric) {
        Number numeric;
        SqlLiteral literal;
        RelDataType operandType;
        RelDataType commonType = null;
        boolean seenParameters = false;
        boolean seenChar = false;
        for (SqlNode operand : operands) {
            operandType = this.validator.deriveType(scope, operand);
            if (SqlNodeUtil.isLiteral(operand)) continue;
            if (SqlNodeUtil.isParameter(operand)) {
                seenParameters = true;
                continue;
            }
            commonType = commonType == null ? operandType : HazelcastTypeSystem.withHigherPrecedence(operandType, commonType);
            seenChar |= HazelcastTypeSystem.isChar(operandType);
        }
        for (SqlNode operand : operands) {
            operandType = this.validator.deriveType(scope, operand);
            if (!SqlNodeUtil.isLiteral(operand) || !HazelcastTypeSystem.isNumeric(operandType)) continue;
            literal = (SqlLiteral)operand;
            if (literal.getValue() == null) {
                operandType = TYPE_FACTORY.createSqlType(SqlTypeName.NULL);
            } else {
                numeric = SqlNodeUtil.numericValue((SqlNode)literal);
                assert (numeric != null);
                operandType = HazelcastTypeSystem.narrowestTypeFor(numeric, commonType == null ? null : HazelcastTypeSystem.typeName(commonType));
            }
            commonType = commonType == null ? operandType : HazelcastTypeSystem.withHigherPrecedence(operandType, commonType);
        }
        for (SqlNode operand : operands) {
            operandType = this.validator.deriveType(scope, operand);
            if (!SqlNodeUtil.isLiteral(operand) || HazelcastTypeSystem.isNumeric(operandType)) continue;
            literal = (SqlLiteral)operand;
            if (literal.getValue() == null) {
                operandType = TYPE_FACTORY.createSqlType(SqlTypeName.NULL);
            } else if (HazelcastTypeSystem.isChar(operandType) && (commonType != null && HazelcastTypeSystem.isNumeric(commonType) || assumeNumeric)) {
                numeric = SqlNodeUtil.numericValue(operand);
                assert (numeric != null);
                operandType = HazelcastTypeSystem.narrowestTypeFor(numeric, commonType == null ? null : HazelcastTypeSystem.typeName(commonType));
            }
            commonType = commonType == null ? operandType : HazelcastTypeSystem.withHigherPrecedence(operandType, commonType);
        }
        if (commonType == null) {
            assert (seenParameters);
            return null;
        }
        if (HazelcastTypeSystem.typeName(commonType) == SqlTypeName.NULL && seenParameters) {
            return null;
        }
        if (HazelcastTypeSystem.isChar(commonType) && assumeNumeric) {
            commonType = TYPE_FACTORY.createSqlType(SqlTypeName.DOUBLE);
        }
        if ((seenParameters || seenChar) && HazelcastTypeSystem.isInteger(commonType)) {
            commonType = TYPE_FACTORY.createSqlType(SqlTypeName.BIGINT);
        }
        RelDataType[] types = new RelDataType[operands.size() + 1];
        boolean nullable = false;
        for (int i = 0; i < operands.size(); ++i) {
            SqlNode operand = operands.get(i);
            RelDataType operandType2 = this.validator.deriveType(scope, operand);
            if (SqlNodeUtil.isParameter(operand)) {
                types[i] = TYPE_FACTORY.createTypeWithNullability(commonType, true);
                nullable = true;
                continue;
            }
            if (SqlNodeUtil.isLiteral(operand)) {
                SqlLiteral literal2 = (SqlLiteral)operand;
                if (literal2.getValue() == null) {
                    types[i] = TYPE_FACTORY.createTypeWithNullability(commonType, true);
                    nullable = true;
                    continue;
                }
                if (HazelcastTypeSystem.isNumeric(operandType2) || HazelcastTypeSystem.isChar(operandType2) && HazelcastTypeSystem.isNumeric(commonType)) {
                    RelDataType literalType;
                    Number numeric2 = SqlNodeUtil.numericValue(operand);
                    assert (numeric2 != null);
                    if (HazelcastTypeSystem.typeName(commonType) == SqlTypeName.DECIMAL) {
                        literalType = TYPE_FACTORY.createSqlType(SqlTypeName.DECIMAL);
                    } else {
                        literalType = HazelcastTypeSystem.narrowestTypeFor(numeric2, HazelcastTypeSystem.typeName(commonType));
                        if (assumeNumeric && HazelcastTypeSystem.isFloatingPoint(commonType)) {
                            literalType = HazelcastTypeSystem.withHigherPrecedence(literalType, commonType);
                            literalType = TYPE_FACTORY.createTypeWithNullability(literalType, false);
                        }
                    }
                    types[i] = literalType;
                    continue;
                }
                if (HazelcastTypeSystem.isChar(operandType2) && !HazelcastTypeSystem.isChar(commonType) && HazelcastTypeSystem.typeName(commonType) != SqlTypeName.ANY) {
                    types[i] = TYPE_FACTORY.createTypeWithNullability(commonType, false);
                    continue;
                }
                types[i] = operandType2;
                nullable |= HazelcastTypeSystem.typeName(operandType2) == SqlTypeName.NULL;
                continue;
            }
            RelDataType type = HazelcastTypeSystem.isNumeric(operandType2) && HazelcastTypeSystem.typeName(commonType) == SqlTypeName.DECIMAL ? commonType : (HazelcastTypeSystem.isChar(operandType2) && HazelcastTypeSystem.typeName(commonType) != SqlTypeName.ANY ? commonType : operandType2);
            types[i] = TYPE_FACTORY.createTypeWithNullability(type, operandType2.isNullable());
            nullable |= operandType2.isNullable();
        }
        types[types.length - 1] = commonType = TYPE_FACTORY.createTypeWithNullability(commonType, nullable);
        return types;
    }
}

