/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.mongodb;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStore;
import com.hazelcast.spring.mongodb.MongoDBConverter;
import com.hazelcast.spring.mongodb.SpringMongoDBConverter;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoMapStore
implements MapStore,
MapLoaderLifecycleSupport {
    private String mapName;
    private MongoDBConverter converter;
    private DBCollection coll;
    private MongoTemplate mongoTemplate;
    protected static final Logger logger = Logger.getLogger(MongoMapStore.class.getName());

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void store(Object key, Object value) {
        DBObject dbo = this.converter.toDBObject(value);
        dbo.put("_id", key);
        this.coll.save(dbo);
    }

    public void storeAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.store(key, value);
        }
    }

    public void delete(Object key) {
        BasicDBObject dbo = new BasicDBObject();
        dbo.put("_id", key);
        this.coll.remove((DBObject)dbo);
    }

    public void deleteAll(Collection keys) {
        BasicDBList dbo = new BasicDBList();
        for (Object key : keys) {
            dbo.add((Object)new BasicDBObject("_id", key));
        }
        BasicDBObject dbb = new BasicDBObject("$or", (Object)dbo);
        this.coll.remove((DBObject)dbb);
    }

    public Object load(Object key) {
        BasicDBObject dbo = new BasicDBObject();
        dbo.put("_id", key);
        DBObject obj = this.coll.findOne((DBObject)dbo);
        if (obj == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(obj.get("_class").toString());
            return this.converter.toObject(clazz, obj);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public Map loadAll(Collection keys) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        BasicDBList dbo = new BasicDBList();
        for (Object key : keys) {
            dbo.add((Object)new BasicDBObject("_id", key));
        }
        BasicDBObject dbb = new BasicDBObject("$or", (Object)dbo);
        DBCursor cursor = this.coll.find((DBObject)dbb);
        while (cursor.hasNext()) {
            try {
                DBObject obj = cursor.next();
                Class<?> clazz = Class.forName(obj.get("_class").toString());
                map.put(obj.get("_id"), this.converter.toObject(clazz, obj));
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return map;
    }

    public Set loadAllKeys() {
        HashSet<Object> keyset = new HashSet<Object>();
        BasicDBList dbo = new BasicDBList();
        dbo.add((Object)"_id");
        DBCursor cursor = this.coll.find(null, (DBObject)dbo);
        while (cursor.hasNext()) {
            keyset.add(cursor.next().get("_id"));
        }
        return keyset;
    }

    public void init(HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
        this.mapName = properties.get("collection") != null ? (String)properties.get("collection") : mapName;
        this.coll = this.mongoTemplate.getCollection(this.mapName);
        this.converter = new SpringMongoDBConverter(this.mongoTemplate);
    }

    public void destroy() {
    }
}

