/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.hazelcast.sql.SqlColumnMetadata;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class Queries {
    private static final SqlDialect DIALECT = CalciteSqlDialect.DEFAULT;
    private final String loadQuery;
    private final Function<Integer, String> loadAllFactory;
    private final Map<Integer, String> loadAllQueries = new ConcurrentHashMap<Integer, String>();
    private final String loadAllKeys;
    private final String storeSink;
    private final String storeUpdate;
    private final String delete;
    private final Function<Integer, String> deleteAllFactory;
    private final Map<Integer, String> deleteAllQueries = new ConcurrentHashMap<Integer, String>();

    Queries(String mapping, String idColumn, List<SqlColumnMetadata> columnMetadata) {
        this.loadQuery = Queries.buildLoadQuery(mapping, idColumn);
        this.loadAllFactory = n -> this.buildLoadAllQuery(mapping, idColumn, (int)n);
        this.loadAllKeys = Queries.buildLoadAllKeysQuery(mapping, idColumn);
        this.storeSink = this.buildStoreSinkQuery(mapping, columnMetadata);
        this.storeUpdate = this.buildStoreUpdateQuery(mapping, idColumn, columnMetadata);
        this.delete = Queries.buildDeleteQuery(mapping, idColumn);
        this.deleteAllFactory = n -> this.buildDeleteAllQuery(mapping, idColumn, (int)n);
    }

    private static String buildLoadQuery(String mapping, String idColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ");
        DIALECT.quoteIdentifier(sb, mapping);
        sb.append(" WHERE ");
        DIALECT.quoteIdentifier(sb, idColumn);
        sb.append(" = ?");
        return sb.toString();
    }

    private String buildLoadAllQuery(String mapping, String idColumn, int n) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ");
        DIALECT.quoteIdentifier(sb, mapping);
        sb.append(" WHERE ");
        DIALECT.quoteIdentifier(sb, idColumn);
        sb.append(" IN (");
        Queries.appendQueryParams(sb, n);
        sb.append(')');
        return sb.toString();
    }

    private static String buildLoadAllKeysQuery(String mapping, String idColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        DIALECT.quoteIdentifier(sb, idColumn);
        sb.append(" FROM ");
        DIALECT.quoteIdentifier(sb, mapping);
        return sb.toString();
    }

    private String buildStoreSinkQuery(String mapping, List<SqlColumnMetadata> columnMetadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("SINK INTO ");
        DIALECT.quoteIdentifier(sb, mapping);
        sb.append(" (");
        Iterator<SqlColumnMetadata> iterator = columnMetadata.iterator();
        while (iterator.hasNext()) {
            SqlColumnMetadata column = iterator.next();
            DIALECT.quoteIdentifier(sb, column.getName());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(") VALUES (");
        Queries.appendQueryParams(sb, columnMetadata.size());
        sb.append(')');
        return sb.toString();
    }

    private String buildStoreUpdateQuery(String mapping, String idColumn, List<SqlColumnMetadata> columnMetadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        DIALECT.quoteIdentifier(sb, mapping);
        sb.append(" SET ");
        Iterator<SqlColumnMetadata> iterator = columnMetadata.iterator();
        while (iterator.hasNext()) {
            SqlColumnMetadata column = iterator.next();
            if (idColumn.equals(column.getName())) continue;
            DIALECT.quoteIdentifier(sb, column.getName());
            sb.append(" = ?");
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" WHERE ");
        DIALECT.quoteIdentifier(sb, idColumn);
        sb.append(" = ?");
        return sb.toString();
    }

    private static String buildDeleteQuery(String mapping, String idColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        DIALECT.quoteIdentifier(sb, mapping);
        sb.append(" WHERE ");
        DIALECT.quoteIdentifier(sb, idColumn);
        sb.append(" = ?");
        return sb.toString();
    }

    private static void appendQueryParams(StringBuilder sb, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append('?');
            if (i >= n - 1) continue;
            sb.append(", ");
        }
    }

    private String buildDeleteAllQuery(String mapping, String idColumn, int n) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        DIALECT.quoteIdentifier(sb, mapping);
        sb.append(" WHERE ");
        DIALECT.quoteIdentifier(sb, idColumn);
        sb.append(" IN (");
        Queries.appendQueryParams(sb, n);
        sb.append(")");
        return sb.toString();
    }

    String load() {
        return this.loadQuery;
    }

    String loadAll(int n) {
        return this.loadAllQueries.computeIfAbsent(n, this.loadAllFactory);
    }

    String loadAllKeys() {
        return this.loadAllKeys;
    }

    String storeSink() {
        return this.storeSink;
    }

    String storeUpdate() {
        return this.storeUpdate;
    }

    String delete() {
        return this.delete;
    }

    String deleteAll(int n) {
        return this.deleteAllQueries.computeIfAbsent(n, this.deleteAllFactory);
    }
}

