/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.mapstore.GenericMapStoreProperties;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;

final class FromSqlRowConverter {
    private FromSqlRowConverter() {
    }

    @Nonnull
    public static GenericRecord toGenericRecord(SqlRow sqlRow, GenericMapStoreProperties properties) {
        GenericRecordBuilder builder = GenericRecordBuilder.compact((String)properties.compactTypeName);
        SqlRowMetadata sqlRowMetadata = sqlRow.getMetadata();
        block15: for (int i = 0; i < sqlRowMetadata.getColumnCount(); ++i) {
            SqlColumnMetadata sqlColumnMetadata = sqlRowMetadata.getColumn(i);
            String columnName = sqlColumnMetadata.getName();
            if (columnName.equals(properties.idColumn) && !properties.idColumnInColumns) continue;
            switch (sqlColumnMetadata.getType()) {
                case VARCHAR: {
                    builder.setString(columnName, (String)sqlRow.getObject(i));
                    continue block15;
                }
                case BOOLEAN: {
                    builder.setBoolean(columnName, ((Boolean)sqlRow.getObject(i)).booleanValue());
                    continue block15;
                }
                case TINYINT: {
                    builder.setInt8(columnName, ((Byte)sqlRow.getObject(i)).byteValue());
                    continue block15;
                }
                case SMALLINT: {
                    builder.setInt16(columnName, ((Short)sqlRow.getObject(i)).shortValue());
                    continue block15;
                }
                case INTEGER: {
                    builder.setInt32(columnName, ((Integer)sqlRow.getObject(i)).intValue());
                    continue block15;
                }
                case BIGINT: {
                    builder.setInt64(columnName, ((Long)sqlRow.getObject(i)).longValue());
                    continue block15;
                }
                case DECIMAL: {
                    builder.setDecimal(columnName, (BigDecimal)sqlRow.getObject(i));
                    continue block15;
                }
                case REAL: {
                    builder.setFloat32(columnName, ((Float)sqlRow.getObject(i)).floatValue());
                    continue block15;
                }
                case DOUBLE: {
                    builder.setFloat64(columnName, ((Double)sqlRow.getObject(i)).doubleValue());
                    continue block15;
                }
                case DATE: {
                    builder.setDate(columnName, (LocalDate)sqlRow.getObject(i));
                    continue block15;
                }
                case TIME: {
                    builder.setTime(columnName, (LocalTime)sqlRow.getObject(i));
                    continue block15;
                }
                case TIMESTAMP: {
                    builder.setTimestamp(columnName, (LocalDateTime)sqlRow.getObject(i));
                    continue block15;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    builder.setTimestampWithTimezone(columnName, (OffsetDateTime)sqlRow.getObject(i));
                    continue block15;
                }
                default: {
                    throw new HazelcastException("Column type " + String.valueOf(sqlColumnMetadata.getType()) + " not supported");
                }
            }
        }
        return builder.build();
    }
}

