/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.operation.steps.engine.StepResponseUtil;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;

public enum UtilSteps implements IMapOpStep
{
    SEND_RESPONSE{

        @Override
        public void runStep(State state) {
            StepResponseUtil.sendResponse(state);
            MapOperation operation = state.getOperation();
            operation.afterRunInternal();
            operation.disposeDeferredBlocks();
        }

        @Override
        public Step nextStep(State state) {
            return null;
        }
    }
    ,
    HANDLE_ERROR{

        @Override
        public void runStep(State state) {
            try {
                OperationRunnerImpl operationRunner = 2.getPartitionOperationRunner(state);
                operationRunner.handleOperationError(state.getOperation(), state.getThrowable());
            }
            finally {
                state.setThrowable(null);
            }
        }

        @Override
        public Step nextStep(State state) {
            return null;
        }
    };


    public static OperationRunnerImpl getPartitionOperationRunner(State state) {
        MapOperation operation = state.getOperation();
        return (OperationRunnerImpl)((OperationServiceImpl)operation.getNodeEngine().getOperationService()).getOperationExecutor().getPartitionOperationRunners()[state.getPartitionId()];
    }
}

