/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.file;

import com.hazelcast.jet.pipeline.file.AvroFileFormat;
import com.hazelcast.jet.pipeline.file.CsvFileFormat;
import com.hazelcast.jet.pipeline.file.JsonFileFormat;
import com.hazelcast.jet.pipeline.file.LinesTextFileFormat;
import com.hazelcast.jet.pipeline.file.ParquetFileFormat;
import com.hazelcast.jet.pipeline.file.RawBytesFileFormat;
import com.hazelcast.jet.pipeline.file.TextFileFormat;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface FileFormat<T>
extends Serializable {
    @Nonnull
    public String format();

    @Nonnull
    public static <T> AvroFileFormat<T> avro() {
        return FileFormat.avro(null);
    }

    @Nonnull
    public static <T> AvroFileFormat<T> avro(@Nullable Class<T> clazz) {
        return new AvroFileFormat<T>().withReflect(clazz);
    }

    @Nonnull
    public static CsvFileFormat<String[]> csv(@Nullable List<String> fieldNames) {
        return new CsvFileFormat<String[]>(fieldNames);
    }

    @Nonnull
    public static <T> CsvFileFormat<T> csv(@Nonnull Class<T> clazz) {
        return new CsvFileFormat<T>(clazz);
    }

    @Nonnull
    public static <T> JsonFileFormat<T> json() {
        return FileFormat.json(null);
    }

    @Nonnull
    public static <T> JsonFileFormat<T> json(@Nullable Class<T> clazz) {
        return new JsonFileFormat<T>().withClass(clazz);
    }

    @Nonnull
    public static LinesTextFileFormat lines() {
        return new LinesTextFileFormat();
    }

    @Nonnull
    public static LinesTextFileFormat lines(@Nonnull Charset charset) {
        return new LinesTextFileFormat(charset);
    }

    @Nonnull
    public static <T> ParquetFileFormat<T> parquet() {
        return new ParquetFileFormat();
    }

    @Nonnull
    public static RawBytesFileFormat bytes() {
        return new RawBytesFileFormat();
    }

    @Nonnull
    public static TextFileFormat text() {
        return new TextFileFormat();
    }

    @Nonnull
    public static TextFileFormat text(@Nonnull Charset charset) {
        return new TextFileFormat(charset);
    }
}

