/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jdbc.HazelcastSqlClient;
import com.hazelcast.jdbc.JdbcDataBaseMetadata;
import com.hazelcast.jdbc.JdbcPreparedStatement;
import com.hazelcast.jdbc.JdbcStatement;
import com.hazelcast.jdbc.JdbcUrl;
import com.hazelcast.jdbc.JdbcUtils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class JdbcConnection
implements Connection {
    private final HazelcastSqlClient client;
    private final AtomicBoolean closed = new AtomicBoolean();
    private String schema;
    private boolean readOnly = true;
    private boolean autoCommit;
    private SQLWarning warnings;

    JdbcConnection(HazelcastSqlClient client) {
        this.client = client;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new JdbcStatement(this.client, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return new JdbcPreparedStatement(sql, this.client, this);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw JdbcUtils.unsupported("CallableStatement not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new SQLException("Auto-commit is set to true");
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new SQLException("Auto-commit is set to true");
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.client.shutdown();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new JdbcDataBaseMetadata(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return;
            }
        }
        throw new SQLException("Invalid value for transaction isolation: " + level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        this.checkStatementParameters(resultSetType, resultSetConcurrency, 2);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        this.checkStatementParameters(resultSetType, resultSetConcurrency, 2);
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw JdbcUtils.unsupported("CallableStatement not supported");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw JdbcUtils.unsupported("Type Map not supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw JdbcUtils.unsupported("Type Map not supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        if (!this.supportsHoldability(holdability)) {
            throw JdbcUtils.unsupported("Value for holdability not supported " + holdability);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw JdbcUtils.unsupported("Savepoint is not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw JdbcUtils.unsupported("Savepoint is not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw JdbcUtils.unsupported("Rollback is not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw JdbcUtils.unsupported("Savepoint is not supported.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        this.checkStatementParameters(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        this.checkStatementParameters(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw JdbcUtils.unsupported("CallableStatement not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        if (autoGeneratedKeys != 2) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        if (columnIndexes.length != 0) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        if (columnNames.length != 0) {
            throw this.unsupportedAutoGeneratedKeys();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw JdbcUtils.unsupported("Clob is not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw JdbcUtils.unsupported("Blob is not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw JdbcUtils.unsupported("NClob is not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw JdbcUtils.unsupported("SQLXML is not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout cannot be less than 0");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.isClosed()) {
            throw new SQLClientInfoException("Connection is closed", Collections.emptyMap());
        }
        this.generateWarning("Client info is not supported.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.isClosed()) {
            throw new SQLClientInfoException("Connection is closed", Collections.emptyMap());
        }
        this.generateWarning("Client info is not supported.");
    }

    @Override
    public String getClientInfo(String name) {
        return null;
    }

    @Override
    public Properties getClientInfo() {
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw JdbcUtils.unsupported("Array is not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw JdbcUtils.unsupported("Struct is not supported.");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        this.schema = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor cannot be null");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw JdbcUtils.unsupported("Network timeout is not supported");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw JdbcUtils.unsupported("Network timeout is not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return JdbcUtils.isWrapperFor(this, iface);
    }

    public boolean supportsResultSetType(int resultSetType) {
        return resultSetType == 1003;
    }

    public boolean supportsResultSetConcurrency(int resultSetConcurrency) {
        return resultSetConcurrency == 1007;
    }

    public boolean supportsHoldability(int holdability) {
        return holdability == 2;
    }

    JdbcUrl getJdbcUrl() {
        return this.client.getJdbcUrl();
    }

    HazelcastInstance getClientInstance() {
        return this.client.getClient();
    }

    private void generateWarning(String reason) {
        SQLWarning currentWarning = new SQLWarning(reason);
        if (this.warnings != null) {
            this.warnings.setNextWarning(currentWarning);
        } else {
            this.warnings = currentWarning;
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    private void checkStatementParameters(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.supportsResultSetType(resultSetType)) {
            throw JdbcUtils.unsupported("Unsupported ResultSet type: " + resultSetType);
        }
        if (!this.supportsResultSetConcurrency(resultSetConcurrency)) {
            throw JdbcUtils.unsupported("Unsupported ResultSet concurrency: " + resultSetConcurrency);
        }
        if (!this.supportsHoldability(resultSetHoldability)) {
            throw JdbcUtils.unsupported("Unsupported ResultSet holdability: " + resultSetHoldability);
        }
    }

    private SQLFeatureNotSupportedException unsupportedAutoGeneratedKeys() {
        return JdbcUtils.unsupported("Auto-generated keys are not supported.");
    }
}

