/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.TimeUtil;
import java.util.concurrent.TimeUnit;

public final class TimeStripUtil {
    public static final long EPOCH_TIME_MILLIS = TimeUtil.zeroOutMs(1514764800000L);
    private static final int UNSET = -1;

    private TimeStripUtil() {
    }

    public static int stripBaseTime(long millis) {
        if (millis == Long.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (millis > 0L) {
            long toSeconds = TimeUnit.MILLISECONDS.toSeconds(millis - EPOCH_TIME_MILLIS);
            return toSeconds >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)toSeconds;
        }
        return -1;
    }

    public static long recomputeWithBaseTime(int seconds) {
        if (seconds == -1) {
            return 0L;
        }
        if (seconds == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return EPOCH_TIME_MILLIS + TimeUnit.SECONDS.toMillis(seconds);
    }
}

