/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.datastore;

import com.hazelcast.com.zaxxer.hikari.HikariConfig;
import com.hazelcast.com.zaxxer.hikari.HikariDataSource;
import com.hazelcast.config.ExternalDataStoreConfig;
import com.hazelcast.datastore.ExternalDataStoreFactory;
import com.hazelcast.datastore.impl.CloseableDataSource;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.annotation.Beta;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;

@Beta
public class JdbcDataStoreFactory
implements ExternalDataStoreFactory<DataSource> {
    private static final AtomicInteger DATA_SOURCE_COUNTER = new AtomicInteger();
    protected HikariDataSource sharedDataSource;
    protected CloseableDataSource sharedCloseableDataSource;
    protected ExternalDataStoreConfig config;

    @Override
    public void init(ExternalDataStoreConfig config) {
        this.config = config;
        if (config.isShared()) {
            this.sharedDataSource = this.doCreateDataSource();
            this.sharedCloseableDataSource = CloseableDataSource.nonClosing(this.sharedDataSource);
        }
    }

    @Override
    public DataSource getDataStore() {
        return this.config.isShared() ? this.sharedCloseableDataSource : CloseableDataSource.closing(this.doCreateDataSource());
    }

    protected HikariDataSource doCreateDataSource() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.config.getProperties());
        if (!properties.containsKey("poolName")) {
            String suffix = StringUtil.isNullOrEmpty(this.config.getName()) ? "" : "-" + this.config.getName();
            properties.put("poolName", "HikariPool-" + DATA_SOURCE_COUNTER.getAndIncrement() + suffix);
        }
        HikariConfig dataSourceConfig = new HikariConfig(properties);
        return new HikariDataSource(dataSourceConfig);
    }

    @Override
    public void close() throws Exception {
        if (this.sharedDataSource != null) {
            this.sharedDataSource.close();
        }
    }
}

