/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.TreeMap;

public class BeanPropertyIntrospector {
    protected static final POJODefinition.Prop[] NO_PROPS = new POJODefinition.Prop[0];
    private static final BeanPropertyIntrospector INSTANCE = new BeanPropertyIntrospector();

    public static BeanPropertyIntrospector instance() {
        return INSTANCE;
    }

    public POJODefinition pojoDefinitionForDeserialization(JSONReader jSONReader, Class<?> clazz) {
        return this._construct(clazz, jSONReader.features());
    }

    public POJODefinition pojoDefinitionForSerialization(JSONWriter jSONWriter, Class<?> clazz) {
        return this._construct(clazz, jSONWriter.features());
    }

    private POJODefinition _construct(Class<?> clazz, int n) {
        POJODefinition.Prop[] propArray;
        TreeMap<String, POJODefinition.PropBuilder> treeMap = new TreeMap<String, POJODefinition.PropBuilder>();
        BeanPropertyIntrospector._introspect(clazz, treeMap, n);
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        for (Constructor<?> constructor4 : clazz.getDeclaredConstructors()) {
            Object object = constructor4.getParameterTypes();
            if (((Class<?>[])object).length == 0) {
                constructor = constructor4;
                continue;
            }
            if (((Class<?>[])object).length != 1) continue;
            Class<?> clazz2 = object[0];
            if (clazz2 == String.class) {
                constructor2 = constructor4;
                continue;
            }
            if (clazz2 != Long.class && clazz2 != Long.TYPE) continue;
            constructor3 = constructor4;
        }
        int n2 = treeMap.size();
        if (n2 == 0) {
            propArray = NO_PROPS;
        } else {
            propArray = new POJODefinition.Prop[n2];
            int n3 = 0;
            for (Object object : treeMap.values()) {
                propArray[n3++] = ((POJODefinition.PropBuilder)object).build();
            }
        }
        return new POJODefinition(clazz, propArray, constructor, constructor2, constructor3);
    }

    private static void _introspect(Class<?> clazz, Map<String, POJODefinition.PropBuilder> map, int n) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        BeanPropertyIntrospector._introspect(clazz.getSuperclass(), map, n);
        boolean bl = JSON.Feature.INCLUDE_STATIC_FIELDS.isDisabled(n);
        for (Field accessibleObject : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(accessibleObject.getModifiers()) || accessibleObject.isEnumConstant() || accessibleObject.isSynthetic() || Modifier.isStatic(accessibleObject.getModifiers()) && (bl || Modifier.isFinal(accessibleObject.getModifiers()))) continue;
            BeanPropertyIntrospector._propFrom(map, accessibleObject.getName()).withField(accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Object object;
            int n2 = ((Method)accessibleObject).getModifiers();
            if (Modifier.isStatic(n2) || ((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
            if (classArray.length == 0) {
                if (!Modifier.isPublic(n2) || (object = ((Method)accessibleObject).getReturnType()) == Void.class) continue;
                String string = ((Method)accessibleObject).getName();
                if (string.startsWith("get")) {
                    if (string.length() <= 3) continue;
                    string = BeanPropertyIntrospector.decap(string.substring(3));
                    BeanPropertyIntrospector._propFrom(map, string).withGetter((Method)accessibleObject);
                    continue;
                }
                if (!string.startsWith("is") || string.length() <= 2) continue;
                string = BeanPropertyIntrospector.decap(string.substring(2));
                BeanPropertyIntrospector._propFrom(map, string).withIsGetter((Method)accessibleObject);
                continue;
            }
            if (classArray.length != 1 || !((String)(object = ((Method)accessibleObject).getName())).startsWith("set") || ((String)object).length() == 3) continue;
            object = BeanPropertyIntrospector.decap(((String)object).substring(3));
            BeanPropertyIntrospector._propFrom(map, (String)object).withSetter((Method)accessibleObject);
        }
    }

    private static POJODefinition.PropBuilder _propFrom(Map<String, POJODefinition.PropBuilder> map, String string) {
        POJODefinition.PropBuilder propBuilder = map.get(string);
        if (propBuilder == null) {
            propBuilder = POJODefinition.Prop.builder(string);
            map.put(string, propBuilder);
        }
        return propBuilder;
    }

    private static String decap(String string) {
        char c;
        char c2 = string.charAt(0);
        if (!(c2 == (c = Character.toLowerCase(c2)) || string.length() != 1 && Character.isUpperCase(string.charAt(1)))) {
            char[] cArray = string.toCharArray();
            cArray[0] = c;
            return new String(cArray);
        }
        return string;
    }
}

