/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.configuration.CacheEntryListenerConfiguration;

public abstract class AbstractCacheSyncListenerCompleter
implements CacheSyncListenerCompleter {
    private final AtomicInteger completionIdCounter = new AtomicInteger();
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
    private final ConcurrentMap<CacheEntryListenerConfiguration, UUID> asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, UUID>();
    private final ConcurrentMap<CacheEntryListenerConfiguration, UUID> syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, UUID>();

    @Override
    public void countDownCompletionLatch(int countDownLatchId) {
        if (countDownLatchId != -1) {
            CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
            if (countDownLatch == null) {
                return;
            }
            countDownLatch.countDown();
            if (countDownLatch.getCount() == 0L) {
                this.deregisterCompletionLatch(countDownLatchId);
            }
        }
    }

    private void notifyAndClearSyncListenerLatches() {
        Collection latches = this.syncLocks.values();
        Iterator iterator = latches.iterator();
        while (iterator.hasNext()) {
            CountDownLatch latch = (CountDownLatch)iterator.next();
            iterator.remove();
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    public void deregisterCompletionLatch(Integer countDownLatchId) {
        if (countDownLatchId != -1) {
            this.syncLocks.remove(countDownLatchId);
        }
    }

    public Integer registerCompletionLatch(int count) {
        return this.registerCompletionLatch(this.completionIdCounter.incrementAndGet(), count);
    }

    public Integer registerCompletionLatch(Integer countDownLatchId, int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int size = this.syncListenerRegistrations.size();
            CountDownLatch countDownLatch = new CountDownLatch(count * size);
            this.syncLocks.put(countDownLatchId, countDownLatch);
            return countDownLatchId;
        }
        return -1;
    }

    public void waitCompletionLatch(Integer countDownLatchId, InternalCompletableFuture future) throws ExecutionException {
        CountDownLatch countDownLatch;
        if (countDownLatchId != -1 && (countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId)) != null) {
            this.awaitLatch(countDownLatch, future);
        }
    }

    public void waitCompletionLatch(Integer countDownLatchId) throws ExecutionException {
        this.waitCompletionLatch(countDownLatchId, null);
    }

    public void waitCompletionLatch(Integer countDownLatchId, int offset) throws ExecutionException {
        CountDownLatch countDownLatch;
        if (countDownLatchId != -1 && (countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId)) != null) {
            for (int i = 0; i < offset; ++i) {
                countDownLatch.countDown();
            }
            this.awaitLatch(countDownLatch, null);
        }
    }

    protected abstract void awaitLatch(CountDownLatch var1, InternalCompletableFuture var2) throws ExecutionException;

    public void putListenerIfAbsent(CacheEntryListenerConfiguration configuration, UUID regId) {
        if (configuration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(configuration, regId);
        } else {
            this.asyncListenerRegistrations.putIfAbsent(configuration, regId);
        }
    }

    public UUID removeListener(CacheEntryListenerConfiguration configuration) {
        if (configuration.isSynchronous()) {
            return (UUID)this.syncListenerRegistrations.remove(configuration);
        }
        return (UUID)this.asyncListenerRegistrations.remove(configuration);
    }

    public UUID getListenerId(CacheEntryListenerConfiguration configuration) {
        if (configuration.isSynchronous()) {
            return (UUID)this.syncListenerRegistrations.get(configuration);
        }
        return (UUID)this.asyncListenerRegistrations.get(configuration);
    }

    public void clearListeners() {
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.notifyAndClearSyncListenerLatches();
    }

    public Collection<UUID> getListenersIds(boolean sync) {
        if (sync) {
            return this.syncListenerRegistrations.values();
        }
        return this.asyncListenerRegistrations.values();
    }
}

